/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.StringRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.Tree;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AutomataScriptInterpreterOverallResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResultAtElement;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.AssignableTest;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.AutomataDefinitionInterpreter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.AutomataScriptTypeChecker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.IMessagePrinter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.InterpreterException;
import de.uni_freiburg.informatik.ultimate.plugins.generator.automatascriptinterpreter.ListExistingOperations;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AssignmentExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomataDefinitionsAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomataTestFileAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.BinaryExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.BreakStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ConditionalBooleanExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ConstantExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ContinueStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ForStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.IfElseStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.IfStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.NestedLassowordAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.NestedwordAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.OperationInvocationExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.RelationalExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.ReturnStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.StatementListAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.TreeAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.UnaryExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.VariableDeclarationAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.VariableExpressionAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.WhileStatementAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AtsASTNode;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AutomataScriptParserRun;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;

public class TestFileInterpreter
implements IMessagePrinter {
    private static final boolean PRINT_STACK_TRACE_FOR_EXCEPTIONS = true;
    public static final String WRITE = "write";
    public static final String PRINT = "print";
    public static final String ASSERT = "assert";
    private static final int WRITE_ARGUMENTS = 3;
    private static final String ASSERTION_HOLDS_MESSAGE = "Assertion holds.";
    private static final String ASSERTION_VIOLATED_MESSAGE = "Assertion violated!";
    private static final String ERROR_STRING = "Error: ";
    private static final String DOES_NOT_EXIST = "\" does not exist";
    private static final String DIRECTORY = "Directory \"";
    private final Map<String, Object> mVariables;
    private final Map<String, Set<Class<?>>> mExistingOperations;
    private Flow mFlow;
    private final AutomataDefinitionInterpreter mAutomataInterpreter;
    private final ILogger mLogger;
    private IAutomaton<String, String> mLastPrintedAutomaton;
    private boolean mPrintAutomataToFile;
    private PrintWriter mPrintWriter;
    private String mPath = ".";
    private boolean mIgnoreOperationsAndExecuteCommandInstead;
    private String mCommandToExecute;
    private final List<GenericResultAtElement<AtsASTNode>> mResultOfAssertStatements;
    private final IUltimateServiceProvider mServices;
    private final boolean mProvideStatisticsResults = true;

    public TestFileInterpreter(IUltimateServiceProvider iUltimateServiceProvider) {
        assert (iUltimateServiceProvider != null);
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.readPreferences();
        assert (TestFileInterpreter.isStatisticsEnumAlphabeticallySorted()) : "The entries of enum StatisticsType must be sorted alphabetically.";
        this.mVariables = new HashMap<String, Object>();
        this.mFlow = Flow.NORMAL;
        this.mAutomataInterpreter = new AutomataDefinitionInterpreter(this, this.mLogger, this.mServices);
        this.mExistingOperations = this.getOperationClasses();
        this.mLastPrintedAutomaton = null;
        this.mResultOfAssertStatements = new ArrayList<GenericResultAtElement<AtsASTNode>>();
        if (this.mPrintAutomataToFile) {
            String string = this.mPath + File.separator + "automatascriptOutput" + TestFileInterpreter.getDateTime() + ".ats";
            File file = new File(string);
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (FileWriter fileWriter = new FileWriter(file);){
                    this.mPrintWriter = new PrintWriter(fileWriter);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                throw new AssertionError((Object)iOException);
            }
        }
    }

    private void readPreferences() {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mPrintAutomataToFile = iPreferenceProvider.getBoolean("Write results of print operation to file");
        this.mPath = iPreferenceProvider.getString("Directory");
        this.mIgnoreOperationsAndExecuteCommandInstead = iPreferenceProvider.getBoolean("Ignore all commands and only execute below command");
        this.mCommandToExecute = iPreferenceProvider.getString("Command");
    }

    private static String getDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    public Object interpretTestFile(AtsASTNode atsASTNode) {
        AtsASTNode atsASTNode2;
        Throwable throwable;
        Object object;
        Object object2;
        AutomataTestFileAST automataTestFileAST = null;
        if (atsASTNode instanceof AutomataTestFileAST) {
            automataTestFileAST = (AutomataTestFileAST)atsASTNode;
        }
        Finished finished = Finished.FINISHED;
        Object object3 = null;
        this.reportToLogger(LoggerSeverity.DEBUG, "Interpreting automata definitions...");
        try {
            this.mAutomataInterpreter.interpret(automataTestFileAST.getAutomataDefinitions());
        }
        catch (Exception exception) {
            object3 = exception.getMessage();
            this.reportToLogger(LoggerSeverity.INFO, "Error during interpreting automata definitions.");
            this.reportToLogger(LoggerSeverity.INFO, ERROR_STRING + (String)object3);
            if (exception instanceof InterpreterException) {
                this.reportToLogger(LoggerSeverity.INFO, ERROR_STRING + ((InterpreterException)exception).getShortDescription());
            }
            this.reportToLogger(LoggerSeverity.INFO, "Interpretation of testfile cancelled.");
            this.reportToUltimate(IResultWithSeverity.Severity.ERROR, (String)object3 + " Interpretation of testfile cancelled.", "Error", atsASTNode);
            finished = Finished.ERROR;
        }
        if (this.mIgnoreOperationsAndExecuteCommandInstead) {
            object2 = TestFileInterpreter.substituteAutomataNames(this.mCommandToExecute, automataTestFileAST.getAutomataDefinitions());
            object = new InputStreamReader(new ByteArrayInputStream(((String)object2).getBytes()));
            throwable = new AutomataScriptParserRun(this.mServices, this.mLogger, (Reader)object, "mySettingsFileGivenStringDoesNotHaveFilename", "mySettingsFileGivenStringDoesNotHaveFileAbsolutePath").getResult();
            atsASTNode2 = throwable.getStatementList();
        } else {
            atsASTNode2 = automataTestFileAST.getStatementList();
        }
        if (finished == Finished.FINISHED) {
            this.mVariables.putAll(this.mAutomataInterpreter.getAutomata());
            this.reportToLogger(LoggerSeverity.DEBUG, "Typechecking of test file...");
            try {
                new AutomataScriptTypeChecker(this.mExistingOperations).checkTestFile(atsASTNode2, this.mVariables);
            }
            catch (InterpreterException interpreterException) {
                this.reportToLogger(LoggerSeverity.INFO, ERROR_STRING + interpreterException.getMessage());
                this.reportToLogger(LoggerSeverity.INFO, ERROR_STRING + interpreterException.getShortDescription());
                this.reportToLogger(LoggerSeverity.INFO, "Interpretation of testfile cancelled.");
                object = interpreterException.getShortDescription();
                if (object == null) {
                    object = "Error";
                }
                this.reportToUltimate(IResultWithSeverity.Severity.ERROR, interpreterException.getLongDescription(), (String)object, atsASTNode);
                finished = Finished.ERROR;
                object3 = interpreterException.getLongDescription();
            }
        }
        object2 = null;
        if (finished == Finished.FINISHED) {
            this.reportToLogger(LoggerSeverity.DEBUG, "Interpreting test file...");
            if (atsASTNode2 != null) {
                try {
                    object2 = this.interpret(atsASTNode2);
                }
                catch (InterpreterException interpreterException) {
                    throwable = interpreterException.getCause();
                    if (throwable != null) {
                        if (throwable instanceof AutomataOperationCanceledException) {
                            finished = Finished.TIMEOUT;
                            object3 = "Timeout " + ((AutomataOperationCanceledException)throwable).printRunningTaskMessage();
                        } else if (throwable instanceof OutOfMemoryError) {
                            finished = Finished.OUTOFMEMORY;
                        } else {
                            finished = Finished.ERROR;
                            object3 = interpreterException.getLongDescription();
                        }
                    } else {
                        finished = Finished.ERROR;
                        object3 = interpreterException.getLongDescription();
                    }
                    this.printMessage(IResultWithSeverity.Severity.ERROR, LoggerSeverity.INFO, interpreterException.getLongDescription(), "Interpretation of ats file failed", atsASTNode);
                }
            }
        }
        this.reportToLogger(LoggerSeverity.DEBUG, "Reporting results...");
        this.reportResult(finished, (String)object3);
        if (this.mPrintAutomataToFile) {
            this.mPrintWriter.close();
        }
        return object2;
    }

    private static String substituteAutomataNames(String string, AutomataDefinitionsAST automataDefinitionsAST) {
        String string2 = string;
        List list = automataDefinitionsAST.getListOfAutomataDefinitions();
        int n = list.size();
        ListIterator listIterator = list.listIterator(n);
        while (listIterator.hasPrevious()) {
            AutomatonAST automatonAST = (AutomatonAST)listIterator.previous();
            String string3 = "\\$" + n;
            String string4 = automatonAST.getName();
            string2 = string2.replaceAll(string3, string4);
            --n;
        }
        if (string2.contains("$")) {
            int n2 = list.size();
            if (n2 == 0) {
                throw new IllegalArgumentException("The command contained an illegal automaton reference. There were no automata found in the input.");
            }
            if (n2 == 1) {
                throw new IllegalArgumentException("The command contained an illegal automaton reference. There was only 1 automaton found, so only $1 is legal.");
            }
            throw new IllegalArgumentException(String.format("%s There were only %d automata found, so only $1 to $%d are legal.", "The command contained an illegal automaton reference.", n2, n2));
        }
        return string2;
    }

    public IAutomaton<String, String> getLastPrintedAutomaton() {
        return this.mLastPrintedAutomaton;
    }

    private Object interpret(AssignmentExpressionAST assignmentExpressionAST) throws InterpreterException {
        List list = assignmentExpressionAST.getOutgoingNodes();
        VariableExpressionAST variableExpressionAST = (VariableExpressionAST)list.get(0);
        if (!this.mVariables.containsKey(variableExpressionAST.getIdentifier())) {
            String string = assignmentExpressionAST.getLocation().getStartLine() + ": Variable \"" + variableExpressionAST.getIdentifier() + "\" was not declared before.";
            throw new InterpreterException(assignmentExpressionAST.getLocation(), string);
        }
        Object object = this.interpret((AtsASTNode)list.get(1));
        if (object == null) {
            String string = "Var \"" + variableExpressionAST.getIdentifier() + "\" is assigned \"null\".";
            throw new InterpreterException(assignmentExpressionAST.getLocation(), string);
        }
        Object object2 = this.mVariables.get(variableExpressionAST.getIdentifier());
        switch (assignmentExpressionAST.getOperator()) {
            case ASSIGN: {
                this.mVariables.put(variableExpressionAST.getIdentifier(), object);
                break;
            }
            case PLUSASSIGN: {
                Integer n = (Integer)object2 + (Integer)object;
                this.mVariables.put(variableExpressionAST.getIdentifier(), n);
                break;
            }
            case MINUSASSIGN: {
                Integer n = (Integer)object2 - (Integer)object;
                this.mVariables.put(variableExpressionAST.getIdentifier(), n);
                break;
            }
            case MULTASSIGN: {
                Integer n = (Integer)object2 * (Integer)object;
                this.mVariables.put(variableExpressionAST.getIdentifier(), n);
                break;
            }
            case DIVASSIGN: {
                Integer n = (Integer)object2 / (Integer)object;
                this.mVariables.put(variableExpressionAST.getIdentifier(), n);
                break;
            }
            default: {
                throw new InterpreterException(assignmentExpressionAST.getLocation(), "AssignmentExpression: This type of operator is not supported: " + String.valueOf(assignmentExpressionAST.getOperator()));
            }
        }
        return object2;
    }

    private Object interpret(AtsASTNode atsASTNode) throws InterpreterException {
        Object object = null;
        if (atsASTNode instanceof AssignmentExpressionAST) {
            object = this.interpret((AssignmentExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof BinaryExpressionAST) {
            object = this.interpret((BinaryExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof BreakStatementAST) {
            object = this.interpret((BreakStatementAST)atsASTNode);
        } else if (atsASTNode instanceof ConditionalBooleanExpressionAST) {
            object = this.interpret((ConditionalBooleanExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof ConstantExpressionAST) {
            object = TestFileInterpreter.interpret((ConstantExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof ContinueStatementAST) {
            object = this.interpret((ContinueStatementAST)atsASTNode);
        } else if (atsASTNode instanceof ForStatementAST) {
            object = this.interpret((ForStatementAST)atsASTNode);
        } else if (atsASTNode instanceof IfElseStatementAST) {
            object = this.interpret((IfElseStatementAST)atsASTNode);
        } else if (atsASTNode instanceof IfStatementAST) {
            object = this.interpret((IfStatementAST)atsASTNode);
        } else if (atsASTNode instanceof NestedwordAST) {
            object = TestFileInterpreter.interpret((NestedwordAST)atsASTNode);
        } else if (atsASTNode instanceof NestedLassowordAST) {
            object = TestFileInterpreter.interpret((NestedLassowordAST)atsASTNode);
        } else if (atsASTNode instanceof OperationInvocationExpressionAST) {
            object = this.interpret((OperationInvocationExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof RelationalExpressionAST) {
            object = this.interpret((RelationalExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof ReturnStatementAST) {
            object = this.interpret((ReturnStatementAST)atsASTNode);
        } else if (atsASTNode instanceof StatementListAST) {
            object = this.interpret((StatementListAST)atsASTNode);
        } else if (atsASTNode instanceof TreeAST) {
            object = TestFileInterpreter.interpret((TreeAST)atsASTNode);
        } else if (atsASTNode instanceof UnaryExpressionAST) {
            object = this.interpret((UnaryExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof VariableDeclarationAST) {
            object = this.interpret((VariableDeclarationAST)atsASTNode);
        } else if (atsASTNode instanceof VariableExpressionAST) {
            object = this.interpret((VariableExpressionAST)atsASTNode);
        } else if (atsASTNode instanceof WhileStatementAST) {
            object = this.interpret((WhileStatementAST)atsASTNode);
        }
        return object;
    }

    private Object interpret(BinaryExpressionAST binaryExpressionAST) throws InterpreterException {
        List list = binaryExpressionAST.getOutgoingNodes();
        if (binaryExpressionAST.getReturnType() == String.class) {
            String string = this.interpret((AtsASTNode)list.get(0)).toString();
            string = string.concat(this.interpret((AtsASTNode)list.get(1)).toString());
            return string;
        }
        Integer n = (Integer)this.interpret((AtsASTNode)list.get(0));
        Integer n2 = (Integer)this.interpret((AtsASTNode)list.get(1));
        switch (binaryExpressionAST.getOperator()) {
            case PLUS: {
                return n + n2;
            }
            case MINUS: {
                return n - n2;
            }
            case MULTIPLICATION: {
                return n * n2;
            }
            case DIVISION: {
                return n / n2;
            }
        }
        throw new InterpreterException(binaryExpressionAST.getLocation(), " BinaryExpression: This type of operator is not supported: " + String.valueOf(binaryExpressionAST.getOperator()));
    }

    private Object interpret(BreakStatementAST breakStatementAST) {
        this.mFlow = Flow.BREAK;
        return null;
    }

    private Boolean interpret(ConditionalBooleanExpressionAST conditionalBooleanExpressionAST) throws InterpreterException {
        List list = conditionalBooleanExpressionAST.getOutgoingNodes();
        switch (conditionalBooleanExpressionAST.getOperator()) {
            case NOT: {
                return (Boolean)this.interpret((AtsASTNode)list.get(0)) == false;
            }
            case AND: {
                return (Boolean)this.interpret((AtsASTNode)list.get(0)) == false ? false : (Boolean)this.interpret((AtsASTNode)list.get(1));
            }
            case OR: {
                return (Boolean)this.interpret((AtsASTNode)list.get(0)) != false ? true : (Boolean)this.interpret((AtsASTNode)list.get(1));
            }
        }
        String string = "ConditionalBooleanExpression: This type of operator is not supported: " + String.valueOf(conditionalBooleanExpressionAST.getOperator());
        throw new InterpreterException(conditionalBooleanExpressionAST.getLocation(), string);
    }

    private static Object interpret(ConstantExpressionAST constantExpressionAST) {
        return constantExpressionAST.getValue();
    }

    private Object interpret(ContinueStatementAST continueStatementAST) {
        this.mFlow = Flow.CONTINUE;
        return null;
    }

    private Object interpret(ForStatementAST forStatementAST) throws InterpreterException {
        boolean bl;
        List list = forStatementAST.getOutgoingNodes();
        boolean bl2 = bl = list.get(0) == null;
        if (list.get(1) != null) {
            this.interpret((AtsASTNode)list.get(1));
        }
        while (bl || ((Boolean)this.interpret((AtsASTNode)list.get(0))).booleanValue()) {
            List list2 = ((AtsASTNode)list.get(3)).getOutgoingNodes();
            for (AtsASTNode atsASTNode : list2) {
                this.interpret(atsASTNode);
                if (this.mFlow == Flow.NORMAL) continue;
                switch (this.mFlow) {
                    case BREAK: 
                    case RETURN: {
                        this.mFlow = Flow.NORMAL;
                        return null;
                    }
                    case CONTINUE: {
                        this.mFlow = Flow.NORMAL;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            if (list.get(2) == null) continue;
            this.interpret((AtsASTNode)list.get(2));
        }
        return null;
    }

    private Object interpret(IfElseStatementAST ifElseStatementAST) throws InterpreterException {
        List list = ifElseStatementAST.getOutgoingNodes();
        if (((Boolean)this.interpret((AtsASTNode)list.get(0))).booleanValue()) {
            this.interpret((AtsASTNode)list.get(1));
        } else {
            this.interpret((AtsASTNode)list.get(2));
        }
        return null;
    }

    private Object interpret(IfStatementAST ifStatementAST) throws InterpreterException {
        List list = ifStatementAST.getOutgoingNodes();
        if (((Boolean)this.interpret((AtsASTNode)list.get(0))).booleanValue()) {
            int n = 1;
            while (n < list.size()) {
                this.interpret((AtsASTNode)list.get(n));
                ++n;
            }
        }
        return null;
    }

    private static NestedWord<String> interpret(NestedwordAST nestedwordAST) {
        return new NestedWord((Object[])nestedwordAST.getWordSymbols(), nestedwordAST.getNestingRelation());
    }

    private static NestedLassoWord<String> interpret(NestedLassowordAST nestedLassowordAST) {
        NestedWord<String> nestedWord = TestFileInterpreter.interpret(nestedLassowordAST.getStem());
        NestedWord<String> nestedWord2 = TestFileInterpreter.interpret(nestedLassowordAST.getLoop());
        return new NestedLassoWord(nestedWord, nestedWord2);
    }

    private static Tree<StringRankedLetter> interpret(TreeAST treeAST) {
        return treeAST.getTree();
    }

    private Object interpret(OperationInvocationExpressionAST operationInvocationExpressionAST) throws InterpreterException {
        Object object2;
        List list = operationInvocationExpressionAST.getOutgoingNodes();
        if (list.size() != 1) {
            String string = "OperationExpression should have only 1 child (ArgumentList). Num of children: " + list.size();
            throw new InterpreterException(operationInvocationExpressionAST.getLocation(), string);
        }
        if (list.get(0) == null) {
            throw new InterpreterException(operationInvocationExpressionAST.getLocation(), "OperationExpression's child should not be null.");
        }
        List list2 = ((AtsASTNode)list.get(0)).getOutgoingNodes();
        ArrayList<Object> arrayList = new ArrayList<Object>(list2.size());
        for (Object object2 : list2) {
            arrayList.add(this.interpret((AtsASTNode)object2));
        }
        object2 = null;
        if (operationInvocationExpressionAST.getOperationName().equalsIgnoreCase(ASSERT) && arrayList.size() == 1) {
            object2 = this.executeAssertMethod(operationInvocationExpressionAST, arrayList);
        } else if (operationInvocationExpressionAST.getOperationName().equalsIgnoreCase(PRINT)) {
            this.executePrintMethod(operationInvocationExpressionAST, list, arrayList);
        } else if (operationInvocationExpressionAST.getOperationName().equalsIgnoreCase(WRITE)) {
            this.executeWriteMethod(operationInvocationExpressionAST, list, arrayList);
        } else {
            object2 = this.executeLibraryMethod(operationInvocationExpressionAST, arrayList, object2);
        }
        return object2;
    }

    private Object executeLibraryMethod(OperationInvocationExpressionAST operationInvocationExpressionAST, ArrayList<Object> arrayList, Object object) throws InterpreterException {
        SimpleTimer simpleTimer = new SimpleTimer();
        IOperation<String, String, ? super StringFactory> iOperation = null;
        try {
            iOperation = this.getAutomataOperation(operationInvocationExpressionAST, arrayList);
        }
        finally {
            AutomataOperationStatistics automataOperationStatistics;
            this.mLogger.info((Object)"reporting benchmark results");
            if (iOperation == null) {
                automataOperationStatistics = new AutomataOperationStatistics();
            } else {
                automataOperationStatistics = iOperation.getAutomataOperationStatistics();
                if (automataOperationStatistics == null) {
                    automataOperationStatistics = new AutomataOperationStatistics();
                }
            }
            automataOperationStatistics.addKeyValuePair(StatisticsType.ATS_ID, (Object)operationInvocationExpressionAST.getAsString());
            automataOperationStatistics.addKeyValuePair(StatisticsType.OPERATION_NAME, (Object)operationInvocationExpressionAST.getOperationName());
            automataOperationStatistics.addKeyValuePair(StatisticsType.RUNTIME_TOTAL_MS, (Object)(simpleTimer.checkTime() / 1000000L));
            StatisticsResult statisticsResult = new StatisticsResult(Activator.PLUGIN_ID, "automata script interpreter benchmark results", (ICsvProviderProvider)automataOperationStatistics);
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)statisticsResult);
        }
        if (iOperation != null) {
            try {
                assert (iOperation.checkResult((IStateFactory)new StringFactory())) : "Result of operation " + iOperation.getOperationName() + " is wrong (according to its checkResult method)";
                return iOperation.getResult();
            }
            catch (AutomataLibraryException | AssertionError | OutOfMemoryError object2) {
                throw new InterpreterException(operationInvocationExpressionAST.getLocation(), (Throwable)object2);
            }
        }
        return object;
    }

    private void executeWriteMethod(OperationInvocationExpressionAST operationInvocationExpressionAST, List<AtsASTNode> list, ArrayList<Object> arrayList) throws InterpreterException {
        AutomatonDefinitionPrinter.Format format;
        if (arrayList.size() != 3) {
            throw new InterpreterException(operationInvocationExpressionAST.getLocation(), "write needs three arguments");
        }
        String string = (String)arrayList.get(1);
        String string2 = (String)arrayList.get(2);
        try {
            format = AutomatonDefinitionPrinter.Format.valueOf((String)string2);
        }
        catch (Exception exception) {
            throw new InterpreterException(operationInvocationExpressionAST.getLocation(), "unknown format " + string);
        }
        String string3 = list.get(0).getAsString();
        this.reportToLogger(LoggerSeverity.INFO, "Writing " + string3 + " to file " + string + " in " + String.valueOf(format) + " format.");
        IAutomaton iAutomaton = (IAutomaton)arrayList.get(0);
        new AutomatonDefinitionPrinter(new AutomataLibraryServices(this.mServices), "ats", string, format, "output according to \"write\" command", new IAutomaton[]{iAutomaton});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executePrintMethod(OperationInvocationExpressionAST operationInvocationExpressionAST, List<AtsASTNode> list, ArrayList<Object> arrayList) throws InterpreterException {
        String string;
        String string2 = list.get(0).getAsString();
        this.reportToLogger(LoggerSeverity.INFO, "Printing " + string2);
        if (arrayList.get(0) instanceof IAutomaton) {
            if (arrayList.size() == 1) {
            } else {
                if (arrayList.size() != 2) throw new InterpreterException(operationInvocationExpressionAST.getLocation(), "if first argument of print command is an automaton only two arguments are allowed");
                if (!(arrayList.get(1) instanceof String)) throw new InterpreterException(operationInvocationExpressionAST.getLocation(), "if first argument of print command is an automaton second argument has to be a string that defines an output format");
                try {
                    AutomatonDefinitionPrinter.Format.valueOf((String)((String)arrayList.get(1)));
                }
                catch (Exception exception) {
                    throw new InterpreterException(operationInvocationExpressionAST.getLocation(), "unknown format " + (String)arrayList.get(1));
                }
            }
            this.mLastPrintedAutomaton = (IAutomaton)arrayList.get(0);
            string = AutomatonDefinitionPrinter.toString((AutomataLibraryServices)new AutomataLibraryServices(this.mServices), (String)"automaton", this.mLastPrintedAutomaton);
        } else {
            if (arrayList.size() > 1) {
                throw new InterpreterException(operationInvocationExpressionAST.getLocation(), "if first argument of print command is not an automaton no second argument allowed");
            }
            string = String.valueOf(arrayList.get(0));
        }
        this.printMessage(IResultWithSeverity.Severity.INFO, LoggerSeverity.INFO, string, operationInvocationExpressionAST.getAsString(), (AtsASTNode)operationInvocationExpressionAST);
        if (!this.mPrintAutomataToFile) return;
        String string3 = "/* " + operationInvocationExpressionAST.getAsString() + " */";
        this.mPrintWriter.println(string3);
        this.mPrintWriter.println(string);
    }

    private Object executeAssertMethod(OperationInvocationExpressionAST operationInvocationExpressionAST, ArrayList<Object> arrayList) throws AssertionError {
        Object object = arrayList.get(0);
        if (object instanceof Boolean) {
            if (((Boolean)object).booleanValue()) {
                this.mResultOfAssertStatements.add((GenericResultAtElement<AtsASTNode>)new GenericResultAtElement((IElement)operationInvocationExpressionAST, Activator.PLUGIN_ID, this.mServices.getBacktranslationService(), ASSERTION_HOLDS_MESSAGE, operationInvocationExpressionAST.getAsString(), IResultWithSeverity.Severity.INFO));
            } else {
                this.mResultOfAssertStatements.add((GenericResultAtElement<AtsASTNode>)new GenericResultAtElement((IElement)operationInvocationExpressionAST, Activator.PLUGIN_ID, this.mServices.getBacktranslationService(), ASSERTION_VIOLATED_MESSAGE, operationInvocationExpressionAST.getAsString(), IResultWithSeverity.Severity.ERROR));
            }
        } else {
            throw new AssertionError((Object)"assert expects boolean result, type checker should have found this");
        }
        return object;
    }

    private Boolean interpret(RelationalExpressionAST relationalExpressionAST) throws InterpreterException {
        List list = relationalExpressionAST.getOutgoingNodes();
        if (relationalExpressionAST.getExpectingType() == Integer.class) {
            int n = (Integer)this.interpret((AtsASTNode)list.get(0));
            int n2 = (Integer)this.interpret((AtsASTNode)list.get(1));
            switch (relationalExpressionAST.getOperator()) {
                case GREATERTHAN: {
                    if (n > n2) {
                        return true;
                    }
                    return false;
                }
                case LESSTHAN: {
                    if (n < n2) {
                        return true;
                    }
                    return false;
                }
                case GREATER_EQ_THAN: {
                    if (n >= n2) {
                        return true;
                    }
                    return false;
                }
                case LESS_EQ_THAN: {
                    if (n <= n2) {
                        return true;
                    }
                    return false;
                }
                case EQ: {
                    if (n == n2) {
                        return true;
                    }
                    return false;
                }
                case NOT_EQ: {
                    if (n != n2) {
                        return true;
                    }
                    return false;
                }
            }
            throw new InterpreterException(relationalExpressionAST.getLocation(), "This type of operator is not supported: " + String.valueOf(relationalExpressionAST.getOperator()));
        }
        return null;
    }

    private Object interpret(ReturnStatementAST returnStatementAST) throws InterpreterException {
        List list = returnStatementAST.getOutgoingNodes();
        this.mFlow = Flow.RETURN;
        if (list.isEmpty()) {
            return null;
        }
        return this.interpret((AtsASTNode)list.get(0));
    }

    private Object interpret(StatementListAST statementListAST) throws InterpreterException {
        for (AtsASTNode atsASTNode : statementListAST.getOutgoingNodes()) {
            this.interpret(atsASTNode);
        }
        return null;
    }

    private Integer interpret(UnaryExpressionAST unaryExpressionAST) throws InterpreterException {
        List list = unaryExpressionAST.getOutgoingNodes();
        VariableExpressionAST variableExpressionAST = (VariableExpressionAST)list.get(0);
        Integer n = (Integer)this.interpret(variableExpressionAST);
        switch (unaryExpressionAST.getOperator()) {
            case EXPR_PLUSPLUS: {
                this.mVariables.put(variableExpressionAST.getIdentifier(), n + 1);
                return n;
            }
            case EXPR_MINUSMINUS: {
                this.mVariables.put(variableExpressionAST.getIdentifier(), n - 1);
                return n;
            }
            case PLUSPLUS_EXPR: {
                this.mVariables.put(variableExpressionAST.getIdentifier(), n + 1);
                return n + 1;
            }
            case MINUSMINUS_EXPR: {
                this.mVariables.put(variableExpressionAST.getIdentifier(), n - 1);
                return n - 1;
            }
        }
        String string = unaryExpressionAST.getLocation().getStartLine() + ": UnaryExpression: This type of operator is not supported: " + String.valueOf(unaryExpressionAST.getOperator());
        throw new InterpreterException(unaryExpressionAST.getLocation(), string);
    }

    private Object interpret(VariableDeclarationAST variableDeclarationAST) throws InterpreterException {
        List list = variableDeclarationAST.getOutgoingNodes();
        Object object = null;
        if (list.size() == 1) {
            object = this.interpret((AtsASTNode)list.get(0));
        }
        for (String string : variableDeclarationAST.getIdentifiers()) {
            if (object == null) {
                String string2 = "Var \"" + string + "\" is assigned \"null\".";
                throw new InterpreterException(variableDeclarationAST.getLocation(), string2);
            }
            this.mVariables.put(string, object);
        }
        return null;
    }

    private Object interpret(VariableExpressionAST variableExpressionAST) throws InterpreterException {
        if (!this.mVariables.containsKey(variableExpressionAST.getIdentifier())) {
            String string = "Variable \"" + variableExpressionAST.getIdentifier() + "\" was not declared before.";
            throw new InterpreterException(variableExpressionAST.getLocation(), string);
        }
        return this.mVariables.get(variableExpressionAST.getIdentifier());
    }

    private Object interpret(WhileStatementAST whileStatementAST) throws InterpreterException {
        List list = whileStatementAST.getOutgoingNodes();
        Boolean bl = (Boolean)this.interpret((AtsASTNode)list.get(0));
        while (bl.booleanValue()) {
            List list2 = ((AtsASTNode)list.get(1)).getOutgoingNodes();
            for (AtsASTNode atsASTNode : list2) {
                this.interpret(atsASTNode);
                if (this.mFlow == Flow.NORMAL) continue;
                switch (this.mFlow) {
                    case BREAK: 
                    case RETURN: {
                        this.mFlow = Flow.NORMAL;
                        return null;
                    }
                    case CONTINUE: {
                        this.mFlow = Flow.NORMAL;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
            bl = (Boolean)this.interpret((AtsASTNode)list.get(0));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void reportResult(Finished finished, String string) {
        void var4_12;
        Object object;
        this.mLogger.info((Object)"----------------- Test Summary -----------------");
        boolean bl = false;
        for (GenericResultAtElement<AtsASTNode> overallResult2 : this.mResultOfAssertStatements) {
            this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, overallResult2);
            if (overallResult2.getSeverity() == IResultWithSeverity.Severity.ERROR) {
                bl = true;
            }
            this.reportToLogger(LoggerSeverity.INFO, "Line " + overallResult2.getLocation().getStartLine() + ": " + overallResult2.getShortDescription());
        }
        if (finished == Finished.FINISHED) {
            object = LoggerSeverity.INFO;
            if (this.mResultOfAssertStatements.isEmpty()) {
                AutomataScriptInterpreterOverallResult.OverallResult overallResult = AutomataScriptInterpreterOverallResult.OverallResult.NO_ASSERTION;
            } else if (bl) {
                AutomataScriptInterpreterOverallResult.OverallResult overallResult = AutomataScriptInterpreterOverallResult.OverallResult.SOME_ASSERTION_FAILED;
            } else {
                AutomataScriptInterpreterOverallResult.OverallResult overallResult = AutomataScriptInterpreterOverallResult.OverallResult.ALL_ASSERTIONS_HOLD;
            }
        } else if (finished == Finished.TIMEOUT) {
            object = LoggerSeverity.INFO;
            AutomataScriptInterpreterOverallResult.OverallResult overallResult = AutomataScriptInterpreterOverallResult.OverallResult.TIMEOUT;
        } else if (finished == Finished.OUTOFMEMORY) {
            object = LoggerSeverity.INFO;
            AutomataScriptInterpreterOverallResult.OverallResult overallResult = AutomataScriptInterpreterOverallResult.OverallResult.OUT_OF_MEMORY;
        } else if (finished == Finished.ERROR) {
            object = LoggerSeverity.ERROR;
            AutomataScriptInterpreterOverallResult.OverallResult overallResult = AutomataScriptInterpreterOverallResult.OverallResult.EXCEPTION_OR_ERROR;
        } else {
            throw new AssertionError();
        }
        AutomataScriptInterpreterOverallResult automataScriptInterpreterOverallResult = new AutomataScriptInterpreterOverallResult(Activator.PLUGIN_ID, (AutomataScriptInterpreterOverallResult.OverallResult)var4_12, string);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)automataScriptInterpreterOverallResult);
        this.reportToLogger((LoggerSeverity)((Object)object), automataScriptInterpreterOverallResult.getLongDescription());
    }

    @Override
    public void printMessage(IResultWithSeverity.Severity severity, LoggerSeverity loggerSeverity, String string, String string2, AtsASTNode atsASTNode) {
        this.reportToUltimate(severity, string, string2, atsASTNode);
        this.reportToLogger(loggerSeverity, string);
    }

    private void reportToUltimate(IResultWithSeverity.Severity severity, String string, String string2, AtsASTNode atsASTNode) {
        Object object = atsASTNode == null ? new GenericResult(Activator.PLUGIN_ID, string2, string, severity) : new GenericResultAtElement((IElement)atsASTNode, Activator.PLUGIN_ID, this.mServices.getBacktranslationService(), string2, string, severity);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)object);
    }

    private void reportToLogger(LoggerSeverity loggerSeverity, String string) {
        switch (loggerSeverity) {
            case ERROR: {
                this.mLogger.error((Object)string);
                break;
            }
            case WARNING: {
                this.mLogger.warn((Object)string);
                break;
            }
            case DEBUG: {
                this.mLogger.debug((Object)string);
                break;
            }
            default: {
                this.mLogger.info((Object)string);
            }
        }
    }

    private IOperation<String, String, ? super StringFactory> getAutomataOperation(OperationInvocationExpressionAST operationInvocationExpressionAST, List<Object> list) throws InterpreterException {
        Object object3;
        String string = operationInvocationExpressionAST.getOperationName();
        if (!this.mExistingOperations.containsKey(string)) {
            String string2 = new ListExistingOperations(this.mExistingOperations).prettyPrint();
            String object3 = "Unsupported operation \"" + string + "\"" + System.getProperty("line.separator") + "We support only the following operations " + System.getProperty("line.separator") + string2;
            throw new InterpreterException(operationInvocationExpressionAST.getLocation(), object3);
        }
        for (Class<?> serializable2 : this.mExistingOperations.get(string)) {
            Object object2;
            Constructor<?>[] constructorArray = serializable2.getConstructors();
            if (constructorArray.length == 0) {
                object2 = "Error in automata library: operation " + string + " does not have a constructor";
                throw new InterpreterException(operationInvocationExpressionAST.getLocation(), (String)object2, (String)object2);
            }
            Constructor<?>[] constructorArray2 = constructorArray;
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = constructorArray2[n2];
                assert (TestFileInterpreter.isNoStateFactoryAfterSecondArgument(((Constructor)object2).getParameterTypes())) : "constructor of " + ((Constructor)object2).getDeclaringClass().getSimpleName() + " violates \"services and state factory first\" convention";
                Object[] objectArray = this.prependAutomataLibraryServicesAndStateFactoryIfNeeded((Constructor<?>)object2, list);
                if (TestFileInterpreter.allArgumentsHaveCorrectTypeForThisConstructor(object2, objectArray)) {
                    try {
                        return (IOperation)((Constructor)object2).newInstance(objectArray);
                    }
                    catch (IllegalAccessException | InstantiationException invocationTargetException) {
                        TestFileInterpreter.printStackTrace(invocationTargetException);
                        throw new AssertionError((Object)invocationTargetException);
                    }
                    catch (InvocationTargetException outOfMemoryError) {
                        Throwable throwable = outOfMemoryError.getTargetException();
                        if (!(throwable instanceof AutomataLibraryException)) {
                            TestFileInterpreter.printStackTrace(outOfMemoryError);
                        }
                        if (throwable instanceof InterpreterException) {
                            throw (InterpreterException)throwable;
                        }
                        throw new InterpreterException(operationInvocationExpressionAST.getLocation(), throwable);
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        throw new InterpreterException(operationInvocationExpressionAST.getLocation(), (Throwable)outOfMemoryError);
                    }
                }
                ++n2;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Operation \"").append(operationInvocationExpressionAST.getOperationName()).append("\" is not defined for ").append(list.size() == 1 ? "this type of argument." : "these types of arguments.").append(" (");
        for (Object object3 : list) {
            stringBuilder.append(object3.getClass().getSimpleName()).append(" ");
        }
        stringBuilder.append(")");
        object3 = stringBuilder.toString();
        this.printMessage(IResultWithSeverity.Severity.ERROR, LoggerSeverity.DEBUG, (String)object3, "Operation error", (AtsASTNode)operationInvocationExpressionAST);
        throw new InterpreterException(operationInvocationExpressionAST.getLocation(), (String)object3);
    }

    private static void printStackTrace(Exception exception) {
        exception.printStackTrace();
    }

    private Object[] prependAutomataLibraryServicesAndStateFactoryIfNeeded(Constructor<?> constructor, List<Object> list) {
        assert (TestFileInterpreter.isServicesFirstArgument(constructor.getParameterTypes()));
        boolean bl = TestFileInterpreter.isStateFactorySecondArgument(constructor.getParameterTypes());
        int n = list.size() + (bl ? 2 : 1);
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        arrayList.add(new AutomataLibraryServices(this.mServices));
        if (bl) {
            arrayList.add(new StringFactory());
        }
        arrayList.addAll(list);
        return arrayList.toArray();
    }

    private static boolean isServicesFirstArgument(Class<?>[] classArray) {
        if (classArray.length < 1) {
            return false;
        }
        return AutomataLibraryServices.class.isAssignableFrom(classArray[0]);
    }

    private static boolean isStateFactorySecondArgument(Class<?>[] classArray) {
        if (classArray.length < 1) {
            return false;
        }
        return IStateFactory.class.isAssignableFrom(classArray[1]);
    }

    private static boolean isNoStateFactoryAfterSecondArgument(Class<?>[] classArray) {
        int n = 2;
        while (n < classArray.length) {
            if (IStateFactory.class.isAssignableFrom(classArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static boolean allArgumentsHaveCorrectTypeForThisConstructor(Constructor<?> constructor, Object[] objectArray) {
        if (objectArray.length == constructor.getParameterTypes().length) {
            int n = 0;
            Class<?>[] classArray = constructor.getParameterTypes();
            int n2 = classArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Class<?> clazz = classArray[n3];
                if (AssignableTest.isAssignableFrom(clazz, objectArray[n].getClass())) {
                    ++n;
                } else {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }

    private Map<String, Set<Class<?>>> getOperationClasses() {
        String[] stringArray;
        HashMap hashMap = new HashMap();
        String[] stringArray2 = stringArray = new String[]{"de.uni_freiburg.informatik.ultimate.automata.alternating", "de.uni_freiburg.informatik.ultimate.automata.counting", "de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi", "de.uni_freiburg.informatik.ultimate.automata.nestedword.operations", "de.uni_freiburg.informatik.ultimate.automata.petrinet", "de.uni_freiburg.informatik.ultimate.automata.tree.operations", "de.uni_freiburg.informatik.ultimate.automata.rabin"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            Collection<File> collection = this.filesInDirectory(TestFileInterpreter.getPathFromPackageName(string));
            for (File file : collection) {
                String string2;
                boolean bl = this.addClassIfOperation(hashMap, string, file, string2 = file.getName());
                if (bl || !this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("Not considering " + file.getAbsolutePath()));
            }
            ++n2;
        }
        return hashMap;
    }

    private boolean addClassIfOperation(Map<String, Set<Class<?>>> map, String string, File file, String string2) {
        if (!string2.endsWith(".class")) {
            return false;
        }
        if (string2.contains("$")) {
            return false;
        }
        Class<?> clazz = this.getClassFromFile(string, file);
        if (clazz == null) {
            return false;
        }
        if (TestFileInterpreter.classIsAbstract(clazz)) {
            return false;
        }
        if (!ReflectionUtil.isClassImplementingInterface(clazz, IOperation.class)) {
            return false;
        }
        String string3 = IOperation.computeOperationName(clazz);
        Set<Class<?>> set = map.get(string3);
        if (set == null) {
            set = new HashSet();
            map.put(string3, set);
        }
        set.add(clazz);
        return true;
    }

    private Class<?> getClassFromFile(String string, File file) {
        Class<?> clazz;
        String string2 = TestFileInterpreter.getQualifiedNameFromFile(string, file);
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.mLogger.error((Object)("Couldn't load/find class " + string2));
            return null;
        }
        return clazz;
    }

    private static String getQualifiedNameFromFile(String string, File file) {
        assert (file != null);
        assert (file.getName().endsWith(".class"));
        String string2 = file.getAbsolutePath();
        String string3 = string2.substring(0, string2.length() - 6);
        String string4 = TestFileInterpreter.getPathFromPackageName(string);
        int n = string3.indexOf(string4);
        assert (n != -1);
        return string3.substring(n).replace(File.separatorChar, '.');
    }

    private static String getPathFromPackageName(String string) {
        return string.replace(".", File.separator);
    }

    private static boolean classIsAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    private Collection<File> filesInDirectory(String string) {
        File file;
        URL uRL = IOperation.class.getClassLoader().getResource(string);
        if (uRL == null) {
            this.mLogger.error((Object)(DIRECTORY + string + DOES_NOT_EXIST));
            return Collections.emptyList();
        }
        String string2 = uRL.getProtocol();
        if ("file".equals(string2)) {
            try {
                file = new File(uRL.toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                this.mLogger.error((Object)(DIRECTORY + string + DOES_NOT_EXIST));
                return Collections.emptyList();
            }
        } else if ("bundleresource".equals(string2)) {
            try {
                URL uRL2 = FileLocator.toFileURL((URL)uRL);
                file = new File(uRL2.getFile());
            }
            catch (Exception exception) {
                this.mLogger.error((Object)(DIRECTORY + string + DOES_NOT_EXIST));
                return Collections.emptyList();
            }
        } else {
            throw new UnsupportedOperationException("unknown protocol");
        }
        return TestFileInterpreter.resolveDirectories(Arrays.asList(file));
    }

    private static Collection<File> resolveDirectories(Collection<File> collection) {
        ArrayDeque<File> arrayDeque = new ArrayDeque<File>();
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayDeque.addAll(collection);
        while (!arrayDeque.isEmpty()) {
            File file = (File)arrayDeque.removeFirst();
            if (file.isFile()) {
                arrayList.add(file);
                continue;
            }
            arrayDeque.addAll(Arrays.asList(file.listFiles()));
        }
        return arrayList;
    }

    private static boolean isStatisticsEnumAlphabeticallySorted() {
        StatisticsType[] statisticsTypeArray = StatisticsType.values();
        int n = 1;
        while (n < statisticsTypeArray.length) {
            if (statisticsTypeArray[n - 1].toString().compareTo(statisticsTypeArray[n].toString()) > 0) {
                StatisticsType statisticsType = statisticsTypeArray[n];
                StatisticsType statisticsType2 = statisticsTypeArray[n - 1];
                assert (false) : "The entries of enum StatisticsType are not sorted alphabetically. Too late: " + String.valueOf(statisticsType) + " too early: " + String.valueOf(statisticsType2);
                return false;
            }
            ++n;
        }
        return true;
    }

    private static enum Finished {
        FINISHED,
        TIMEOUT,
        ERROR,
        OUTOFMEMORY;

    }

    static enum Flow {
        NORMAL,
        BREAK,
        CONTINUE,
        RETURN;

    }

    public static enum LoggerSeverity {
        INFO,
        WARNING,
        ERROR,
        DEBUG;

    }

    private static class SimpleTimer {
        private final long mStartTime = System.nanoTime();

        public long checkTime() {
            return System.nanoTime() - this.mStartTime;
        }
    }
}

