/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.BvToIntTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.BvToIntTranslation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.IntToBvBackTranslation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;

public class TranslationManager {
    private final ManagedScript mMgdScript;
    private final Script mScript;
    private final FunctionSymbol mIntand;
    private LinkedHashMap<Term, Term> mVariableMap;
    private LinkedHashMap<Term, Term> mReversedVarMap;
    private final TranslationConstrainer mTc;
    private HashSet<Term> mConstraintSet;
    private final boolean mNutzTransformation;
    private final TranslationConstrainer.ConstraintsForBitwiseOperations mCfo;

    public TranslationManager(ManagedScript managedScript, TranslationConstrainer.ConstraintsForBitwiseOperations constraintsForBitwiseOperations, boolean bl) {
        this.mMgdScript = managedScript;
        this.mScript = managedScript.getScript();
        this.mVariableMap = new LinkedHashMap();
        this.mReversedVarMap = new LinkedHashMap();
        this.mConstraintSet = new HashSet();
        this.mTc = new TranslationConstrainer(this.mMgdScript, constraintsForBitwiseOperations);
        this.mIntand = this.mTc.getIntAndFunctionSymbol();
        this.mNutzTransformation = bl;
        this.mCfo = constraintsForBitwiseOperations;
    }

    public void setReplacementVarMaps(LinkedHashMap<Term, Term> linkedHashMap) {
        this.mVariableMap = linkedHashMap;
    }

    public Triple<Term, Set<TermVariable>, Boolean> translateBvtoInt(Term term) {
        BvToIntTranslation bvToIntTranslation = new BvToIntTranslation(this.mMgdScript, this.mVariableMap, this.mTc, term.getFreeVars(), this.mNutzTransformation);
        Term term2 = bvToIntTranslation.transform(term);
        this.mVariableMap = bvToIntTranslation.getVarMap();
        this.mReversedVarMap = bvToIntTranslation.getReversedVarMap();
        Set<TermVariable> set = bvToIntTranslation.getOverapproxVariables();
        boolean bl = bvToIntTranslation.wasOverapproximation();
        if (!this.mNutzTransformation) {
            this.mConstraintSet.addAll(this.mTc.getConstraints());
            this.mConstraintSet.addAll(bvToIntTranslation.mArraySelectConstraintMap.values());
        }
        Term term3 = SmtUtils.and(this.mScript, term2, SmtUtils.and(this.mScript, this.mConstraintSet));
        return new Triple((Object)term3, set, (Object)bl);
    }

    public Triple<Term, Set<Term>, Boolean> translateBvtoIntTransferrer(Term term, Script script, Script script2) {
        Term term2;
        this.mConstraintSet = new HashSet();
        TranslationConstrainer translationConstrainer = new TranslationConstrainer(this.mMgdScript, this.mCfo);
        BvToIntTransferrer bvToIntTransferrer = new BvToIntTransferrer(script, script2, this.mMgdScript, this.mVariableMap, translationConstrainer, term.getFreeVars(), this.mNutzTransformation);
        try {
            term2 = bvToIntTransferrer.transform(term);
        }
        catch (SMTLIBException sMTLIBException) {
            throw new AssertionError((Object)("Translation error " + String.valueOf((Object)sMTLIBException)));
        }
        this.mVariableMap = bvToIntTransferrer.getVarMap();
        this.mReversedVarMap = bvToIntTransferrer.getReversedVarMap();
        Set<Term> set = bvToIntTransferrer.getOverapproxVariables();
        boolean bl = bvToIntTransferrer.wasOverapproximation();
        if (!this.mNutzTransformation) {
            this.mConstraintSet.addAll(translationConstrainer.getConstraints());
            this.mConstraintSet.addAll(bvToIntTransferrer.mArrayConstraintMap.values());
        } else {
            this.mConstraintSet.addAll(translationConstrainer.getBvandConstraints());
        }
        if (!this.mConstraintSet.isEmpty() && !SmtSortUtils.isBoolSort(term2.getSort())) {
            throw new AssertionError((Object)"Cannot add constraints to non-Boolean formula.");
        }
        Term term3 = SmtUtils.and(this.mScript, term2, SmtUtils.and(this.mScript, this.mConstraintSet));
        return new Triple((Object)term3, set, (Object)bl);
    }

    public Term translateIntBacktoBv(Term term) {
        UnfTransformer unfTransformer = new UnfTransformer(this.mScript);
        Term term2 = unfTransformer.transform(term);
        HashSet<Term> hashSet = this.mConstraintSet;
        hashSet.addAll(this.mTc.getTvConstraints());
        IntToBvBackTranslation intToBvBackTranslation = new IntToBvBackTranslation(this.mMgdScript, this.mReversedVarMap, hashSet, this.mIntand);
        return intToBvBackTranslation.transform(term2);
    }

    public LinkedHashMap<Term, Term> getVarMap() {
        return this.mVariableMap;
    }

    public LinkedHashMap<Term, Term> getReversedVarMap() {
        return this.mReversedVarMap;
    }
}

