/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ContractStatement;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class Decreases
extends ContractStatement {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(Decreases.class);
    Expression formula;
    String identifier;

    public Decreases(Expression expression) {
        this.formula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Decreases: " + String.valueOf(this);
    }

    public Decreases(Expression expression, String string) {
        this.formula = expression;
        this.identifier = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid Decreases: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Decreases").append('[');
        stringBuffer.append(this.formula);
        stringBuffer.append(',').append(this.identifier);
        return stringBuffer.append(']').toString();
    }

    public Expression getFormula() {
        return this.formula;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.formula);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((ContractStatement)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.formula != null) {
            this.formula.accept(aCSLVisitor);
        }
    }

    @Override
    public ContractStatement accept(ACSLTransformer aCSLTransformer) {
        ContractStatement contractStatement = aCSLTransformer.transform(this);
        if (contractStatement != this) {
            return contractStatement;
        }
        Expression expression = null;
        if (this.formula != null) {
            expression = this.formula.accept(aCSLTransformer);
        }
        if (this.formula != expression) {
            return new Decreases(expression, this.identifier);
        }
        return this;
    }
}

