/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class QuantifierExpression
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(QuantifierExpression.class);
    boolean isUniversal;
    Declaration[] variables;
    Expression subformula;

    public QuantifierExpression(boolean bl, Declaration[] declarationArray, Expression expression) {
        this.isUniversal = bl;
        this.variables = declarationArray;
        this.subformula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid QuantifierExpression: " + String.valueOf(this);
    }

    public QuantifierExpression(ACSLType aCSLType, boolean bl, Declaration[] declarationArray, Expression expression) {
        super(aCSLType);
        this.isUniversal = bl;
        this.variables = declarationArray;
        this.subformula = expression;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid QuantifierExpression: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("QuantifierExpression").append('[');
        stringBuffer.append(this.isUniversal);
        stringBuffer.append(',');
        if (this.variables == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.variables.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.variables[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append(this.subformula);
        return stringBuffer.append(']').toString();
    }

    public boolean isUniversal() {
        return this.isUniversal;
    }

    public Declaration[] getVariables() {
        return this.variables;
    }

    public Expression getSubformula() {
        return this.subformula;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.variables != null) {
            list.addAll(Arrays.asList(this.variables));
        }
        list.add(this.subformula);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this)) {
            if (this.variables != null) {
                Declaration[] declarationArray = this.variables;
                int n = this.variables.length;
                int n2 = 0;
                while (n2 < n) {
                    Declaration declaration = declarationArray[n2];
                    declaration.accept(aCSLVisitor);
                    ++n2;
                }
            }
            if (this.subformula != null) {
                this.subformula.accept(aCSLVisitor);
            }
            if (this.type != null) {
                this.type.accept(aCSLVisitor);
            }
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        ACSLNode aCSLNode;
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        boolean bl = false;
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        if (this.variables != null) {
            Declaration[] declarationArray = this.variables;
            int n = this.variables.length;
            int n2 = 0;
            while (n2 < n) {
                aCSLNode = declarationArray[n2];
                Declaration declaration = ((Declaration)aCSLNode).accept(aCSLTransformer);
                bl = bl || declaration != aCSLNode;
                arrayList.add(declaration);
                ++n2;
            }
        }
        aCSLNode = null;
        if (this.subformula != null) {
            aCSLNode = this.subformula.accept(aCSLTransformer);
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (bl || this.subformula != aCSLNode || this.type != aCSLType) {
            return new QuantifierExpression(aCSLType, this.isUniversal, arrayList.toArray(new Declaration[0]), (Expression)aCSLNode);
        }
        return this;
    }
}

