/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRUtils;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.paraoct.OctTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OctConjunction {
    private final ArrayList<OctTerm> mTerms = new ArrayList();
    private Set<TermVariable> mCachedVariables = new LinkedHashSet<TermVariable>();

    public void addTerm(OctTerm octTerm) {
        if (octTerm == null) {
            return;
        }
        this.mTerms.add(octTerm);
        this.mCachedVariables = null;
    }

    public void removeTerm(OctTerm octTerm) {
        this.mTerms.remove(octTerm);
        this.mCachedVariables = null;
    }

    public List<OctTerm> getTerms() {
        return this.mTerms;
    }

    public int getVariableCount() {
        return this.getVariables().size();
    }

    public Set<TermVariable> getVariables() {
        if (this.mCachedVariables != null) {
            return this.mCachedVariables;
        }
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        for (OctTerm octTerm : this.mTerms) {
            if (octTerm.isOneVar()) {
                linkedHashSet.add(octTerm.getFirstVar());
                continue;
            }
            linkedHashSet.add(octTerm.getFirstVar());
            linkedHashSet.add(octTerm.getSecondVar());
        }
        this.mCachedVariables = linkedHashSet;
        return linkedHashSet;
    }

    public String toString() {
        if (this.mTerms.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("(" + this.mTerms.get(0).toString() + ")");
        int n = 1;
        while (n < this.mTerms.size()) {
            stringBuilder.append(" and (" + this.mTerms.get(n).toString() + ")");
            ++n;
        }
        return stringBuilder.toString();
    }

    public Term toTerm(Script script, FastUPRUtils fastUPRUtils) {
        if (this.isEmpty()) {
            return script.term("true", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (OctTerm object2 : this.mTerms) {
            fastUPRUtils.debug("OctTerm: " + object2.toString());
            arrayList.add(object2.toTerm(script));
            fastUPRUtils.debug("Term: " + object2.toTerm(script).toString());
        }
        Term[] termArray2 = new Term[arrayList.size()];
        termArray2 = arrayList.toArray(termArray2);
        Term term = script.term("and", termArray2);
        fastUPRUtils.debug(term.toString());
        return term;
    }

    public Term toTerm(Script script) {
        if (this.isEmpty()) {
            return script.term("true", new Term[0]);
        }
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (OctTerm object2 : this.mTerms) {
            arrayList.add(object2.toTerm(script));
        }
        Term[] termArray2 = new Term[arrayList.size()];
        termArray2 = arrayList.toArray(termArray2);
        if (termArray2.length == 1) {
            return termArray2[0];
        }
        return script.term("and", termArray2);
    }

    public boolean isEmpty() {
        return this.mTerms.isEmpty();
    }
}

