/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class RewriteDivision
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replace integer division by equivalent linear constraints";
    private static final String DIV_AUX_PREFIX = "div_aux";
    private static final String MOD_AUX_PREFIX = "mod_aux";
    private static final boolean CHECK_RESULT = true;
    private static final boolean CHECK_RESULT_WITH_QUAMTIFIERS = false;
    private final Map<TermVariable, Term> mAuxVars;
    private final ReplacementVarFactory mVarFactory;
    private final Collection<Term> mAuxTerms;

    public RewriteDivision(ReplacementVarFactory replacementVarFactory) {
        this.mVarFactory = replacementVarFactory;
        this.mAuxVars = new LinkedHashMap<TermVariable, Term>();
        this.mAuxTerms = new ArrayList<Term>();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula) throws TermException {
        this.mAuxVars.clear();
        this.mAuxTerms.clear();
        ModifiableTransFormula modifiableTransFormula2 = super.process(managedScript, modifiableTransFormula);
        Term term = modifiableTransFormula2.getFormula();
        Term term2 = SmtUtils.and((Script)managedScript.getScript(), (Term[])this.mAuxTerms.toArray(new Term[this.mAuxTerms.size()]));
        modifiableTransFormula2.setFormula(SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term, term2}));
        modifiableTransFormula2.addAuxVars(this.mAuxVars.keySet());
        return modifiableTransFormula2;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        Term term;
        Term term2 = modifiableTransFormula.getFormula();
        Term term3 = SmtUtils.and((Script)script, (Term[])new Term[]{term2, SmtUtils.and((Script)script, (Term[])this.mAuxTerms.toArray(new Term[this.mAuxTerms.size()]))});
        boolean bl = this.isIncorrect(script, term3, term = modifiableTransFormula2.getFormula());
        boolean bl2 = false;
        return !bl && !bl2;
    }

    private boolean isIncorrect(Script script, Term term, Term term2) {
        return Script.LBool.SAT == Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term2}));
    }

    private boolean isIncorrectWithQuantifiers(Script script, Term term, Term term2) {
        Term term3 = !this.mAuxVars.isEmpty() ? script.quantifier(0, this.mAuxVars.keySet().toArray(new TermVariable[this.mAuxVars.size()]), term2, (Term[][])new Term[0][]) : script.term("true", new Term[0]);
        return Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term3})) == Script.LBool.SAT;
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript managedScript) {
        return new RewriteDivisionTransformer(managedScript.getScript());
    }

    private class RewriteDivisionTransformer
    extends TermTransformer {
        private final Script mScript;

        RewriteDivisionTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
            String string = applicationTerm.getFunction().getName();
            if (string.equals("div")) {
                assert (applicationTerm.getParameters().length == 2);
                Term term = termArray[0];
                Term term2 = termArray[1];
                TermVariable termVariable = RewriteDivision.this.mVarFactory.getOrConstructAuxVar(RewriteDivision.DIV_AUX_PREFIX + term.toString() + term2.toString(), applicationTerm.getSort());
                RewriteDivision.this.mAuxVars.put(termVariable, (Term)applicationTerm);
                Term term3 = this.computeDivAuxTerms(term, term2, termVariable);
                RewriteDivision.this.mAuxTerms.add(term3);
                this.setResult((Term)termVariable);
            } else if (string.equals("mod")) {
                assert (applicationTerm.getParameters().length == 2);
                Term term = termArray[0];
                Term term4 = termArray[1];
                TermVariable termVariable = RewriteDivision.this.mVarFactory.getOrConstructAuxVar(RewriteDivision.DIV_AUX_PREFIX + term.toString() + term4.toString(), applicationTerm.getSort());
                RewriteDivision.this.mAuxVars.put(termVariable, this.mScript.term("div", new Term[]{term, term4}));
                TermVariable termVariable2 = RewriteDivision.this.mVarFactory.getOrConstructAuxVar(RewriteDivision.MOD_AUX_PREFIX + term.toString() + term4.toString(), applicationTerm.getSort());
                RewriteDivision.this.mAuxVars.put(termVariable2, (Term)applicationTerm);
                Term term5 = this.computeModAuxTerms(term, term4, termVariable, termVariable2);
                RewriteDivision.this.mAuxTerms.add(term5);
                this.setResult((Term)termVariable2);
            } else {
                super.convertApplicationTerm(applicationTerm, termArray);
            }
        }

        private Term computeDivAuxTerms(Term term, Term term2, TermVariable termVariable) {
            Term[] termArray = new Term[2];
            Term term3 = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ONE);
            Term term4 = this.mScript.term("-", new Term[]{term3});
            Term term5 = this.mScript.term("<=", new Term[]{term2, term4});
            Term term6 = this.mScript.term(">=", new Term[]{term2, term3});
            Term term7 = this.mScript.term("*", new Term[]{termVariable, term2});
            Term term8 = this.mScript.term("<=", new Term[]{term7, term});
            Term term9 = this.mScript.term("*", new Term[]{this.mScript.term("+", new Term[]{termVariable, term3}), term2});
            Term term10 = this.mScript.term("-", new Term[]{term9, term3});
            Term term11 = this.mScript.term("*", new Term[]{this.mScript.term("-", new Term[]{termVariable, term3}), term2});
            Term term12 = this.mScript.term("-", new Term[]{term11, term3});
            Term term13 = this.mScript.term("<=", new Term[]{term, term10});
            Term term14 = this.mScript.term("<=", new Term[]{term, term12});
            termArray[0] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term6, term8, term13});
            termArray[1] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term8, term14});
            return SmtUtils.or((Script)this.mScript, (Term[])termArray);
        }

        private Term computeModAuxTerms(Term term, Term term2, TermVariable termVariable, TermVariable termVariable2) {
            Term[] termArray = new Term[2];
            Term term3 = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ONE);
            Term term4 = this.mScript.term("-", new Term[]{term3});
            Term term5 = this.mScript.term("<=", new Term[]{term2, term4});
            Term term6 = this.mScript.term(">=", new Term[]{term2, term3});
            Term term7 = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ZERO);
            Term term8 = this.mScript.term("<=", new Term[]{term7, termVariable2});
            Term term9 = this.mScript.term("-", new Term[]{term2, term3});
            Term term10 = this.mScript.term("<=", new Term[]{termVariable2, term9});
            Term term11 = this.mScript.term("-", new Term[]{this.mScript.term("-", new Term[]{term2}), term3});
            Term term12 = this.mScript.term("<=", new Term[]{termVariable2, term11});
            Term term13 = this.mScript.term("=", new Term[]{term, this.mScript.term("+", new Term[]{this.mScript.term("*", new Term[]{termVariable, term2}), termVariable2})});
            termArray[0] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term6, term8, term10, term13});
            termArray[1] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term5, term8, term12, term13});
            return SmtUtils.or((Script)this.mScript, (Term[])termArray);
        }
    }
}

