/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.pea2boogie.testgen;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieExpressionTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieLocation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Phase;
import de.uni_freiburg.informatik.ultimate.lib.pea.PhaseEventAutomata;
import de.uni_freiburg.informatik.ultimate.lib.pea.Transition;
import de.uni_freiburg.informatik.ultimate.pea2boogie.IReqSymbolTable;
import de.uni_freiburg.informatik.ultimate.pea2boogie.PeaResultUtil;
import de.uni_freiburg.informatik.ultimate.pea2boogie.generator.StrictInvariant;
import de.uni_freiburg.informatik.ultimate.pea2boogie.req2pea.IReq2PeaAnnotator;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.Req2CauseTrackingPea;
import de.uni_freiburg.informatik.ultimate.pea2boogie.testgen.ReqEffectStore;
import de.uni_freiburg.informatik.ultimate.pea2boogie.translator.CDDTranslator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.NormalFormTransformer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReqTestAnnotator
implements IReq2PeaAnnotator {
    private final BoogieLocation mLocation;
    private final IReqSymbolTable mSymbolTable;
    private final Req2CauseTrackingPea mReq2Pea;
    private final NormalFormTransformer<Expression> mNormalFormTransformer;
    private final Map<PhaseEventAutomata, ReqEffectStore> mPea2EffectStore;
    public static final String TEST_ASSERTION_PREFIX = "testgen_";
    public static final String TRACKING_VAR_PREFIX = "u_";

    public ReqTestAnnotator(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Req2CauseTrackingPea req2CauseTrackingPea) {
        this.mSymbolTable = req2CauseTrackingPea.getSymboltable();
        this.mReq2Pea = req2CauseTrackingPea;
        this.mLocation = new BoogieLocation("", -1, -1, -1, -1);
        this.mNormalFormTransformer = new NormalFormTransformer((INormalFormable)new BoogieExpressionTransformer());
        this.mPea2EffectStore = this.mReq2Pea.getReqEffectStore();
    }

    @Override
    public List<Statement> getStateChecks() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>(this.genTrackingAssumptions());
        arrayList.addAll(this.genTestAssertions());
        return arrayList;
    }

    @Override
    public List<Statement> getPostTransitionChecks() {
        return Collections.emptyList();
    }

    @Override
    public List<Statement> getPreChecks() {
        return new ArrayList<Statement>();
    }

    public static String getTrackingVar(String string) {
        return TRACKING_VAR_PREFIX + string;
    }

    private List<Statement> genTrackingAssumptions() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (String string : this.mSymbolTable.getStateVars()) {
            ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
            String string2 = ReqTestAnnotator.getTrackingVar(string);
            if (this.mSymbolTable.getInputVars().contains(string) || !this.mSymbolTable.getStateVars().contains(string2) && !this.mSymbolTable.getOutputVars().contains(string)) continue;
            for (Map.Entry<PhaseEventAutomata, ReqEffectStore> entry : this.mPea2EffectStore.entrySet()) {
                if (!entry.getValue().getEffectVars().contains(string)) continue;
                arrayList2.addAll(this.genPhaseTrackingDisjuncts(entry.getKey(), string));
                arrayList2.addAll(this.genTransitionTrackingDisjuncts(entry.getKey(), string));
            }
            if (arrayList2.size() <= 0) continue;
            BinaryExpression binaryExpression = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.LOGICIMPLIES, (Expression)this.mSymbolTable.getIdentifierExpression(string2), this.genDisjunction(arrayList2, this.mLocation));
            arrayList.add((Statement)new AssumeStatement((ILocation)this.mLocation, (Expression)binaryExpression));
        }
        return arrayList;
    }

    private List<Expression> genPhaseTrackingDisjuncts(PhaseEventAutomata phaseEventAutomata, String string) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (Integer n : this.mPea2EffectStore.get(phaseEventAutomata).getEffectPhaseIndexes()) {
            arrayList.addAll(this.genPhaseEffectTracking(phaseEventAutomata, string, n));
        }
        return arrayList;
    }

    private List<Expression> genTransitionTrackingDisjuncts(PhaseEventAutomata phaseEventAutomata, String string) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        for (Integer n : this.mPea2EffectStore.get(phaseEventAutomata).getEffectEdgeSourceIndexes()) {
            arrayList.addAll(this.genTransitionEffectTracking(phaseEventAutomata, string, n));
        }
        return arrayList;
    }

    private List<Expression> genPhaseEffectTracking(PhaseEventAutomata phaseEventAutomata, String string, Integer n) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        String string2 = this.mSymbolTable.getPcName(phaseEventAutomata);
        if (this.mPea2EffectStore.get(phaseEventAutomata).isEffectPhaseIndex(n)) {
            BinaryExpression binaryExpression = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.COMPEQ, (Expression)this.mSymbolTable.getIdentifierExpression(string2), (Expression)new IntegerLiteral((ILocation)this.mLocation, n.toString()));
            arrayList.add((Expression)binaryExpression);
        }
        return arrayList;
    }

    private List<Expression> genTransitionEffectTracking(PhaseEventAutomata phaseEventAutomata, String string, Integer n) {
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        List list = phaseEventAutomata.getPhases();
        for (Transition transition : ((Phase)list.get(n)).getTransitions()) {
            Integer n2 = list.indexOf(transition.getDest());
            if (!this.mPea2EffectStore.get(phaseEventAutomata).isEffectEdge(n, n2)) continue;
            arrayList.add(this.genTransitionSucceedingTracking(phaseEventAutomata, n, n2));
        }
        return arrayList;
    }

    private Expression genTransitionSucceedingTracking(PhaseEventAutomata phaseEventAutomata, Integer n, Integer n2) {
        String string = this.mSymbolTable.getPcName(phaseEventAutomata);
        BinaryExpression binaryExpression = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.COMPEQ, (Expression)this.mSymbolTable.getIdentifierExpression(this.mSymbolTable.getHistoryVarId(string)), (Expression)new IntegerLiteral((ILocation)this.mLocation, n.toString()));
        BinaryExpression binaryExpression2 = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.COMPEQ, (Expression)this.mSymbolTable.getIdentifierExpression(string), (Expression)new IntegerLiteral((ILocation)this.mLocation, Integer.toString(n2)));
        return new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.LOGICAND, (Expression)binaryExpression, (Expression)binaryExpression2);
    }

    private Expression genDisjunction(List<Expression> list, BoogieLocation boogieLocation) {
        Iterator<Expression> iterator = list.iterator();
        if (!iterator.hasNext()) {
            return ExpressionFactory.createBooleanLiteral((ILocation)boogieLocation, (boolean)false);
        }
        Expression expression = iterator.next();
        while (iterator.hasNext()) {
            expression = new BinaryExpression((ILocation)boogieLocation, BinaryExpression.Operator.LOGICOR, expression, iterator.next());
        }
        return (Expression)this.mNormalFormTransformer.toNnf((Object)expression);
    }

    private List<Statement> genTestAssertions() {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (Map.Entry<PhaseEventAutomata, ReqEffectStore> entry : this.mPea2EffectStore.entrySet()) {
            arrayList.addAll(this.genTestPhaseEffectAssertion(entry.getKey(), entry.getValue().getOutputEffectPhaseIndex()));
            arrayList.addAll(this.genTestEdgeEffectAssertion(entry.getKey(), entry.getValue().getOutputEffectEdges()));
        }
        return arrayList;
    }

    private List<Statement> genTestPhaseEffectAssertion(PhaseEventAutomata phaseEventAutomata, Set<Integer> set) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (int n : set) {
            CDD cDD;
            String string = this.mSymbolTable.getPcName(phaseEventAutomata);
            BinaryExpression binaryExpression = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.COMPEQ, (Expression)this.mSymbolTable.getIdentifierExpression(this.mSymbolTable.getHistoryVarId(string)), (Expression)new IntegerLiteral((ILocation)this.mLocation, Integer.toString(n)));
            CDD cDD2 = phaseEventAutomata.getLocation(n).getClockInvariant();
            BooleanLiteral booleanLiteral = new BooleanLiteral((ILocation)this.mLocation, true);
            if (cDD2 != CDD.TRUE) {
                cDD = new StrictInvariant().genStrictInv(cDD2, Collections.emptySet());
                booleanLiteral = new CDDTranslator().toBoogie(cDD.negate(), this.mLocation);
            }
            cDD = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.LOGICAND, (Expression)booleanLiteral, (Expression)binaryExpression);
            NamedAttribute[] namedAttributeArray = new NamedAttribute[]{new NamedAttribute((ILocation)this.mLocation, TEST_ASSERTION_PREFIX + phaseEventAutomata.getName() + Integer.toString(n), new Expression[0])};
            AssertStatement assertStatement = new AssertStatement((ILocation)this.mLocation, namedAttributeArray, (Expression)new UnaryExpression((ILocation)this.mLocation, UnaryExpression.Operator.LOGICNEG, (Expression)cDD));
            arrayList.add((Statement)assertStatement);
        }
        return arrayList;
    }

    private List<Statement> genTestEdgeEffectAssertion(PhaseEventAutomata phaseEventAutomata, Set<Pair<Integer, Integer>> set) {
        ArrayList<Statement> arrayList = new ArrayList<Statement>();
        for (Pair<Integer, Integer> pair : set) {
            BinaryExpression binaryExpression = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.COMPEQ, (Expression)this.mSymbolTable.getIdentifierExpression(this.mSymbolTable.getHistoryVarId(this.mSymbolTable.getPcName(phaseEventAutomata))), (Expression)new IntegerLiteral((ILocation)this.mLocation, Integer.toString((Integer)pair.getKey())));
            BinaryExpression binaryExpression2 = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.COMPEQ, (Expression)this.mSymbolTable.getIdentifierExpression(this.mSymbolTable.getPcName(phaseEventAutomata)), (Expression)new IntegerLiteral((ILocation)this.mLocation, Integer.toString((Integer)pair.getValue())));
            BinaryExpression binaryExpression3 = new BinaryExpression((ILocation)this.mLocation, BinaryExpression.Operator.LOGICAND, (Expression)binaryExpression2, (Expression)binaryExpression);
            NamedAttribute[] namedAttributeArray = new NamedAttribute[]{new NamedAttribute((ILocation)this.mLocation, TEST_ASSERTION_PREFIX + phaseEventAutomata.getName(), new Expression[0])};
            AssertStatement assertStatement = new AssertStatement((ILocation)this.mLocation, namedAttributeArray, (Expression)new UnaryExpression((ILocation)this.mLocation, UnaryExpression.Operator.LOGICNEG, (Expression)binaryExpression3));
            arrayList.add((Statement)assertStatement);
        }
        return arrayList;
    }

    @Override
    public PeaResultUtil getPeaResultUtil() {
        return null;
    }
}

