/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRCore;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.IAccelerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;

public class AcceleratorFastUPR
implements IAccelerator {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private boolean mFoundAcceleration;
    private final boolean mIsOverapprox;
    private final IIcfgSymbolTable mSymbolTable;

    public AcceleratorFastUPR(ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mFoundAcceleration = false;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mIsOverapprox = false;
    }

    @Override
    public UnmodifiableTransFormula accelerateLoop(UnmodifiableTransFormula unmodifiableTransFormula, IcfgLocation icfgLocation) {
        try {
            this.mLogger.debug((Object)"Accelerating Loop using FastUPR");
            FastUPRCore fastUPRCore = new FastUPRCore(unmodifiableTransFormula, this.mScript, this.mLogger, this.mServices);
            UnmodifiableTransFormula unmodifiableTransFormula2 = fastUPRCore.getResult();
            this.mFoundAcceleration = true;
            this.mLogger.debug((Object)"Done.");
            return unmodifiableTransFormula2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.mFoundAcceleration = false;
            this.mLogger.info((Object)("FastUPR could not accelerate loop because " + String.valueOf(unsupportedOperationException)));
            return unmodifiableTransFormula;
        }
    }

    @Override
    public boolean accelerationFinishedCorrectly() {
        return this.mFoundAcceleration;
    }

    @Override
    public boolean isOverapprox() {
        return this.mIsOverapprox;
    }
}

