/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IImplicationGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ImplicationMap;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.PredicateTrie;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.RestructureHelperObject;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifierStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BPredicateUnifier
implements IPredicateUnifier {
    private static final boolean USE_MAP = true;
    private static final boolean USE_RESTRUCTURE = true;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final Script mScript;
    private final IImplicationGraph<IPredicate> mImplicationGraph;
    private final BasicPredicateFactory mBasicPredicateFactory;
    private final IPredicate mTruePredicate;
    private final IPredicate mFalsePredicate;
    private final Collection<IPredicate> mPredicates;
    private final Set<IPredicate> mIntricatePredicate;
    private final IIcfgSymbolTable mSymbolTable;
    private final PredicateUnifierStatisticsGenerator mStatisticsTracker;
    private final ILogger mLogger;
    private PredicateTrie<IPredicate> mPredicateTrie;
    private long mImplicationTime = 0L;
    private int mDepthOffset;

    public BPredicateUnifier(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, IIcfgSymbolTable iIcfgSymbolTable) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
        this.mScript = this.mMgdScript.getScript();
        this.mBasicPredicateFactory = basicPredicateFactory;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mTruePredicate = basicPredicateFactory.newPredicate(this.mScript.term("true", new Term[0]));
        this.mFalsePredicate = basicPredicateFactory.newPredicate(this.mScript.term("false", new Term[0]));
        this.mPredicates = new HashSet<IPredicate>();
        this.mIntricatePredicate = new HashSet<IPredicate>();
        this.mStatisticsTracker = new PredicateUnifierStatisticsGenerator();
        this.mPredicateTrie = new PredicateTrie<IPredicate>(iLogger, iUltimateServiceProvider, this.mMgdScript, this.mTruePredicate, this.mFalsePredicate, basicPredicateFactory, this.mSymbolTable);
        this.mImplicationGraph = new ImplicationMap<IPredicate>(this.mMgdScript, this, this.mFalsePredicate, this.mTruePredicate, true);
        this.mPredicates.add(this.mTruePredicate);
        this.mPredicates.add(this.mFalsePredicate);
        this.mDepthOffset = 0;
        iLogger.info((Object)"Initialized predicate-trie based predicate unifier");
    }

    @Override
    public IPredicate getOrConstructPredicateForDisjunction(Collection<IPredicate> collection) {
        IPredicate iPredicate3;
        for (IPredicate object2 : collection) {
            if (!this.mPredicates.contains(object2)) {
                throw new AssertionError((Object)("PredicateUnifier does not know the predicate " + String.valueOf(object2)));
            }
        }
        Collection<IPredicate> collection2 = this.mImplicationGraph.removeImplyingVerticesFromCollection(collection);
        IPredicate iPredicate2 = this.mBasicPredicateFactory.or(collection2);
        for (IPredicate iPredicate3 : this.mPredicates) {
            if (!iPredicate3.getFormula().equals(iPredicate2.getFormula())) continue;
            return iPredicate3;
        }
        iPredicate3 = this.getOrConstructPredicate(iPredicate2);
        return iPredicate3;
    }

    @Override
    public IPredicate getOrConstructPredicateForConjunction(Collection<IPredicate> collection) {
        IPredicate iPredicate3;
        for (IPredicate object2 : collection) {
            if (!this.mPredicates.contains(object2)) {
                throw new AssertionError((Object)("PredicateUnifier does not know the predicate " + String.valueOf(object2)));
            }
        }
        Collection<IPredicate> collection2 = this.mImplicationGraph.removeImpliedVerticesFromCollection(collection);
        IPredicate iPredicate2 = this.mBasicPredicateFactory.and(collection2);
        for (IPredicate iPredicate3 : this.mPredicates) {
            if (!iPredicate3.getFormula().equals(iPredicate2.getFormula())) continue;
            return iPredicate3;
        }
        iPredicate3 = this.getOrConstructPredicate(iPredicate2);
        return iPredicate3;
    }

    @Override
    public String collectPredicateUnifierStatistics() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PredicateUnifierStatisticsGenerator.PredicateUnifierStatisticsType.getInstance().prettyprintBenchmarkData(this.mStatisticsTracker));
        stringBuilder.append(" " + (double)(this.mImplicationTime / 100L) / 10.0 + "s impTime " + this.mPredicateTrie.getDepth());
        return stringBuilder.toString();
    }

    @Override
    public IPredicateCoverageChecker getCoverageRelation() {
        return this.mImplicationGraph;
    }

    @Override
    public IStatisticsDataProvider getPredicateUnifierBenchmark() {
        return this.mStatisticsTracker;
    }

    @Override
    public boolean isIntricatePredicate(IPredicate iPredicate) {
        return this.mIntricatePredicate.contains(iPredicate);
    }

    private Script.LBool isDistinct(IPredicate iPredicate, IPredicate iPredicate2) {
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        Term term = this.mScript.term("distinct", new Term[]{iPredicate.getClosedFormula(), iPredicate2.getClosedFormula()});
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        try {
            Script.LBool lBool;
            this.mMgdScript.assertTerm((Object)this, term);
            Script.LBool lBool2 = lBool = this.mMgdScript.checkSat((Object)this);
            return lBool2;
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }

    @Override
    public Set<IPredicate> cannibalize(boolean bl, Term term) {
        Term[] termArray = SmtUtils.cannibalize((ManagedScript)this.mMgdScript, (IUltimateServiceProvider)this.mServices, (boolean)bl, (Term)term);
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>(termArray.length);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray2[n2];
            IPredicate iPredicate = this.getOrConstructPredicate(term2);
            hashSet.add(iPredicate);
            ++n2;
        }
        return hashSet;
    }

    @Override
    public Set<IPredicate> cannibalizeAll(boolean bl, Collection<IPredicate> collection) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        for (IPredicate iPredicate : collection) {
            hashSet.addAll(this.cannibalize(bl, iPredicate.getFormula()));
        }
        return hashSet;
    }

    @Override
    public IPredicate getOrConstructPredicate(Term term) {
        this.mStatisticsTracker.incrementGetRequests();
        return this.getOrConstructPredicateInternal(term);
    }

    private IPredicate getOrConstructPredicateInternal(Term term) {
        this.mStatisticsTracker.continueTime();
        Term term2 = new CommuhashNormalForm(this.mServices, this.mScript).transform(term);
        BasicPredicate basicPredicate = this.mBasicPredicateFactory.newPredicate(term2);
        IPredicate iPredicate = this.catchTrueOrFalse(basicPredicate);
        if (iPredicate != null) {
            return iPredicate;
        }
        IPredicate iPredicate2 = this.mPredicateTrie.unifyPredicate(basicPredicate);
        if (this.mPredicates.add(iPredicate2)) {
            long l = System.currentTimeMillis();
            this.mImplicationGraph.unifyPredicate(iPredicate2);
            this.mImplicationTime += System.currentTimeMillis() - l;
            this.mStatisticsTracker.incrementConstructedPredicates();
        } else if (iPredicate2.getFormula().toString().equals(basicPredicate.getFormula().toString())) {
            this.mStatisticsTracker.incrementSyntacticMatches();
        } else {
            this.mStatisticsTracker.incrementSemanticMatches();
        }
        this.mStatisticsTracker.stopTime();
        return iPredicate2;
    }

    private IPredicate catchTrueOrFalse(IPredicate iPredicate) {
        if (this.mTruePredicate.getFormula().equals(iPredicate.getFormula())) {
            this.mStatisticsTracker.incrementSyntacticMatches();
            this.mStatisticsTracker.stopTime();
            return this.mTruePredicate;
        }
        if (this.mFalsePredicate.getFormula().equals(iPredicate.getFormula())) {
            this.mStatisticsTracker.incrementSyntacticMatches();
            this.mStatisticsTracker.stopTime();
            return this.mFalsePredicate;
        }
        Script.LBool lBool = this.isDistinct(iPredicate, this.mTruePredicate);
        if (lBool == Script.LBool.UNSAT) {
            this.mStatisticsTracker.incrementSemanticMatches();
            this.mStatisticsTracker.stopTime();
            return this.mTruePredicate;
        }
        if (lBool == Script.LBool.UNKNOWN) {
            this.mIntricatePredicate.add(iPredicate);
            return iPredicate;
        }
        Script.LBool lBool2 = this.isDistinct(iPredicate, this.mFalsePredicate);
        if (lBool2 == Script.LBool.UNSAT) {
            this.mStatisticsTracker.incrementSemanticMatches();
            this.mStatisticsTracker.stopTime();
            return this.mFalsePredicate;
        }
        if (lBool2 == Script.LBool.UNKNOWN) {
            this.mIntricatePredicate.add(iPredicate);
            return iPredicate;
        }
        return null;
    }

    @Override
    public IPredicate getOrConstructPredicate(IPredicate iPredicate) {
        if (this.mPredicates.contains(iPredicate)) {
            return iPredicate;
        }
        return this.getOrConstructPredicate(iPredicate.getFormula());
    }

    @Override
    public boolean isRepresentative(IPredicate iPredicate) {
        return this.mPredicates.contains(iPredicate);
    }

    @Override
    public BasicPredicateFactory getPredicateFactory() {
        return this.mBasicPredicateFactory;
    }

    @Override
    public IPredicate getTruePredicate() {
        return this.mTruePredicate;
    }

    @Override
    public IPredicate getFalsePredicate() {
        return this.mFalsePredicate;
    }

    public String print(boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append("Predicate Trie:\n" + this.mPredicateTrie.toString());
        }
        if (bl2) {
            stringBuilder.append("Implication Graph:\n" + this.mImplicationGraph.toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public IPredicate constructNewPredicate(Term term, Map<IPredicate, IncrementalPlicationChecker.Validity> map, Map<IPredicate, IncrementalPlicationChecker.Validity> map2) {
        return this.getOrConstructPredicate(term);
    }

    public boolean restructurePredicateTrie() {
        int n = this.mPredicateTrie.getDepth();
        if (n <= this.minDepth(this.mPredicates.size())) {
            return false;
        }
        if (!(this.mImplicationGraph instanceof ImplicationMap)) {
            throw new UnsupportedOperationException("restructure only possible with ImplicationMap");
        }
        ImplicationMap implicationMap = (ImplicationMap)this.mImplicationGraph;
        HashMap<IPredicate, Set<IPredicate>> hashMap = new HashMap<IPredicate, Set<IPredicate>>();
        implicationMap.getDescendantsMap().entrySet().forEach(entry -> {
            HashSet hashSet = hashMap.put((IPredicate)entry.getKey(), new HashSet((Collection)entry.getValue()));
        });
        hashMap.remove(this.mFalsePredicate);
        hashMap.remove(this.mTruePredicate);
        hashMap.keySet().forEach(iPredicate -> {
            boolean bl = ((Set)hashMap.get(iPredicate)).remove(this.mTruePredicate);
        });
        HashMap<IPredicate, Set<IPredicate>> hashMap2 = new HashMap<IPredicate, Set<IPredicate>>();
        implicationMap.getAncestorsMap().entrySet().forEach(entry -> {
            HashSet hashSet = hashMap2.put((IPredicate)entry.getKey(), new HashSet((Collection)entry.getValue()));
        });
        hashMap2.remove(this.mFalsePredicate);
        hashMap2.remove(this.mTruePredicate);
        hashMap2.keySet().forEach(iPredicate -> {
            boolean bl = ((Set)hashMap2.get(iPredicate)).remove(this.mFalsePredicate);
        });
        HashMap<RestructureHelperObject, Pair<RestructureHelperObject, RestructureHelperObject>> hashMap3 = new HashMap<RestructureHelperObject, Pair<RestructureHelperObject, RestructureHelperObject>>();
        RestructureHelperObject restructureHelperObject = this.getWitnessInductive(hashMap, hashMap2, hashMap3);
        PredicateTrie<IPredicate> predicateTrie = new PredicateTrie<IPredicate>(this.mLogger, this.mServices, this.mMgdScript, this.mTruePredicate, this.mFalsePredicate, this.mBasicPredicateFactory, this.mSymbolTable);
        predicateTrie.fillTrie(restructureHelperObject, hashMap3);
        if (n - predicateTrie.getDepth() > 0) {
            this.mPredicateTrie = predicateTrie;
            return true;
        }
        return false;
    }

    private RestructureHelperObject getWitnessInductive(Map<IPredicate, Set<IPredicate>> map, Map<IPredicate, Set<IPredicate>> map2, Map<RestructureHelperObject, Pair<RestructureHelperObject, RestructureHelperObject>> map3) {
        Pair<IPredicate, IPredicate> pair = this.getPivot(map, map2);
        Term term = this.mScript.term("and", new Term[]{((IPredicate)pair.getFirst()).getFormula(), this.mScript.term("not", new Term[]{((IPredicate)pair.getSecond()).getFormula()})});
        RestructureHelperObject restructureHelperObject = new RestructureHelperObject(this.mPredicateTrie.getWitness(term), null);
        Pair<Set<IPredicate>, Set<IPredicate>> pair2 = this.splitPredicates(restructureHelperObject, pair, map, map2);
        RestructureHelperObject restructureHelperObject2 = null;
        RestructureHelperObject restructureHelperObject3 = null;
        Pair<Map<IPredicate, Set<IPredicate>>, Map<IPredicate, Set<IPredicate>>> pair3 = this.prepareSubGraph((Set)pair2.getFirst(), map, map2);
        restructureHelperObject2 = ((Map)pair3.getFirst()).size() == 1 ? new RestructureHelperObject(-1, null, (IPredicate)((Map)pair3.getFirst()).keySet().iterator().next()) : this.getWitnessInductive((Map)pair3.getFirst(), (Map)pair3.getSecond(), map3);
        Pair<Map<IPredicate, Set<IPredicate>>, Map<IPredicate, Set<IPredicate>>> pair4 = this.prepareSubGraph((Set)pair2.getSecond(), map, map2);
        restructureHelperObject3 = ((Map)pair4.getFirst()).size() == 1 ? new RestructureHelperObject(-1, null, (IPredicate)((Map)pair4.getFirst()).keySet().iterator().next()) : this.getWitnessInductive((Map)pair4.getFirst(), (Map)pair4.getSecond(), map3);
        map3.put(restructureHelperObject, (Pair<RestructureHelperObject, RestructureHelperObject>)new Pair((Object)restructureHelperObject2, (Object)restructureHelperObject3));
        return restructureHelperObject;
    }

    private Pair<Map<IPredicate, Set<IPredicate>>, Map<IPredicate, Set<IPredicate>>> prepareSubGraph(Set<IPredicate> set, Map<IPredicate, Set<IPredicate>> map, Map<IPredicate, Set<IPredicate>> map2) {
        HashMap hashMap = new HashMap();
        for (IPredicate iPredicate : set) {
            hashMap.put(iPredicate, new HashSet(map.get(iPredicate)));
            for (IPredicate iPredicate2 : map.get(iPredicate)) {
                if (set.contains(iPredicate2)) continue;
                ((Set)hashMap.get(iPredicate)).remove(iPredicate2);
            }
        }
        HashMap hashMap2 = new HashMap();
        for (IPredicate iPredicate : set) {
            hashMap2.put(iPredicate, new HashSet(map2.get(iPredicate)));
            for (IPredicate iPredicate3 : map2.get(iPredicate)) {
                if (set.contains(iPredicate3)) continue;
                ((Set)hashMap2.get(iPredicate)).remove(iPredicate3);
            }
        }
        return new Pair(hashMap, hashMap2);
    }

    private Pair<Set<IPredicate>, Set<IPredicate>> splitPredicates(RestructureHelperObject restructureHelperObject, Pair<IPredicate, IPredicate> pair, Map<IPredicate, Set<IPredicate>> map, Map<IPredicate, Set<IPredicate>> map2) {
        HashDeque hashDeque = new HashDeque();
        hashDeque.addAll(map.keySet());
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>((Collection)map.get(pair.getFirst()));
        hashSet.add((IPredicate)pair.getFirst());
        HashSet<IPredicate> hashSet2 = new HashSet<IPredicate>((Collection)map2.get(pair.getSecond()));
        hashSet2.add((IPredicate)pair.getSecond());
        hashSet2.removeAll(hashSet);
        hashDeque.removeAll(hashSet);
        hashDeque.removeAll(hashSet2);
        while (!hashDeque.isEmpty()) {
            IPredicate iPredicate = (IPredicate)hashDeque.pop();
            if (this.mPredicateTrie.fulfillsPredicate(iPredicate, restructureHelperObject.getWitness())) {
                hashSet.add(iPredicate);
                hashSet.addAll((Collection)map.get(iPredicate));
                hashDeque.removeAll((Collection)map.get(iPredicate));
                continue;
            }
            hashSet2.add(iPredicate);
            hashSet2.addAll((Collection)map2.get(iPredicate));
            hashDeque.removeAll((Collection)map2.get(iPredicate));
        }
        return new Pair(hashSet, hashSet2);
    }

    /*
     * WARNING - void declaration
     */
    private Pair<IPredicate, IPredicate> getPivot(Map<IPredicate, Set<IPredicate>> map, Map<IPredicate, Set<IPredicate>> map2) {
        void var7_17;
        float f;
        assert (!map.isEmpty() && !map2.isEmpty());
        float f2 = f = (float)map.size() / 2.0f;
        IPredicate object3 = null;
        for (IPredicate iPredicate : map.keySet()) {
            float f3 = map.get(iPredicate).size() + 1;
            if (f3 == f) {
                object3 = iPredicate;
                break;
            }
            if (!(Math.abs(f - f3) < f2)) continue;
            f2 = Math.abs(f - f3);
            object3 = iPredicate;
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry<IPredicate, Set<IPredicate>> entry : map2.entrySet()) {
            hashMap.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        for (IPredicate iPredicate : map.get(object3)) {
            for (IPredicate iPredicate2 : map.get(iPredicate)) {
                ((Set)hashMap.get(iPredicate2)).remove(iPredicate);
            }
        }
        for (IPredicate iPredicate : map.get(object3)) {
            hashMap.remove(iPredicate);
        }
        hashMap.remove(object3);
        f2 = f;
        Object var7_13 = null;
        for (Map.Entry entry : hashMap.entrySet()) {
            float f4 = ((Set)entry.getValue()).size() + 1;
            if (f4 == f) {
                IPredicate iPredicate = (IPredicate)entry.getKey();
                break;
            }
            if (!(Math.abs(f - f4) < f2)) continue;
            f2 = Math.abs(f - f4);
            IPredicate iPredicate = (IPredicate)entry.getKey();
        }
        return new Pair((Object)object3, (Object)var7_17);
    }

    private int minDepth(int n) {
        return (int)Math.ceil(Math.log(n) / Math.log(2.0) + 1.0);
    }
}

