/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.Set;

public class UnknownState
implements ISLPredicate {
    private final IcfgLocation mProgramPoint;
    private final int mSerialNumber;
    private final Term mTerm;

    protected UnknownState(IcfgLocation icfgLocation, int n, Term term) {
        this.mProgramPoint = icfgLocation;
        this.mSerialNumber = n;
        this.mTerm = term;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.mSerialNumber).append("#");
        if (this.mProgramPoint != null) {
            stringBuilder.append(this.mProgramPoint.getDebugIdentifier());
        } else {
            stringBuilder.append("unknown");
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return HashUtils.hashJenkins((int)31, (Object)this.mSerialNumber);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UnknownState) {
            UnknownState unknownState = (UnknownState)object;
            if (this.mSerialNumber == unknownState.mSerialNumber) {
                throw new UnsupportedOperationException("different predicates with same serial number");
            }
        }
        return false;
    }

    @Override
    public IcfgLocation getProgramPoint() {
        return this.mProgramPoint;
    }

    @Override
    public Term getFormula() {
        return this.mTerm;
    }

    @Override
    public Set<IProgramVar> getVars() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<IProgramFunction> getFuns() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Term getClosedFormula() {
        throw new UnsupportedOperationException();
    }
}

