/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling;

import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RefinementEngineStatisticsGenerator
implements IStatisticsDataProvider {
    private final ConstructionCache<RefinementEngineStatisticsDefinitions, Set<IStatisticsDataProvider>> mStats = new ConstructionCache(refinementEngineStatisticsDefinitions -> new HashSet());
    private final ConstructionCache<RefinementEngineStatisticsDefinitions, StatisticsData> mStatsAggregated = new ConstructionCache(refinementEngineStatisticsDefinitions -> new StatisticsData());
    private static final StatisticsType<RefinementEngineStatisticsDefinitions> TYPE = new StatisticsType(RefinementEngineStatisticsDefinitions.class);

    public IStatisticsType getBenchmarkType() {
        return TYPE;
    }

    public void finishRefinementEngineRun() {
        for (Map.Entry entry : this.mStats.entrySet()) {
            StatisticsData statisticsData = (StatisticsData)this.mStatsAggregated.getOrConstruct((Object)((RefinementEngineStatisticsDefinitions)((Object)entry.getKey())));
            for (IStatisticsDataProvider iStatisticsDataProvider : (Set)entry.getValue()) {
                statisticsData.aggregateBenchmarkData(iStatisticsDataProvider);
            }
        }
    }

    public void addStatistics(RefinementEngineStatisticsDefinitions refinementEngineStatisticsDefinitions, IStatisticsDataProvider iStatisticsDataProvider) {
        if (iStatisticsDataProvider == null) {
            return;
        }
        ((Set)this.mStats.getOrConstruct((Object)refinementEngineStatisticsDefinitions)).add(iStatisticsDataProvider);
    }

    public Object getValue(String string) {
        RefinementEngineStatisticsDefinitions refinementEngineStatisticsDefinitions = RefinementEngineStatisticsDefinitions.valueOf(string);
        return this.mStatsAggregated.getOrConstruct((Object)refinementEngineStatisticsDefinitions);
    }

    public Collection<String> getKeys() {
        return TYPE.getKeys();
    }

    public static enum RefinementEngineStatisticsDefinitions implements IStatisticsElement
    {
        TRACE_CHECK(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        INVARIANT_SYNTHESIS(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        INTERPOLANT_CONSOLIDATION(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        ABSTRACT_INTERPRETATION(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        PDR(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        ACCELERATED_INTERPOLATION(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA),
        SIFA(StatisticsData.class, StatisticsType.STATISTICS_DATA_AGGREGATION, StatisticsType.KEY_BEFORE_DATA);

        private final Class<?> mClazz;
        private final Function<Object, Function<Object, Object>> mAggr;
        private final Function<String, Function<Object, String>> mPrettyprinter;

        private RefinementEngineStatisticsDefinitions(Class<?> clazz, Function<Object, Function<Object, Object>> function, Function<String, Function<Object, String>> function2) {
            this.mClazz = clazz;
            this.mAggr = function;
            this.mPrettyprinter = function2;
        }

        public Object aggregate(Object object, Object object2) {
            return this.mAggr.apply(object).apply(object2);
        }

        public String prettyprint(Object object) {
            return this.mPrettyprinter.apply(this.name()).apply(object);
        }
    }
}

