/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.Context;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;

public class QuantifierUtils {
    private static final String UNKNOWN_QUANTIFIER = "unknown quantifier";

    private QuantifierUtils() {
    }

    public static boolean isQuantifierFree(Term term2) {
        return !new SubtermPropertyChecker(term -> term instanceof QuantifiedFormula).isSatisfiedBySomeSubterm(term2);
    }

    public static Term flattenQuantifiers(Script script, QuantifiedFormula quantifiedFormula) {
        return SmtUtils.quantifier(script, quantifiedFormula.getQuantifier(), Arrays.asList(quantifiedFormula.getVariables()), quantifiedFormula.getSubformula());
    }

    public static String getAsciiAbbreviation(int n) {
        if (n == 0) {
            return "E";
        }
        if (n == 1) {
            return "A";
        }
        throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
    }

    public static int getDualQuantifier(int n) {
        if (n == 0) {
            return 1;
        }
        if (n == 1) {
            return 0;
        }
        throw new UnsupportedOperationException(UNKNOWN_QUANTIFIER);
    }

    public static Term applyCorrespondingFiniteConnective(Script script, int n, Collection<Term> collection) {
        Term term;
        if (n == 0) {
            term = SmtUtils.or(script, collection);
        } else if (n == 1) {
            term = SmtUtils.and(script, collection);
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term;
    }

    public static Term applyCorrespondingFiniteConnective(Script script, int n, Term ... termArray) {
        return QuantifierUtils.applyCorrespondingFiniteConnective(script, n, Arrays.asList(termArray));
    }

    public static Term applyDualFiniteConnective(Script script, int n, Collection<Term> collection) {
        Term term;
        if (n == 0) {
            term = SmtUtils.and(script, collection);
        } else if (n == 1) {
            term = SmtUtils.or(script, collection);
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term;
    }

    public static Term applyDualFiniteConnective(Script script, int n, Term ... termArray) {
        return QuantifierUtils.applyDualFiniteConnective(script, n, Arrays.asList(termArray));
    }

    public static int getCorrespondingQuantifier(String string) {
        if (string.equals("and")) {
            return 1;
        }
        if (string.equals("or")) {
            return 0;
        }
        throw new AssertionError((Object)("unsupported connective " + string));
    }

    public static String getNameOfCorrespondingJuncts(int n) {
        String string;
        if (n == 0) {
            string = "disjuncts";
        } else if (n == 1) {
            string = "conjuncts";
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return string;
    }

    public static String getNameOfDualJuncts(int n) {
        String string;
        if (n == 0) {
            string = "conjuncts";
        } else if (n == 1) {
            string = "disjuncts";
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return string;
    }

    public static Term[] getCorrespondingFiniteJuncts(int n, Term term) {
        Term[] termArray;
        if (n == 0) {
            termArray = SmtUtils.getDisjuncts(term);
        } else if (n == 1) {
            termArray = SmtUtils.getConjuncts(term);
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return termArray;
    }

    public static Term[] getDualFiniteJuncts(int n, Term term) {
        Term[] termArray;
        if (n == 0) {
            termArray = SmtUtils.getConjuncts(term);
        } else if (n == 1) {
            termArray = SmtUtils.getDisjuncts(term);
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return termArray;
    }

    public static boolean isDualFiniteJunction(int n, Term term) {
        return QuantifierUtils.getDualFiniteJuncts(n, term).length > 1;
    }

    public static boolean isCorrespondingFiniteJunction(int n, Term term) {
        return QuantifierUtils.getCorrespondingFiniteJuncts(n, term).length > 1;
    }

    public static Term getNeutralElement(Script script, int n) {
        if (n == 0) {
            return script.term("false", new Term[0]);
        }
        if (n == 1) {
            return script.term("true", new Term[0]);
        }
        throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
    }

    public static Term getAbsorbingElement(Script script, int n) {
        if (n == 0) {
            return script.term("true", new Term[0]);
        }
        if (n == 1) {
            return script.term("false", new Term[0]);
        }
        throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
    }

    public static String getDualBooleanConnective(String string) {
        if (string.equals("and")) {
            return "or";
        }
        if (string.equals("or")) {
            return "and";
        }
        throw new AssertionError((Object)("unsupported connective " + string));
    }

    public static Term negateIfUniversal(Script script, int n, Term term) {
        Term term2;
        if (n == 0) {
            term2 = term;
        } else if (n == 1) {
            term2 = SmtUtils.not(script, term);
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term2;
    }

    public static Term negateIfUniversal(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, int n, Term term) {
        Term term2;
        if (n == 0) {
            term2 = term;
        } else if (n == 1) {
            term2 = new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.IS_ATOM).transform(SmtUtils.not(managedScript.getScript(), term));
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term2;
    }

    public static Term negateIfExistential(Script script, int n, Term term) {
        Term term2;
        if (n == 0) {
            term2 = SmtUtils.not(script, term);
        } else if (n == 1) {
            term2 = term;
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term2;
    }

    public static Term negateIfExistential(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, int n, Term term) {
        Term term2;
        if (n == 0) {
            term2 = new NnfTransformer(managedScript, iUltimateServiceProvider, NnfTransformer.QuantifierHandling.IS_ATOM).transform(SmtUtils.not(managedScript.getScript(), term));
        } else if (n == 1) {
            term2 = term;
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term2;
    }

    public static Term applyDerOperator(Script script, int n, Term term, Term term2) {
        Term term3;
        if (n == 0) {
            term3 = SmtUtils.binaryEquality(script, term, term2);
        } else if (n == 1) {
            term3 = SmtUtils.distinct(script, term, term2);
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term3;
    }

    public static Term applyAntiDerOperator(Script script, int n, Term term, Term term2) {
        Term term3;
        if (n == 0) {
            term3 = SmtUtils.distinct(script, term, term2);
        } else if (n == 1) {
            term3 = SmtUtils.binaryEquality(script, term, term2);
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term3;
    }

    public static RelationSymbol getDerOperator(int n) {
        if (n == 0) {
            return RelationSymbol.EQ;
        }
        if (n == 1) {
            return RelationSymbol.DISTINCT;
        }
        throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
    }

    public static boolean isDerRelationSymbol(int n, RelationSymbol relationSymbol) {
        return relationSymbol.equals((Object)QuantifierUtils.getDerOperator(n));
    }

    public static Term transformToXnf(IUltimateServiceProvider iUltimateServiceProvider, Script script, int n, ManagedScript managedScript, Term term) throws AssertionError {
        if (n == 0) {
            term = SmtUtils.toDnf(iUltimateServiceProvider, managedScript, term);
        } else if (n == 1) {
            term = SmtUtils.toCnf(iUltimateServiceProvider, managedScript, term);
        } else {
            throw new AssertionError((Object)UNKNOWN_QUANTIFIER);
        }
        return term;
    }

    public static LinkedHashSet<TermVariable> projectToFreeVars(Collection<TermVariable> collection, Term term) {
        LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            if (collection.contains(termVariable)) {
                linkedHashSet.add(termVariable);
            }
            ++n2;
        }
        return linkedHashSet;
    }

    @FunctionalInterface
    public static interface IQuantifierEliminator {
        public Term eliminate(IUltimateServiceProvider var1, ManagedScript var2, boolean var3, QuantifierPusher.PqeTechniques var4, SmtUtils.SimplificationTechnique var5, Context var6, Term var7);
    }
}

