/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import java.util.Iterator;

public class SimpleList<E extends SimpleListable<E>>
extends SimpleListable<E>
implements Iterable<E> {
    public SimpleList() {
        this.mNext = this.mPrev = this;
    }

    public boolean isEmpty() {
        return this.mNext == this;
    }

    public E removeFirst() {
        SimpleListable simpleListable = this.mNext;
        this.mNext = simpleListable.mNext;
        this.mNext.mPrev = this;
        simpleListable.mPrev = null;
        simpleListable.mNext = null;
        return simpleListable.getElem();
    }

    public E removeLast() {
        SimpleListable simpleListable = this.mPrev;
        this.mPrev = simpleListable.mPrev;
        this.mPrev.mNext = this;
        simpleListable.mPrev = null;
        simpleListable.mNext = null;
        return simpleListable.getElem();
    }

    public void prepareRemove(E e) {
        if (this.mNext == e) {
            this.mNext = this.mPrev == e ? (this.mPrev = this) : ((SimpleListable)e).mNext;
        } else if (this.mPrev == e) {
            this.mPrev = ((SimpleListable)e).mPrev;
        }
    }

    public void append(E e) {
        assert (this.mPrev.mNext == this);
        ((SimpleListable)e).mPrev = this.mPrev;
        ((SimpleListable)e).mNext = this;
        this.mPrev.mNext = e;
        this.mPrev = this.mPrev.mNext;
    }

    public void prepend(E e) {
        assert (this.mNext.mPrev == this);
        ((SimpleListable)e).mNext = this.mNext;
        ((SimpleListable)e).mPrev = this;
        this.mNext.mPrev = e;
        this.mNext = e;
    }

    public void prependIntoJoined(E e, boolean bl) {
        if (((SimpleListable)e).mNext == null) {
            if (this != this.mNext || bl) {
                ((SimpleListable)e).mNext = this.mNext;
                ((SimpleListable)e).mPrev = this.mNext.mPrev;
                if (this.mNext.mPrev != this) {
                    this.mNext.mPrev.mNext = e;
                }
            }
            this.mNext.mPrev = e;
            this.mNext = e;
        } else if (this.mNext == ((SimpleListable)e).mNext) {
            this.mNext = e;
        }
    }

    public void undoPrependIntoJoined(E e, boolean bl) {
        if (this.mNext == e && this.mPrev == e) {
            this.mNext = this;
            this.mPrev = this;
        } else if (this.mNext == e) {
            this.mNext = ((SimpleListable)e).mNext;
        } else if (this.mPrev == e) {
            this.mPrev = ((SimpleListable)e).mPrev;
        }
        if (bl) {
            ((SimpleListable)e).removeFromList();
        }
    }

    public void moveAll(SimpleList<E> simpleList) {
        if (simpleList.mNext == simpleList) {
            return;
        }
        simpleList.mNext.mPrev = this.mPrev;
        simpleList.mPrev.mNext = this;
        this.mPrev.mNext = simpleList.mNext;
        this.mPrev = simpleList.mPrev;
        simpleList.mNext = simpleList.mPrev = simpleList;
    }

    public void joinList(SimpleList<E> simpleList) {
        if (simpleList.mNext == simpleList) {
            return;
        }
        this.mPrev.mNext = simpleList.mNext;
        simpleList.mNext.mPrev = this.mPrev;
        this.mPrev = simpleList.mPrev;
        this.mPrev.mNext = this;
    }

    public void unjoinList(SimpleList<E> simpleList) {
        simpleList.mPrev.mNext.mPrev = simpleList.mNext.mPrev;
        simpleList.mNext.mPrev.mNext = simpleList.mPrev.mNext;
        simpleList.mNext.mPrev = simpleList;
        simpleList.mPrev.mNext = simpleList;
    }

    public boolean isSublistOf(SimpleList<E> simpleList) {
        if (this.mNext == this && this.mPrev == this) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        SimpleListable simpleListable = simpleList.mNext;
        while (simpleListable != simpleList) {
            if (simpleListable == this.mNext) {
                bl = true;
            }
            if (simpleListable == this.mPrev) {
                assert (bl);
                bl2 = true;
            }
            simpleListable = simpleListable.mNext;
        }
        return bl && bl2;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            SimpleListable<E> mCur;
            SimpleListable<E> mPrev;
            {
                this.mCur = SimpleList.this;
                this.mPrev = null;
            }

            @Override
            public boolean hasNext() {
                return this.mCur != SimpleList.this.mPrev;
            }

            @Override
            public E next() {
                this.mPrev = this.mCur;
                this.mCur = this.mCur.mNext;
                return this.mCur.getElem();
            }

            @Override
            public void remove() {
                if (!$assertionsDisabled && this.mPrev == null) {
                    throw new AssertionError();
                }
                this.mPrev.mNext = this.mCur.mNext;
                this.mCur.mNext.mPrev = this.mPrev;
                this.mCur.mNext = null;
                this.mCur.mPrev = null;
                this.mCur = this.mPrev;
                this.mPrev = null;
            }
        };
    }

    public Iterable<E> reverse() {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    SimpleListable<E> mCur;
                    {
                        this.mCur = (this).SimpleList.this.mPrev;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mCur != SimpleList.this;
                    }

                    @Override
                    public E next() {
                        Object e = this.mCur.getElem();
                        this.mCur = this.mCur.mPrev;
                        return e;
                    }

                    @Override
                    public void remove() {
                        this.mCur.mNext = this.mCur.mNext.mNext;
                        this.mCur.mNext.mPrev = this.mCur;
                    }
                };
            }
        };
    }

    public void clear() {
        this.mNext = this.mPrev = this;
    }

    public boolean wellformed() {
        if (this.mNext.mPrev != this) {
            System.err.println("Not in this list!!!!");
            return false;
        }
        SimpleListable simpleListable = this.mNext;
        while (!(simpleListable instanceof SimpleList)) {
            if (simpleListable.mNext.mPrev != simpleListable) {
                System.err.println("Wrong links!!!!");
                return false;
            }
            simpleListable = simpleListable.mNext;
        }
        return simpleListable == this;
    }

    public boolean wellformedPart() {
        SimpleListable simpleListable = this.mNext;
        while (simpleListable != this.mPrev) {
            if (simpleListable instanceof SimpleList) {
                return false;
            }
            if (simpleListable.mNext.mPrev != simpleListable) {
                return false;
            }
            simpleListable = simpleListable.mNext;
        }
        return true;
    }

    public boolean contains(E e) {
        SimpleListable simpleListable = this.mNext;
        while (simpleListable != this) {
            if (simpleListable.getElem().equals(e)) {
                return true;
            }
            simpleListable = simpleListable.mNext;
        }
        return false;
    }

    public String toString() {
        if (this.mNext == this) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mNext.mPrev != this) {
            stringBuilder.append('~');
        }
        stringBuilder.append('[');
        SimpleListable simpleListable = this.mNext;
        while (simpleListable != this.mPrev) {
            stringBuilder.append(simpleListable).append(",");
            simpleListable = simpleListable.mNext;
        }
        stringBuilder.append(simpleListable);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public SimpleList<E> cloneJoinedList() {
        SimpleList<E> simpleList = new SimpleList<E>();
        simpleList.mNext = this.mNext;
        simpleList.mPrev = this.mPrev;
        if (this.mNext.mPrev == this) {
            this.mNext.mPrev = simpleList;
            this.mPrev.mNext = simpleList;
        }
        return simpleList;
    }
}

