/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ArraySortInterpretation
implements SortInterpretation {
    private final Model mModel;
    private final SortInterpretation mIndexSort;
    private final SortInterpretation mValueSort;
    private final HashMap<Map<Term, Term>, Map<Term, Term>> mUnifier;
    private final HashMap<Term, HashMap<Term, Term>> mDiffMap;

    public ArraySortInterpretation(Model model, SortInterpretation sortInterpretation, SortInterpretation sortInterpretation2) {
        this.mModel = model;
        this.mIndexSort = sortInterpretation;
        this.mValueSort = sortInterpretation2;
        this.mUnifier = new HashMap();
        Map map = Collections.emptyMap();
        this.mUnifier.put(map, map);
        this.mDiffMap = new HashMap();
    }

    @Override
    public Term getModelValue(int n, Sort sort) {
        Sort sort2 = sort.getArguments()[1];
        return this.createArray(Collections.emptyMap(), this.mValueSort.getModelValue(n, sort2), sort);
    }

    private Term createArray(Map<Term, Term> map, Term term, Sort sort) {
        Theory theory = term.getTheory();
        FunctionSymbol functionSymbol = theory.getFunctionWithResult("const", null, sort, new Sort[]{term.getSort()});
        Term term2 = theory.term(functionSymbol, new Term[]{term});
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>(map.keySet());
        while (!arrayDeque.isEmpty()) {
            Term term3 = arrayDeque.removeLast();
            term2 = theory.term("store", new Term[]{term2, term3, map.get(term3)});
        }
        return term2;
    }

    public Term getSelect(Term term, Term term2) {
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        while (applicationTerm.getFunction().getName() == "store") {
            if (applicationTerm.getParameters()[1] == term2) {
                return applicationTerm.getParameters()[2];
            }
            applicationTerm = (ApplicationTerm)applicationTerm.getParameters()[0];
        }
        assert (applicationTerm.getFunction().getName() == "const");
        return applicationTerm.getParameters()[0];
    }

    public Term normalizeStoreTerm(Term term) {
        Term term2;
        LinkedHashMap<Term, Term> linkedHashMap = new LinkedHashMap<Term, Term>();
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        while (applicationTerm.getFunction().getName() == "store") {
            term2 = applicationTerm.getParameters()[1];
            if (!linkedHashMap.containsKey(term2)) {
                linkedHashMap.put(term2, applicationTerm.getParameters()[2]);
            }
            applicationTerm = (ApplicationTerm)applicationTerm.getParameters()[0];
        }
        assert (applicationTerm.getFunction().getName() == "const");
        term2 = applicationTerm.getParameters()[0];
        Map<Term, Term> map = linkedHashMap.entrySet().iterator();
        while (map.hasNext()) {
            Map.Entry entry = map.next();
            if (entry.getValue() != term2) continue;
            map.remove();
        }
        map = this.mUnifier.get(linkedHashMap);
        if (map == null) {
            this.mUnifier.put(linkedHashMap, linkedHashMap);
            map = linkedHashMap;
        }
        return this.createArray(map, term2, term.getSort());
    }

    @Override
    public Term extendFresh(Sort sort) {
        assert (sort.getSortSymbol().getName() == "Array");
        Sort sort2 = sort.getArguments()[0];
        Sort sort3 = sort.getArguments()[1];
        Term term = this.mIndexSort.extendFresh(sort2);
        Term term2 = this.mModel.getSecondValue(sort3);
        Map<Term, Term> map = Collections.singletonMap(term, term2);
        Map<Term, Term> map2 = this.mUnifier.put(map, map);
        assert (map2 == null);
        return this.createArray(map, this.mModel.getSomeValue(sort3), sort);
    }

    @Override
    public Term toSMTLIB(Theory theory, Sort sort) {
        throw new InternalError("toSMTLIB called");
    }

    public void addDiff(Term term, Term term2, Term term3) {
        HashMap<Object, Object> hashMap = this.mDiffMap.get(term);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.mDiffMap.put(term, hashMap);
        }
        Term term4 = hashMap.put(term2, term3);
        assert (term4 == null);
    }

    public Term computeDiff(Term term, Term term2, Sort sort) {
        Term term3;
        Term term4;
        Object object;
        Map map = this.mDiffMap.get(term);
        if (map != null && (object = (Term)map.get(term2)) != null) {
            return object;
        }
        if (term == term2) {
            return this.mModel.getSomeValue(sort);
        }
        object = new HashMap();
        ApplicationTerm applicationTerm = (ApplicationTerm)term2;
        while (applicationTerm.getFunction().getName() == "store") {
            term4 = applicationTerm.getParameters()[1];
            object.put(term4, applicationTerm.getParameters()[2]);
            applicationTerm = (ApplicationTerm)applicationTerm.getParameters()[0];
        }
        assert (applicationTerm.getFunction().getName() == "const");
        term4 = applicationTerm.getParameters()[0];
        applicationTerm = (ApplicationTerm)term;
        while (applicationTerm.getFunction().getName() == "store") {
            term3 = applicationTerm.getParameters()[1];
            Term term5 = (Term)object.get(term3);
            if (term5 == null) {
                term5 = term4;
            }
            if (term5 != applicationTerm.getParameters()[2]) {
                return term3;
            }
            applicationTerm = (ApplicationTerm)applicationTerm.getParameters()[0];
        }
        assert (applicationTerm.getFunction().getName() == "const");
        assert (term4 != applicationTerm.getParameters()[0]);
        term3 = this.mIndexSort.extendFresh(sort);
        this.addDiff(term, term2, term3);
        return term3;
    }

    public SortInterpretation getIndexInterpretation() {
        return this.mIndexSort;
    }

    public SortInterpretation getValueInterpretation() {
        return this.mValueSort;
    }

    @Override
    public void register(Term term) {
    }
}

