/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;

public class ExactInfinitesimalNumber
implements Comparable<ExactInfinitesimalNumber> {
    public static final ExactInfinitesimalNumber ZERO = new ExactInfinitesimalNumber(Rational.ZERO, Rational.ZERO);
    public static final ExactInfinitesimalNumber POSITIVE_INFINITY = new ExactInfinitesimalNumber(Rational.POSITIVE_INFINITY, Rational.ZERO);
    public static final ExactInfinitesimalNumber NEGATIVE_INFINITY = new ExactInfinitesimalNumber(Rational.NEGATIVE_INFINITY, Rational.ZERO);
    private final Rational mReal;
    private final Rational mEps;

    public ExactInfinitesimalNumber(Rational rational) {
        this.mReal = rational;
        this.mEps = Rational.ZERO;
    }

    public ExactInfinitesimalNumber(Rational rational, Rational rational2) {
        this.mReal = rational;
        this.mEps = rational2;
    }

    public ExactInfinitesimalNumber(InfinitesimalNumber infinitesimalNumber) {
        this.mReal = infinitesimalNumber.mReal;
        this.mEps = Rational.valueOf((long)infinitesimalNumber.mEps, (long)1L);
    }

    public Rational getRealValue() {
        return this.mReal;
    }

    public Rational getEpsilon() {
        return this.mEps;
    }

    public String toString() {
        if (this.mEps.signum() == 0) {
            return this.mReal.toString();
        }
        if (this.mEps.signum() > 0) {
            return this.mReal.toString() + "+" + this.mEps.toString() + "eps";
        }
        return this.mReal.toString() + "-" + this.mEps.abs().toString() + "eps";
    }

    public boolean equals(Object object) {
        if (object instanceof InfinitesimalNumber) {
            InfinitesimalNumber infinitesimalNumber = (InfinitesimalNumber)object;
            return this.mReal.equals((Object)infinitesimalNumber.mReal) && this.mEps.equals((Object)Rational.valueOf((long)infinitesimalNumber.mEps, (long)1L));
        }
        if (object instanceof ExactInfinitesimalNumber) {
            ExactInfinitesimalNumber exactInfinitesimalNumber = (ExactInfinitesimalNumber)object;
            return this.mReal.equals((Object)exactInfinitesimalNumber.mReal) && this.mEps.equals((Object)exactInfinitesimalNumber.mEps);
        }
        return false;
    }

    public int hashCode() {
        return this.mReal.hashCode() + 65537 * this.mEps.hashCode();
    }

    public ExactInfinitesimalNumber add(Rational rational) {
        return new ExactInfinitesimalNumber(this.mReal.add(rational), this.mEps);
    }

    public ExactInfinitesimalNumber add(InfinitesimalNumber infinitesimalNumber) {
        return new ExactInfinitesimalNumber(this.mReal.add(infinitesimalNumber.mReal), this.mEps.add(Rational.valueOf((long)infinitesimalNumber.mEps, (long)1L)));
    }

    public ExactInfinitesimalNumber add(ExactInfinitesimalNumber exactInfinitesimalNumber) {
        return new ExactInfinitesimalNumber(this.mReal.add(exactInfinitesimalNumber.mReal), this.mEps.add(exactInfinitesimalNumber.mEps));
    }

    public ExactInfinitesimalNumber sub(ExactInfinitesimalNumber exactInfinitesimalNumber) {
        return new ExactInfinitesimalNumber(this.mReal.sub(exactInfinitesimalNumber.mReal), this.mEps.sub(exactInfinitesimalNumber.mEps));
    }

    public ExactInfinitesimalNumber isub(InfinitesimalNumber infinitesimalNumber) {
        return new ExactInfinitesimalNumber(infinitesimalNumber.mReal.sub(this.mReal), Rational.valueOf((long)infinitesimalNumber.mEps, (long)1L).sub(this.mEps));
    }

    public ExactInfinitesimalNumber negate() {
        return new ExactInfinitesimalNumber(this.mReal.negate(), this.mEps.negate());
    }

    public ExactInfinitesimalNumber mul(Rational rational) {
        return new ExactInfinitesimalNumber(this.mReal.mul(rational), this.mEps.mul(rational));
    }

    public ExactInfinitesimalNumber div(Rational rational) {
        return new ExactInfinitesimalNumber(this.mReal.div(rational), this.mEps.div(rational));
    }

    public ExactInfinitesimalNumber abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public InfinitesimalNumber roundToInfinitesimal() {
        return new InfinitesimalNumber(this.mReal, this.mEps.signum());
    }

    @Override
    public int compareTo(InfinitesimalNumber infinitesimalNumber) {
        int n = this.mReal.compareTo(infinitesimalNumber.mReal);
        return n == 0 ? this.mEps.compareTo(Rational.valueOf((long)infinitesimalNumber.mEps, (long)1L)) : n;
    }

    @Override
    public int compareTo(ExactInfinitesimalNumber exactInfinitesimalNumber) {
        int n = this.mReal.compareTo(exactInfinitesimalNumber.mReal);
        return n == 0 ? this.mEps.compareTo(exactInfinitesimalNumber.mEps) : n;
    }

    public int signum() {
        return this.mReal == Rational.ZERO ? this.mEps.signum() : this.mReal.signum();
    }
}

