/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.EMatching;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.ematching.ICode;
import java.util.Arrays;
import java.util.List;

public class ReverseCode
implements ICode {
    private final EMatching mEMatching;
    private final int mArgRegIndex;
    private final FunctionSymbol mFunc;
    private final int mArgPos;
    private final int mOutRegIndex;
    private final ICode mRemainingCode;

    public ReverseCode(EMatching eMatching, int n, FunctionSymbol functionSymbol, int n2, int n3, ICode iCode) {
        this.mEMatching = eMatching;
        this.mArgRegIndex = n;
        this.mFunc = functionSymbol;
        this.mArgPos = n2;
        this.mOutRegIndex = n3;
        this.mRemainingCode = iCode;
    }

    @Override
    public void execute(CCTerm[] cCTermArray, int n) {
        CCTerm cCTerm = cCTermArray[this.mArgRegIndex];
        this.mEMatching.installReverseTrigger(this.mFunc, cCTerm, this.mArgPos, this.mOutRegIndex, this.mRemainingCode, cCTermArray, n);
        List<CCTerm> list = this.mEMatching.getQuantTheory().getCClosure().getAllFuncAppsForArg(this.mFunc, cCTerm, this.mArgPos);
        for (CCTerm cCTerm2 : list) {
            CCTerm[] cCTermArray2 = Arrays.copyOf(cCTermArray, cCTermArray.length);
            cCTermArray2[this.mOutRegIndex] = cCTerm2;
            assert (cCTerm2 instanceof CCAppTerm);
            CCAppTerm cCAppTerm = (CCAppTerm)cCTerm2;
            int n2 = 0;
            while (n2 < this.mFunc.getParameterSorts().length - this.mArgPos - 1) {
                cCAppTerm = (CCAppTerm)cCAppTerm.getFunc();
                ++n2;
            }
            CCTerm cCTerm3 = cCAppTerm.getArg();
            int n3 = this.mEMatching.getQuantTheory().getCClosure().getDecideLevelForPath(cCTerm, cCTerm3);
            this.mEMatching.addCode(this.mRemainingCode, cCTermArray2, n3 > n ? n3 : n);
        }
    }

    public String toString() {
        return "reverse(" + String.valueOf(this.mFunc) + ", " + this.mArgPos + ", r" + this.mArgRegIndex + ", r" + this.mOutRegIndex + ",\n" + this.mRemainingCode.toString() + ")";
    }
}

