/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.lassoranker.LassoAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationAnalysisBenchmark;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.LassoAnalysisResults;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.cegar.BuchiCegarLoopResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.csv.CsvUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BuchiCegarLoopBenchmark
extends CegarStatisticsType {
    private static final BuchiCegarLoopBenchmark s_Instance = new BuchiCegarLoopBenchmark();
    public static final String RESULT = "Result";
    public static final String HIGHEST_RANK = "HighestRank";
    public static final String NON_LIVE_STATE_REMOVAL = "NonLiveStateRemoval";
    public static final String BUCHI_CLOSURE = "BuchiClosure";
    public static final String NONTRIVIAL_MODUL_STAGES = "NontrivialModuleStages";
    public static final String LASSO_ANALYSIS_TIME = "LassoAnalysisTime";
    public static final String LASSO_ANALYSIS_RESULTS = "LassoAnalysisResults";
    public static final String INTERPOLANT_COVERING_CAPABILITY_FINITE = "InterpolantCoveringCapabilityFinite";
    public static final String INTERPOLANT_COVERING_CAPABILITY_BUCHI = "InterpolantCoveringCapabilityBuchi";
    public static final String LASSO_PREPROCESSING_BENCHMARKS = "LassoPreprocessingBenchmarks";
    public static final String LASSO_TERMINATION_ANALYSIS_BENCHMARKS = "LassoTerminationAnalysisBenchmarks";
    public static final String LASSO_NONTERMINATION_ANALYSIS_BENCHMARKS = "LassoNonterminationAnalysisBenchmarks";
    public static final String LASSO_NONTERMINATION_ANALYSIS_SAT_FIXPOINT = "LassoNonterminationAnalysisSatFixpoint";
    public static final String LASSO_NONTERMINATION_ANALYSIS_SAT_UNBOUNDED = "LassoNonterminationAnalysisSatUnbounded";
    public static final String LASSO_NONTERMINATION_ANALYSIS_UNSAT = "LassoNonterminationAnalysisUnsat";
    public static final String LASSO_NONTERMINATION_ANALYSIS_UNKNOWN = "LassoNonterminationAnalysisUnknown";
    public static final String LASSO_NONTERMINATION_ANALYSIS_TIME = "LassoNonterminationAnalysisTime";
    public static final String MINIMIZATION_OF_DETERMINISTIC_AUTOMATA = "MinimizationsOfDetermnisticAutomata";
    public static final String MINIMIZATION_OF_NONDETERMINISTIC_AUTOMATA = "MinimizationsOfNondetermnisticAutomata";

    public static BuchiCegarLoopBenchmark getInstance() {
        return s_Instance;
    }

    public Collection<String> getKeys() {
        ArrayList<String> arrayList = new ArrayList<String>(super.getKeys());
        arrayList.add(HIGHEST_RANK);
        arrayList.add(NON_LIVE_STATE_REMOVAL);
        arrayList.add(BUCHI_CLOSURE);
        arrayList.add(NONTRIVIAL_MODUL_STAGES);
        arrayList.add(LASSO_ANALYSIS_TIME);
        arrayList.add(LASSO_ANALYSIS_RESULTS);
        arrayList.add(INTERPOLANT_COVERING_CAPABILITY_FINITE);
        arrayList.add(INTERPOLANT_COVERING_CAPABILITY_BUCHI);
        arrayList.add(LASSO_PREPROCESSING_BENCHMARKS);
        arrayList.add(LASSO_TERMINATION_ANALYSIS_BENCHMARKS);
        arrayList.add(LASSO_NONTERMINATION_ANALYSIS_SAT_FIXPOINT);
        arrayList.add(LASSO_NONTERMINATION_ANALYSIS_SAT_UNBOUNDED);
        arrayList.add(LASSO_NONTERMINATION_ANALYSIS_UNSAT);
        arrayList.add(LASSO_NONTERMINATION_ANALYSIS_UNKNOWN);
        arrayList.add(LASSO_NONTERMINATION_ANALYSIS_TIME);
        arrayList.add(MINIMIZATION_OF_DETERMINISTIC_AUTOMATA);
        arrayList.add(MINIMIZATION_OF_NONDETERMINISTIC_AUTOMATA);
        return arrayList;
    }

    public Object aggregate(String string, Object object, Object object2) {
        switch (string) {
            case "Result": {
                BuchiCegarLoopResult.Result result = (BuchiCegarLoopResult.Result)((Object)object);
                BuchiCegarLoopResult.Result result2 = (BuchiCegarLoopResult.Result)((Object)object2);
                HashSet<BuchiCegarLoopResult.Result> hashSet = new HashSet<BuchiCegarLoopResult.Result>();
                hashSet.add(result);
                hashSet.add(result2);
                if (hashSet.contains((Object)BuchiCegarLoopResult.Result.NONTERMINATING)) {
                    return BuchiCegarLoopResult.Result.NONTERMINATING;
                }
                if (hashSet.contains((Object)BuchiCegarLoopResult.Result.UNKNOWN)) {
                    return BuchiCegarLoopResult.Result.UNKNOWN;
                }
                if (hashSet.contains((Object)BuchiCegarLoopResult.Result.TIMEOUT)) {
                    return BuchiCegarLoopResult.Result.TIMEOUT;
                }
                if (hashSet.contains((Object)BuchiCegarLoopResult.Result.TERMINATING)) {
                    return BuchiCegarLoopResult.Result.TERMINATING;
                }
                throw new AssertionError();
            }
            case "NontrivialModuleStages": {
                int[] nArray = (int[])object;
                int[] nArray2 = (int[])object2;
                assert (nArray.length == 4);
                assert (nArray2.length == 4);
                int[] nArray3 = new int[4];
                int n = 0;
                while (n < 4) {
                    nArray3[n] = nArray[n] + nArray[n];
                    ++n;
                }
                return nArray3;
            }
            case "InterpolantCoveringCapabilityFinite": 
            case "InterpolantCoveringCapabilityBuchi": {
                CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation = (CoverageAnalysis.BackwardCoveringInformation)object;
                CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation2 = (CoverageAnalysis.BackwardCoveringInformation)object2;
                return new CoverageAnalysis.BackwardCoveringInformation(backwardCoveringInformation, backwardCoveringInformation2);
            }
            case "HighestRank": 
            case "LassoNonterminationAnalysisUnknown": 
            case "LassoNonterminationAnalysisTime": 
            case "LassoNonterminationAnalysisUnsat": 
            case "LassoPreprocessingBenchmarks": 
            case "LassoNonterminationAnalysisSatUnbounded": 
            case "LassoTerminationAnalysisBenchmarks": 
            case "LassoNonterminationAnalysisSatFixpoint": {
                throw new AssertionError((Object)"not yet implemented");
            }
        }
        return super.aggregate(string, object, object2);
    }

    public String prettyprintBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("B\u00fcchiAutomizer plugin needed ");
        Long l = (Long)iStatisticsDataProvider.getValue(CegarLoopStatisticsDefinitions.OverallTime.toString());
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyprintNanoseconds((long)l));
        stringBuilder.append(" and ");
        Integer n = (Integer)iStatisticsDataProvider.getValue(CegarLoopStatisticsDefinitions.OverallIterations.toString());
        stringBuilder.append(n);
        stringBuilder.append(" iterations. ");
        stringBuilder.append(" TraceHistogramMax:");
        Integer n2 = (Integer)iStatisticsDataProvider.getValue(CegarLoopStatisticsDefinitions.TraceHistogramMax.toString());
        stringBuilder.append(n2);
        stringBuilder.append(". ");
        Long l2 = (Long)iStatisticsDataProvider.getValue(LASSO_ANALYSIS_TIME);
        stringBuilder.append("Analysis of lassos took ");
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyprintNanoseconds((long)l2));
        stringBuilder.append(". ");
        IStatisticsDataProvider iStatisticsDataProvider2 = (IStatisticsDataProvider)iStatisticsDataProvider.getValue(CegarLoopStatisticsDefinitions.HoareTripleCheckerStatistics.toString());
        Long l3 = iStatisticsDataProvider2.getKeys().isEmpty() ? Long.valueOf(0L) : (Long)iStatisticsDataProvider2.getValue(String.valueOf(IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.Time));
        stringBuilder.append("Construction of modules took ");
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyprintNanoseconds((long)l3));
        Long l4 = (Long)iStatisticsDataProvider.getValue(CegarLoopStatisticsDefinitions.AutomataDifference.toString());
        stringBuilder.append(". ");
        stringBuilder.append("B\u00fcchi inclusion checks took ");
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyprintNanoseconds((long)(l4 - l3)));
        stringBuilder.append(". ");
        stringBuilder.append("Highest rank in rank-based complementation ");
        Integer n3 = (Integer)iStatisticsDataProvider.getValue(HIGHEST_RANK);
        stringBuilder.append(n3);
        stringBuilder.append(". ");
        stringBuilder.append("Minimization of det autom ");
        stringBuilder.append(iStatisticsDataProvider.getValue(MINIMIZATION_OF_DETERMINISTIC_AUTOMATA));
        stringBuilder.append(". ");
        stringBuilder.append("Minimization of nondet autom ");
        stringBuilder.append(iStatisticsDataProvider.getValue(MINIMIZATION_OF_NONDETERMINISTIC_AUTOMATA));
        stringBuilder.append(". ");
        stringBuilder.append("Automata minimization ");
        stringBuilder.append(iStatisticsDataProvider.getValue(CegarLoopStatisticsDefinitions.AutomataMinimizationStatistics.toString()));
        stringBuilder.append(". ");
        stringBuilder.append("Non-live state removal took ");
        Long l5 = (Long)iStatisticsDataProvider.getValue(NON_LIVE_STATE_REMOVAL);
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyprintNanoseconds((long)l5));
        stringBuilder.append(" Buchi closure took ");
        Long l6 = (Long)iStatisticsDataProvider.getValue(BUCHI_CLOSURE);
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyprintNanoseconds((long)l6));
        stringBuilder.append(". ");
        CegarStatisticsType.SizeIterationPair sizeIterationPair = (CegarStatisticsType.SizeIterationPair)iStatisticsDataProvider.getValue(CegarLoopStatisticsDefinitions.BiggestAbstraction.toString());
        stringBuilder.append("Biggest automaton had ");
        stringBuilder.append(sizeIterationPair.getSize());
        stringBuilder.append(" states and ocurred in iteration ");
        stringBuilder.append(sizeIterationPair.getIteration());
        stringBuilder.append(".\t");
        int[] nArray = (int[])iStatisticsDataProvider.getValue(NONTRIVIAL_MODUL_STAGES);
        stringBuilder.append("Nontrivial modules had stage ");
        stringBuilder.append(Arrays.toString(nArray));
        stringBuilder.append(".\t");
        CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation = (CoverageAnalysis.BackwardCoveringInformation)iStatisticsDataProvider.getValue(INTERPOLANT_COVERING_CAPABILITY_FINITE);
        stringBuilder.append(INTERPOLANT_COVERING_CAPABILITY_FINITE);
        stringBuilder.append(": ");
        stringBuilder.append(backwardCoveringInformation.toString());
        stringBuilder.append("\t");
        CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation2 = (CoverageAnalysis.BackwardCoveringInformation)iStatisticsDataProvider.getValue(INTERPOLANT_COVERING_CAPABILITY_BUCHI);
        stringBuilder.append(INTERPOLANT_COVERING_CAPABILITY_BUCHI);
        stringBuilder.append(": ");
        stringBuilder.append(backwardCoveringInformation2.toString());
        stringBuilder.append("\t");
        stringBuilder.append(CegarLoopStatisticsDefinitions.HoareTripleCheckerStatistics.toString());
        stringBuilder.append(": ");
        stringBuilder.append(iStatisticsDataProvider2);
        stringBuilder.append("\t");
        stringBuilder.append(LASSO_ANALYSIS_RESULTS);
        stringBuilder.append(": ");
        LassoAnalysisResults lassoAnalysisResults = (LassoAnalysisResults)iStatisticsDataProvider.getValue(LASSO_ANALYSIS_RESULTS);
        stringBuilder.append(lassoAnalysisResults.toString());
        stringBuilder.append(LASSO_PREPROCESSING_BENCHMARKS);
        stringBuilder.append(": ");
        List list = (List)iStatisticsDataProvider.getValue(LASSO_PREPROCESSING_BENCHMARKS);
        stringBuilder.append(LassoAnalysis.PreprocessingBenchmark.prettyprint((List)list));
        stringBuilder.append(LASSO_TERMINATION_ANALYSIS_BENCHMARKS);
        stringBuilder.append(": ");
        List list2 = (List)iStatisticsDataProvider.getValue(LASSO_TERMINATION_ANALYSIS_BENCHMARKS);
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyPrintTerminationAnalysisBenchmark(list2));
        stringBuilder.append(LASSO_TERMINATION_ANALYSIS_BENCHMARKS);
        stringBuilder.append(": ");
        stringBuilder.append(LASSO_NONTERMINATION_ANALYSIS_SAT_FIXPOINT);
        stringBuilder.append(": ");
        stringBuilder.append(iStatisticsDataProvider.getValue(LASSO_NONTERMINATION_ANALYSIS_SAT_FIXPOINT));
        stringBuilder.append("\t");
        stringBuilder.append(LASSO_NONTERMINATION_ANALYSIS_SAT_UNBOUNDED);
        stringBuilder.append(": ");
        stringBuilder.append(iStatisticsDataProvider.getValue(LASSO_NONTERMINATION_ANALYSIS_SAT_UNBOUNDED));
        stringBuilder.append("\t");
        stringBuilder.append(LASSO_NONTERMINATION_ANALYSIS_UNSAT);
        stringBuilder.append(": ");
        stringBuilder.append(iStatisticsDataProvider.getValue(LASSO_NONTERMINATION_ANALYSIS_UNSAT));
        stringBuilder.append("\t");
        stringBuilder.append(LASSO_NONTERMINATION_ANALYSIS_UNKNOWN);
        stringBuilder.append(": ");
        stringBuilder.append(iStatisticsDataProvider.getValue(LASSO_NONTERMINATION_ANALYSIS_UNKNOWN));
        stringBuilder.append("\t");
        stringBuilder.append(LASSO_NONTERMINATION_ANALYSIS_TIME);
        stringBuilder.append(": ");
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyprintNanoseconds((long)((Long)iStatisticsDataProvider.getValue(LASSO_NONTERMINATION_ANALYSIS_TIME))));
        stringBuilder.append("\t");
        String string = CegarLoopStatisticsDefinitions.InitialAbstractionConstructionTime.toString();
        stringBuilder.append(string);
        stringBuilder.append(": ");
        stringBuilder.append(BuchiCegarLoopBenchmark.prettyprintNanoseconds((long)((Long)iStatisticsDataProvider.getValue(string))));
        return stringBuilder.toString();
    }

    private static String prettyPrintTerminationAnalysisBenchmark(List<TerminationAnalysisBenchmark> list) {
        if (list.isEmpty()) {
            return "not available";
        }
        StringBuilder stringBuilder = new StringBuilder();
        ICsvProvider<Object> iCsvProvider = BuchiCegarLoopBenchmark.aggregateTermBench(list);
        int n = 0;
        for (String string : iCsvProvider.getColumnTitles()) {
            stringBuilder.append(string);
            stringBuilder.append(": ");
            if (string.equals("Time")) {
                long l = (Long)iCsvProvider.getRow(0).get(n);
                stringBuilder.append(l /= 1000000L);
                stringBuilder.append("ms");
            } else if (string.equals("ConstraintsSatisfiability")) {
                Script.LBool lBool = (Script.LBool)iCsvProvider.getRow(0).get(n);
                stringBuilder.append(lBool);
            } else {
                int n2 = (Integer)iCsvProvider.getRow(0).get(n);
                stringBuilder.append(n2);
            }
            stringBuilder.append(" ");
            ++n;
        }
        return stringBuilder.toString();
    }

    private static ICsvProvider<Object> aggregateTermBench(List<TerminationAnalysisBenchmark> list) {
        ArrayList<ICsvProvider> arrayList = new ArrayList<ICsvProvider>();
        list = Collections.singletonList(BuchiCegarLoopBenchmark.mostMotzkinButUnknownFirst(list));
        for (TerminationAnalysisBenchmark iCsvProvider2 : list) {
            arrayList.add(iCsvProvider2.createCsvProvider());
        }
        ICsvProvider iCsvProvider = CsvUtils.concatenateRows(arrayList);
        ICsvProvider iCsvProvider3 = CsvUtils.projectColumn((ICsvProvider)iCsvProvider, (String[])new String[]{"ConstraintsSatisfiability", "Degree", "Time", "VariablesStem", "VariablesLoop", "DisjunctsStem", "DisjunctsLoop", "SupportingInvariants", "MotzkinApplications"});
        return iCsvProvider3;
    }

    private static TerminationAnalysisBenchmark mostMotzkinButUnknownFirst(List<TerminationAnalysisBenchmark> list) {
        boolean bl = false;
        int n = 0;
        TerminationAnalysisBenchmark terminationAnalysisBenchmark = null;
        for (TerminationAnalysisBenchmark terminationAnalysisBenchmark2 : list) {
            if (!bl) {
                if (terminationAnalysisBenchmark2.getConstraintsSatisfiability() == Script.LBool.UNKNOWN) {
                    bl = true;
                    terminationAnalysisBenchmark = terminationAnalysisBenchmark2;
                    n = terminationAnalysisBenchmark2.getMotzkinApplications();
                    continue;
                }
                if (terminationAnalysisBenchmark2.getMotzkinApplications() <= n) continue;
                terminationAnalysisBenchmark = terminationAnalysisBenchmark2;
                n = terminationAnalysisBenchmark2.getMotzkinApplications();
                continue;
            }
            if (terminationAnalysisBenchmark2.getConstraintsSatisfiability() != Script.LBool.UNKNOWN || terminationAnalysisBenchmark2.getMotzkinApplications() <= n) continue;
            terminationAnalysisBenchmark = terminationAnalysisBenchmark2;
            n = terminationAnalysisBenchmark2.getMotzkinApplications();
        }
        return terminationAnalysisBenchmark;
    }
}

