/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import java.math.BigInteger;

public class MutableRational
implements Comparable<MutableRational> {
    int mNum;
    int mDenom;
    BigInteger mBignum;
    BigInteger mBigdenom;

    public MutableRational(int n, int n2) {
        this.setValue(n, n2);
    }

    public MutableRational(BigInteger bigInteger, BigInteger bigInteger2) {
        this.mBignum = bigInteger;
        this.mBigdenom = bigInteger2;
        this.normalize();
    }

    public MutableRational(Rational rational) {
        this.mNum = rational.mNum;
        this.mDenom = rational.mDenom;
        if (rational instanceof Rational.BigRational) {
            this.mBignum = rational.numerator();
            this.mBigdenom = rational.denominator();
        }
    }

    public MutableRational(MutableRational mutableRational) {
        this.mNum = mutableRational.mNum;
        this.mDenom = mutableRational.mDenom;
        this.mBignum = mutableRational.mBignum;
        this.mBigdenom = mutableRational.mBigdenom;
    }

    public void setValue(Rational rational) {
        this.mNum = rational.mNum;
        this.mDenom = rational.mDenom;
        if (rational instanceof Rational.BigRational) {
            this.mBignum = rational.numerator();
            this.mBigdenom = rational.denominator();
        } else {
            this.mBigdenom = null;
            this.mBignum = null;
        }
    }

    public void setValue(long l, long l2) {
        long l3 = Rational.gcd(Math.abs(l), Math.abs(l2));
        if (l2 < 0L) {
            l3 = -l3;
        }
        if (l3 != 0L) {
            l /= l3;
            l2 /= l3;
        }
        if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE && l2 <= Integer.MAX_VALUE) {
            this.mNum = (int)l;
            this.mDenom = (int)l2;
            this.mBigdenom = null;
            this.mBignum = null;
        } else {
            this.mBignum = BigInteger.valueOf(l);
            this.mBigdenom = BigInteger.valueOf(l2);
        }
    }

    private void normalize() {
        if (this.mBignum == null) {
            int n = Rational.gcd(this.mNum, this.mDenom);
            if (n != 0 && n != 1) {
                this.mNum /= n;
                this.mDenom /= n;
            }
            if (this.mDenom < 0) {
                this.mNum = -this.mNum;
                this.mDenom = -this.mDenom;
            }
        } else {
            if (!this.mBigdenom.equals(BigInteger.ONE)) {
                BigInteger bigInteger = Rational.gcd(this.mBignum, this.mBigdenom).abs();
                if (this.mBigdenom.signum() < 0) {
                    bigInteger = bigInteger.negate();
                }
                if (!bigInteger.equals(BigInteger.ZERO) && !bigInteger.equals(BigInteger.ONE)) {
                    this.mBignum = this.mBignum.divide(bigInteger);
                    this.mBigdenom = this.mBigdenom.divide(bigInteger);
                }
            }
            if (this.mBigdenom.bitLength() < 32 && this.mBignum.bitLength() < 32) {
                this.mNum = this.mBignum.intValue();
                this.mDenom = this.mBigdenom.intValue();
                this.mBigdenom = null;
                this.mBignum = null;
            }
        }
    }

    public MutableRational add(Rational rational) {
        BigInteger bigInteger;
        if (rational == Rational.ZERO) {
            return this;
        }
        if (this.mBignum == null && !(rational instanceof Rational.BigRational)) {
            if (this.mDenom == rational.mDenom) {
                if (this.mDenom == 0) {
                    if (this.mNum != rational.mNum) {
                        this.mNum = 0;
                    }
                } else {
                    this.setValue((long)this.mNum + (long)rational.mNum, this.mDenom);
                }
            } else {
                int n = Rational.gcd(this.mDenom, rational.mDenom);
                long l = this.mDenom / n;
                long l2 = rational.mDenom / n;
                long l3 = l * (long)rational.mDenom;
                long l4 = l2 * (long)this.mNum + l * (long)rational.mNum;
                this.setValue(l4, l3);
            }
            return this;
        }
        if (this.mBignum == null && this.mNum == 0 && this.mDenom == 1) {
            this.mBignum = rational.numerator();
            this.mBigdenom = rational.denominator();
            return this;
        }
        BigInteger bigInteger2 = this.denominator();
        if (bigInteger2.equals(bigInteger = rational.denominator())) {
            this.mBignum = this.numerator().add(rational.numerator());
            this.mBigdenom = bigInteger2;
        } else {
            BigInteger bigInteger3 = Rational.gcd(bigInteger2, bigInteger);
            BigInteger bigInteger4 = bigInteger2.divide(bigInteger3);
            BigInteger bigInteger5 = bigInteger.divide(bigInteger3);
            this.mBignum = this.numerator().multiply(bigInteger5).add(rational.numerator().multiply(bigInteger4));
            this.mBigdenom = bigInteger2.multiply(bigInteger5);
        }
        this.normalize();
        return this;
    }

    public MutableRational negate() {
        if (this.mBignum == null) {
            if (this.mNum == Integer.MIN_VALUE) {
                this.setValue(0x80000000L, this.mDenom);
            } else {
                this.mNum = -this.mNum;
            }
        } else {
            this.mBignum = this.mBignum.negate();
        }
        return this;
    }

    public MutableRational sub(Rational rational) {
        return this.add(rational.negate());
    }

    public MutableRational mul(Rational rational) {
        if (rational == Rational.ONE) {
            return this;
        }
        if (rational == Rational.MONE) {
            return this.negate();
        }
        if (this.mBignum == null && !(rational instanceof Rational.BigRational)) {
            long l = (long)this.mNum * (long)rational.mNum;
            long l2 = (long)this.mDenom * (long)rational.mDenom;
            this.setValue(l, l2);
            return this;
        }
        this.mBignum = this.numerator().multiply(rational.numerator());
        this.mBigdenom = this.denominator().multiply(rational.denominator());
        this.normalize();
        return this;
    }

    public MutableRational div(Rational rational) {
        if (rational == Rational.ZERO) {
            throw new ArithmeticException("Division by ZERO");
        }
        if (this.mBignum == null && this.mNum == 0) {
            return this;
        }
        if (rational == Rational.ONE) {
            return this;
        }
        if (rational == Rational.MONE) {
            return this.negate();
        }
        if (this.mBignum == null && !(rational instanceof Rational.BigRational)) {
            long l = (long)this.mNum * (long)rational.mDenom;
            long l2 = (long)this.mDenom * (long)rational.mNum;
            if (l2 == 0L && rational.mNum < 0) {
                l = -l;
            }
            this.setValue(l, l2);
            return this;
        }
        this.mBignum = this.numerator().multiply(rational.denominator());
        this.mBigdenom = this.denominator().multiply(rational.numerator());
        if (this.mBigdenom.equals(BigInteger.ZERO) && rational.numerator().signum() == -1) {
            this.mBignum = this.mBignum.negate();
        }
        this.normalize();
        return this;
    }

    public MutableRational inverse() {
        if (this.mBignum == null) {
            this.setValue(this.mDenom, this.mNum);
        } else {
            BigInteger bigInteger = this.mBigdenom;
            if (this.mBignum.signum() < 0) {
                this.mBigdenom = this.mBignum.negate();
                this.mBignum = bigInteger.negate();
            } else {
                this.mBigdenom = this.mBignum;
                this.mBignum = bigInteger;
            }
        }
        return this;
    }

    public boolean isNegative() {
        return this.numerator().signum() < 0;
    }

    public MutableRational addmul(Rational rational, Rational rational2) {
        return this.add(rational.mul(rational2));
    }

    public MutableRational addmul(Rational rational, BigInteger bigInteger) {
        return this.add(rational.mul(bigInteger));
    }

    public MutableRational subdiv(Rational rational, Rational rational2) {
        return this.sub(rational).div(rational2);
    }

    @Override
    public int compareTo(MutableRational mutableRational) {
        if (this.mBignum == null && mutableRational.mBignum == null) {
            if (mutableRational.mDenom == this.mDenom) {
                return this.mNum < mutableRational.mNum ? -1 : (this.mNum == mutableRational.mNum ? 0 : 1);
            }
            long l = (long)this.mNum * (long)mutableRational.mDenom;
            long l2 = (long)mutableRational.mNum * (long)this.mDenom;
            return l < l2 ? -1 : (l == l2 ? 0 : 1);
        }
        BigInteger bigInteger = this.numerator().multiply(mutableRational.denominator());
        BigInteger bigInteger2 = mutableRational.numerator().multiply(this.denominator());
        return bigInteger.compareTo(bigInteger2);
    }

    @Override
    public int compareTo(Rational rational) {
        if (this.mBignum == null && !(rational instanceof Rational.BigRational)) {
            if (rational.mDenom == this.mDenom) {
                return this.mNum < rational.mNum ? -1 : (this.mNum == rational.mNum ? 0 : 1);
            }
            long l = (long)this.mNum * (long)rational.mDenom;
            long l2 = (long)rational.mNum * (long)this.mDenom;
            return l < l2 ? -1 : (l == l2 ? 0 : 1);
        }
        BigInteger bigInteger = this.numerator().multiply(rational.denominator());
        BigInteger bigInteger2 = rational.numerator().multiply(this.denominator());
        return bigInteger.compareTo(bigInteger2);
    }

    public boolean equals(Object object) {
        if (object instanceof Rational) {
            Rational rational = (Rational)object;
            return this.mBignum == null ? !(rational instanceof Rational.BigRational) && this.mNum == rational.mNum && this.mDenom == rational.mDenom : this.mBignum.equals(rational.numerator()) && this.mBigdenom.equals(rational.denominator());
        }
        if (object instanceof MutableRational) {
            MutableRational mutableRational = (MutableRational)object;
            return this.mBignum == null ? mutableRational.mBignum == null && this.mNum == mutableRational.mNum && this.mDenom == mutableRational.mDenom : this.mBignum.equals(mutableRational.mBignum) && this.mBigdenom.equals(mutableRational.mBigdenom);
        }
        return false;
    }

    public BigInteger numerator() {
        return this.mBignum == null ? BigInteger.valueOf(this.mNum) : this.mBignum;
    }

    public BigInteger denominator() {
        return this.mBigdenom == null ? BigInteger.valueOf(this.mDenom) : this.mBigdenom;
    }

    public int hashCode() {
        if (this.mBignum == null) {
            return this.mNum * 257 + this.mDenom;
        }
        return this.mBignum.hashCode() * 257 + this.mBigdenom.hashCode();
    }

    public String toString() {
        if (this.mBignum == null) {
            if (this.mDenom == 0) {
                return this.mNum > 0 ? "inf" : (this.mNum == 0 ? "nan" : "-inf");
            }
            if (this.mDenom == 1) {
                return String.valueOf(this.mNum);
            }
            return this.mNum + "/" + this.mDenom;
        }
        if (this.mBigdenom.equals(BigInteger.ONE)) {
            return this.mBignum.toString();
        }
        return String.valueOf(this.mBignum) + "/" + String.valueOf(this.mBigdenom);
    }

    public boolean isIntegral() {
        return this.mBignum == null ? this.mDenom <= 1 : this.mBigdenom.equals(BigInteger.ONE);
    }

    public Rational toRational() {
        if (this.mBignum == null) {
            return Rational.valueOf(this.mNum, this.mDenom);
        }
        return Rational.valueOf(this.numerator(), this.denominator());
    }

    public int signum() {
        if (this.mBignum == null) {
            return this.mNum < 0 ? -1 : (this.mNum == 0 ? 0 : 1);
        }
        return this.mBignum.signum();
    }
}

