/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.util;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.MappedTerm2Expression;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.PoormanAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.util.AssumptionBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class TermConjunctEvaluator<STATE extends IAbstractState<STATE>> {
    private final ILogger mLogger;
    private final IAbstractDomain<STATE, IcfgEdge> mBackingDomain;
    private final MappedTerm2Expression mMappedTerm2Expression;
    private final Set<TermVariable> mVariableRetainmentSet;
    private final Map<TermVariable, String> mAlternateOldNames;
    private final CodeBlockFactory mCodeBlockFactory;
    private final Function<Collection<STATE>, Collection<STATE>> mPostFunction;
    private final Script mScript;
    private final Map<Term[], CodeBlock> mCachedCodeBlocks;

    public TermConjunctEvaluator(ILogger iLogger, Term term, IAbstractDomain<STATE, IcfgEdge> iAbstractDomain, Set<TermVariable> set, Map<TermVariable, String> map, MappedTerm2Expression mappedTerm2Expression, CodeBlockFactory codeBlockFactory, Script script) {
        this.mLogger = iLogger;
        this.mBackingDomain = iAbstractDomain;
        this.mVariableRetainmentSet = set;
        this.mAlternateOldNames = map;
        this.mMappedTerm2Expression = mappedTerm2Expression;
        this.mCodeBlockFactory = codeBlockFactory;
        this.mScript = script;
        this.mCachedCodeBlocks = new HashMap<Term[], CodeBlock>();
        this.mPostFunction = this.visit(term);
    }

    public Collection<STATE> computePost(PoormanAbstractState<STATE> poormanAbstractState) {
        if (this.mPostFunction == null) {
            throw new UnsupportedOperationException("No result produced.");
        }
        return this.mPostFunction.apply(Collections.singletonList(poormanAbstractState.getBackingState()));
    }

    private Function<Collection<STATE>, Collection<STATE>> visit(Term term) {
        if (term instanceof ApplicationTerm) {
            return this.visit((ApplicationTerm)term);
        }
        if (term instanceof AnnotatedTerm) {
            return this.visit((AnnotatedTerm)term);
        }
        if (term instanceof LetTerm) {
            return this.visit((LetTerm)term);
        }
        if (term instanceof QuantifiedFormula) {
            return this.visit((QuantifiedFormula)term);
        }
        if (term instanceof TermVariable) {
            return this.visit((TermVariable)term);
        }
        throw new UnsupportedOperationException("Unsupported term type: " + term.getClass().getSimpleName());
    }

    private Function<Collection<STATE>, Collection<STATE>> visit(TermVariable termVariable) {
        return collection -> this.applyPost((Collection<STATE>)collection, new Term[]{termVariable});
    }

    private Function<Collection<STATE>, Collection<STATE>> visit(QuantifiedFormula quantifiedFormula) {
        throw new UnsupportedOperationException("Quantified formulas cannot be handled right now.");
    }

    private Function<Collection<STATE>, Collection<STATE>> visit(LetTerm letTerm) {
        throw new UnsupportedOperationException("LetTerm formulas cannot be handled right now.");
    }

    private Function<Collection<STATE>, Collection<STATE>> visit(AnnotatedTerm annotatedTerm) {
        throw new UnsupportedOperationException("AnnotatedTerm formulas cannot be handled right now.");
    }

    private Function<Collection<STATE>, Collection<STATE>> visit(ApplicationTerm applicationTerm) {
        String string = applicationTerm.getFunction().getName();
        if (string.equals("and")) {
            ArrayList<Term> arrayList = new ArrayList<Term>();
            ArrayList<Term> arrayList2 = new ArrayList<Term>();
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term = termArray[n2];
                if (this.mBackingDomain.isAbstractable(term)) {
                    arrayList.add(term);
                } else {
                    arrayList2.add(term);
                }
                ++n2;
            }
            return collection -> {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Abstractables:     " + String.valueOf(arrayList)));
                    this.mLogger.debug((Object)("Non-Abstractables: " + String.valueOf(arrayList2)));
                }
                Collection<STATE> collection2 = this.applyPost((Collection<STATE>)collection, arrayList.toArray(new Term[arrayList.size()]));
                return this.computeFixpoint(arrayList2, collection2);
            };
        }
        if (string.equals("or")) {
            return collection -> {
                HashSet<STATE> hashSet = new HashSet<STATE>();
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray[n2];
                    hashSet.addAll(this.visit(term).apply((Collection<STATE>)collection));
                    ++n2;
                }
                return hashSet;
            };
        }
        if (string.equals("not")) {
            assert (applicationTerm.getParameters().length == 1);
            Term term = applicationTerm.getParameters()[0];
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm2 = (ApplicationTerm)term;
                Term term2 = this.negateTerm(applicationTerm2);
                if (term2 == applicationTerm2) {
                    return collection -> this.applyPost((Collection<STATE>)collection, new Term[]{applicationTerm});
                }
                return this.visit(term2);
            }
        }
        return collection -> this.applyPost((Collection<STATE>)collection, new Term[]{applicationTerm});
    }

    private Collection<STATE> computeFixpoint(Collection<Term> collection, Collection<STATE> collection2) {
        Set set;
        if (collection.isEmpty()) {
            return collection2;
        }
        DisjunctiveAbstractState disjunctiveAbstractState = DisjunctiveAbstractState.createDisjunction(collection2);
        int n = 0;
        block0: while (true) {
            ++n;
            DisjunctiveAbstractState disjunctiveAbstractState3 = disjunctiveAbstractState;
            for (Term term : collection) {
                disjunctiveAbstractState3 = DisjunctiveAbstractState.createDisjunction(this.visit(term).apply(disjunctiveAbstractState3.getStates()));
                if (!disjunctiveAbstractState3.isBottom()) continue;
                set = Collections.emptySet();
                break block0;
            }
            DisjunctiveAbstractState disjunctiveAbstractState22 = disjunctiveAbstractState;
            if (disjunctiveAbstractState3.isSubsetOf(disjunctiveAbstractState22) != IAbstractState.SubsetResult.NONE) {
                set = disjunctiveAbstractState3.getStates();
                break;
            }
            disjunctiveAbstractState = disjunctiveAbstractState3;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Computed fixpoint for " + collection.size() + " terms and " + collection2.size() + " states in " + n + " iterations, resulting in " + set.size() + " states"));
        }
        return set;
    }

    /*
     * Exception decompiling
     */
    private Term negateTerm(ApplicationTerm var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[12] lbl107 : CaseStatement: default:\u000a, @NONE, blocks:[12] lbl107 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CodeBlock getCachedCodeBlock(Term ... termArray) {
        if (termArray.length == 0) {
            return null;
        }
        CodeBlock codeBlock = this.mCachedCodeBlocks.get(termArray);
        if (codeBlock != null) {
            return codeBlock;
        }
        AssumeStatement[] assumeStatementArray = AssumptionBuilder.constructBoogieAssumeStatement(this.mLogger, this.mVariableRetainmentSet, this.mAlternateOldNames, this.mMappedTerm2Expression, termArray);
        CodeBlock codeBlock2 = AssumptionBuilder.constructCodeBlock(this.mCodeBlockFactory, (Statement[])assumeStatementArray);
        this.mCachedCodeBlocks.put(termArray, codeBlock2);
        return codeBlock2;
    }

    private Collection<STATE> applyPost(Collection<STATE> collection, Term ... termArray) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("PreStates: " + String.valueOf(collection)));
        }
        if (collection.stream().allMatch(iAbstractState -> iAbstractState.isBottom())) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("PostStates: " + String.valueOf(collection)));
            }
            return collection;
        }
        CodeBlock codeBlock = this.getCachedCodeBlock(termArray);
        if (codeBlock == null) {
            return collection;
        }
        HashSet hashSet = new HashSet();
        for (IAbstractState iAbstractState2 : collection) {
            if (iAbstractState2.isBottom()) continue;
            hashSet.addAll(this.mBackingDomain.getPostOperator().apply(iAbstractState2, (Object)codeBlock));
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("PostStates: " + String.valueOf(hashSet)));
        }
        return hashSet;
    }

    private /* synthetic */ Term lambda$5(Term term) {
        return this.mScript.term("not", new Term[]{term});
    }
}

