/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.BoogiePreprocessorBacktranslator;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AddressStore;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AddressStoreFactory;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.AliasAnalysis;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.IdentifierReplacer;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MayAlias;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemoryArrayReplacer;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySliceException;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySliceUtils;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.PointerBase;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MemorySlicer
implements IUnmanagedObserver {
    private final BoogiePreprocessorBacktranslator mTranslator;
    private final AddressStoreFactory mAsfac;
    private final ILogger mLogger;

    public MemorySlicer(BoogiePreprocessorBacktranslator boogiePreprocessorBacktranslator, ILogger iLogger) {
        this.mTranslator = boogiePreprocessorBacktranslator;
        this.mAsfac = new AddressStoreFactory();
        this.mLogger = iLogger;
    }

    public void init(ModelType modelType, int n, int n2) {
    }

    public void finish() {
    }

    public boolean performedChanges() {
        return true;
    }

    public boolean process(IElement iElement) {
        if (iElement instanceof Unit) {
            Unit unit = (Unit)iElement;
            Map<String, Procedure> map = this.constructIdToImplementation(unit.getDeclarations());
            try {
                ArrayDeque<Declaration> arrayDeque = this.tryToSliceMemory(unit, map);
                unit.setDeclarations(arrayDeque.toArray(new Declaration[arrayDeque.size()]));
            }
            catch (MemorySliceException memorySliceException) {
                this.mLogger.warn((Object)("Omit memory slicing because it failed with the following exception: " + memorySliceException.getMessage()));
            }
            return false;
        }
        return true;
    }

    private ArrayDeque<Declaration> tryToSliceMemory(Unit unit, Map<String, Procedure> map) throws AssertionError {
        Object object;
        AliasAnalysis aliasAnalysis = new AliasAnalysis(this.mAsfac, map);
        MayAlias mayAlias = aliasAnalysis.aliasAnalysis(unit);
        Map<AddressStore, Integer> map2 = this.constructMemorySliceMapping(aliasAnalysis, mayAlias);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer hashRelation2 : map2.values()) {
            object = MemorySliceUtils.constructMemorySliceSuffix(hashRelation2);
            arrayList.add((String)object);
        }
        HashRelation<String, Integer> hashRelation = this.computeProcedureToDirectlyModifiedSlices(aliasAnalysis, mayAlias, map2);
        Iterator<Integer> iterator = this.computeProcedureToModifiedSlices(aliasAnalysis, hashRelation);
        object = new ArrayDeque();
        MemoryArrayReplacer memoryArrayReplacer = new MemoryArrayReplacer(this.mAsfac, mayAlias, map2, (HashRelation<String, Integer>)iterator);
        Declaration[] declarationArray = unit.getDeclarations();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration declaration = declarationArray[n2];
            List<String> list = Arrays.asList("#memory_$Pointer$", "#memory_int", "#memory_real");
            List<VariableDeclaration> list2 = this.duplicateMemoryArrayVarDecl(list, arrayList, declaration);
            if (list2 != null) {
                ((ArrayDeque)object).addAll(list2);
            } else if (declaration instanceof Procedure) {
                Procedure procedure = (Procedure)declaration;
                if (MemorySlicer.isUltimateBasicMemoryReadWriteProcedure(procedure) || MemorySlicer.isUltimateMemoryReadWriteProcedureWithImplementation(procedure)) {
                    var18_19 = MemorySlicer.duplicateProcedure(list, arrayList, (Procedure)declaration);
                    ((ArrayDeque)object).addAll(var18_19);
                } else if (MemorySlicer.isUltimateMemoryAllocationProcedure(procedure)) {
                    ((ArrayDeque)object).add(procedure);
                } else if (MemorySlicer.isUltimateMemoryConcurrencyProcedure(procedure)) {
                    ((ArrayDeque)object).add(procedure);
                } else {
                    if (procedure.getSpecification() != null) {
                        Declaration declaration2 = var18_19 = procedure.getSpecification();
                        int n3 = ((Declaration)declaration2).length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Declaration declaration3 = declaration2[n4];
                            if (!(declaration3 instanceof ModifiesSpecification)) {
                                throw new MemorySliceException(String.format("Unsupported: Procedure %s is not part of the Ultimate memory model but has specification other that is not a ModifiesSpecification", procedure.getIdentifier()));
                            }
                            ++n4;
                        }
                    }
                    var18_19 = memoryArrayReplacer.processDeclaration((Declaration)procedure);
                    ((ArrayDeque)object).add(var18_19);
                }
            } else {
                ((ArrayDeque)object).add(declaration);
            }
            ++n2;
        }
        this.mLogger.info((Object)memoryArrayReplacer.generateLogMessage());
        return object;
    }

    public HashRelation<String, Integer> computeProcedureToModifiedSlices(AliasAnalysis aliasAnalysis, HashRelation<String, Integer> hashRelation) {
        HashRelation hashRelation2 = new HashRelation(hashRelation);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(hashRelation.getDomain());
        while (!linkedHashSet.isEmpty()) {
            String string = (String)linkedHashSet.iterator().next();
            linkedHashSet.remove(string);
            for (String string2 : aliasAnalysis.getReverseCallgraph().getImage((Object)string)) {
                if (string2.equals(string)) continue;
                boolean bl = false;
                for (Integer n : hashRelation2.getImage((Object)string)) {
                    bl |= hashRelation2.addPair((Object)string2, (Object)n);
                }
                if (!bl) continue;
                linkedHashSet.add(string2);
            }
        }
        return hashRelation2;
    }

    public HashRelation<String, Integer> computeProcedureToDirectlyModifiedSlices(AliasAnalysis aliasAnalysis, MayAlias mayAlias, Map<AddressStore, Integer> map) {
        HashRelation hashRelation = new HashRelation();
        HashRelation<String, PointerBase> hashRelation2 = aliasAnalysis.getProcedureToWritePointers();
        for (String string : hashRelation2.getDomain()) {
            for (PointerBase pointerBase : hashRelation2.getImage((Object)string)) {
                AddressStore addressStore = (AddressStore)mayAlias.getAddressStores().find((Object)pointerBase);
                Integer n = map.get(addressStore);
                if (n == null) {
                    throw new MemorySliceException("Unknown PointerBase " + String.valueOf(pointerBase));
                }
                hashRelation.addPair((Object)string, (Object)n);
            }
        }
        return hashRelation;
    }

    public Map<AddressStore, Integer> constructMemorySliceMapping(AliasAnalysis aliasAnalysis, MayAlias mayAlias) {
        HashMap<AddressStore, Integer> hashMap = new HashMap<AddressStore, Integer>();
        UnionFind<AddressStore> unionFind = mayAlias.getAddressStores();
        for (AddressStore addressStore : unionFind.getAllElements()) {
            if (addressStore instanceof PointerBase && AliasAnalysis.isNullPointer((PointerBase)addressStore)) assert (unionFind.find((Object)addressStore) == addressStore && unionFind.getEquivalenceClassMembers((Object)addressStore).size() == 1);
        }
        int n = 0;
        HashSet hashSet = new HashSet();
        for (AddressStore addressStore : aliasAnalysis.getAccessAddresses()) {
            AddressStore addressStore2 = (AddressStore)unionFind.find((Object)addressStore);
            Objects.requireNonNull(addressStore2, "Cannot find pointer: " + String.valueOf(addressStore));
            hashSet.add(addressStore2);
        }
        Iterator<PointerBase> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            AddressStore addressStore;
            addressStore = iterator.next();
            hashMap.put(addressStore, n);
            ++n;
        }
        return hashMap;
    }

    private Map<String, Procedure> constructIdToImplementation(Declaration[] declarationArray) {
        HashMap<String, Procedure> hashMap = new HashMap<String, Procedure>();
        Declaration[] declarationArray2 = declarationArray;
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Procedure procedure;
            Declaration declaration = declarationArray2[n2];
            if (declaration instanceof Procedure && (procedure = (Procedure)declaration).getBody() != null) {
                hashMap.put(procedure.getIdentifier(), procedure);
            }
            ++n2;
        }
        return hashMap;
    }

    private static boolean isUltimateBasicMemoryReadWriteProcedure(Procedure procedure) {
        List<String> list = MemorySlicer.toList("write~$Pointer$", "write~int", "write~real", "write~init~$Pointer$", "write~init~int", "write~init~real", "write~unchecked~$Pointer$", "write~unchecked~int", "write~unchecked~real", "read~$Pointer$", "read~int", "read~real", "read~unchecked~$Pointer$", "read~unchecked~int", "read~unchecked~real");
        assert (list.size() == 15);
        for (String string : list) {
            if (!procedure.getIdentifier().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUltimateMemoryReadWriteProcedureWithImplementation(Procedure procedure) {
        List<String> list = MemorySlicer.toList("#Ultimate.C_memset", "#Ultimate.C_memcpy", "#Ultimate.C_memmove", "#Ultimate.C_strcpy", "#Ultimate.C_realloc");
        for (String string : list) {
            if (!procedure.getIdentifier().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUltimateMemoryAllocationProcedure(Procedure procedure) {
        List<String> list = MemorySlicer.toList("#Ultimate.allocInit", "#Ultimate.allocOnHeap", "#Ultimate.allocOnStack", "ULTIMATE.dealloc");
        for (String string : list) {
            if (!procedure.getIdentifier().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUltimateMemoryConcurrencyProcedure(Procedure procedure) {
        List<String> list = MemorySlicer.toList("#PthreadsForkCount", "#PthreadsMutex", "#PthreadsMutexLock", "#PthreadsMutexUnlock", "#PthreadsMutexTryLock", "#PthreadsRwLock", "#PthreadsRwLockReadLock", "#PthreadsRwLockWriteLock", "#PthreadsRwLockUnlock");
        for (String string : list) {
            if (!procedure.getIdentifier().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    public static ModifiesSpecification reviseModifiesSpec(Collection<Integer> collection, ModifiesSpecification modifiesSpecification, String ... stringArray) {
        VariableLHS variableLHS;
        VariableLHS[] variableLHSArray = modifiesSpecification.getIdentifiers();
        ArrayList<VariableLHS> arrayList = new ArrayList<VariableLHS>();
        VariableLHS[] variableLHSArray2 = variableLHSArray;
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            variableLHS = variableLHSArray2[n2];
            if (Arrays.asList(stringArray).contains(variableLHS.getIdentifier())) {
                for (Integer n3 : collection) {
                    String string = MemorySliceUtils.constructMemorySliceSuffix(n3);
                    VariableLHS variableLHS2 = new VariableLHS(variableLHS.getLoc(), variableLHS.getType(), variableLHS.getIdentifier() + string, variableLHS.getDeclarationInformation());
                    ModelUtils.copyAnnotations((IElement)variableLHS, (IElement)variableLHS2);
                    arrayList.add(variableLHS2);
                }
            } else {
                arrayList.add(variableLHS);
            }
            ++n2;
        }
        variableLHS = new ModifiesSpecification(modifiesSpecification.getLoc(), modifiesSpecification.isFree(), arrayList.toArray(new VariableLHS[arrayList.size()]));
        ModelUtils.copyAnnotations((IElement)modifiesSpecification, (IElement)variableLHS);
        return variableLHS;
    }

    private static List<String> toList(String ... stringArray) {
        return Arrays.asList(stringArray);
    }

    private static List<Procedure> duplicateProcedure(List<String> list, Collection<String> collection, Procedure procedure) {
        ArrayList<Procedure> arrayList = new ArrayList<Procedure>(collection.size());
        for (String string : collection) {
            Map<String, String> map = list.stream().collect(Collectors.toMap(Function.identity(), string2 -> string2 + string));
            arrayList.add(MemorySlicer.renameSpecification(map, string, procedure));
        }
        return arrayList;
    }

    private static Procedure renameSpecification(Map<String, String> map, String string, Procedure procedure) {
        IdentifierReplacer identifierReplacer = new IdentifierReplacer(map, procedure.getIdentifier(), string);
        Body body = procedure.getBody() == null ? null : identifierReplacer.processBody(procedure.getBody());
        Specification[] specificationArray = procedure.getSpecification() == null ? null : identifierReplacer.processSpecifications(procedure.getSpecification());
        Procedure procedure2 = new Procedure(procedure.getLoc(), procedure.getAttributes(), procedure.getIdentifier() + string, procedure.getTypeParams(), procedure.getInParams(), procedure.getOutParams(), specificationArray, body);
        ModelUtils.copyAnnotations((IElement)procedure, (IElement)procedure2);
        return procedure2;
    }

    public List<VariableDeclaration> duplicateMemoryArrayVarDecl(Collection<String> collection, Collection<String> collection2, Declaration declaration) {
        VariableDeclaration variableDeclaration;
        if (declaration instanceof VariableDeclaration && (variableDeclaration = (VariableDeclaration)declaration).getVariables().length == 1) {
            VarList varList = variableDeclaration.getVariables()[0];
            if (this.isSingleIdList("#memory_$Pointer$", varList)) {
                return MemorySlicer.duplicateMemoryArrayVarDecl(variableDeclaration, new String[]{"#memory_$Pointer$"}, collection2);
            }
            if (this.isSingleIdList("#memory_int", varList)) {
                return MemorySlicer.duplicateMemoryArrayVarDecl(variableDeclaration, new String[]{"#memory_int"}, collection2);
            }
            if (this.isSingleIdList("#memory_real", varList)) {
                return MemorySlicer.duplicateMemoryArrayVarDecl(variableDeclaration, new String[]{"#memory_real"}, collection2);
            }
        }
        return null;
    }

    private boolean isSingleIdList(String string, VarList varList) {
        String[] stringArray = varList.getIdentifiers();
        if (stringArray.length == 1) {
            return stringArray[0].equals(string);
        }
        return false;
    }

    private static List<VariableDeclaration> duplicateMemoryArrayVarDecl(VariableDeclaration variableDeclaration, String[] stringArray, Collection<String> collection) {
        ArrayList<VariableDeclaration> arrayList = new ArrayList<VariableDeclaration>();
        for (String string : collection) {
            arrayList.add(MemorySlicer.renameMemoryArray(variableDeclaration, stringArray, string));
        }
        return arrayList;
    }

    private static VariableDeclaration renameMemoryArray(VariableDeclaration variableDeclaration, String[] stringArray, String string) {
        assert (variableDeclaration.getVariables().length == stringArray.length);
        VarList[] varListArray = new VarList[variableDeclaration.getVariables().length];
        int n = 0;
        while (n < variableDeclaration.getVariables().length) {
            VarList varList = variableDeclaration.getVariables()[n];
            VarList varList2 = new VarList(varList.getLoc(), new String[]{stringArray[n] + string}, varList.getType(), varList.getWhereClause());
            ModelUtils.copyAnnotations((IElement)varList, (IElement)varList2);
            varListArray[n] = varList2;
            ++n;
        }
        VariableDeclaration variableDeclaration2 = new VariableDeclaration(variableDeclaration.getLoc(), variableDeclaration.getAttributes(), varListArray);
        ModelUtils.copyAnnotations((IElement)variableDeclaration, (IElement)variableDeclaration2);
        return variableDeclaration2;
    }
}

