/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieUtils;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BreakStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GotoStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WildcardExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ConditionAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LTLStepAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopExitAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.OverapproxVariable;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Statements2TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.LoopEntryDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.OrdinaryDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureEntryDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorWithCheckDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureExitDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureFinalDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.StringDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder.IcfgBacktranslator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder.WeakestPrecondition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder.preferences.IcfgPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.icfgbuilder.util.TransFormulaAdder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.AtomicBlockAnalyzer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.AtomicBlockInfo;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlockFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ForkThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.JoinThreadCurrent;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.LargeBlockEncoding;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.LiveIcfgUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class CfgBuilder {
    private static final String ULTIMATE_START = "ULTIMATE.start";
    private final ILogger mLogger;
    private final BoogieIcfgContainer mIcfg;
    private final Boogie2SMT mBoogie2Smt;
    private final BoogieDeclarations mBoogieDeclarations;
    private TransFormulaAdder mTransFormulaAdder;
    private final Collection<Summary> mImplementationSummarys = new LinkedHashSet<Summary>();
    private final Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> mForks = new HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>>();
    private final List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> mJoins = new ArrayList<IIcfgJoinTransitionThreadCurrent<IcfgLocation>>();
    private final IcfgBacktranslator mIcfgBacktranslator;
    private final IcfgPreferenceInitializer.CodeBlockSize mCodeBlockSize;
    private final boolean mCtxSwitchOnlyAtAtomicBoundaries;
    private final IUltimateServiceProvider mServices;
    private final boolean mAddAssumeForEachAssert;
    private final CodeBlockFactory mCbf;
    private Stack<BoogieIcfgLocation> mConditionalStarts;
    private int mRemovedAssumeTrueStatements = 0;
    private static final SmtUtils.SimplificationTechnique SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.POLY_PAC;
    private final boolean mRemoveAssumeTrueStmt;
    private final boolean mFutureLiveOptimization;

    public CfgBuilder(Unit unit, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        this.mAddAssumeForEachAssert = iPreferenceProvider.getBoolean("Add additional assume for each assert");
        this.mRemoveAssumeTrueStmt = iPreferenceProvider.getBoolean("Remove assume true statements");
        String string = ILocation.getAnnotation((IElement)unit).getFileName();
        String string2 = new File(string).getName();
        Script script = this.constructAndInitializeSolver(iUltimateServiceProvider, string2);
        ManagedScript managedScript = new ManagedScript(this.mServices, script);
        this.mBoogieDeclarations = new BoogieDeclarations(unit, this.mLogger);
        boolean bl = iPreferenceProvider.getBoolean("Skolemize terms");
        ForkAndGotoInformation forkAndGotoInformation = new ForkAndGotoInformation(this.mBoogieDeclarations);
        IcfgPreferenceInitializer.CodeBlockSize codeBlockSize = (IcfgPreferenceInitializer.CodeBlockSize)iPreferenceProvider.getEnum("Size of a code block", IcfgPreferenceInitializer.CodeBlockSize.class);
        if (!codeBlockSize.isConcurrencySafe() && forkAndGotoInformation.hasSomeForkEdge()) {
            this.mCodeBlockSize = IcfgPreferenceInitializer.CodeBlockSize.OneNontrivialStatement;
            this.mLogger.warn("User set CodeBlockSize to %s but program contains fork statements. Overwriting the user preferences and setting CodeBlockSize to %s.", new Object[]{codeBlockSize, this.mCodeBlockSize});
        } else {
            this.mCodeBlockSize = codeBlockSize;
        }
        this.mCtxSwitchOnlyAtAtomicBoundaries = iPreferenceProvider.getBoolean("Only consider context switches at boundaries of atomic blocks");
        this.mFutureLiveOptimization = iPreferenceProvider.getBoolean("Future-live optimization");
        this.mBoogie2Smt = new Boogie2SMT(managedScript, this.mBoogieDeclarations, this.mServices, bl);
        IcfgBacktranslator icfgBacktranslator = new IcfgBacktranslator(this.mLogger);
        icfgBacktranslator.setTerm2Expression(this.mBoogie2Smt.getTerm2Expression());
        this.mIcfgBacktranslator = icfgBacktranslator;
        ConcurrencyInformation concurrencyInformation = new ConcurrencyInformation(this.mForks, Collections.emptyMap(), this.mJoins);
        this.mIcfg = new BoogieIcfgContainer(this.mServices, this.mBoogieDeclarations, this.mBoogie2Smt, concurrencyInformation);
        this.mCbf = this.mIcfg.getCodeBlockFactory();
        this.mCbf.storeFactory(this.mServices.getStorage());
    }

    public IIcfg<BoogieIcfgLocation> createIcfg(Unit unit) {
        Object object2;
        this.mLogger.info((Object)"Building ICFG");
        this.mTransFormulaAdder = new TransFormulaAdder(this.mBoogie2Smt, this.mServices);
        BoogieIcfgContainer boogieIcfgContainer = this.mIcfg;
        for (Object object2 : this.mBoogieDeclarations.getProcImplementation().keySet()) {
            Body body = ((Procedure)this.mBoogieDeclarations.getProcImplementation().get(object2)).getBody();
            Object object3 = body.getBlock().length == 0 ? new ReturnStatement(((Procedure)this.mBoogieDeclarations.getProcImplementation().get(object2)).getLocation()) : body.getBlock()[0];
            BoogieIcfgLocation boogieIcfgLocation = new BoogieIcfgLocation((DebugIdentifier)new ProcedureEntryDebugIdentifier((String)object2), (String)object2, false, (BoogieASTNode)object3);
            Procedure procedure = (Procedure)this.mBoogieDeclarations.getProcImplementation().get(object2);
            boogieIcfgContainer.getProcedureEntryNodes().put(object2, boogieIcfgLocation);
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation((DebugIdentifier)new ProcedureFinalDebugIdentifier((String)object2), (String)object2, false, (BoogieASTNode)procedure);
            boogieIcfgContainer.mFinalNode.put(object2, boogieIcfgLocation2);
            BoogieIcfgLocation boogieIcfgLocation3 = new BoogieIcfgLocation((DebugIdentifier)new ProcedureExitDebugIdentifier((String)object2), (String)object2, false, (BoogieASTNode)procedure);
            boogieIcfgContainer.getProcedureExitNodes().put(object2, boogieIcfgLocation3);
        }
        this.mLogger.info((Object)"Building CFG for each procedure with an implementation");
        object2 = new ProcedureCfgBuilder();
        for (String string : this.mBoogieDeclarations.getProcSpecification().keySet()) {
            if (!this.mBoogieDeclarations.getProcImplementation().containsKey(string)) continue;
            ((ProcedureCfgBuilder)object2).buildProcedureCfgFromImplementation(string);
        }
        for (Summary summary : this.mImplementationSummarys) {
            this.addCallTransitionAndReturnTransition(summary, SIMPLIFICATION_TECHNIQUE);
        }
        if (this.mFutureLiveOptimization) {
            if (!IcfgUtils.isConcurrent((IIcfg)boogieIcfgContainer)) {
                LiveIcfgUtils.applyFutureLiveOptimization((IUltimateServiceProvider)this.mServices, (IIcfg)boogieIcfgContainer);
            } else {
                this.mLogger.info((Object)"Omitted future-live optimization because the input is a concurrent program.");
            }
        }
        this.mLogger.info((Object)"Performing block encoding");
        switch (this.mCodeBlockSize) {
            case LoopFreeBlock: {
                new LargeBlockEncoding(this.mServices, this.mIcfg, this.mCbf, LargeBlockEncoding.InternalLbeMode.ALL);
                break;
            }
            case SingleStatement: 
            case OneNontrivialStatement: 
            case SequenceOfStatements: {
                LargeBlockEncoding.InternalLbeMode internalLbeMode = this.mCtxSwitchOnlyAtAtomicBoundaries && IcfgUtils.isConcurrent((IIcfg)this.mIcfg) ? LargeBlockEncoding.InternalLbeMode.ALL_EXCEPT_ATOMIC_BOUNDARIES : LargeBlockEncoding.InternalLbeMode.ONLY_ATOMIC_BLOCK;
                new LargeBlockEncoding(this.mServices, this.mIcfg, this.mCbf, internalLbeMode);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown value: " + String.valueOf((Object)this.mCodeBlockSize)));
            }
        }
        AtomicBlockAnalyzer.ensureAtomicCompositionIsComplete((BoogieIcfgContainer)this.mIcfg, (ILogger)this.mLogger);
        Set set = boogieIcfgContainer.getProcedureEntryNodes().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(ULTIMATE_START)).map(Map.Entry::getValue).collect(Collectors.toSet());
        if (set.isEmpty()) {
            this.mLogger.info((Object)"Using library mode");
            boogieIcfgContainer.getInitialNodes().addAll(boogieIcfgContainer.getProcedureEntryNodes().values());
        } else {
            this.mLogger.info((Object)("Using the " + set.size() + " location(s) as analysis (start of procedure ULTIMATE.start)"));
            boogieIcfgContainer.getInitialNodes().addAll(set);
        }
        ModelUtils.copyAnnotations((IElement)unit, (IElement)boogieIcfgContainer);
        this.mLogger.info((Object)("Removed " + this.mRemovedAssumeTrueStatements + " assume(true) statements."));
        this.mLogger.info("Constructed ICFG has %d procedures, %d locations, %d edges, %d initial locations, %d loop locations, and %d error locations.", new Object[]{boogieIcfgContainer.getProcedureEntryNodes().size(), IcfgUtils.getNumberOfLocations((IIcfg)boogieIcfgContainer), IcfgUtils.getNumberOfEdges((IIcfg)boogieIcfgContainer), boogieIcfgContainer.getInitialNodes().size(), boogieIcfgContainer.getLoopLocations().size(), IcfgUtils.getErrorLocations((IIcfg)boogieIcfgContainer).size()});
        return boogieIcfgContainer;
    }

    public Boogie2SMT getBoogie2Smt() {
        return this.mBoogie2Smt;
    }

    private Script constructAndInitializeSolver(IUltimateServiceProvider iUltimateServiceProvider, String string) {
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        SolverBuilder.SolverMode solverMode = (SolverBuilder.SolverMode)iPreferenceProvider.getEnum("SMT solver", SolverBuilder.SolverMode.class);
        boolean bl = iPreferenceProvider.getBoolean("Fake non-incremental script");
        boolean bl2 = iPreferenceProvider.getBoolean("Dump SMT script to file");
        boolean bl3 = iPreferenceProvider.getBoolean("Compress dumped SMT script");
        String string2 = iPreferenceProvider.getString("To the following directory");
        String string3 = iPreferenceProvider.getString("Command for external solver");
        boolean bl4 = iPreferenceProvider.getBoolean("Dump unsat core track benchmark to file");
        boolean bl5 = iPreferenceProvider.getBoolean("Dump main track benchmark to file");
        Map map = iPreferenceProvider.getKeyValueMap("Additional SMT options");
        Logics logics = Logics.valueOf((String)iPreferenceProvider.getString("Logic for external solver"));
        SolverBuilder.SolverSettings solverSettings = SolverBuilder.constructSolverSettings().setUseFakeIncrementalScript(bl).setDumpSmtScriptToFile(bl2, string2, string, bl3).setDumpUnsatCoreTrackBenchmark(bl4).setDumpMainTrackBenchmark(bl5).setUseExternalSolver(true, string3, logics).setSolverMode(solverMode).setAdditionalOptions(map);
        return SolverBuilder.buildAndInitializeSolver((IUltimateServiceProvider)iUltimateServiceProvider, (SolverBuilder.SolverSettings)solverSettings, (String)"CfgBuilderScript");
    }

    private static Expression getNegation(Expression expression) {
        if (expression == null) {
            return null;
        }
        return new UnaryExpression(expression.getLocation(), (IBoogieType)BoogieType.TYPE_BOOL, UnaryExpression.Operator.LOGICNEG, expression);
    }

    private void addCallTransitionAndReturnTransition(Summary summary, SmtUtils.SimplificationTechnique simplificationTechnique) {
        CallStatement callStatement = summary.getCallStatement();
        String string = callStatement.getMethodName();
        assert (this.mIcfg.getProcedureEntryNodes().containsKey(string)) : "Source code contains call of " + string + " but no such procedure.";
        BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)summary.getSource();
        BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)this.mIcfg.getProcedureEntryNodes().get(string);
        String string2 = boogieIcfgLocation.getProcedure();
        Statements2TransFormula.TranslationResult translationResult = this.mIcfg.getBoogie2SMT().getStatements2TransFormula().inParamAssignment(callStatement, simplificationTechnique);
        Statements2TransFormula.TranslationResult translationResult2 = this.mIcfg.getBoogie2SMT().getStatements2TransFormula().resultAssignment(callStatement, string2, simplificationTechnique);
        HashMap hashMap = new HashMap(translationResult.getOverapproximations());
        hashMap.putAll(translationResult2.getOverapproximations());
        Call call = this.mCbf.constructCall(boogieIcfgLocation, boogieIcfgLocation2, callStatement);
        call.setTransitionFormula(translationResult.getTransFormula());
        if (!hashMap.isEmpty()) {
            new Overapprox(hashMap).annotate((IElement)call);
        }
        BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)summary.getTarget();
        BoogieIcfgLocation boogieIcfgLocation4 = (BoogieIcfgLocation)this.mIcfg.getProcedureExitNodes().get(string);
        Return return_ = this.mCbf.constructReturn(boogieIcfgLocation4, boogieIcfgLocation3, call);
        return_.setTransitionFormula(translationResult2.getTransFormula());
    }

    private BoogieIcfgLocation addErrorNode(String string, BoogieASTNode boogieASTNode, Map<DebugIdentifier, BoogieIcfgLocation> map) {
        ProcedureErrorDebugIdentifier.ProcedureErrorType procedureErrorType;
        int n;
        LinkedHashSet<BoogieIcfgLocation> linkedHashSet = (LinkedHashSet<BoogieIcfgLocation>)this.mIcfg.getProcedureErrorNodes().get(string);
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet<BoogieIcfgLocation>();
            this.mIcfg.getProcedureErrorNodes().put(string, linkedHashSet);
            n = 0;
        } else {
            n = linkedHashSet.size();
        }
        if (boogieASTNode instanceof AssertStatement) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.ASSERT_VIOLATION;
        } else if (boogieASTNode instanceof EnsuresSpecification) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.ENSURES_VIOLATION;
        } else if (boogieASTNode instanceof RequiresSpecification) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.REQUIRES_VIOLATION;
        } else if (boogieASTNode instanceof ForkStatement) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.INUSE_VIOLATION;
        } else if (boogieASTNode instanceof LoopInvariantSpecification) {
            procedureErrorType = ProcedureErrorDebugIdentifier.ProcedureErrorType.LOOP_INVARIANT_VIOLATION;
        } else {
            throw new IllegalArgumentException();
        }
        Check check = Check.getAnnotation((IElement)boogieASTNode);
        if (check == null) {
            throw new IllegalArgumentException("Constructing error location without specification for the following AST node: " + String.valueOf(boogieASTNode));
        }
        ProcedureErrorWithCheckDebugIdentifier procedureErrorWithCheckDebugIdentifier = new ProcedureErrorWithCheckDebugIdentifier(string, n, procedureErrorType, check);
        BoogieIcfgLocation boogieIcfgLocation = new BoogieIcfgLocation((DebugIdentifier)procedureErrorWithCheckDebugIdentifier, string, true, boogieASTNode);
        check.annotate((IElement)boogieIcfgLocation);
        map.put((DebugIdentifier)procedureErrorWithCheckDebugIdentifier, boogieIcfgLocation);
        linkedHashSet.add(boogieIcfgLocation);
        return boogieIcfgLocation;
    }

    public ITranslator<IIcfgTransition<IcfgLocation>, BoogieASTNode, Term, Expression, IcfgLocation, String, ILocation> getBacktranslator() {
        return this.mIcfgBacktranslator;
    }

    private static boolean isPlainAssumeTrueStatement(Statement statement) {
        if (statement instanceof AssumeStatement) {
            BooleanLiteral booleanLiteral;
            AssumeStatement assumeStatement = (AssumeStatement)statement;
            if (assumeStatement.getAttributes() != null && assumeStatement.getAttributes().length > 0) {
                return false;
            }
            if (LTLStepAnnotation.getAnnotation((IElement)assumeStatement) != null) {
                return false;
            }
            if (assumeStatement.getFormula() instanceof BooleanLiteral && (booleanLiteral = (BooleanLiteral)assumeStatement.getFormula()).getValue()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isOverapproximation(Statement statement) {
        Overapprox overapprox = Overapprox.getAnnotation((IElement)statement);
        return overapprox != null;
    }

    private static class ForkAndGotoInformation {
        private boolean mHasSomeForkStatement;
        private final Set<String> mAllGotoTargets = new HashSet<String>();

        public ForkAndGotoInformation(BoogieDeclarations boogieDeclarations) {
            for (Map.Entry entry : boogieDeclarations.getProcImplementation().entrySet()) {
                Procedure procedure = (Procedure)entry.getValue();
                Body body = procedure.getBody();
                this.processStatements(body.getBlock());
            }
        }

        private void processStatements(Statement[] statementArray) {
            Statement[] statementArray2 = statementArray;
            int n = statementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray2[n2];
                if (statement instanceof ForkStatement) {
                    this.mHasSomeForkStatement = true;
                } else if (statement instanceof GotoStatement) {
                    this.mAllGotoTargets.addAll(Arrays.asList(((GotoStatement)statement).getLabels()));
                } else if (statement instanceof AtomicStatement) {
                    this.processStatements(((AtomicStatement)statement).getBody());
                } else if (!(statement instanceof AssignmentStatement || statement instanceof AssumeStatement || statement instanceof HavocStatement || statement instanceof Label || statement instanceof JoinStatement || statement instanceof CallStatement || statement instanceof ReturnStatement || statement instanceof AssertStatement || statement instanceof BreakStatement)) {
                    if (statement instanceof IfStatement) {
                        this.processStatements(((IfStatement)statement).getThenPart());
                        this.processStatements(((IfStatement)statement).getElsePart());
                    } else if (statement instanceof WhileStatement) {
                        this.processStatements(((WhileStatement)statement).getBody());
                    } else {
                        throw new UnsupportedOperationException("Did not expect statement of type " + statement.getClass().getSimpleName());
                    }
                }
                ++n2;
            }
        }

        public boolean hasSomeForkEdge() {
            return this.mHasSomeForkStatement;
        }
    }

    private final class ProcedureCfgBuilder {
        private static final boolean AGGRESSIVE_NODE_MERGING = true;
        private Map<DebugIdentifier, BoogieIcfgLocation> mProcLocNodes;
        private Map<DebugIdentifier, BoogieIcfgLocation> mLabel2LocNodes;
        private Map<String, Label> mLabelString2Statement;
        private DebugIdentifier mLastLabelName;
        IElement mCurrent;
        List<GotoEdge> mGotoEdges;
        String mCurrentProcedureName;
        Set<CodeBlock> mEdges;
        Map<Integer, Integer> mNameCache;
        private Stack<BoogieIcfgLocation> mWhileExits;
        private Map<String, Integer> mGotoTargetCounter;

        private ProcedureCfgBuilder() {
        }

        private void buildProcedureCfgFromImplementation(String string) {
            this.mCurrentProcedureName = string;
            this.mEdges = new HashSet<CodeBlock>();
            this.mGotoEdges = new LinkedList<GotoEdge>();
            this.mNameCache = new HashMap<Integer, Integer>();
            this.mWhileExits = new Stack();
            CfgBuilder.this.mConditionalStarts = new Stack();
            this.mLabelString2Statement = new HashMap<String, Label>();
            Statement[] statementArray = ((Procedure)CfgBuilder.this.mBoogieDeclarations.getProcImplementation().get(string)).getBody().getBlock();
            if (statementArray.length == 0) {
                this.mEdges = new HashSet<CodeBlock>();
            }
            this.mGotoTargetCounter = BoogieUtils.countGotoTargets((Statement[])statementArray);
            this.mLabel2LocNodes = new HashMap<DebugIdentifier, BoogieIcfgLocation>();
            this.findLabels(statementArray);
            this.mProcLocNodes = new HashMap<DebugIdentifier, BoogieIcfgLocation>();
            CfgBuilder.this.mIcfg.getProgramPoints().put(string, this.mProcLocNodes);
            CfgBuilder.this.mLogger.debug((Object)("Start construction of the CFG for" + string));
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(string);
            this.mLastLabelName = boogieIcfgLocation.getDebugIdentifier();
            this.mProcLocNodes.put(this.mLastLabelName, boogieIcfgLocation);
            this.mCurrent = boogieIcfgLocation;
            boogieIcfgLocation = this.buildCodeBlock(statementArray, (BoogieIcfgLocation)CfgBuilder.this.mIcfg.mFinalNode.get(string));
            boogieIcfgLocation = this.assumeRequires(boogieIcfgLocation, false);
            if (boogieIcfgLocation == CfgBuilder.this.mIcfg.mFinalNode.get(string)) {
                CfgBuilder.this.mIcfg.getProcedureEntryNodes().put(string, boogieIcfgLocation);
                this.mergeLocNodes((BoogieIcfgLocation)CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(string), boogieIcfgLocation, true);
            } else {
                this.mergeLocNodes(boogieIcfgLocation, (BoogieIcfgLocation)CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(string), true);
            }
            this.assertAndAssumeEnsures();
            boolean bl = CfgBuilder.this.mServices.getPreferenceProvider(Activator.PLUGIN_ID).getBoolean("Remove goto edges from ICFG");
            if (bl) {
                CfgBuilder.this.mLogger.debug((Object)"Starting removal of auxiliaryGotoTransitions");
                while (!this.mGotoEdges.isEmpty()) {
                    GotoEdge gotoEdge2 = this.mGotoEdges.remove(0);
                    boolean bl2 = this.removeAuxiliaryGoto(gotoEdge2, true);
                    assert (bl2) : "goto not removed";
                }
            } else {
                for (GotoEdge gotoEdge : this.mGotoEdges) {
                    boolean bl3 = this.removeAuxiliaryGoto(gotoEdge, false);
                    if (bl3) continue;
                    this.mEdges.add((CodeBlock)gotoEdge);
                }
            }
            for (CodeBlock codeBlock : this.mEdges) {
                CfgBuilder.this.mTransFormulaAdder.addTransitionFormulas(codeBlock, string, SIMPLIFICATION_TECHNIQUE);
            }
            BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(string);
            Set<BoogieIcfgLocation> set = this.computeReachableLocations(boogieIcfgLocation2);
            BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)CfgBuilder.this.mIcfg.getProcedureExitNodes().get(string);
            Map<DebugIdentifier, BoogieIcfgLocation> map = this.mProcLocNodes;
            this.removeUnreachableProgramPoints(set, map, boogieIcfgLocation3);
        }

        private boolean isAssuAssiHavoc(Statement statement) {
            return statement instanceof AssumeStatement || statement instanceof AssignmentStatement || statement instanceof HavocStatement;
        }

        private void findLabels(Statement[] statementArray) {
            Statement[] statementArray2 = statementArray;
            int n = statementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Statement statement = statementArray2[n2];
                if (statement instanceof Label) {
                    this.mLabelString2Statement.put(((Label)statement).getName(), (Label)statement);
                } else if (statement instanceof WhileStatement) {
                    this.findLabels(((WhileStatement)statement).getBody());
                } else if (statement instanceof IfStatement) {
                    this.findLabels(((IfStatement)statement).getThenPart());
                    this.findLabels(((IfStatement)statement).getElsePart());
                } else if (statement instanceof AtomicStatement) {
                    this.findLabels(((AtomicStatement)statement).getBody());
                }
                ++n2;
            }
        }

        private BoogieIcfgLocation buildCodeBlock(Statement[] statementArray, BoogieIcfgLocation boogieIcfgLocation) {
            return (BoogieIcfgLocation)this.buildCodeBlock(statementArray, (IIcfgElement)boogieIcfgLocation, true);
        }

        /*
         * Exception decompiling
         */
        private IIcfgElement buildCodeBlock(Statement[] var1_1, IIcfgElement var2_2, boolean var3_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private BoogieIcfgLocation buildIf(BoogieIcfgLocation boogieIcfgLocation, IfStatement ifStatement) {
            AssumeStatement assumeStatement;
            AssumeStatement assumeStatement2;
            CfgBuilder.this.mConditionalStarts.add(boogieIcfgLocation);
            IIcfgElement iIcfgElement = this.buildCodeBlock(ifStatement.getThenPart(), (IIcfgElement)boogieIcfgLocation, false);
            IIcfgElement iIcfgElement2 = this.buildCodeBlock(ifStatement.getElsePart(), (IIcfgElement)CfgBuilder.this.mConditionalStarts.peek(), false);
            BoogieIcfgLocation boogieIcfgLocation2 = CfgBuilder.this.mConditionalStarts.pop();
            if (ifStatement.getCondition() instanceof WildcardExpression) {
                assumeStatement = assumeStatement2 = new AssumeStatement(ifStatement.getLocation(), (Expression)ExpressionFactory.createBooleanLiteral((ILocation)ifStatement.getLocation(), (boolean)true));
            } else {
                assumeStatement2 = new AssumeStatement(ifStatement.getLocation(), ifStatement.getCondition());
                assumeStatement = new AssumeStatement(ifStatement.getLocation(), CfgBuilder.getNegation(ifStatement.getCondition()));
                new ConditionAnnotation(false).annotate((IElement)assumeStatement2);
                new ConditionAnnotation(true).annotate((IElement)assumeStatement);
            }
            CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement2, new BoogieASTNode[]{ifStatement});
            CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{ifStatement});
            BoogieIcfgLocation boogieIcfgLocation3 = this.buildNewIcfgLocation((BoogieASTNode)ifStatement);
            ModelUtils.copyAnnotations((IElement)ifStatement, (IElement)assumeStatement2);
            ModelUtils.copyAnnotations((IElement)ifStatement, (IElement)assumeStatement);
            this.buildBranching(assumeStatement2, iIcfgElement, assumeStatement, iIcfgElement2, boogieIcfgLocation3);
            if (this.canIfBeCombined(boogieIcfgLocation2)) {
                IcfgEdge icfgEdge = (IcfgEdge)boogieIcfgLocation2.getIncomingEdges().get(0);
                IcfgEdge icfgEdge2 = (IcfgEdge)boogieIcfgLocation2.getOutgoingEdges().get(0);
                List list = DataStructureUtils.concat((List)((StatementSequence)icfgEdge).getStatements(), (List)((StatementSequence)icfgEdge2).getStatements());
                StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence((BoogieIcfgLocation)icfgEdge.getSource(), (BoogieIcfgLocation)icfgEdge2.getTarget(), list);
                this.mEdges.add((CodeBlock)statementSequence);
                this.mProcLocNodes.remove(boogieIcfgLocation2.getDebugIdentifier());
                ModelUtils.copyAnnotations((IElement)icfgEdge, (IElement)statementSequence);
                ModelUtils.copyAnnotations((IElement)icfgEdge2, (IElement)statementSequence);
                icfgEdge2.disconnectTarget();
                icfgEdge.disconnectSource();
                this.mEdges.remove(icfgEdge2);
                this.mEdges.remove(icfgEdge);
            }
            return boogieIcfgLocation3;
        }

        private boolean canIfBeCombined(BoogieIcfgLocation boogieIcfgLocation) {
            if (!(CfgBuilder.this.mCodeBlockSize != IcfgPreferenceInitializer.CodeBlockSize.LoopFreeBlock && CfgBuilder.this.mCodeBlockSize != IcfgPreferenceInitializer.CodeBlockSize.SequenceOfStatements || boogieIcfgLocation.getIncomingEdges().size() != 1 || boogieIcfgLocation.getOutgoingEdges().size() != 1 || CfgBuilder.this.mConditionalStarts.contains(boogieIcfgLocation) || this.mLabel2LocNodes.containsValue(boogieIcfgLocation))) {
                IcfgEdge icfgEdge = (IcfgEdge)boogieIcfgLocation.getIncomingEdges().get(0);
                IcfgEdge icfgEdge2 = (IcfgEdge)boogieIcfgLocation.getOutgoingEdges().get(0);
                return !(Overapprox.getAnnotation((IElement)icfgEdge) instanceof OverapproxVariable) && !(Overapprox.getAnnotation((IElement)icfgEdge2) instanceof OverapproxVariable) && icfgEdge instanceof StatementSequence && icfgEdge2 instanceof StatementSequence;
            }
            return false;
        }

        private BoogieIcfgLocation buildWhile(IIcfgElement iIcfgElement, WhileStatement whileStatement) {
            LoopInvariantSpecification loopInvariantSpecification;
            Integer n;
            BoogieIcfgLocation boogieIcfgLocation;
            AssignmentStatement assignmentStatement;
            BoogieIcfgLocation boogieIcfgLocation2;
            boolean bl = BoogieUtils.containsOuterBreak((Statement[])whileStatement.getBody());
            Object object = bl && iIcfgElement instanceof StatementSequence ? this.endStatementSequence((StatementSequence)iIcfgElement) : iIcfgElement;
            BoogieIcfgLocation boogieIcfgLocation3 = new BoogieIcfgLocation(this.constructLocDebugIdentifier((BoogieASTNode)whileStatement), this.mCurrentProcedureName, false, (BoogieASTNode)whileStatement);
            if (whileStatement.getInvariants().length == 0) {
                boogieIcfgLocation2 = boogieIcfgLocation3;
            } else {
                assignmentStatement = new AssignmentStatement(whileStatement.getLoc(), null, null);
                boogieIcfgLocation2 = new BoogieIcfgLocation(this.constructLocDebugIdentifier((BoogieASTNode)assignmentStatement), this.mCurrentProcedureName, false, (BoogieASTNode)assignmentStatement);
                this.mProcLocNodes.put(boogieIcfgLocation2.getDebugIdentifier(), boogieIcfgLocation2);
                boogieIcfgLocation = boogieIcfgLocation2;
                n = whileStatement.getInvariants().length - 1;
                while (n >= 0) {
                    loopInvariantSpecification = whileStatement.getInvariants()[n];
                    if (loopInvariantSpecification.isFree()) {
                        AssumeStatement assumeStatement = new AssumeStatement(loopInvariantSpecification.getLocation(), loopInvariantSpecification.getFormula());
                        CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{loopInvariantSpecification});
                        ModelUtils.copyAnnotations((IElement)loopInvariantSpecification, (IElement)assumeStatement);
                        boogieIcfgLocation = this.buildAssuAssiHavoc((IIcfgElement)boogieIcfgLocation, (Statement)assumeStatement);
                    } else {
                        if (boogieIcfgLocation instanceof StatementSequence) {
                            boogieIcfgLocation = this.endStatementSequence((StatementSequence)boogieIcfgLocation);
                        }
                        boogieIcfgLocation = this.buildBranchingToNewErrorLocation((IIcfgElement)boogieIcfgLocation, loopInvariantSpecification.getFormula(), (BoogieASTNode)loopInvariantSpecification);
                    }
                    n = n - 1;
                }
                if (boogieIcfgLocation instanceof StatementSequence) {
                    boogieIcfgLocation = this.endStatementSequence((StatementSequence)boogieIcfgLocation);
                }
                this.mergeLocNodes(boogieIcfgLocation, boogieIcfgLocation3, false);
            }
            new LoopEntryAnnotation(LoopEntryAnnotation.LoopEntryType.WHILE).annotate((IElement)boogieIcfgLocation3);
            this.mProcLocNodes.put(boogieIcfgLocation3.getDebugIdentifier(), boogieIcfgLocation3);
            CfgBuilder.this.mIcfg.getLoopLocations().add(boogieIcfgLocation3);
            if (bl) {
                this.mWhileExits.add((BoogieIcfgLocation)object);
            }
            CfgBuilder.this.mConditionalStarts.add(boogieIcfgLocation2);
            if (whileStatement.getCondition() instanceof WildcardExpression) {
                assignmentStatement = new AssumeStatement(whileStatement.getLocation(), (Expression)ExpressionFactory.createBooleanLiteral((ILocation)whileStatement.getLocation(), (boolean)true));
                boogieIcfgLocation = assignmentStatement;
            } else {
                assignmentStatement = new AssumeStatement(whileStatement.getLocation(), whileStatement.getCondition());
                boogieIcfgLocation = new AssumeStatement(whileStatement.getLocation(), CfgBuilder.getNegation(whileStatement.getCondition()));
                new ConditionAnnotation(false).annotate((IElement)assignmentStatement);
                new ConditionAnnotation(true).annotate((IElement)boogieIcfgLocation);
            }
            CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assignmentStatement, new BoogieASTNode[]{whileStatement});
            CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)boogieIcfgLocation, new BoogieASTNode[]{whileStatement});
            ModelUtils.copyAnnotations((IElement)whileStatement, (IElement)assignmentStatement);
            ModelUtils.copyAnnotations((IElement)whileStatement, (IElement)boogieIcfgLocation);
            n = this.buildCodeBlock(whileStatement.getBody(), (IIcfgElement)boogieIcfgLocation3, false);
            if (n instanceof BoogieIcfgLocation && CfgBuilder.isPlainAssumeTrueStatement((Statement)assignmentStatement) && n != boogieIcfgLocation3) {
                this.buildBranchingWithoutTrueCond((IIcfgElement)n, (AssumeStatement)boogieIcfgLocation, (IIcfgElement)object, boogieIcfgLocation2);
            } else {
                this.buildBranching((AssumeStatement)assignmentStatement, (IIcfgElement)n, (AssumeStatement)boogieIcfgLocation, (IIcfgElement)object, boogieIcfgLocation2);
            }
            if (bl) {
                loopInvariantSpecification = this.mWhileExits.pop();
                assert (loopInvariantSpecification == object);
            }
            CfgBuilder.this.mConditionalStarts.pop();
            return boogieIcfgLocation3;
        }

        private IIcfgElement buildAssuAssiHavoc(IIcfgElement iIcfgElement, Statement statement) {
            StatementSequence statementSequence = this.prependStatement(statement, iIcfgElement);
            if (CfgBuilder.this.mCodeBlockSize == IcfgPreferenceInitializer.CodeBlockSize.SingleStatement) {
                return this.endStatementSequence(statementSequence);
            }
            return statementSequence;
        }

        private StatementSequence prependStatement(Statement statement, IIcfgElement iIcfgElement) {
            assert (statement instanceof AssumeStatement || statement instanceof AssignmentStatement || statement instanceof HavocStatement);
            switch (CfgBuilder.this.mCodeBlockSize) {
                case OneNontrivialStatement: {
                    if (iIcfgElement instanceof StatementSequence && !StatementSequence.isAssumeTrueStatement((Statement)statement) && !((StatementSequence)iIcfgElement).isTrivial()) {
                        iIcfgElement = this.endStatementSequence((StatementSequence)iIcfgElement);
                    }
                }
                case SequenceOfStatements: 
                case LoopFreeBlock: {
                    if (iIcfgElement instanceof StatementSequence) {
                        this.addStatementToStatementSequence(statement, (StatementSequence)iIcfgElement);
                        return (StatementSequence)iIcfgElement;
                    }
                    return this.startNewStatementSequenceAndAddStatement((BoogieIcfgLocation)iIcfgElement, statement);
                }
                case SingleStatement: {
                    if (iIcfgElement instanceof StatementSequence) {
                        if (((StatementSequence)iIcfgElement).getStatements().isEmpty()) {
                            this.addStatementToStatementSequence(statement, (StatementSequence)iIcfgElement);
                            return (StatementSequence)iIcfgElement;
                        }
                        iIcfgElement = this.endStatementSequence((StatementSequence)iIcfgElement);
                    }
                    return this.startNewStatementSequenceAndAddStatement((BoogieIcfgLocation)iIcfgElement, statement);
                }
            }
            throw new AssertionError((Object)("Unknown value: " + String.valueOf((Object)CfgBuilder.this.mCodeBlockSize)));
        }

        private BoogieIcfgLocation buildAssert(IIcfgElement iIcfgElement, AssertStatement assertStatement) {
            return this.buildBranchingToNewErrorLocation(iIcfgElement, assertStatement.getFormula(), (BoogieASTNode)assertStatement);
        }

        private BoogieIcfgLocation buildBranchingToNewErrorLocation(IIcfgElement iIcfgElement, Expression expression, BoogieASTNode boogieASTNode) {
            BoogieIcfgLocation boogieIcfgLocation = CfgBuilder.this.addErrorNode(this.mCurrentProcedureName, boogieASTNode, this.mProcLocNodes);
            this.mProcLocNodes.put(boogieIcfgLocation.getDebugIdentifier(), boogieIcfgLocation);
            AssumeStatement assumeStatement = CfgBuilder.this.mAddAssumeForEachAssert ? new AssumeStatement(boogieASTNode.getLocation(), expression) : new AssumeStatement(boogieASTNode.getLocation(), (Expression)ExpressionFactory.createBooleanLiteral((ILocation)boogieASTNode.getLocation(), (boolean)true));
            new ConditionAnnotation(false).annotate((IElement)assumeStatement);
            AssumeStatement assumeStatement2 = new AssumeStatement(boogieASTNode.getLocation(), CfgBuilder.getNegation(expression));
            new ConditionAnnotation(true).annotate((IElement)assumeStatement2);
            CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{boogieASTNode});
            CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement2, new BoogieASTNode[]{boogieASTNode});
            BoogieIcfgLocation boogieIcfgLocation2 = this.buildNewIcfgLocation(boogieASTNode);
            ModelUtils.copyAnnotations((IElement)boogieASTNode, (IElement)assumeStatement);
            ModelUtils.copyAnnotations((IElement)boogieASTNode, (IElement)assumeStatement2);
            this.buildBranching(assumeStatement2, (IIcfgElement)boogieIcfgLocation, assumeStatement, iIcfgElement, boogieIcfgLocation2);
            return boogieIcfgLocation2;
        }

        private BoogieIcfgLocation buildNewIcfgLocation(BoogieASTNode boogieASTNode) {
            BoogieIcfgLocation boogieIcfgLocation = new BoogieIcfgLocation(this.constructLocDebugIdentifier(boogieASTNode), this.mCurrentProcedureName, false, boogieASTNode);
            this.mProcLocNodes.put(boogieIcfgLocation.getDebugIdentifier(), boogieIcfgLocation);
            return boogieIcfgLocation;
        }

        private void buildBranching(AssumeStatement assumeStatement, IIcfgElement iIcfgElement, AssumeStatement assumeStatement2, IIcfgElement iIcfgElement2, BoogieIcfgLocation boogieIcfgLocation) {
            StatementSequence statementSequence = this.prependStatement((Statement)assumeStatement, iIcfgElement);
            this.endStatementSequence(statementSequence, boogieIcfgLocation);
            StatementSequence statementSequence2 = this.prependStatement((Statement)assumeStatement2, iIcfgElement2);
            this.endStatementSequence(statementSequence2, boogieIcfgLocation);
        }

        private void buildBranchingWithoutTrueCond(IIcfgElement iIcfgElement, AssumeStatement assumeStatement, IIcfgElement iIcfgElement2, BoogieIcfgLocation boogieIcfgLocation) {
            this.mergeLocNodes((BoogieIcfgLocation)iIcfgElement, boogieIcfgLocation, true);
            StatementSequence statementSequence = this.prependStatement((Statement)assumeStatement, iIcfgElement2);
            this.endStatementSequence(statementSequence, boogieIcfgLocation);
        }

        private BoogieIcfgLocation buildReturn(BoogieIcfgLocation boogieIcfgLocation, ReturnStatement returnStatement) {
            return (BoogieIcfgLocation)CfgBuilder.this.mIcfg.mFinalNode.get(this.mCurrentProcedureName);
        }

        private BoogieIcfgLocation buildBreak(BoogieIcfgLocation boogieIcfgLocation, BreakStatement breakStatement) {
            ModelUtils.copyAnnotationsExcept((IElement)breakStatement, (IElement)((IElement)this.mWhileExits.peek()), (Class[])new Class[]{ILocation.class});
            new LoopExitAnnotation(LoopExitAnnotation.LoopExitType.BREAK).annotate((IElement)this.mWhileExits.peek());
            return this.mWhileExits.peek();
        }

        private BoogieIcfgLocation buildLabel(IIcfgElement iIcfgElement, Label label) {
            BoogieIcfgLocation boogieIcfgLocation;
            BoogieIcfgLocation boogieIcfgLocation2 = this.getLocNodeForLabel((DebugIdentifier)new StringDebugIdentifier(label.getName()), (Statement)label);
            if (iIcfgElement instanceof BoogieIcfgLocation) {
                this.mergeLocNodes(boogieIcfgLocation2, (BoogieIcfgLocation)iIcfgElement, true);
                boogieIcfgLocation = (BoogieIcfgLocation)iIcfgElement;
            } else {
                this.endStatementSequence((StatementSequence)iIcfgElement, boogieIcfgLocation2);
                boogieIcfgLocation = boogieIcfgLocation2;
            }
            if (!this.isAuxiliaryLabel(label)) {
                CfgBuilder.this.mIcfg.getLocationsOfInterest().add(boogieIcfgLocation);
            }
            return boogieIcfgLocation;
        }

        private boolean isAuxiliaryLabel(Label label) {
            if (label.getAttributes() == null) {
                return false;
            }
            NamedAttribute[] namedAttributeArray = label.getAttributes();
            int n = namedAttributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                NamedAttribute namedAttribute = namedAttributeArray[n2];
                if (namedAttribute.getName().equals("auxiliary_label")) {
                    if (namedAttribute.getValues().length != 0) {
                        throw new AssertionError((Object)"Attribut must not have values");
                    }
                    return true;
                }
                ++n2;
            }
            return false;
        }

        private BoogieIcfgLocation buildGoto(BoogieIcfgLocation boogieIcfgLocation, GotoStatement gotoStatement) {
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation(this.constructLocDebugIdentifier((BoogieASTNode)gotoStatement), this.mCurrentProcedureName, false, (BoogieASTNode)gotoStatement);
            this.mProcLocNodes.put(boogieIcfgLocation2.getDebugIdentifier(), boogieIcfgLocation2);
            String[] stringArray = gotoStatement.getLabels();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                GotoEdge gotoEdge = CfgBuilder.this.mCbf.constructGotoEdge(boogieIcfgLocation2, this.getLocNodeForLabel((DebugIdentifier)new StringDebugIdentifier(string), (Statement)this.mLabelString2Statement.get(string)));
                ModelUtils.copyAnnotations((IElement)gotoStatement, (IElement)gotoEdge);
                this.mGotoEdges.add(gotoEdge);
                this.mEdges.add((CodeBlock)gotoEdge);
                ++n2;
            }
            return boogieIcfgLocation2;
        }

        private BoogieIcfgLocation buildFork(BoogieIcfgLocation boogieIcfgLocation, ForkStatement forkStatement) {
            ForkThreadCurrent forkThreadCurrent;
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation(this.constructLocDebugIdentifier((BoogieASTNode)forkStatement), this.mCurrentProcedureName, false, (BoogieASTNode)forkStatement);
            this.mProcLocNodes.put(boogieIcfgLocation2.getDebugIdentifier(), boogieIcfgLocation2);
            if (CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(forkStatement.getProcedureName())) {
                forkThreadCurrent = CfgBuilder.this.mCbf.constructForkCurrentThread(boogieIcfgLocation2, boogieIcfgLocation, forkStatement, true);
                ModelUtils.copyAnnotations((IElement)forkStatement, (IElement)forkThreadCurrent);
                CfgBuilder.this.mForks.put((IIcfgForkTransitionThreadCurrent<IcfgLocation>)forkThreadCurrent, null);
            } else {
                forkThreadCurrent = CfgBuilder.this.mCbf.constructForkCurrentThread(boogieIcfgLocation2, boogieIcfgLocation, forkStatement, false);
                ModelUtils.copyAnnotations((IElement)forkStatement, (IElement)forkThreadCurrent);
            }
            this.mEdges.add((CodeBlock)forkThreadCurrent);
            return boogieIcfgLocation2;
        }

        private BoogieIcfgLocation buildJoin(BoogieIcfgLocation boogieIcfgLocation, JoinStatement joinStatement) {
            BoogieIcfgLocation boogieIcfgLocation2 = new BoogieIcfgLocation(this.constructLocDebugIdentifier((BoogieASTNode)joinStatement), this.mCurrentProcedureName, false, (BoogieASTNode)joinStatement);
            this.mProcLocNodes.put(boogieIcfgLocation2.getDebugIdentifier(), boogieIcfgLocation2);
            JoinThreadCurrent joinThreadCurrent = CfgBuilder.this.mCbf.constructJoinCurrentThread(boogieIcfgLocation2, boogieIcfgLocation, joinStatement);
            ModelUtils.copyAnnotations((IElement)joinStatement, (IElement)joinThreadCurrent);
            CfgBuilder.this.mJoins.add((IIcfgJoinTransitionThreadCurrent<IcfgLocation>)joinThreadCurrent);
            this.mEdges.add((CodeBlock)joinThreadCurrent);
            return boogieIcfgLocation2;
        }

        private IIcfgElement beginAtomicBlockFromBottom(BoogieIcfgLocation boogieIcfgLocation, Statement statement) {
            StatementSequence statementSequence = this.startNewStatementSequence(boogieIcfgLocation);
            AtomicBlockInfo.addEndAnnotation((IIcfgTransition)statementSequence);
            return this.endStatementSequence(statementSequence, statement);
        }

        private BoogieIcfgLocation endAtomicBlockAtTop(IIcfgElement iIcfgElement, Statement statement) {
            assert (iIcfgElement instanceof BoogieIcfgLocation || iIcfgElement instanceof StatementSequence);
            StatementSequence statementSequence = !(iIcfgElement instanceof StatementSequence) ? this.startNewStatementSequence((BoogieIcfgLocation)iIcfgElement) : (StatementSequence)iIcfgElement;
            if (AtomicBlockInfo.isEndOfAtomicBlock((IIcfgTransition)statementSequence)) {
                AtomicBlockInfo.removeAnnotation((IIcfgTransition)statementSequence);
                AtomicBlockInfo.addCompleteAnnotation((IIcfgTransition)statementSequence);
            } else {
                AtomicBlockInfo.addBeginAnnotation((IIcfgTransition)statementSequence);
            }
            return this.endStatementSequence(statementSequence, statement);
        }

        private BoogieIcfgLocation buildAtomic(BoogieIcfgLocation boogieIcfgLocation, AtomicStatement atomicStatement) {
            IIcfgElement iIcfgElement = this.beginAtomicBlockFromBottom(boogieIcfgLocation, (Statement)atomicStatement);
            iIcfgElement = this.buildCodeBlock(atomicStatement.getBody(), iIcfgElement, false);
            return this.endAtomicBlockAtTop(iIcfgElement, (Statement)atomicStatement);
        }

        private IIcfgElement buildCall(IIcfgElement iIcfgElement, CallStatement callStatement) {
            Summary summary;
            BoogieIcfgLocation boogieIcfgLocation;
            boolean bl;
            String string = callStatement.getMethodName();
            if ("__VERIFIER_atomic_begin".equals(string)) {
                return this.endAtomicBlockAtTop(iIcfgElement, (Statement)callStatement);
            }
            if ("__VERIFIER_atomic_end".equals(string)) {
                BoogieIcfgLocation boogieIcfgLocation2;
                if (iIcfgElement instanceof StatementSequence) {
                    boogieIcfgLocation2 = this.endStatementSequence((StatementSequence)iIcfgElement);
                } else if (iIcfgElement instanceof BoogieIcfgLocation) {
                    boogieIcfgLocation2 = (BoogieIcfgLocation)iIcfgElement;
                } else {
                    throw new AssertionError((Object)"Expected StatementSequence or BoogieIcfgLocation");
                }
                return this.beginAtomicBlockFromBottom(boogieIcfgLocation2, (Statement)callStatement);
            }
            List list = (List)CfgBuilder.this.mBoogieDeclarations.getRequiresNonFree().get(string);
            boolean bl2 = CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(string);
            boolean bl3 = bl = list == null || list.isEmpty();
            if ((CfgBuilder.this.mCodeBlockSize == IcfgPreferenceInitializer.CodeBlockSize.SequenceOfStatements || CfgBuilder.this.mCodeBlockSize == IcfgPreferenceInitializer.CodeBlockSize.LoopFreeBlock) && !bl2 && bl) {
                if (iIcfgElement instanceof BoogieIcfgLocation) {
                    return this.startNewStatementSequenceAndAddStatement((BoogieIcfgLocation)iIcfgElement, (Statement)callStatement);
                }
                if (iIcfgElement instanceof StatementSequence) {
                    return this.addStatementToStatementSequence((Statement)callStatement, (StatementSequence)iIcfgElement);
                }
                throw new AssertionError((Object)"mCurrent must be CodeBlock or BoogieIcfgLocation");
            }
            if (iIcfgElement instanceof StatementSequence) {
                boogieIcfgLocation = this.endStatementSequence((StatementSequence)iIcfgElement, (Statement)callStatement);
            } else if (iIcfgElement instanceof BoogieIcfgLocation) {
                boogieIcfgLocation = (BoogieIcfgLocation)iIcfgElement;
            } else {
                throw new AssertionError();
            }
            BoogieIcfgLocation boogieIcfgLocation3 = new BoogieIcfgLocation(this.constructLocDebugIdentifier((BoogieASTNode)callStatement), this.mCurrentProcedureName, false, (BoogieASTNode)callStatement);
            this.mProcLocNodes.put(boogieIcfgLocation3.getDebugIdentifier(), boogieIcfgLocation3);
            ModelUtils.mergeAnnotations((IElement)callStatement, (IElement[])new IElement[]{boogieIcfgLocation3});
            if (CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(callStatement.getMethodName())) {
                summary = CfgBuilder.this.mCbf.constructSummary(boogieIcfgLocation3, boogieIcfgLocation, callStatement, true);
                ModelUtils.copyAnnotations((IElement)callStatement, (IElement)summary);
                CfgBuilder.this.mImplementationSummarys.add(summary);
            } else {
                summary = CfgBuilder.this.mCbf.constructSummary(boogieIcfgLocation3, boogieIcfgLocation, callStatement, false);
                ModelUtils.copyAnnotations((IElement)callStatement, (IElement)summary);
            }
            this.mEdges.add((CodeBlock)summary);
            if (list != null && !list.isEmpty()) {
                for (RequiresSpecification requiresSpecification : list) {
                    AssumeStatement assumeStatement;
                    Procedure procedure = CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(string) ? (Procedure)CfgBuilder.this.mBoogieDeclarations.getProcImplementation().get(string) : (Procedure)CfgBuilder.this.mBoogieDeclarations.getProcSpecification().get(string);
                    Expression expression = CfgBuilder.getNegation(new WeakestPrecondition(requiresSpecification.getFormula(), callStatement, procedure).getResult());
                    AssumeStatement assumeStatement2 = assumeStatement = new AssumeStatement(callStatement.getLocation(), expression);
                    ModelUtils.copyAnnotations((IElement)callStatement, (IElement)assumeStatement2);
                    CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{callStatement, requiresSpecification});
                    BoogieIcfgLocation boogieIcfgLocation4 = CfgBuilder.this.addErrorNode(this.mCurrentProcedureName, (BoogieASTNode)requiresSpecification, this.mProcLocNodes);
                    StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence(boogieIcfgLocation3, boogieIcfgLocation4, (Statement)assumeStatement);
                    ModelUtils.copyAnnotations((IElement)requiresSpecification, (IElement)statementSequence);
                    ModelUtils.copyAnnotations((IElement)requiresSpecification, (IElement)boogieIcfgLocation4);
                    this.mEdges.add((CodeBlock)statementSequence);
                }
            }
            return boogieIcfgLocation3;
        }

        private BoogieIcfgLocation endStatementSequence(StatementSequence statementSequence, BoogieIcfgLocation boogieIcfgLocation) {
            statementSequence.connectSource((IcfgLocation)boogieIcfgLocation);
            return boogieIcfgLocation;
        }

        private BoogieIcfgLocation endStatementSequence(StatementSequence statementSequence, Statement statement) {
            DebugIdentifier debugIdentifier = this.constructLocDebugIdentifier((BoogieASTNode)statement);
            BoogieIcfgLocation boogieIcfgLocation = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)statement);
            this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation);
            return this.endStatementSequence(statementSequence, boogieIcfgLocation);
        }

        private BoogieIcfgLocation endStatementSequence(StatementSequence statementSequence) {
            return this.endStatementSequence(statementSequence, (Statement)statementSequence.getStatements().get(0));
        }

        private StatementSequence startNewStatementSequenceAndAddStatement(BoogieIcfgLocation boogieIcfgLocation, Statement statement) {
            assert (this.isIntraproceduralBranchFreeStatement(statement)) : "cannot add statement to code block " + String.valueOf(statement);
            StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence(null, boogieIcfgLocation, statement);
            ModelUtils.copyAnnotations((IElement)statement, (IElement)statementSequence);
            this.mEdges.add((CodeBlock)statementSequence);
            return statementSequence;
        }

        private StatementSequence startNewStatementSequence(BoogieIcfgLocation boogieIcfgLocation) {
            StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence(null, boogieIcfgLocation, List.of());
            this.mEdges.add((CodeBlock)statementSequence);
            return statementSequence;
        }

        private StatementSequence addStatementToStatementSequence(Statement statement, StatementSequence statementSequence) {
            assert (this.isIntraproceduralBranchFreeStatement(statement)) : "cannot add statement to code block " + String.valueOf(statement);
            statementSequence.addStatement(statement, 0);
            ModelUtils.copyAnnotations((IElement)statement, (IElement)statementSequence);
            return statementSequence;
        }

        private void removeUnreachableProgramPoints(Set<BoogieIcfgLocation> set, Map<DebugIdentifier, BoogieIcfgLocation> map, BoogieIcfgLocation boogieIcfgLocation) {
            Iterator<Map.Entry<DebugIdentifier, BoogieIcfgLocation>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<DebugIdentifier, BoogieIcfgLocation> entry = iterator.next();
                if (set.contains(entry.getValue()) || boogieIcfgLocation == entry.getValue()) continue;
                iterator.remove();
                ArrayList arrayList = new ArrayList(entry.getValue().getOutgoingEdges());
                for (IcfgEdge icfgEdge : arrayList) {
                    icfgEdge.disconnectSource();
                    icfgEdge.disconnectTarget();
                    CfgBuilder.this.mLogger.info((Object)("dead code at ProgramPoint " + String.valueOf(entry.getValue()) + ": " + String.valueOf(icfgEdge)));
                    CfgBuilder.this.mImplementationSummarys.remove(icfgEdge);
                }
            }
        }

        private Set<BoogieIcfgLocation> computeReachableLocations(BoogieIcfgLocation boogieIcfgLocation) {
            HashSet<BoogieIcfgLocation> hashSet = new HashSet<BoogieIcfgLocation>();
            ArrayDeque<BoogieIcfgLocation> arrayDeque = new ArrayDeque<BoogieIcfgLocation>();
            arrayDeque.add(boogieIcfgLocation);
            hashSet.add(boogieIcfgLocation);
            while (!arrayDeque.isEmpty()) {
                BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)arrayDeque.removeFirst();
                for (IcfgLocation icfgLocation : boogieIcfgLocation2.getOutgoingNodes()) {
                    if (hashSet.contains(icfgLocation)) continue;
                    hashSet.add((BoogieIcfgLocation)icfgLocation);
                    arrayDeque.add((BoogieIcfgLocation)icfgLocation);
                }
            }
            return hashSet;
        }

        private List<EnsuresSpecification> getDummyEnsuresSpecifications(ILocation iLocation) {
            BooleanLiteral booleanLiteral = ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)true);
            EnsuresSpecification ensuresSpecification = new EnsuresSpecification(iLocation, false, (Expression)booleanLiteral);
            ArrayList<EnsuresSpecification> arrayList = new ArrayList<EnsuresSpecification>(1);
            arrayList.add(ensuresSpecification);
            return arrayList;
        }

        private List<RequiresSpecification> getDummyRequiresSpecifications() {
            BooleanLiteral booleanLiteral = new BooleanLiteral(null, (IBoogieType)BoogieType.TYPE_BOOL, true);
            RequiresSpecification requiresSpecification = new RequiresSpecification(null, false, (Expression)booleanLiteral);
            ArrayList<RequiresSpecification> arrayList = new ArrayList<RequiresSpecification>(1);
            arrayList.add(requiresSpecification);
            return arrayList;
        }

        private boolean removeAuxiliaryGoto(GotoEdge gotoEdge, boolean bl) {
            BoogieIcfgLocation boogieIcfgLocation = (BoogieIcfgLocation)gotoEdge.getSource();
            BoogieIcfgLocation boogieIcfgLocation2 = (BoogieIcfgLocation)gotoEdge.getTarget();
            assert (!boogieIcfgLocation2.isErrorLocation());
            for (IcfgEdge icfgEdge : boogieIcfgLocation2.getOutgoingEdges()) {
                if (!(icfgEdge instanceof Call)) continue;
                CfgBuilder.this.mLogger.warn((Object)("Will not remove gotoEdge" + String.valueOf(gotoEdge) + "since this would involve adding/removing calland return edges and bring my naive goto replacing algorithm into terrible trouble"));
                return false;
            }
            CfgBuilder.this.mLogger.debug((Object)("Removed GotoEdge from" + String.valueOf(boogieIcfgLocation) + " to " + String.valueOf(boogieIcfgLocation2)));
            if (boogieIcfgLocation == boogieIcfgLocation2) {
                IcfgEdge icfgEdge;
                boogieIcfgLocation.removeOutgoing((IModifiableMultigraphEdge)gotoEdge);
                gotoEdge.setSource(null);
                gotoEdge.setTarget(null);
                boogieIcfgLocation2.removeIncoming((IModifiableMultigraphEdge)gotoEdge);
                icfgEdge = boogieIcfgLocation.getBoogieASTNode().getLocation();
                StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence(boogieIcfgLocation, boogieIcfgLocation2, (Statement)new AssumeStatement((ILocation)icfgEdge, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)icfgEdge, (boolean)true)));
                statementSequence.setTransitionFormula(TransFormulaBuilder.getTrivialTransFormula((ManagedScript)CfgBuilder.this.mBoogie2Smt.getManagedScript()));
                CfgBuilder.this.mLogger.debug((Object)"GotoEdge was selfloop");
                return true;
            }
            assert (!boogieIcfgLocation2.getIncomingEdges().isEmpty()) : "there should be at least the goto that might be removed";
            assert (!boogieIcfgLocation.getOutgoingEdges().isEmpty()) : "there should be at least the goto that might be removed";
            if (boogieIcfgLocation2.getIncomingEdges().size() == 1 || boogieIcfgLocation.getOutgoingEdges().size() == 1) {
                boogieIcfgLocation.removeOutgoing((IModifiableMultigraphEdge)gotoEdge);
                gotoEdge.setSource(null);
                gotoEdge.setTarget(null);
                boogieIcfgLocation2.removeIncoming((IModifiableMultigraphEdge)gotoEdge);
                for (IcfgEdge icfgEdge : boogieIcfgLocation2.getOutgoingEdges()) {
                    ModelUtils.copyAnnotations((IElement)gotoEdge, (IElement)icfgEdge, LoopEntryAnnotation.class);
                    ModelUtils.copyAnnotations((IElement)gotoEdge, (IElement)icfgEdge, LoopExitAnnotation.class);
                }
                boolean bl2 = this.isLoopLocationOrLoi(boogieIcfgLocation2);
                if (bl2) {
                    boolean bl3 = this.isLoopLocationOrLoi(boogieIcfgLocation);
                    this.mergeLocNodes(boogieIcfgLocation, boogieIcfgLocation2, false);
                    CfgBuilder.this.mLogger.debug((Object)(String.valueOf(boogieIcfgLocation) + " gets absorbed by " + String.valueOf(boogieIcfgLocation2)));
                } else {
                    this.mergeLocNodes(boogieIcfgLocation2, boogieIcfgLocation, true);
                    CfgBuilder.this.mLogger.debug((Object)(String.valueOf(boogieIcfgLocation2) + " gets absorbed by " + String.valueOf(boogieIcfgLocation)));
                }
                return true;
            }
            if (bl) {
                boogieIcfgLocation.removeOutgoing((IModifiableMultigraphEdge)gotoEdge);
                gotoEdge.setSource(null);
                gotoEdge.setTarget(null);
                boogieIcfgLocation2.removeIncoming((IModifiableMultigraphEdge)gotoEdge);
                CfgBuilder.this.mLogger.debug((Object)(String.valueOf(boogieIcfgLocation2) + " has " + boogieIcfgLocation2.getIncomingEdges().size() + " predecessors, namely " + String.valueOf(boogieIcfgLocation2.getIncomingNodes())));
                CfgBuilder.this.mLogger.debug((Object)(String.valueOf(boogieIcfgLocation) + " has " + boogieIcfgLocation.getIncomingEdges().size() + " successors, namely " + String.valueOf(boogieIcfgLocation.getOutgoingNodes())));
                CfgBuilder.this.mLogger.debug((Object)("Adding for every successor transition of " + String.valueOf(boogieIcfgLocation2) + " a copy of that transition as successor of " + String.valueOf(boogieIcfgLocation)));
                for (IcfgEdge icfgEdge : boogieIcfgLocation2.getOutgoingEdges()) {
                    BoogieIcfgLocation boogieIcfgLocation3 = (BoogieIcfgLocation)icfgEdge.getTarget();
                    CodeBlock codeBlock = CfgBuilder.this.mCbf.copyCodeBlock((CodeBlock)icfgEdge, boogieIcfgLocation, boogieIcfgLocation3);
                    ModelUtils.copyAnnotations((IElement)gotoEdge, (IElement)codeBlock, LoopEntryAnnotation.class);
                    ModelUtils.copyAnnotations((IElement)gotoEdge, (IElement)codeBlock, LoopExitAnnotation.class);
                    if (codeBlock instanceof GotoEdge) {
                        this.mGotoEdges.add((GotoEdge)codeBlock);
                        continue;
                    }
                    this.mEdges.add(codeBlock);
                }
                return true;
            }
            return false;
        }

        private boolean isLoopLocationOrLoi(BoogieIcfgLocation boogieIcfgLocation) {
            return CfgBuilder.this.mIcfg.getLoopLocations().contains(boogieIcfgLocation) || CfgBuilder.this.mIcfg.getLocationsOfInterest().contains(boogieIcfgLocation);
        }

        private void assertAndAssumeEnsures() {
            AssumeStatement assumeStatement;
            EnsuresSpecification ensuresSpecification2;
            Procedure procedure;
            List<EnsuresSpecification> list = (List<EnsuresSpecification>)CfgBuilder.this.mBoogieDeclarations.getEnsures().get(this.mCurrentProcedureName);
            if (list == null || list.isEmpty()) {
                procedure = (Procedure)CfgBuilder.this.mBoogieDeclarations.getProcSpecification().get(this.mCurrentProcedureName);
                list = this.getDummyEnsuresSpecifications(procedure.getLocation());
            }
            procedure = (BoogieIcfgLocation)CfgBuilder.this.mIcfg.getProcedureExitNodes().get(this.mCurrentProcedureName);
            this.mLastLabelName = procedure.getDebugIdentifier();
            this.mProcLocNodes.put(this.mLastLabelName, (BoogieIcfgLocation)procedure);
            this.mCurrent = procedure;
            for (EnsuresSpecification ensuresSpecification2 : list) {
                assumeStatement = new AssumeStatement(ensuresSpecification2.getLocation(), ensuresSpecification2.getFormula());
                ModelUtils.copyAnnotations((IElement)ensuresSpecification2, (IElement)assumeStatement);
                CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{ensuresSpecification2});
                this.mCurrent = this.buildAssuAssiHavoc((IIcfgElement)this.mCurrent, (Statement)assumeStatement);
            }
            ensuresSpecification2 = (BoogieIcfgLocation)CfgBuilder.this.mIcfg.mFinalNode.get(this.mCurrentProcedureName);
            this.mLastLabelName = ensuresSpecification2.getDebugIdentifier();
            this.mProcLocNodes.put(this.mLastLabelName, (BoogieIcfgLocation)ensuresSpecification2);
            if (this.mCurrent instanceof BoogieIcfgLocation) {
                this.mergeLocNodes((BoogieIcfgLocation)this.mCurrent, (BoogieIcfgLocation)ensuresSpecification2, false);
            } else {
                ((CodeBlock)this.mCurrent).connectSource((IcfgLocation)ensuresSpecification2);
            }
            List list2 = (List)CfgBuilder.this.mBoogieDeclarations.getEnsuresNonFree().get(this.mCurrentProcedureName);
            if (list2 != null && !list2.isEmpty()) {
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    AssumeStatement assumeStatement2;
                    assumeStatement = (EnsuresSpecification)iterator.next();
                    Expression expression = assumeStatement.getFormula();
                    AssumeStatement assumeStatement3 = assumeStatement2 = new AssumeStatement(assumeStatement.getLocation(), CfgBuilder.getNegation(expression));
                    ModelUtils.copyAnnotations((IElement)assumeStatement, (IElement)assumeStatement3);
                    CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement2, new BoogieASTNode[]{assumeStatement});
                    BoogieIcfgLocation boogieIcfgLocation = CfgBuilder.this.addErrorNode(this.mCurrentProcedureName, (BoogieASTNode)assumeStatement, this.mProcLocNodes);
                    StatementSequence statementSequence = CfgBuilder.this.mCbf.constructStatementSequence((BoogieIcfgLocation)ensuresSpecification2, boogieIcfgLocation, (Statement)assumeStatement2);
                    ModelUtils.copyAnnotations((IElement)assumeStatement, (IElement)statementSequence);
                    ModelUtils.copyAnnotations((IElement)assumeStatement, (IElement)boogieIcfgLocation);
                    this.mEdges.add((CodeBlock)statementSequence);
                }
            }
        }

        private BoogieIcfgLocation assumeRequires(BoogieIcfgLocation boogieIcfgLocation, boolean bl) {
            List<RequiresSpecification> list = (List<RequiresSpecification>)CfgBuilder.this.mBoogieDeclarations.getRequires().get(this.mCurrentProcedureName);
            if ((list == null || list.isEmpty()) && bl) {
                list = this.getDummyRequiresSpecifications();
            }
            BoogieIcfgLocation boogieIcfgLocation2 = boogieIcfgLocation;
            if (list != null && !list.isEmpty()) {
                int n = list.size() - 1;
                while (n >= 0) {
                    RequiresSpecification requiresSpecification = list.get(n);
                    AssumeStatement assumeStatement = new AssumeStatement(requiresSpecification.getLocation(), requiresSpecification.getFormula());
                    ModelUtils.copyAnnotations((IElement)requiresSpecification, (IElement)assumeStatement);
                    CfgBuilder.this.mIcfgBacktranslator.putAux((Statement)assumeStatement, new BoogieASTNode[]{requiresSpecification});
                    boogieIcfgLocation2 = this.buildAssuAssiHavoc((IIcfgElement)boogieIcfgLocation2, (Statement)assumeStatement);
                    --n;
                }
            }
            if (boogieIcfgLocation2 instanceof StatementSequence) {
                return this.endStatementSequence((StatementSequence)boogieIcfgLocation2);
            }
            return boogieIcfgLocation2;
        }

        private DebugIdentifier constructLocDebugIdentifier(BoogieASTNode boogieASTNode) {
            ILocation iLocation = boogieASTNode.getLocation();
            int n = iLocation.getStartLine();
            Integer n2 = this.mNameCache.get(n);
            n2 = n2 == null ? Integer.valueOf(0) : Integer.valueOf(n2 + 1);
            this.mNameCache.put(n, n2);
            if (boogieASTNode instanceof WhileStatement) {
                return new LoopEntryDebugIdentifier(n, n2.intValue());
            }
            return new OrdinaryDebugIdentifier(n, n2.intValue());
        }

        private BoogieIcfgLocation getLocNodeForLabel(DebugIdentifier debugIdentifier, Statement statement) {
            ILocation iLocation = statement.getLocation();
            BoogieIcfgLocation boogieIcfgLocation = this.mLabel2LocNodes.get(debugIdentifier);
            if (boogieIcfgLocation != null) {
                if (CfgBuilder.this.mLogger.isDebugEnabled()) {
                    CfgBuilder.this.mLogger.debug((Object)("LocNode for " + String.valueOf(debugIdentifier) + " already constructed, namely: " + String.valueOf(boogieIcfgLocation)));
                }
                if (statement instanceof Label && boogieIcfgLocation.getDebugIdentifier() == debugIdentifier) {
                    iLocation.annotate((IElement)boogieIcfgLocation);
                }
                ModelUtils.copyAnnotations((IElement)statement, (IElement)boogieIcfgLocation);
                return boogieIcfgLocation;
            }
            boogieIcfgLocation = new BoogieIcfgLocation(debugIdentifier, this.mCurrentProcedureName, false, (BoogieASTNode)statement);
            this.mLabel2LocNodes.put(debugIdentifier, boogieIcfgLocation);
            this.mProcLocNodes.put(debugIdentifier, boogieIcfgLocation);
            if (CfgBuilder.this.mLogger.isDebugEnabled()) {
                CfgBuilder.this.mLogger.debug((Object)("LocNode for " + String.valueOf(debugIdentifier) + " has not existed yet. Constructed it"));
            }
            return boogieIcfgLocation;
        }

        private boolean isIntraproceduralBranchFreeStatement(Statement statement) {
            if (statement instanceof AssumeStatement) {
                return true;
            }
            if (statement instanceof AssignmentStatement) {
                return true;
            }
            if (statement instanceof HavocStatement) {
                return true;
            }
            if (!(statement instanceof CallStatement)) {
                return false;
            }
            CallStatement callStatement = (CallStatement)statement;
            if (CfgBuilder.this.mBoogieDeclarations.getProcImplementation().containsKey(callStatement.getMethodName())) {
                return false;
            }
            return CfgBuilder.this.mBoogieDeclarations.getRequiresNonFree().get(callStatement.getMethodName()) == null || ((List)CfgBuilder.this.mBoogieDeclarations.getRequiresNonFree().get(callStatement.getMethodName())).isEmpty();
        }

        private void mergeLocNodes(BoogieIcfgLocation boogieIcfgLocation, BoogieIcfgLocation boogieIcfgLocation2, boolean bl) {
            assert (!boogieIcfgLocation.isErrorLocation());
            if (boogieIcfgLocation == boogieIcfgLocation2) {
                return;
            }
            for (IcfgEdge icfgEdge : boogieIcfgLocation.getIncomingEdges()) {
                icfgEdge.setTarget((IModifiableExplicitEdgesMultigraph)boogieIcfgLocation2);
                boogieIcfgLocation2.addIncoming((IModifiableMultigraphEdge)icfgEdge);
            }
            boogieIcfgLocation.clearIncoming();
            for (IcfgEdge icfgEdge : boogieIcfgLocation.getOutgoingEdges()) {
                icfgEdge.setSource((IModifiableExplicitEdgesMultigraph)boogieIcfgLocation2);
                boogieIcfgLocation2.addOutgoing((IModifiableMultigraphEdge)icfgEdge);
            }
            boogieIcfgLocation.clearOutgoing();
            this.mProcLocNodes.remove(boogieIcfgLocation.getDebugIdentifier());
            if (this.mLabel2LocNodes.containsKey(boogieIcfgLocation.getDebugIdentifier())) {
                this.mLabel2LocNodes.put(boogieIcfgLocation.getDebugIdentifier(), boogieIcfgLocation2);
            }
            assert (boogieIcfgLocation != CfgBuilder.this.mIcfg.getProcedureExitNodes().get(this.mCurrentProcedureName));
            if (boogieIcfgLocation == CfgBuilder.this.mIcfg.getProcedureEntryNodes().get(this.mCurrentProcedureName)) {
                CfgBuilder.this.mIcfg.getProcedureEntryNodes().put(this.mCurrentProcedureName, boogieIcfgLocation2);
            }
            if (CfgBuilder.this.mIcfg.getLoopLocations().remove(boogieIcfgLocation)) {
                CfgBuilder.this.mIcfg.getLoopLocations().add(boogieIcfgLocation2);
            }
            if (CfgBuilder.this.mIcfg.getLocationsOfInterest().remove(boogieIcfgLocation)) {
                CfgBuilder.this.mIcfg.getLocationsOfInterest().add(boogieIcfgLocation2);
            }
            if (bl) {
                ModelUtils.copyAnnotations((IElement)boogieIcfgLocation, (IElement)boogieIcfgLocation2);
            } else {
                ModelUtils.copyAnnotationsExcept((IElement)boogieIcfgLocation, (IElement)boogieIcfgLocation2, (Class[])new Class[]{ILocation.class});
            }
        }
    }
}

