/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.IntegralHull;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearInequality;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LinearTransition
implements Serializable {
    private static final long serialVersionUID = 8925538198614759883L;
    private final Map<IProgramVar, TermVariable> minVars;
    private final Map<IProgramVar, TermVariable> moutVars;
    private final List<List<LinearInequality>> mpolyhedra;
    private final boolean mcontains_integers;

    public LinearTransition(List<List<LinearInequality>> list, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        assert (list != null);
        assert (map != null);
        assert (map2 != null);
        for (List<LinearInequality> list2 : list) {
            assert (list2 != null);
        }
        this.mpolyhedra = list;
        this.minVars = Collections.unmodifiableMap(map);
        this.moutVars = Collections.unmodifiableMap(map2);
        this.mcontains_integers = this.checkIfContainsSort(this.minVars.keySet(), "Int") || this.checkIfContainsSort(this.moutVars.keySet(), "Int");
    }

    private boolean checkIfContainsSort(Set<IProgramVar> set, String string) {
        for (IProgramVar iProgramVar : set) {
            Sort sort = ReplacementVarUtils.getDefinition((IProgramVar)iProgramVar).getSort();
            if (!sort.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfContainsIntegers() {
        for (List<LinearInequality> list : this.mpolyhedra) {
            for (LinearInequality linearInequality : list) {
                for (Term term : linearInequality.getVariables()) {
                    if (!SmtSortUtils.isIntSort((Sort)term.getSort())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static LinearTransition getTranstionTrue() {
        LinearInequality linearInequality = new LinearInequality();
        return new LinearTransition(Collections.singletonList(Collections.singletonList(linearInequality)), Collections.emptyMap(), Collections.emptyMap());
    }

    public static LinearTransition getTranstionFalse() {
        LinearInequality linearInequality = new LinearInequality();
        linearInequality.setStrict(true);
        return new LinearTransition(Collections.singletonList(Collections.singletonList(linearInequality)), Collections.emptyMap(), Collections.emptyMap());
    }

    private static List<Term> toClauses(Term term) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        if (!(term instanceof ApplicationTerm)) {
            arrayList.add(term);
            return arrayList;
        }
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if (!applicationTerm.getFunction().getName().equals("or")) {
            arrayList.add(term);
            return arrayList;
        }
        Term[] termArray = applicationTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray[n2];
            arrayList.addAll(LinearTransition.toClauses(term2));
            ++n2;
        }
        return arrayList;
    }

    public static LinearTransition fromTransFormulaLR(ModifiableTransFormula modifiableTransFormula, InequalityConverter.NlaHandling nlaHandling) throws TermException {
        ArrayList<List<LinearInequality>> arrayList = new ArrayList<List<LinearInequality>>();
        for (Term term : LinearTransition.toClauses(modifiableTransFormula.getFormula())) {
            arrayList.add(InequalityConverter.convert(term, nlaHandling));
        }
        return new LinearTransition(arrayList, modifiableTransFormula.getInVars(), modifiableTransFormula.getOutVars());
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.minVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.moutVars;
    }

    public boolean containsIntegers() {
        return this.mcontains_integers;
    }

    public void integralHull() {
        for (List<LinearInequality> list : this.mpolyhedra) {
            list.addAll(IntegralHull.compute(list));
        }
    }

    public boolean isConjunctive() {
        return this.mpolyhedra.size() <= 1;
    }

    public boolean isTrue() {
        for (List<LinearInequality> list : this.mpolyhedra) {
            boolean bl = true;
            for (LinearInequality linearInequality : list) {
                boolean bl2 = bl = bl && linearInequality.isConstant() && linearInequality.getConstant().isZero() && !linearInequality.isStrict();
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public boolean isFalse() {
        for (List<LinearInequality> list : this.mpolyhedra) {
            boolean bl = false;
            for (LinearInequality linearInequality : list) {
                if (!linearInequality.isConstant() || !linearInequality.getConstant().isZero() || !linearInequality.isStrict()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public int getNumPolyhedra() {
        return this.mpolyhedra.size();
    }

    public int getNumInequalities() {
        int n = 0;
        for (List<LinearInequality> list : this.mpolyhedra) {
            n += list.size();
        }
        return n;
    }

    public Set<Term> getVariables() {
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        for (List<LinearInequality> list : this.mpolyhedra) {
            for (LinearInequality linearInequality : list) {
                linkedHashSet.addAll(linearInequality.getVariables());
            }
        }
        return linkedHashSet;
    }

    public List<List<LinearInequality>> getPolyhedra() {
        return Collections.unmodifiableList(this.mpolyhedra);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("InVars: ");
        stringBuilder.append(this.minVars.toString());
        stringBuilder.append("\nOutVars: ");
        stringBuilder.append(this.moutVars.toString());
        stringBuilder.append("\n(OR\n");
        for (List<LinearInequality> list : this.mpolyhedra) {
            stringBuilder.append("    (AND\n");
            for (LinearInequality linearInequality : list) {
                stringBuilder.append("        ");
                stringBuilder.append(linearInequality);
                stringBuilder.append("\n");
            }
            stringBuilder.append("    )\n");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

