/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class IfStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(IfStatement.class);
    Expression condition;
    Statement[] thenPart;
    Statement[] elsePart;

    public IfStatement(ILocation iLocation, Expression expression, Statement[] statementArray, Statement[] statementArray2) {
        super(iLocation);
        this.condition = expression;
        this.thenPart = statementArray;
        this.elsePart = statementArray2;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IfStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IfStatement").append('[');
        stringBuffer.append((Object)this.condition);
        stringBuffer.append(',');
        if (this.thenPart == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.thenPart.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.thenPart[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.elsePart == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.elsePart.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.elsePart[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Statement[] getThenPart() {
        return this.thenPart;
    }

    public Statement[] getElsePart() {
        return this.elsePart;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        list.add(this.condition);
        if (this.thenPart != null) {
            list.addAll(Arrays.asList(this.thenPart));
        }
        if (this.elsePart != null) {
            list.addAll(Arrays.asList(this.elsePart));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            Statement statement;
            int n;
            int n2;
            Statement[] statementArray;
            if (this.condition != null) {
                this.condition.accept(generatedBoogieAstVisitor);
            }
            if (this.thenPart != null) {
                statementArray = this.thenPart;
                n2 = this.thenPart.length;
                n = 0;
                while (n < n2) {
                    statement = statementArray[n];
                    statement.accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.elsePart != null) {
                statementArray = this.elsePart;
                n2 = this.elsePart.length;
                n = 0;
                while (n < n2) {
                    statement = statementArray[n];
                    statement.accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        int n;
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        Expression expression = null;
        if (this.condition != null) {
            expression = this.condition.accept(generatedBoogieAstTransformer);
        }
        boolean bl = false;
        ArrayList<Statement[]> arrayList = new ArrayList<Statement[]>();
        if (this.thenPart != null) {
            Statement[] statementArray = this.thenPart;
            n = this.thenPart.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = statementArray[n2];
                object = ((Statement)((Object)object2)).accept(generatedBoogieAstTransformer);
                bl = bl || object != object2;
                arrayList.add((Statement[])object);
                ++n2;
            }
        }
        object2 = new ArrayList();
        if (this.elsePart != null) {
            object = this.elsePart;
            int n3 = this.elsePart.length;
            n = 0;
            while (n < n3) {
                Statement statement2 = object[n];
                Statement statement3 = statement2.accept(generatedBoogieAstTransformer);
                bl = bl || statement3 != statement2;
                ((ArrayList)object2).add(statement3);
                ++n;
            }
        }
        if (bl || this.condition != expression) {
            return new IfStatement(this.loc, expression, arrayList.toArray(new Statement[0]), ((ArrayList)object2).toArray(new Statement[0]));
        }
        return this;
    }
}

