/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.domain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.DnfToExplicitValue;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.RelationCheckUtil;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class ExplicitValueDomain
implements IDomain {
    private final SymbolicTools mTools;
    private final int mMaxDisjuncts;

    public ExplicitValueDomain(SymbolicTools symbolicTools, int n) {
        this.mTools = symbolicTools;
        this.mMaxDisjuncts = n;
    }

    @Override
    public IPredicate join(IPredicate iPredicate, IPredicate iPredicate2) {
        return this.joinAccordingToMax(this.mTools.or(iPredicate, iPredicate2));
    }

    @Override
    public IPredicate widen(IPredicate iPredicate, IPredicate iPredicate2) {
        return this.join(iPredicate, iPredicate2);
    }

    @Override
    public IDomain.ResultForAlteredInputs isEqBottom(IPredicate iPredicate) {
        return RelationCheckUtil.isEqBottom_SolverAlphaSolver(this.mTools, this, iPredicate);
    }

    @Override
    public IDomain.ResultForAlteredInputs isSubsetEq(IPredicate iPredicate, IPredicate iPredicate2) {
        return RelationCheckUtil.isSubsetEq_SolverAlphaSolver(this.mTools, this, iPredicate, iPredicate2);
    }

    @Override
    public IPredicate alpha(IPredicate iPredicate) {
        DnfToExplicitValue dnfToExplicitValue = new DnfToExplicitValue(this.mTools);
        Term[] termArray = (Term[])Arrays.stream(this.mTools.dnfDisjuncts(iPredicate)).map(arg_0 -> ((DnfToExplicitValue)dnfToExplicitValue).transform(arg_0)).toArray(Term[]::new);
        return this.mTools.orT(this.joinAccordingToMax(termArray));
    }

    private IPredicate joinAccordingToMax(IPredicate iPredicate) {
        return this.mTools.orT(this.joinAccordingToMax(this.mTools.dnfDisjuncts(iPredicate)));
    }

    private Term[] joinAccordingToMax(Term[] termArray) {
        if (termArray.length <= this.mMaxDisjuncts) {
            return termArray;
        }
        Term[] termArray2 = new Term[this.mMaxDisjuncts];
        int n = 0;
        int n2 = 0;
        while (n2 < termArray2.length) {
            int n3 = (int)Math.ceil((double)(termArray.length - n) / (double)(termArray2.length - n2));
            termArray2[n2] = Arrays.stream(termArray, n, n + n3).reduce(termArray[n], this::joinConjunctions);
            n += n3;
            ++n2;
        }
        return termArray2;
    }

    private Term joinConjunctions(Term term, Term term2) {
        return this.mapToConjunction(ExplicitValueDomain.joinMapsOfVarsToValues(ExplicitValueDomain.mapVarsToValues(term), ExplicitValueDomain.mapVarsToValues(term2)));
    }

    private Term mapToConjunction(Map<Term, Term> map) {
        return this.mTools.andT((Term[])map.entrySet().stream().map(this::entryToEq).toArray(Term[]::new)).getFormula();
    }

    private Term entryToEq(Map.Entry<Term, Term> entry) {
        return this.mTools.getScript().term("=", new Term[]{entry.getKey(), entry.getValue()});
    }

    private static Map<Term, Term> joinMapsOfVarsToValues(Map<Term, Term> map, Map<Term, Term> map2) {
        map.entrySet().retainAll(map2.entrySet());
        return map;
    }

    private static Map<Term, Term> mapVarsToValues(Term term) {
        LinkedHashMap<Term, Term> linkedHashMap = new LinkedHashMap<Term, Term>();
        Term[] termArray = SmtUtils.getConjuncts((Term)term);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray[n2];
            ExplicitValueDomain.addPairsToMap(linkedHashMap, term2);
            ++n2;
        }
        return linkedHashMap;
    }

    private static void addPairsToMap(Map<Term, Term> map, Term term2) {
        Term[] termArray = ExplicitValueDomain.subtermsOfEq(term2);
        Optional<Term> optional = ExplicitValueDomain.extractValue(termArray);
        if (!optional.isPresent()) {
            return;
        }
        ExplicitValueDomain.extractVariables(termArray).forEach(term -> {
            Term term2 = map.put((Term)term, (Term)optional.get());
        });
    }

    private static Term[] subtermsOfEq(Term term) {
        ApplicationTerm applicationTerm;
        if (term instanceof ApplicationTerm && "=".equals((applicationTerm = (ApplicationTerm)term).getFunction().getName())) {
            return applicationTerm.getParameters();
        }
        return new Term[0];
    }

    private static Collection<Term> extractVariables(Term[] termArray) {
        ArrayList<Term> arrayList = new ArrayList<Term>(termArray.length);
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray2[n2];
            if (term instanceof TermVariable) {
                arrayList.add(term);
            }
            ++n2;
        }
        return arrayList;
    }

    private static Optional<Term> extractValue(Term[] termArray) {
        Term term = null;
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray2[n2];
            if (term2 instanceof ConstantTerm) {
                if (term != null) {
                    throw new AssertionError((Object)"More than one constant. Expected simplification to remove them.");
                }
                term = term2;
            }
            ++n2;
        }
        return Optional.ofNullable(term);
    }
}

