/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting.datastructures;

import de.uni_freiburg.informatik.ultimate.automata.counting.datastructures.IAtomicCounterGuard;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ConjunctiveCounterFormula {
    private final LinkedHashSet<IAtomicCounterGuard> mConjuncts;

    public ConjunctiveCounterFormula(LinkedHashSet<IAtomicCounterGuard> linkedHashSet) {
        Objects.nonNull(linkedHashSet);
        this.mConjuncts = linkedHashSet;
    }

    public Set<IAtomicCounterGuard> getConjuncts() {
        return Collections.unmodifiableSet(this.mConjuncts);
    }

    public String toString() {
        if (this.getConjuncts().isEmpty()) {
            return "true";
        }
        if (this.getConjuncts().size() == 1) {
            return this.getConjuncts().iterator().next().toString();
        }
        return String.format("(and %s)", this.mConjuncts.stream().map(Object::toString).collect(Collectors.joining(" ")));
    }
}

