/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.BinaryNwaOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IntersectNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IntersectDD;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.reachablestates.NestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;

public final class Intersect<LETTER, STATE>
extends BinaryNwaOperation<LETTER, STATE, INwaInclusionStateFactory<STATE>> {
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mFstOperand;
    private final INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mSndOperand;
    private final NestedWordAutomatonReachableStates<LETTER, STATE> mResult;

    public Intersect(AutomataLibraryServices automataLibraryServices, IIntersectionStateFactory<STATE> iIntersectionStateFactory, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider2) throws AutomataLibraryException {
        super(automataLibraryServices);
        this.mFstOperand = iNwaOutgoingLetterAndTransitionProvider;
        this.mSndOperand = iNwaOutgoingLetterAndTransitionProvider2;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        IntersectNwa<LETTER, STATE> intersectNwa = new IntersectNwa<LETTER, STATE>(this.mFstOperand, this.mSndOperand, iIntersectionStateFactory, false);
        this.mResult = new NestedWordAutomatonReachableStates<LETTER, STATE>(this.mServices, intersectNwa);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getOperationName() + ". Result " + this.mResult.sizeInformation();
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getFirstOperand() {
        return this.mFstOperand;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> getSecondOperand() {
        return this.mSndOperand;
    }

    @Override
    public INestedWordAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        Object object = new IntersectDD<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, this.mFstOperand, this.mSndOperand).getResult();
        boolean bl = true;
        assert (bl &= object.size() == this.mResult.size());
        assert (bl &= new IsEquivalent<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, object, this.mResult).getResult().booleanValue());
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", "language is different", this.mFstOperand, this.mSndOperand);
        }
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        return bl;
    }
}

