/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.AGameGraph;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.DuplicatorVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.Vertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.TransitionType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorSubSummaryChoiceVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.DuplicatorWinningSink;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerNwaVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.SpoilerSubSummaryPriorityVertex;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameLetter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.game.IGameState;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.GameAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.util.nwa.graph.summarycomputationgraph.GameCallReturnSummary;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import java.util.Collection;

public class GameAutomatonToGameGraphTransformer<LETTER, STATE> {
    private final INestedWordAutomaton<IGameLetter<LETTER, STATE>, IGameState> mGameAutomaton;
    private final AGameGraph<LETTER, STATE> mGameGraph;
    private final SpoilerNwaVertex<LETTER, STATE> mSpoilerWinningSink;
    private final DuplicatorNwaVertex<LETTER, STATE> mDuplicatorWinningSink;
    private AutomataLibraryServices mServices;

    public GameAutomatonToGameGraphTransformer(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<IGameLetter<LETTER, STATE>, IGameState> iNestedWordAutomaton, SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton2, Collection<GameCallReturnSummary<STATE>> collection) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mGameAutomaton = iNestedWordAutomaton;
        this.mSpoilerWinningSink = spoilerNwaVertex;
        this.mDuplicatorWinningSink = new DuplicatorNwaVertex<Object, Object>(0, false, null, null, null, TransitionType.SINK, new DuplicatorWinningSink(null));
        this.mGameGraph = new AGameGraph<LETTER, STATE>(this.mServices, null, null, null, iNestedWordAutomaton2){

            @Override
            public INestedWordAutomaton<LETTER, STATE> generateAutomatonFromGraph() throws AutomataOperationCanceledException {
                return null;
            }

            @Override
            public void generateGameGraphFromAutomaton() throws AutomataOperationCanceledException {
            }
        };
        for (IGameState object : this.mGameAutomaton.getStates()) {
            this.addSpoilerVertex(object);
            boolean bl = false;
            for (OutgoingInternalTransition outgoingInternalTransition : this.mGameAutomaton.internalSuccessors(object)) {
                bl = true;
                this.addDuplicatorVertex((IGameLetter)outgoingInternalTransition.getLetter());
                this.addSpoilerVertex(outgoingInternalTransition.getSucc());
                this.addEdges(object, (IGameLetter)outgoingInternalTransition.getLetter(), outgoingInternalTransition.getSucc());
            }
            boolean bl2 = false;
            for (OutgoingCallTransition outgoingCallTransition : this.mGameAutomaton.callSuccessors(object)) {
                bl2 = true;
                this.addDuplicatorVertex((IGameLetter)outgoingCallTransition.getLetter());
                this.addSpoilerVertex(outgoingCallTransition.getSucc());
                this.addEdges(object, (IGameLetter)outgoingCallTransition.getLetter(), outgoingCallTransition.getSucc());
            }
            if (bl || bl2) continue;
            this.addEdgeToDuplicatorSink(object);
        }
        for (GameCallReturnSummary gameCallReturnSummary : collection) {
            this.addGameSummary(gameCallReturnSummary);
        }
        this.mGameGraph.increaseGlobalInfinity();
    }

    private SpoilerNwaVertex<LETTER, STATE> getSpoilerVertex(IGameState iGameState) {
        if (GameAutomaton.isSpoilerSink(iGameState)) {
            return this.mSpoilerWinningSink;
        }
        return GameAutomaton.unwrapSpoilerNwaVertex(iGameState);
    }

    private void addEdgeToDuplicatorSink(IGameState iGameState) {
        this.mGameGraph.addEdge(this.getSpoilerVertex(iGameState), this.mDuplicatorWinningSink);
    }

    private void addEdges(IGameState iGameState, IGameLetter<LETTER, STATE> iGameLetter, IGameState iGameState2) {
        this.mGameGraph.addEdge(this.getSpoilerVertex(iGameState), (Vertex)((Object)iGameLetter));
        this.mGameGraph.addEdge((Vertex)((Object)iGameLetter), this.getSpoilerVertex(iGameState2));
    }

    private void addDuplicatorVertex(IGameLetter<LETTER, STATE> iGameLetter) {
        if (!this.mGameGraph.getDuplicatorVertices().contains(iGameLetter)) {
            this.mGameGraph.addDuplicatorVertex((DuplicatorVertex)((Object)iGameLetter));
        }
    }

    private void addSpoilerVertex(IGameState iGameState) {
        SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex = this.getSpoilerVertex(iGameState);
        if (!this.mGameGraph.getSpoilerVertices().contains(spoilerNwaVertex)) {
            this.mGameGraph.addSpoilerVertex(spoilerNwaVertex);
            if (spoilerNwaVertex.getPriority() == 1) {
                this.mGameGraph.increaseGlobalInfinity();
            }
            if (spoilerNwaVertex == this.mSpoilerWinningSink) {
                this.mGameGraph.addEdge(this.mSpoilerWinningSink, this.mSpoilerWinningSink);
            }
        }
    }

    private void addGameSummary(GameCallReturnSummary<STATE> gameCallReturnSummary) {
        SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex = this.getSpoilerVertex(gameCallReturnSummary.getSummarySource());
        assert (this.mGameGraph.getSpoilerVertices().contains(spoilerNwaVertex)) : "source missing";
        DuplicatorSubSummaryChoiceVertex duplicatorSubSummaryChoiceVertex = new DuplicatorSubSummaryChoiceVertex(gameCallReturnSummary);
        assert (!this.mGameGraph.getDuplicatorVertices().contains(duplicatorSubSummaryChoiceVertex)) : "duplicator choice already there";
        this.mGameGraph.addDuplicatorVertex(duplicatorSubSummaryChoiceVertex);
        this.mGameGraph.addEdge(spoilerNwaVertex, duplicatorSubSummaryChoiceVertex);
        for (IGameState iGameState : gameCallReturnSummary.getDuplicatorResponses().keySet()) {
            SpoilerSubSummaryPriorityVertex spoilerSubSummaryPriorityVertex = new SpoilerSubSummaryPriorityVertex(gameCallReturnSummary, iGameState);
            assert (!this.mGameGraph.getSpoilerVertices().contains(spoilerSubSummaryPriorityVertex)) : "spoiler priority vertex already there";
            this.mGameGraph.addSpoilerVertex(spoilerSubSummaryPriorityVertex);
            SpoilerNwaVertex<LETTER, STATE> spoilerNwaVertex2 = this.getSpoilerVertex(iGameState);
            assert (this.mGameGraph.getSpoilerVertices().contains(spoilerNwaVertex2)) : "target missing";
            this.mGameGraph.addEdge(duplicatorSubSummaryChoiceVertex, spoilerSubSummaryPriorityVertex);
            this.mGameGraph.addEdge(spoilerSubSummaryPriorityVertex, spoilerNwaVertex2);
        }
    }

    public AGameGraph<LETTER, STATE> getResult() {
        return this.mGameGraph;
    }
}

