/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.visitors.IDfsVisitor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.function.Predicate;

public class AcceptingRunSearchVisitor<L, S>
implements IDfsVisitor<L, S> {
    private final Predicate<S> mIsGoalState;
    private final Deque<S> mStateStack = new ArrayDeque<S>();
    private final Deque<L> mLetterStack = new ArrayDeque<L>();
    private L mPendingLetter;
    private S mPendingState;
    private boolean mFound;
    private NestedRun<L, S> mRun;

    public AcceptingRunSearchVisitor(Predicate<S> predicate) {
        this.mIsGoalState = predicate;
    }

    @Override
    public boolean addStartState(S s) {
        assert (this.mStateStack.isEmpty()) : "start state must be first";
        this.mStateStack.addLast(s);
        this.mFound = this.mIsGoalState.test(s);
        return false;
    }

    @Override
    public boolean discoverTransition(S s, L l, S s2) {
        assert (!this.mFound) : "Unexpected transition discovery after abort";
        assert (this.mStateStack.getLast() == s) : "Unexpected transition from state " + String.valueOf(s);
        this.mPendingLetter = l;
        this.mPendingState = s2;
        return false;
    }

    @Override
    public boolean discoverState(S s) {
        assert (!this.mFound) : "Unexpected state discovery after abort";
        if (this.mPendingLetter == null) {
            assert (this.mStateStack.size() == 1 && this.mStateStack.getLast() == s) : "Unexpected discovery of state " + String.valueOf(s);
        } else {
            assert (this.mPendingState == s) : "Unexpected discovery of state " + String.valueOf(s);
            this.mLetterStack.addLast(this.mPendingLetter);
            this.mStateStack.addLast(this.mPendingState);
            this.mPendingLetter = null;
            this.mPendingState = null;
        }
        this.mFound = this.mIsGoalState.test(s);
        return false;
    }

    @Override
    public void backtrackState(S s, boolean bl) {
        assert (!this.mFound) : "Unexpected backtrack after abort";
        assert (this.mStateStack.getLast() == s) : "Unexpected backtrack of state " + String.valueOf(s);
        this.mPendingLetter = null;
        this.mPendingState = null;
        this.mStateStack.removeLast();
        this.mLetterStack.pollLast();
    }

    @Override
    public boolean isFinished() {
        return this.mFound;
    }

    public NestedRun<L, S> getAcceptingRun() {
        if (this.mRun != null) {
            return this.mRun;
        }
        if (!this.mFound) {
            return null;
        }
        ArrayList<S> arrayList = new ArrayList<S>(this.mStateStack);
        Word<Object> word = new Word<Object>(this.mLetterStack.toArray());
        this.mRun = new NestedRun<Object, S>(NestedWord.nestedWord(word), arrayList);
        return this.mRun;
    }
}

