/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.Determinize;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.isTotal;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Totalize<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final ITreeAutomatonBU<LETTER, STATE> mTreeAutomaton;
    private final ISinkStateFactory<STATE> mStateFactory;
    protected final ITreeAutomatonBU<LETTER, STATE> mResult;
    private final Map<Integer, List<List<STATE>>> mMemCombinations;
    private final STATE mDummyState;
    private final Set<STATE> mStates;
    private final Collection<LETTER> mAlphabet;

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> Totalize(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mTreeAutomaton = new Determinize<LETTER, STATE>(automataLibraryServices, SF, iTreeAutomatonBU).getResult();
        this.mStateFactory = SF;
        this.mMemCombinations = new HashMap<Integer, List<List<STATE>>>();
        this.mDummyState = this.mStateFactory.createSinkStateContent();
        this.mStates = new HashSet<STATE>();
        this.mStates.add(this.mDummyState);
        this.mStates.addAll(this.mTreeAutomaton.getStates());
        this.mAlphabet = new HashSet<LETTER>();
        this.mAlphabet.addAll(iTreeAutomatonBU.getAlphabet());
        this.mResult = this.computeTotalize();
    }

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> Totalize(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU, Collection<LETTER> collection) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mTreeAutomaton = new Determinize<LETTER, STATE>(automataLibraryServices, SF, iTreeAutomatonBU).getResult();
        this.mStateFactory = SF;
        this.mMemCombinations = new HashMap<Integer, List<List<STATE>>>();
        this.mDummyState = this.mStateFactory.createSinkStateContent();
        this.mStates = new HashSet<STATE>();
        this.mStates.add(this.mDummyState);
        this.mStates.addAll(this.mTreeAutomaton.getStates());
        this.mAlphabet = new HashSet<LETTER>();
        this.mAlphabet.addAll(collection);
        this.mAlphabet.addAll(iTreeAutomatonBU.getAlphabet());
        this.mResult = this.computeTotalize();
    }

    private List<List<STATE>> combinations(int n) {
        if (this.mMemCombinations.containsKey(n)) {
            return this.mMemCombinations.get(n);
        }
        ArrayList<List<STATE>> arrayList = new ArrayList<List<STATE>>();
        if (n == 0) {
            ArrayList arrayList2 = new ArrayList();
            arrayList.add(arrayList2);
            this.mMemCombinations.put(n, arrayList);
            return arrayList;
        }
        List<List<STATE>> list = this.combinations(n - 1);
        for (STATE STATE : this.mStates) {
            for (List<STATE> list2 : list) {
                ArrayList<STATE> arrayList3 = new ArrayList<STATE>(list2);
                arrayList3.add(STATE);
                arrayList.add(arrayList3);
            }
        }
        this.mMemCombinations.put(n, arrayList);
        return arrayList;
    }

    private TreeAutomatonBU<LETTER, STATE> computeTotalize() throws AutomataOperationCanceledException {
        TreeAutomatonBU<LETTER, STATE> treeAutomatonBU = new TreeAutomatonBU<LETTER, STATE>();
        treeAutomatonBU.extendAlphabet(this.mTreeAutomaton.getAlphabet());
        treeAutomatonBU.extendAlphabet(this.mAlphabet);
        for (STATE object : this.mStates) {
            treeAutomatonBU.addState(object);
            if (!this.mTreeAutomaton.isFinalState(object)) continue;
            treeAutomatonBU.addFinalState(object);
        }
        for (List list : this.mTreeAutomaton.getSourceCombinations()) {
            for (TreeAutomatonRule<List, STATE> treeAutomatonRule : this.mTreeAutomaton.getSuccessors(list)) {
                if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                    throw new AutomataOperationCanceledException(this.getRunningTaskInfo());
                }
                treeAutomatonBU.addRule(treeAutomatonRule);
                for (List list2 : this.combinations(treeAutomatonRule.getArity())) {
                    Iterable<STATE> iterable = this.mTreeAutomaton.getSuccessors(list2, treeAutomatonRule.getLetter());
                    if (iterable != null && iterable.iterator().hasNext()) continue;
                    treeAutomatonBU.addRule(new TreeAutomatonRule<List, STATE>(treeAutomatonRule.getLetter(), list2, this.mDummyState));
                }
                assert (treeAutomatonRule.getLetter().getRank() == treeAutomatonRule.getArity());
            }
        }
        for (IRankedLetter iRankedLetter : this.mAlphabet) {
            int n = iRankedLetter.getRank();
            for (List<STATE> list : this.combinations(n)) {
                Iterable<STATE> iterable = this.mTreeAutomaton.getSuccessors(list, iRankedLetter);
                if (iterable != null && iterable.iterator().hasNext()) continue;
                treeAutomatonBU.addRule(new TreeAutomatonRule<IRankedLetter, STATE>(iRankedLetter, list, this.mDummyState));
            }
        }
        return treeAutomatonBU;
    }

    @Override
    public String startMessage() {
        return "Starting " + this.getOperationName();
    }

    @Override
    public String exitMessage() {
        return "Finishing " + this.getOperationName();
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getResult() {
        assert (new isTotal<LETTER, STATE>(this.mServices, this.mResult).getResult().booleanValue());
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    private RunningTaskInfo getRunningTaskInfo() {
        return new RunningTaskInfo(this.getClass(), "totalizing tree automaton with " + this.mTreeAutomaton.sizeInformation());
    }
}

