/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.function.Predicate;

public final class NonInductiveAnnotationGenerator {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredicateTransformer;
    private final ManagedScript mManagedScript;
    private final BasicPredicateFactory mPredicateFactory;
    private final IIcfg<?> mIcfg;
    private final HashRelation<IcfgLocation, IPredicate> mResult = new HashRelation();
    private final ArrayDeque<Pair<IcfgLocation, IPredicate>> mWorklist = new ArrayDeque();
    private final Predicate<Pair<IcfgLocation, IcfgLocation>> mExitCondition;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA;
    private final Approximation mApproximation;

    public NonInductiveAnnotationGenerator(IUltimateServiceProvider iUltimateServiceProvider, BasicPredicateFactory basicPredicateFactory, IIcfg<?> iIcfg, Approximation approximation) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mPredicateFactory = basicPredicateFactory;
        this.mIcfg = iIcfg;
        this.mManagedScript = iIcfg.getCfgSmtToolkit().getManagedScript();
        this.mPredicateTransformer = new PredicateTransformer(this.mManagedScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mManagedScript));
        this.mApproximation = approximation;
        this.mExitCondition = this.constructExitCondition_OnlyOne();
        switch (this.mApproximation) {
            case OVERAPPROXIMATION: {
                this.initializeWorklistForOverapproximation();
                break;
            }
            case UNDERAPPROXIMATION: {
                this.initializeWorklistForUnderapproximation();
                break;
            }
        }
        while (!this.mWorklist.isEmpty()) {
            Pair<IcfgLocation, IPredicate> pair = this.mWorklist.removeFirst();
            switch (this.mApproximation) {
                case OVERAPPROXIMATION: {
                    this.processAnnotationForOverapproximation((IcfgLocation)pair.getFirst(), (IPredicate)pair.getSecond(), this.mExitCondition);
                    break;
                }
                case UNDERAPPROXIMATION: {
                    this.processAnnotationForUnderapproximation((IcfgLocation)pair.getFirst(), (IPredicate)pair.getSecond(), this.mExitCondition);
                    break;
                }
            }
        }
    }

    private void initializeWorklistForUnderapproximation() {
        for (IcfgLocation icfgLocation : this.mIcfg.getInitialNodes()) {
            Term term = this.mManagedScript.getScript().term("true", new Term[0]);
            this.addNewTerm(icfgLocation, term);
        }
    }

    private void initializeWorklistForOverapproximation() {
        for (IcfgLocation icfgLocation : IcfgUtils.getErrorLocations(this.mIcfg)) {
            Term term = this.mManagedScript.getScript().term("false", new Term[0]);
            this.addNewTerm(icfgLocation, term);
        }
    }

    private Predicate<Pair<IcfgLocation, IcfgLocation>> constructExitCondition_OnlyOne() {
        return pair -> this.mResult.getDomain().contains(pair.getSecond());
    }

    private void addNewTerm(IcfgLocation icfgLocation, Term term) {
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(term);
        this.mResult.addPair((Object)icfgLocation, (Object)basicPredicate);
        this.mWorklist.add((Pair<IcfgLocation, IPredicate>)new Pair((Object)icfgLocation, (Object)basicPredicate));
    }

    private void processAnnotationForUnderapproximation(IcfgLocation icfgLocation, IPredicate iPredicate, Predicate<Pair<IcfgLocation, IcfgLocation>> predicate) {
        for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
            IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getTarget();
            if (predicate.test((Pair<IcfgLocation, IcfgLocation>)new Pair((Object)icfgLocation, (Object)icfgLocation2))) continue;
            if (icfgEdge.getLabel() instanceof IInternalAction) {
                IInternalAction iInternalAction = (IInternalAction)icfgEdge.getLabel();
                Term term = (Term)this.mPredicateTransformer.strongestPostcondition((IAbstractPredicate)iPredicate, (ITransitionRelation)iInternalAction.getTransformula());
                Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (Term)term);
                this.addNewTerm((IcfgLocation)icfgEdge.getTarget(), term2);
                continue;
            }
            throw new UnsupportedOperationException("interprocedural programs not yet supported");
        }
    }

    private void processAnnotationForOverapproximation(IcfgLocation icfgLocation, IPredicate iPredicate, Predicate<Pair<IcfgLocation, IcfgLocation>> predicate) {
        for (IcfgEdge icfgEdge : icfgLocation.getIncomingEdges()) {
            IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getSource();
            if (predicate.test((Pair<IcfgLocation, IcfgLocation>)new Pair((Object)icfgLocation, (Object)icfgLocation2))) continue;
            if (icfgEdge.getLabel() instanceof IInternalAction) {
                IInternalAction iInternalAction = (IInternalAction)icfgEdge.getLabel();
                Term term = (Term)this.mPredicateTransformer.weakestPrecondition((IAbstractPredicate)iPredicate, (ITransitionRelation)iInternalAction.getTransformula());
                Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique, (Term)term);
                this.addNewTerm((IcfgLocation)icfgEdge.getSource(), term2);
                continue;
            }
            throw new UnsupportedOperationException("interprocedural programs not yet supported");
        }
    }

    public HashRelation<IcfgLocation, IPredicate> getResult() {
        return this.mResult;
    }

    public static enum Approximation {
        OVERAPPROXIMATION,
        UNDERAPPROXIMATION;

    }
}

