/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.plugins.blockencoding.encoding.BaseBlockEncoder;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.stream.Collectors;

public class RemoveInfeasibleEdges
extends BaseBlockEncoder<IcfgLocation> {
    public RemoveInfeasibleEdges(IUltimateServiceProvider iUltimateServiceProvider, BlockEncodingBacktranslator blockEncodingBacktranslator, ILogger iLogger) {
        super(iLogger, iUltimateServiceProvider, blockEncodingBacktranslator);
    }

    @Override
    protected BasicIcfg<IcfgLocation> createResult(BasicIcfg<IcfgLocation> basicIcfg) {
        ArrayDeque arrayDeque = new ArrayDeque();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        arrayDeque.addAll(basicIcfg.getInitialNodes().stream().flatMap(icfgLocation -> icfgLocation.getOutgoingEdges().stream()).collect(Collectors.toSet()));
        while (!arrayDeque.isEmpty()) {
            IcfgEdge icfgEdge = (IcfgEdge)arrayDeque.removeFirst();
            if (!hashSet.add(icfgEdge)) continue;
            arrayDeque.addAll(((IcfgLocation)icfgEdge.getTarget()).getOutgoingEdges());
            this.checkEdge(icfgEdge);
        }
        this.removeDisconnectedLocations(basicIcfg);
        this.mLogger.info((Object)("Removed " + this.mRemovedEdges + " edges and " + this.mRemovedLocations + " locations because of local infeasibility"));
        return basicIcfg;
    }

    private void checkEdge(IcfgEdge icfgEdge) {
        if (icfgEdge instanceof IIcfgCallTransition || icfgEdge instanceof IIcfgReturnTransition) {
            return;
        }
        UnmodifiableTransFormula.Infeasibility infeasibility = icfgEdge.getTransformula().isInfeasible();
        switch (infeasibility) {
            case INFEASIBLE: {
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Removing " + String.valueOf(infeasibility) + ": " + String.valueOf(icfgEdge)));
                }
                this.removeEdge(icfgEdge);
                break;
            }
            case UNPROVEABLE: 
            case NOT_DETERMINED: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private void removeEdge(IcfgEdge icfgEdge) {
        icfgEdge.disconnectSource();
        icfgEdge.disconnectTarget();
        ++this.mRemovedEdges;
    }

    @Override
    public boolean isGraphStructureChanged() {
        return this.mRemovedEdges > 0 || this.mRemovedLocations > 0;
    }
}

