/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessparser;

import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.FunctionContract;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.GhostUpdate;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.GhostVariable;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Location;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LocationInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.LoopInvariant;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Segment;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.ViolationSequence;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Waypoint;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointAssumption;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointBranching;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointFunctionEnter;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointFunctionReturn;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WaypointTarget;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.Witness;
import de.uni_freiburg.informatik.ultimate.witnessparser.yaml.WitnessEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlWitnessParser {
    private static final int MAXIMAL_SIZE = 0x3200000;

    public static Witness parseWitness(File file) throws IOException {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(0x3200000);
        List list = (List)new Yaml((BaseConstructor)new SafeConstructor(loaderOptions)).load((InputStream)new FileInputStream(file));
        return new Witness(list.stream().flatMap(YamlWitnessParser::parseWitnessEntry).collect(Collectors.toList()));
    }

    private static Stream<WitnessEntry> parseWitnessEntry(Map<String, Object> map2) {
        switch ((String)map2.get("entry_type")) {
            case "location_invariant": {
                Location location = YamlWitnessParser.parseLocation((Map)map2.get("location"));
                Map map3 = (Map)map2.get("location_invariant");
                return Stream.of(new LocationInvariant(location, (String)map3.get("string"), (String)map3.get("format")));
            }
            case "loop_invariant": {
                Location location = YamlWitnessParser.parseLocation((Map)map2.get("location"));
                Map map4 = (Map)map2.get("loop_invariant");
                return Stream.of(new LoopInvariant(location, (String)map4.get("string"), (String)map4.get("format")));
            }
            case "ghost_instrumentation": {
                Map map5 = (Map)map2.get("content");
                List list = (List)map5.get("ghost_variables");
                List list2 = (List)map5.get("ghost_updates");
                return Stream.concat(list.stream().map(map -> YamlWitnessParser.parseGhostVariable(map)), list2.stream().flatMap(map -> YamlWitnessParser.parseGhostUpdates(map)));
            }
            case "invariant_set": {
                List list = (List)map2.get("content");
                return list.stream().map(map -> YamlWitnessParser.parseInvariantSetEntry(map));
            }
            case "violation_sequence": {
                return Stream.of(YamlWitnessParser.parseViolationSequence((List)map2.get("content")));
            }
        }
        throw new UnsupportedOperationException("Unknown entry type " + String.valueOf(map2.get("entry_type")));
    }

    private static WitnessEntry parseViolationSequence(List<Map<String, List<Map<String, Object>>>> list) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        for (Map<String, List<Map<String, Object>>> map : list) {
            ArrayList<Waypoint> arrayList2 = new ArrayList<Waypoint>();
            for (Map<String, Object> map2 : map.get("segment")) {
                String string;
                Map map3 = (Map)map2.get("waypoint");
                switch (string = (String)map3.get("action")) {
                    case "avoid": {
                        arrayList2.add(YamlWitnessParser.parseViolationWaypoint(map3));
                        break;
                    }
                    case "follow": {
                        arrayList.add(new Segment(arrayList2, YamlWitnessParser.parseViolationWaypoint(map3), Segment.SegmentType.FOLLOW));
                        break;
                    }
                    case "cycle": {
                        arrayList.add(new Segment(arrayList2, YamlWitnessParser.parseViolationWaypoint(map3), Segment.SegmentType.CYCLE));
                    }
                }
            }
        }
        return new ViolationSequence(arrayList);
    }

    private static Waypoint parseViolationWaypoint(Map<String, Object> map) {
        Location location = YamlWitnessParser.parseLocation((Map)map.get("location"));
        Map map2 = (Map)map.get("constraint");
        String string = map2 == null ? null : ((String)map2.get("value")).toString();
        switch ((String)map.get("type")) {
            case "target": {
                return new WaypointTarget(location);
            }
            case "branching": {
                return new WaypointBranching(string, location);
            }
            case "assumption": {
                return new WaypointAssumption(string, location);
            }
            case "function_enter": {
                return new WaypointFunctionEnter(location);
            }
            case "function_return": {
                return new WaypointFunctionReturn(string, location);
            }
        }
        throw new UnsupportedOperationException("Unable to parse waypoint with type " + String.valueOf(map.get("type")));
    }

    private static GhostVariable parseGhostVariable(Map<String, Object> map) {
        Map map2 = (Map)map.get("initial");
        return new GhostVariable((String)map.get("name"), (String)map2.get("value"), (String)map2.get("format"), (String)map.get("scope"), (String)map.get("type"));
    }

    private static Stream<GhostUpdate> parseGhostUpdates(Map<String, Object> map2) {
        Location location = YamlWitnessParser.parseLocation((Map)map2.get("location"));
        List list = (List)map2.get("updates");
        return list.stream().map(map -> new GhostUpdate((String)map.get("variable"), (String)map.get("value"), (String)map.get("format"), location));
    }

    private static WitnessEntry parseInvariantSetEntry(Map<String, Map<String, Object>> map) {
        if (map.size() != 1) {
            throw new UnsupportedOperationException("Invalid entry in content " + String.valueOf(map));
        }
        Map<String, Object> map2 = map.values().iterator().next();
        Location location = YamlWitnessParser.parseLocation((Map)map2.get("location"));
        String string = (String)map2.get("format");
        switch ((String)map2.get("type")) {
            case "location_invariant": {
                return new LocationInvariant(location, (String)map2.get("value"), string);
            }
            case "loop_invariant": {
                return new LoopInvariant(location, (String)map2.get("value"), string);
            }
            case "function_contract": {
                return new FunctionContract(location, (String)map2.get("requires"), (String)map2.get("ensures"), string);
            }
        }
        throw new UnsupportedOperationException("Invalid entry in content" + String.valueOf(map));
    }

    private static Location parseLocation(Map<String, Object> map) {
        return new Location((String)map.get("file_name"), (Integer)map.get("line"), (Integer)map.get("column"), (String)map.get("function"));
    }
}

