/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcAsserter;
import de.uni_freiburg.informatik.ultimate.lib.chc.Derivation;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.chc.IChcScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.LoggingScript;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.Executor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class GolemChcScript
implements IChcScript {
    private static final boolean ADD_CLAUSE_NAMES = false;
    private static final boolean ADD_COMMENTS = false;
    private static final boolean DECLARE_FUNCTIONS = true;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;
    private final long mDefaultQueryTimeout;
    private boolean mProduceModels;
    private Model mLastModel;
    private Script.LBool mLastResult;

    public GolemChcScript(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this(iUltimateServiceProvider, managedScript, -1L);
    }

    public GolemChcScript(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, long l) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass());
        this.mMgdScript = managedScript;
        this.mDefaultQueryTimeout = l;
    }

    @Override
    public Script getScript() {
        return this.mMgdScript.getScript();
    }

    @Override
    public Script.LBool solve(HcSymbolTable hcSymbolTable, List<HornClause> list) {
        return this.solve(hcSymbolTable, list, -1L);
    }

    @Override
    public Script.LBool solve(HcSymbolTable hcSymbolTable, List<HornClause> list, long l) {
        LoggingScript loggingScript;
        File file;
        try {
            file = File.createTempFile("golem_", ".smt2");
            this.mLogger.info((Object)("Writing script to file " + file.getAbsolutePath()));
            loggingScript = new LoggingScript(file.getAbsolutePath(), false);
            loggingScript.setLogic(Logics.HORN);
            new ChcAsserter(this.mMgdScript, (Script)loggingScript, false, false, true).assertClauses(hcSymbolTable, list);
            loggingScript.checkSat();
            loggingScript.exit();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        loggingScript = null;
        try {
            loggingScript = new Executor(this.getCommand(file), this.mMgdScript.getScript(), this.mLogger, this.mServices, "golem", null, null, null, this.determineTimeout(l));
            this.mLastResult = loggingScript.parseCheckSatResult();
            this.mLastModel = this.mLastResult == Script.LBool.SAT && this.mProduceModels ? loggingScript.parseGetModelResult() : null;
            Script.LBool lBool = this.mLastResult;
            return lBool;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            if (loggingScript != null) {
                loggingScript.exit();
            }
        }
    }

    private String getCommand(File file) {
        StringBuilder stringBuilder = new StringBuilder("golem");
        if (this.mProduceModels) {
            stringBuilder.append(" --print-witness");
        }
        return stringBuilder.append(" ").append(file.getAbsolutePath()).toString();
    }

    @Override
    public boolean supportsModelProduction() {
        return true;
    }

    @Override
    public void produceModels(boolean bl) {
        this.mProduceModels = bl;
    }

    @Override
    public Optional<Model> getModel() {
        if (this.mLastResult != Script.LBool.SAT) {
            throw new UnsupportedOperationException("No model available: last query was " + String.valueOf(this.mLastResult));
        }
        return Optional.ofNullable(this.mLastModel);
    }

    @Override
    public boolean supportsDerivationProduction() {
        return false;
    }

    @Override
    public void produceDerivations(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<Derivation> getDerivation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsUnsatCores() {
        return false;
    }

    @Override
    public void produceUnsatCores(boolean bl) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<Set<HornClause>> getUnsatCore() {
        throw new UnsupportedOperationException();
    }

    private long determineTimeout(long l) {
        long l2 = this.mServices.getProgressMonitorService().remainingTime();
        long l3 = l <= 0L ? this.mDefaultQueryTimeout : l;
        long l4 = l3 <= 0L ? l2 : Long.min(l3, l2);
        return l4;
    }
}

