/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.EventDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.RangeDecision;
import java.util.List;
import java.util.Vector;

public class TCSFormulaJ2XMLConverter {
    protected List<String> rangeExpressionVariables;
    protected List<String> events;
    private final Vector<String> disjuncts = new Vector();
    private int dnfCount = 1;

    public String[] getDisjuncts(boolean bl, CDD cDD, List<String> list, List<String> list2, int n) {
        this.disjuncts.clear();
        this.rangeExpressionVariables = list;
        this.events = list2;
        ++this.dnfCount;
        this.cddToDNF(new StringBuffer(), cDD, bl);
        int n2 = this.disjuncts.size();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = this.disjuncts.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public String[] getDisjuncts(boolean bl, CDD cDD, List<String> list, List<String> list2) {
        return this.getDisjuncts(bl, cDD, list, list2, 0);
    }

    protected void cddToDNF(StringBuffer stringBuffer, CDD cDD, boolean bl) {
        if (cDD == CDD.TRUE) {
            this.disjuncts.add(stringBuffer.toString());
            return;
        }
        if (cDD == CDD.FALSE) {
            return;
        }
        int n = 0;
        while (n < cDD.getChilds().length) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(stringBuffer.toString());
            this.appendDecisionToBuffer(stringBuffer2, cDD.getDecision(), n, bl);
            this.cddToDNF(stringBuffer2, cDD.getChilds()[n], bl);
            ++n;
        }
    }

    protected void appendDecisionToBuffer(StringBuffer stringBuffer, Decision decision, int n, boolean bl) {
        if (stringBuffer.length() != 0) {
            stringBuffer.append(" /\\ ");
        }
        if (decision instanceof RangeDecision) {
            String string = ((RangeDecision)decision).getVar();
            stringBuffer.append(string);
            if (bl) {
                stringBuffer.append("'");
            }
            if (!this.rangeExpressionVariables.contains(string)) {
                this.rangeExpressionVariables.add(string);
            }
            int[] nArray = ((RangeDecision)decision).getLimits();
            if (n == 0) {
                if ((nArray[0] & 1) == 0) {
                    stringBuffer.append(" &lt; ");
                } else {
                    stringBuffer.append(" &lt;= ");
                }
                stringBuffer.append(nArray[0] / 2);
                return;
            }
            if (n == nArray.length) {
                if ((nArray[nArray.length - 1] & 1) == 1) {
                    stringBuffer.append(" &gt; ");
                } else {
                    stringBuffer.append(" &gt;= ");
                }
                stringBuffer.append(nArray[nArray.length - 1] / 2);
                return;
            }
            if (nArray[n - 1] / 2 == nArray[n] / 2) {
                stringBuffer.append(" &gt; ");
                stringBuffer.append(nArray[n] / 2);
                return;
            }
            if ((nArray[n - 1] & 1) == 1) {
                stringBuffer.append(" &gt; ");
            } else {
                stringBuffer.append(" &gt;= ");
            }
            stringBuffer.append(nArray[n - 1] / 2);
            stringBuffer.append(string);
            if ((nArray[n] & 1) == 0) {
                stringBuffer.append(" &lt; ");
            } else {
                stringBuffer.append(" &lt;= ");
            }
            stringBuffer.append(nArray[n] / 2);
            return;
        }
        if (n == 0) {
            if (decision instanceof BooleanDecision) {
                if (bl) {
                    stringBuffer.append(this.primeBooleanDecision(((BooleanDecision)decision).getVar()));
                } else {
                    stringBuffer.append(((BooleanDecision)decision).getVar().replace("<", "&lt;").replace(">", "&gt;"));
                }
            } else if (decision instanceof EventDecision) {
                if (bl) {
                    throw new RuntimeException("No primed variable allowed here");
                }
                String string = ((EventDecision)decision).getEvent();
                if (!this.events.contains(string)) {
                    this.events.add(string);
                }
                stringBuffer.append("! " + string + " = " + string + "'");
            }
        } else if (decision instanceof BooleanDecision) {
            stringBuffer.append("! ");
            if (bl) {
                stringBuffer.append(this.primeBooleanDecision(((BooleanDecision)decision).getVar()));
            } else {
                stringBuffer.append(((BooleanDecision)decision).getVar().replace("<", "&lt;").replace(">", "&gt;"));
            }
        } else if (decision instanceof EventDecision) {
            if (bl) {
                throw new RuntimeException("No primed variable allowed here");
            }
            String string = ((EventDecision)decision).getEvent();
            if (!this.events.contains(string)) {
                this.events.add(string);
            }
            stringBuffer.append(string + " = " + string + "'");
        }
    }

    public String primeBooleanDecision(String string) {
        String[] stringArray = string.split("<=");
        if (stringArray.length == 2) {
            int n = 0;
            while (n < 2) {
                if (!stringArray[n].matches("(\\d)+")) {
                    stringArray[n] = stringArray[n].trim() + "'";
                }
                ++n;
            }
            return stringArray[0] + " &lt;= " + stringArray[1];
        }
        stringArray = string.split(">=");
        if (stringArray.length == 2) {
            int n = 0;
            while (n < 2) {
                if (!stringArray[n].matches("(\\d)+")) {
                    stringArray[n] = stringArray[n].trim() + "'";
                }
                ++n;
            }
            return stringArray[0] + " &gt;= " + stringArray[1];
        }
        stringArray = string.split("!=");
        if (stringArray.length == 2) {
            int n = 0;
            while (n < 2) {
                if (!stringArray[n].matches("(\\d)+")) {
                    stringArray[n] = stringArray[n].trim() + "'";
                }
                ++n;
            }
            return stringArray[0] + " != " + stringArray[1];
        }
        stringArray = string.split("<");
        if (stringArray.length == 2) {
            int n = 0;
            while (n < 2) {
                if (!stringArray[n].matches("(\\d)+")) {
                    stringArray[n] = stringArray[n].trim() + "'";
                }
                ++n;
            }
            return stringArray[0] + " &lt; " + stringArray[1];
        }
        stringArray = string.split(">");
        if (stringArray.length == 2) {
            int n = 0;
            while (n < 2) {
                if (!stringArray[n].matches("(\\d)+")) {
                    stringArray[n] = stringArray[n].trim() + "'";
                }
                ++n;
            }
            return stringArray[0] + " &gt; " + stringArray[1];
        }
        stringArray = string.split("=");
        if (stringArray.length == 2) {
            int n = 0;
            while (n < 2) {
                if (!stringArray[n].matches("(\\d)+")) {
                    stringArray[n] = stringArray[n].trim() + "'";
                }
                ++n;
            }
            return stringArray[0] + " = " + stringArray[1];
        }
        return string.trim() + "'";
    }
}

