/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.SortedSet;
import java.util.TreeSet;

public class TreePriorityQueue<E>
implements Queue<E> {
    private final TreeSet<E> mQueue;

    public TreePriorityQueue() {
        this.mQueue = new TreeSet();
    }

    public TreePriorityQueue(Comparator<E> comparator) {
        this.mQueue = new TreeSet<E>(comparator);
    }

    public TreePriorityQueue(Collection<E> collection) {
        this.mQueue = new TreeSet<E>(collection);
    }

    public TreePriorityQueue(SortedSet<E> sortedSet) {
        this.mQueue = new TreeSet<E>(sortedSet);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.mQueue.addAll(collection);
    }

    @Override
    public void clear() {
        this.mQueue.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.mQueue.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mQueue.containsAll(collection);
    }

    @Override
    public boolean isEmpty() {
        return this.mQueue.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mQueue.iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.mQueue.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.mQueue.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.mQueue.retainAll(collection);
    }

    @Override
    public int size() {
        return this.mQueue.size();
    }

    @Override
    public Object[] toArray() {
        return this.mQueue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.mQueue.toArray(TArray);
    }

    @Override
    public boolean add(E e) {
        return this.mQueue.add(e);
    }

    @Override
    public E element() {
        return this.mQueue.first();
    }

    @Override
    public boolean offer(E e) {
        return this.mQueue.add(e);
    }

    @Override
    public E peek() {
        if (this.mQueue.isEmpty()) {
            return null;
        }
        return this.mQueue.first();
    }

    @Override
    public E poll() {
        return this.mQueue.pollFirst();
    }

    @Override
    public E remove() {
        if (this.mQueue.isEmpty()) {
            throw new NoSuchElementException("The Queue is Empty");
        }
        return this.mQueue.pollFirst();
    }
}

