/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.SupportingInvariant;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.TerminationArgument;
import de.uni_freiburg.informatik.ultimate.lassoranker.termination.rankingfunctions.RankingFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineSubtermNormalizer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.generator.buchiautomizer.Activator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BinaryStatePredicateManager {
    private static final boolean SIMPLIFY_SUPPORTING_INVARIANTS = true;
    private static final boolean ANNOTATE = false;
    private final Script mScript;
    private final ManagedScript mManagedScript;
    private final PredicateFactory mPredicateFactory;
    private final IProgramNonOldVar mUnseededVariable;
    private final IProgramNonOldVar[] mOldRankVariables;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private IPredicate mRankEquality;
    private IPredicate mRankDecreaseAndBound;
    private Term[] mLexTerms;
    private IPredicate[] mLexEquality;
    private IPredicate[] mLexDecrease;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;

    public BinaryStatePredicateManager(CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, IProgramNonOldVar iProgramNonOldVar, IProgramNonOldVar[] iProgramNonOldVarArray, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mScript = cfgSmtToolkit.getManagedScript().getScript();
        this.mPredicateFactory = predicateFactory;
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
        this.mUnseededVariable = iProgramNonOldVar;
        this.mOldRankVariables = iProgramNonOldVarArray;
    }

    public BspmResult computePredicates(TerminationArgument terminationArgument, boolean bl, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, Set<IProgramNonOldVar> set) {
        IPredicate iPredicate;
        IPredicate iPredicate2;
        IPredicate iPredicate3;
        IPredicate iPredicate4 = this.unseededPredicate();
        this.decodeLex(terminationArgument.getRankingFunction());
        this.mRankEquality = this.mPredicateFactory.and(this.mLexEquality);
        this.mRankDecreaseAndBound = this.computeRankDecreaseAndBound();
        IPredicate iPredicate5 = this.computeSiConjunction(terminationArgument.getSupportingInvariants(), terminationArgument.getArrayIndexSupportingInvariants(), bl, unmodifiableTransFormula, unmodifiableTransFormula2, set);
        IPredicate iPredicate6 = this.mPredicateFactory.or(new IPredicate[]{iPredicate4, this.mRankDecreaseAndBound});
        if (SmtUtils.isTrueLiteral((Term)iPredicate5.getFormula())) {
            iPredicate3 = iPredicate4;
            iPredicate2 = this.mRankEquality;
            iPredicate = iPredicate6;
        } else {
            iPredicate3 = this.mPredicateFactory.and(new IPredicate[]{iPredicate4, iPredicate5});
            iPredicate2 = this.mPredicateFactory.and(new IPredicate[]{this.mRankEquality, iPredicate5});
            iPredicate = this.mPredicateFactory.and(new IPredicate[]{iPredicate5, iPredicate6});
        }
        return new BspmResult(terminationArgument, this.mRankEquality, this.mRankDecreaseAndBound, iPredicate4, iPredicate3, iPredicate5, iPredicate, iPredicate2, this.mOldRankVariables);
    }

    private List<Term> removeSuperfluousSupportingInvariants(List<Term> list, UnmodifiableTransFormula unmodifiableTransFormula, Set<IProgramNonOldVar> set) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        int n = 0;
        while (n < list.size()) {
            Term[] termArray = BinaryStatePredicateManager.startingFromIPlusList(list, n + 1, arrayList);
            boolean bl = this.isSupportingInvariant(termArray, unmodifiableTransFormula, set);
            if (!bl) {
                arrayList.add(list.get(n));
            }
            ++n;
        }
        n = list.size() - arrayList.size();
        this.mLogger.info((Object)(n + " out of " + list.size() + " supporting invariants were superfluous and have been removed"));
        return arrayList;
    }

    private boolean isSupportingInvariant(Term[] termArray, UnmodifiableTransFormula unmodifiableTransFormula, Set<IProgramNonOldVar> set) {
        ArrayList<Term> arrayList = new ArrayList<Term>(Arrays.asList(termArray));
        arrayList.add(this.mRankEquality.getFormula());
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(SmtUtils.and((Script)this.mScript, arrayList));
        ArrayList<Term> arrayList2 = new ArrayList<Term>(Arrays.asList(termArray));
        arrayList2.add(this.mRankDecreaseAndBound.getFormula());
        BasicPredicate basicPredicate2 = this.mPredicateFactory.newPredicate(SmtUtils.and((Script)this.mScript, arrayList2));
        Script.LBool lBool = PredicateUtils.isInductiveHelper((Script)this.mScript, (IPredicate)basicPredicate, (IPredicate)basicPredicate2, (UnmodifiableTransFormula)unmodifiableTransFormula, set, set);
        return switch (lBool) {
            case Script.LBool.UNKNOWN, Script.LBool.SAT -> false;
            case Script.LBool.UNSAT -> true;
            default -> throw new MatchException(null, null);
        };
    }

    private boolean assertSupportingInvariant(Term[] termArray, UnmodifiableTransFormula unmodifiableTransFormula, Set<IProgramNonOldVar> set) {
        ArrayList<Term> arrayList = new ArrayList<Term>(Arrays.asList(termArray));
        arrayList.add(this.mRankEquality.getFormula());
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(SmtUtils.and((Script)this.mScript, arrayList));
        ArrayList<Term> arrayList2 = new ArrayList<Term>(Arrays.asList(termArray));
        arrayList2.add(this.mRankDecreaseAndBound.getFormula());
        ArrayList<Term> arrayList3 = new ArrayList<Term>();
        for (Term term : arrayList2) {
            arrayList3.addAll(Arrays.asList(SmtUtils.getConjuncts((Term)term)));
        }
        for (Term term : arrayList3) {
            BasicPredicate basicPredicate2 = this.mPredicateFactory.newPredicate(term);
            Script.LBool lBool = PredicateUtils.isInductiveHelper((Script)this.mScript, (IPredicate)basicPredicate, (IPredicate)basicPredicate2, (UnmodifiableTransFormula)unmodifiableTransFormula, set, set);
            if (lBool != Script.LBool.UNSAT) {
                throw new AssertionError((Object)("Incorrect supporting invariant. Not inductive: " + String.valueOf(term)));
            }
        }
        return true;
    }

    private static Term[] startingFromIPlusList(List<Term> list, int n, List<Term> list2) {
        ArrayList<Term> arrayList = new ArrayList<Term>(list.size() + n + list.size());
        int n2 = n;
        while (n2 < list.size()) {
            arrayList.add(list.get(n2));
            ++n2;
        }
        arrayList.addAll(list2);
        return arrayList.toArray(new Term[arrayList.size()]);
    }

    private IPredicate unseededPredicate() {
        HashSet<IProgramNonOldVar> hashSet = new HashSet<IProgramNonOldVar>(1);
        hashSet.add(this.mUnseededVariable);
        TermVariable termVariable = this.mUnseededVariable.getTermVariable();
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate((Term)termVariable);
        return basicPredicate;
    }

    private IPredicate computeSiConjunction(Collection<SupportingInvariant> collection, Collection<Term> collection2, boolean bl, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, Set<IProgramNonOldVar> set) {
        Term term;
        Object object2;
        List<Term> list = new ArrayList<Term>(collection.size() + collection2.size());
        for (Object object2 : collection) {
            term = object2.asTerm(this.mManagedScript.getScript());
            list.add(term);
        }
        list.addAll(collection2);
        if (!this.impliedByStem(unmodifiableTransFormula, list, set)) {
            object2 = new DagSizePrinter(unmodifiableTransFormula.getFormula()).toString();
            throw new AssertionError((Object)("Supporting invariant not implied by stem. Stem size: " + (String)object2));
        }
        if (bl) {
            assert (this.assertSupportingInvariant(list.toArray(new Term[list.size()]), unmodifiableTransFormula2, set));
            list = this.removeSuperfluousSupportingInvariants(list, unmodifiableTransFormula2, set);
            assert (this.assertSupportingInvariant(list.toArray(new Term[list.size()]), unmodifiableTransFormula2, set));
        }
        object2 = SmtUtils.and((Script)this.mScript, list);
        term = SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)object2, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
        Term term2 = new AffineSubtermNormalizer(this.mManagedScript.getScript()).transform(term);
        Term term3 = term2;
        if (SmtUtils.isFalseLiteral((Term)term3)) {
            throw new AssertionError((Object)"Supporting invariant is false. This is impossible since we only consider feasible stems.");
        }
        return this.mPredicateFactory.newPredicate(term3);
    }

    private boolean impliedByStem(UnmodifiableTransFormula unmodifiableTransFormula, List<Term> list, Set<IProgramNonOldVar> set) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (Term term : list) {
            boolean bl = this.isInductive(Collections.singleton(this.mManagedScript.getScript().term("true", new Term[0])), set, unmodifiableTransFormula, Collections.singleton(term), set);
            if (bl) {
                arrayList.add(term);
                continue;
            }
            arrayList2.add(term);
        }
        assert (arrayList2.isEmpty()) : "The following invariants are not implied by stem " + arrayList2.toString();
        return arrayList2.isEmpty();
    }

    private boolean isInductive(Set<Term> set, Set<IProgramNonOldVar> set2, UnmodifiableTransFormula unmodifiableTransFormula, Set<Term> set3, Set<IProgramNonOldVar> set4) {
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(SmtUtils.and((Script)this.mScript, set));
        BasicPredicate basicPredicate2 = this.mPredicateFactory.newPredicate(SmtUtils.and((Script)this.mScript, set3));
        Script.LBool lBool = PredicateUtils.isInductiveHelper((Script)this.mManagedScript.getScript(), (IPredicate)basicPredicate, (IPredicate)basicPredicate2, (UnmodifiableTransFormula)unmodifiableTransFormula, set2, set4);
        return lBool == Script.LBool.UNSAT;
    }

    private void decodeLex(RankingFunction rankingFunction) {
        this.mLexTerms = rankingFunction.asLexTerm(this.mScript);
        this.mLexEquality = new IPredicate[this.mLexTerms.length];
        int n = 0;
        while (n < this.mLexTerms.length) {
            this.mLexEquality[n] = this.getRankInEquality(this.mLexTerms[n], ">=", (IProgramVar)this.mOldRankVariables[n], false);
            ++n;
        }
        this.mLexDecrease = new IPredicate[this.mLexTerms.length];
        n = 0;
        while (n < this.mLexTerms.length) {
            this.mLexDecrease[n] = this.getRankInEquality(this.mLexTerms[n], ">", (IProgramVar)this.mOldRankVariables[n], true);
            ++n;
        }
    }

    private IPredicate computeRankDecreaseAndBound() {
        IPredicate[] iPredicateArray = new IPredicate[this.mLexTerms.length];
        int n = 0;
        while (n < this.mLexTerms.length) {
            IPredicate[] iPredicateArray2 = new IPredicate[n + 1];
            System.arraycopy(this.mLexEquality, 0, iPredicateArray2, 0, n);
            iPredicateArray2[n] = this.mLexDecrease[n];
            iPredicateArray[n] = this.mPredicateFactory.and(iPredicateArray2);
            ++n;
        }
        IPredicate iPredicate = this.mPredicateFactory.or(iPredicateArray);
        return iPredicate;
    }

    private IPredicate getRankInEquality(Term term, String string, IProgramVar iProgramVar, boolean bl) {
        assert (string.equals(">=") || string.equals(">"));
        Term term2 = this.mScript.term(string, new Term[]{iProgramVar.getTermVariable(), term});
        if (bl) {
            term2 = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{term2, this.getRankGeq0(iProgramVar)});
        }
        BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(term2);
        return basicPredicate;
    }

    private Term getRankGeq0(IProgramVar iProgramVar) {
        Term term = this.mScript.term(">=", new Term[]{iProgramVar.getTermVariable(), SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ZERO)});
        return term;
    }

    public static class BspmResult {
        private final TerminationArgument mTerminationArgument;
        private final IPredicate mRankEquality;
        private final IPredicate mRankDecreaseAndBound;
        private final IPredicate mStemPrecondition;
        private final IPredicate mStemPostcondition;
        private final IPredicate mSiConjunction;
        private final IPredicate mHonda;
        private final IPredicate mRankEqualityAndSi;
        private final IProgramNonOldVar[] mOldRankVariables;

        public BspmResult(TerminationArgument terminationArgument, IPredicate iPredicate, IPredicate iPredicate2, IPredicate iPredicate3, IPredicate iPredicate4, IPredicate iPredicate5, IPredicate iPredicate6, IPredicate iPredicate7, IProgramNonOldVar[] iProgramNonOldVarArray) {
            this.mTerminationArgument = terminationArgument;
            this.mRankEquality = iPredicate;
            this.mRankDecreaseAndBound = iPredicate2;
            this.mStemPrecondition = iPredicate3;
            this.mStemPostcondition = iPredicate4;
            this.mSiConjunction = iPredicate5;
            this.mHonda = iPredicate6;
            this.mRankEqualityAndSi = iPredicate7;
            this.mOldRankVariables = iProgramNonOldVarArray;
        }

        public TerminationArgument getTerminationArgument() {
            return this.mTerminationArgument;
        }

        public IPredicate getRankEquality() {
            return this.mRankEquality;
        }

        public IPredicate getRankDecreaseAndBound() {
            return this.mRankDecreaseAndBound;
        }

        public IPredicate getStemPrecondition() {
            return this.mStemPrecondition;
        }

        public IPredicate getStemPostcondition() {
            return this.mStemPostcondition;
        }

        public IPredicate getSiConjunction() {
            return this.mSiConjunction;
        }

        public IPredicate getHondaPredicate() {
            return this.mHonda;
        }

        public IPredicate getRankEqAndSi() {
            return this.mRankEqualityAndSi;
        }

        public IProgramNonOldVar[] getOldRankVariables() {
            return this.mOldRankVariables;
        }
    }
}

