/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.CheckClosedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbolFactory;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.logic.simplification.SimplifyDDA;
import de.uni_freiburg.informatik.ultimate.smtinterpol.DefaultLogger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.Interpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.OptionMap;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.SolverOptions;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.MinimalProofChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofSimplifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofTermGenerator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.UnsatCoreCollector;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.ErrorCallback;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ResourceLimit;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.TimeoutHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SMTInterpol
extends NoopScript {
    private final OptionMap mOptions;
    private final SolverOptions mSolverOptions;
    private BigDecimal mSMTLIBVersion = new BigDecimal("2.0");
    private static final BigDecimal TWO_POINT_FIVE = new BigDecimal("2.5");
    private DPLLEngine mEngine;
    private Clausifier mClausifier;
    private ScopedArrayList<Term> mAssertions;
    private TerminationRequest mCancel;
    private TimeoutHandler mTimeout;
    private ResourceLimit mResourceLimit;
    private final LogProxy mLogger;
    Model mModel = null;
    private static final Object NAME = new QuotedObject("SMTInterpol", true);
    private static final Object AUTHORS = new QuotedObject("Juergen Christ, Jochen Hoenicke, Alexander Nutz, and Tanja Schindler", true);
    private static final Object INTERPOLATION_METHOD = new QuotedObject("tree", true);
    private Script.LBool mStatus = Script.LBool.SAT;
    private Script.LBool mStatusInfo = Script.LBool.UNKNOWN;
    private ReasonUnknown mReasonUnknown = null;
    private boolean mAssertionStackModified = true;
    private long mNextQuickCheck = 1L;
    private long mNumAsserts = 0L;
    private ErrorCallback mErrorCallback = null;

    public SMTInterpol() {
        this((LogProxy)new DefaultLogger(), null);
    }

    public SMTInterpol(LogProxy logProxy) {
        this(logProxy, null);
    }

    @Deprecated
    public SMTInterpol(LogProxy logProxy, boolean bl) {
        this(logProxy, null);
    }

    public SMTInterpol(TerminationRequest terminationRequest) {
        this((LogProxy)new DefaultLogger(), terminationRequest);
    }

    public SMTInterpol(LogProxy logProxy, TerminationRequest terminationRequest) {
        this(terminationRequest, new OptionMap(logProxy));
    }

    public SMTInterpol(OptionMap optionMap) {
        this(null, optionMap);
    }

    public SMTInterpol(TerminationRequest terminationRequest, OptionMap optionMap) {
        this.mLogger = optionMap.getLogProxy();
        this.mOptions = optionMap;
        this.mSolverOptions = optionMap.getSolverOptions();
        this.mCancel = terminationRequest;
        this.mTimeout = new TimeoutHandler(this.mCancel);
        this.mResourceLimit = new ResourceLimit(this.mTimeout);
        this.reset();
    }

    @Deprecated
    public SMTInterpol(LogProxy logProxy, boolean bl, TerminationRequest terminationRequest) {
        this(logProxy, terminationRequest);
    }

    public SMTInterpol(SMTInterpol sMTInterpol, Map<String, Object> map, OptionMap.CopyMode copyMode) {
        super(sMTInterpol.getTheory());
        this.mLogger = sMTInterpol.mLogger;
        this.mOptions = sMTInterpol.mOptions.copy(copyMode);
        this.mSolverOptions = this.mOptions.getSolverOptions();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.setOption(entry.getKey(), entry.getValue());
            }
        }
        this.mCancel = sMTInterpol.mCancel;
        this.mTimeout = sMTInterpol.mTimeout;
        this.mResourceLimit = sMTInterpol.mResourceLimit;
        this.setupClausifier(this.getTheory().getLogic());
    }

    public void setErrorCallback(ErrorCallback errorCallback) {
        this.mErrorCallback = errorCallback;
    }

    public final void reset() {
        super.reset();
        this.mEngine = null;
        this.mModel = null;
        this.mAssertionStackModified = true;
        if (this.mAssertions != null) {
            this.mAssertions.clear();
        }
        this.mOptions.reset();
        this.mNextQuickCheck = 1L;
        this.mNumAsserts = 0L;
    }

    public final void resetAssertions() {
        super.resetAssertions();
        this.mAssertionStackModified = true;
        if (this.mAssertions != null) {
            this.mAssertions.clear();
        }
        this.setupClausifier(this.getTheory().getLogic());
    }

    public void push(int n) throws SMTLIBException {
        super.push(n);
        this.modifyAssertionStack();
        while (n-- > 0) {
            if (this.mAssertions != null) {
                this.mAssertions.beginScope();
            }
            this.mClausifier.push();
        }
    }

    public void pop(int n) throws SMTLIBException {
        try {
            super.pop(n);
        }
        catch (SMTLIBException sMTLIBException) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.ERROR_ON_POP);
            }
            throw sMTLIBException;
        }
        this.modifyAssertionStack();
        int n2 = n;
        while (n2-- > 0) {
            if (this.mAssertions == null) continue;
            this.mAssertions.endScope();
        }
        this.mClausifier.pop(n);
    }

    public Script.LBool checkSat() throws SMTLIBException {
        return this.checkSatAssuming(new Term[0]);
    }

    public Script.LBool checkSatAssuming(Term ... termArray) throws SMTLIBException {
        MinimalProofChecker minimalProofChecker;
        long l;
        long l2;
        Script.LBool lBool;
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.mModel = null;
        this.mAssertionStackModified = false;
        this.mEngine.clearAssumptions();
        if (termArray != null && termArray.length != 0) {
            Literal[] literalArray;
            Term[] termArray2 = termArray;
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                literalArray = termArray2[n2];
                if (!(literalArray instanceof ApplicationTerm)) {
                    throw new SMTLIBException("Assumption is not a boolean constant");
                }
                lBool = (ApplicationTerm)literalArray;
                if (lBool.getSort() != this.getTheory().getBooleanSort()) {
                    throw new SMTLIBException("Assumption is not a boolean constant");
                }
                if (lBool.getParameters().length > 1 || lBool.getParameters().length == 1 && !lBool.getFunction().getName().equals("not")) {
                    throw new SMTLIBException("Assumption is not a boolean constant");
                }
                ++n2;
            }
            if (!this.mEngine.quickCheck()) {
                return Script.LBool.UNSAT;
            }
            literalArray = new Literal[termArray.length];
            n2 = 0;
            while (n2 < termArray.length) {
                literalArray[n2] = this.mClausifier.getCreateLiteral(termArray[n2], new SourceAnnotation("", null));
                ++n2;
            }
            this.mEngine.assume(literalArray);
        }
        if ((l2 = this.mSolverOptions.getTimeout()) > 0L) {
            this.mTimeout.setTimeout(l2);
        }
        if ((l = this.mSolverOptions.getReproducibleResourceLimit()) > 0L) {
            this.mResourceLimit.setResourceLimit(l);
        }
        lBool = Script.LBool.UNKNOWN;
        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
        this.mEngine.setRandomSeed(this.mSolverOptions.getRandomSeed());
        try {
            lBool = this.mSolverOptions.getCheckType().check(this.mEngine) ? Script.LBool.SAT : Script.LBool.UNSAT;
        }
        catch (RuntimeException runtimeException) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.EXCEPTION_ON_CHECKSAT);
            }
            throw runtimeException;
        }
        if (lBool == Script.LBool.SAT) {
            if (this.mEngine.hasModel()) {
                if (this.mSolverOptions.isModelCheckModeActive()) {
                    try {
                        this.mModel = new Model(this.mClausifier, this.getTheory());
                        if (!this.mModel.checkTypeValues(this.mLogger) && this.mErrorCallback != null) {
                            this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.INVALID_MODEL);
                        }
                        for (Term term : this.mAssertions) {
                            Term term2 = this.mModel.evaluate(term);
                            if (term2 == this.getTheory().mTrue) continue;
                            this.mLogger.fatal("Model does not satisfy " + term.toStringDirect());
                            if (this.mErrorCallback != null) {
                                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.INVALID_MODEL);
                            }
                            lBool = Script.LBool.UNKNOWN;
                            this.mReasonUnknown = ReasonUnknown.CRASHED;
                        }
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        this.mLogger.warn("Model check mode not working: %s", unsupportedOperationException.getMessage());
                    }
                    catch (SMTLIBException sMTLIBException) {
                        this.mLogger.warn("Model check mode not working: %s", sMTLIBException.getMessage());
                    }
                }
            } else {
                lBool = Script.LBool.UNKNOWN;
                switch (this.mEngine.getCompleteness()) {
                    case 0: {
                        if (this.mSolverOptions.getCheckType() == CheckType.FULL) {
                            throw new InternalError("Complete but no model?");
                        }
                        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                        break;
                    }
                    case 3: {
                        this.mReasonUnknown = ReasonUnknown.MEMOUT;
                        break;
                    }
                    case 5: {
                        this.mReasonUnknown = ReasonUnknown.TIMEOUT;
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                        break;
                    }
                    case 4: {
                        this.mReasonUnknown = ReasonUnknown.CRASHED;
                        break;
                    }
                    case 6: {
                        this.mReasonUnknown = ReasonUnknown.INCOMPLETE;
                        break;
                    }
                    case 7: {
                        this.mReasonUnknown = ReasonUnknown.CANCELLED;
                        break;
                    }
                    default: {
                        throw new InternalError("Unknown incompleteness reason");
                    }
                }
                this.mLogger.debug("Got %s as reason to return unknown", this.mEngine.getCompletenessReason());
            }
        } else if (this.mSolverOptions.isProofCheckModeActive() && !(minimalProofChecker = new MinimalProofChecker((Script)this, this.getLogger())).check(this.getProof())) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.INVALID_PROOF);
            }
            this.mLogger.fatal("Proof-checker did not verify");
            throw new SMTLIBException("Proof-check failed");
        }
        this.mStatus = lBool;
        if (this.isStatusSet() && lBool != Script.LBool.UNKNOWN && !lBool.equals((Object)this.mStatusInfo)) {
            this.mLogger.warn("Status differs: User said %s but we got %s", this.mStatusInfo, lBool);
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.CHECKSAT_STATUS_DIFFERS);
            }
        }
        this.mStatusInfo = Script.LBool.UNKNOWN;
        this.mTimeout.clearTimeout();
        this.mResourceLimit.clearResourceLimit();
        return lBool;
    }

    private final boolean isStatusSet() {
        return this.mStatusInfo != Script.LBool.UNKNOWN;
    }

    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        try {
            this.setLogic(Logics.valueOf((String)string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException("Logic " + string + " not supported");
        }
    }

    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        this.mSolverSetup = new SMTInterpolSetup();
        super.setLogic(logics);
        this.setupClausifier(logics);
    }

    private void setupClausifier(Logics logics) {
        try {
            ProofMode proofMode = this.getProofMode();
            this.mEngine = new DPLLEngine(this.mLogger, this.mResourceLimit);
            this.mClausifier = new Clausifier(this.getTheory(), this.mEngine, proofMode);
            this.mEngine.setProofGeneration(proofMode != ProofMode.NONE);
            this.mClausifier.setQuantifierOptions(this.getBooleanOption(":epr"), this.mSolverOptions.getInstantiationMethod(), this.getBooleanOption(":unknown-term-dawgs"), this.getBooleanOption(":propagate-unknown-terms"), this.getBooleanOption(":propagate-unknown-aux"));
            this.mClausifier.setLogic(logics);
            boolean bl = this.getBooleanOption(":produce-assignments");
            this.mClausifier.setAssignmentProduction(bl);
            this.mEngine.setProduceAssignments(bl);
            this.mEngine.setRandomSeed(this.mSolverOptions.getRandomSeed());
            if (this.getBooleanOption(":produce-assertions") || this.mSolverOptions.isProduceProofs() && this.mSolverOptions.getProofMode() == ProofMode.LOWLEVEL || this.mSolverOptions.isProduceInterpolants() || this.mSolverOptions.isProofCheckModeActive() || this.mSolverOptions.isModelCheckModeActive() || this.getBooleanOption(":unsat-core-check-mode") || this.getBooleanOption(":unsat-assumptions-check-mode")) {
                this.mAssertions = new ScopedArrayList();
            }
            this.mOptions.setOnline();
            this.getTheory().setGlobalSymbols(this.getBooleanOption(":global-declarations"));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            super.reset();
            this.mEngine = null;
            this.mClausifier = null;
            throw unsupportedOperationException;
        }
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        long l;
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        long l2 = this.mSolverOptions.getTimeout();
        if (l2 > 0L) {
            this.mTimeout.setTimeout(l2);
        }
        if ((l = this.mSolverOptions.getReproducibleResourceLimit()) > 0L) {
            this.mResourceLimit.setResourceLimit(l);
        }
        super.assertTerm(term);
        if (!term.getSort().equals(this.getTheory().getBooleanSort())) {
            if (term.getSort().getTheory() == this.getTheory()) {
                throw new SMTLIBException("Asserted terms must have sort Bool");
            }
            throw new SMTLIBException("Asserted terms created with incompatible theory");
        }
        if (!new CheckClosedTerm().isClosed(term)) {
            throw new SMTLIBException("Asserted terms must be closed");
        }
        try {
            this.modifyAssertionStack();
            if (this.mEngine.inconsistent()) {
                this.mLogger.info("Asserting into inconsistent context");
                if (this.mAssertions != null) {
                    this.mAssertions.add(term);
                }
                return Script.LBool.UNSAT;
            }
            this.mClausifier.addFormula(term);
            if (this.mAssertions != null) {
                this.mAssertions.add(term);
            }
            if (this.mNumAsserts++ >= this.mNextQuickCheck) {
                this.mNextQuickCheck *= 2L;
                if (!this.mEngine.quickCheck()) {
                    this.mLogger.info("Assertion made context inconsistent");
                    return Script.LBool.UNSAT;
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new SMTLIBException(unsupportedOperationException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.EXCEPTION_ON_ASSERT);
            }
            throw runtimeException;
        }
        catch (AssertionError assertionError) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.EXCEPTION_ON_ASSERT);
            }
            throw assertionError;
        }
        this.mTimeout.clearTimeout();
        this.mResourceLimit.clearResourceLimit();
        return Script.LBool.UNKNOWN;
    }

    public Term[] getAssertions() throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (this.mAssertions != null) {
            return this.mAssertions.toArray(new Term[this.mAssertions.size()]);
        }
        throw new SMTLIBException("Set option :interactive-mode to true to get assertions!");
    }

    public Assignments getAssignment() throws SMTLIBException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.mEngine.isProduceAssignments()) {
            throw new SMTLIBException("Set option :produce-assignments to true to generate assignments!");
        }
        this.checkAssertionStackModified();
        return this.mEngine.getAssignments();
    }

    public Object getInfo(String string) throws UnsupportedOperationException {
        switch (string) {
            case ":status": {
                return this.mStatus;
            }
            case ":name": {
                return NAME;
            }
            case ":version": {
                return new QuotedObject("2.5-1381-g0e9bd0bf", this.mSMTLIBVersion.compareTo(TWO_POINT_FIVE) >= 0);
            }
            case ":authors": {
                return AUTHORS;
            }
            case ":all-statistics": {
                return this.mEngine == null ? new Object[]{} : this.mEngine.getStatistics();
            }
            case ":status-set": {
                return this.mStatusInfo;
            }
            case ":options": {
                return this.mOptions.getInfo();
            }
            case ":reason-unknown": {
                if (this.mStatus != Script.LBool.UNKNOWN) {
                    throw new SMTLIBException("Status not unknown");
                }
                return this.mReasonUnknown;
            }
            case ":assertion-stack-levels": {
                return this.mStackLevel;
            }
            case ":interpolation-method": {
                return INTERPOLATION_METHOD;
            }
        }
        return this.mOptions.getInfo(string, this.mSMTLIBVersion.compareTo(TWO_POINT_FIVE) >= 0);
    }

    public Object getOption(String string) throws UnsupportedOperationException {
        return this.mOptions.get(string);
    }

    private ProofMode getProofMode() {
        return this.mSolverOptions.getProofMode();
    }

    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        ProofMode proofMode = this.getProofMode();
        if (proofMode == ProofMode.NONE) {
            throw new SMTLIBException("Option :produce-proofs not set to true");
        }
        return this.getProof(proofMode);
    }

    public Term getProof(ProofMode proofMode) throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.checkAssertionStackModified();
        Clause clause = this.retrieveProof();
        try {
            ProofTermGenerator proofTermGenerator = new ProofTermGenerator(new ProofRules(this.getTheory()));
            Term term = proofTermGenerator.convert(clause);
            if (proofMode == ProofMode.LOWLEVEL) {
                term = new ProofSimplifier((Script)this).transformProof(term);
            }
            return term;
        }
        catch (Exception exception) {
            throw new SMTLIBException(exception.getMessage() == null ? exception.toString() : exception.getMessage());
        }
    }

    public Term[] getInterpolants(Term[] termArray, int[] nArray) {
        if (this.getProofMode() == ProofMode.NONE || this.mAssertions == null) {
            throw new SMTLIBException("Option :produce-interpolants not set to true");
        }
        return this.getInterpolants(termArray, nArray, this.getProof(ProofMode.CLAUSES));
    }

    public Term[] getInterpolants(Term[] termArray, int[] nArray, Term term) {
        long l;
        long l2 = this.mSolverOptions.getTimeout();
        if (l2 > 0L) {
            this.mTimeout.setTimeout(l2);
        }
        if ((l = this.mSolverOptions.getReproducibleResourceLimit()) > 0L) {
            this.mResourceLimit.setResourceLimit(l);
        }
        try {
            int n;
            SimplifyDDA simplifyDDA;
            Term[] termArray2;
            int n2;
            if (termArray.length != nArray.length) {
                throw new SMTLIBException("Partition table and subtree array need to have equal length");
            }
            int n3 = 0;
            while (n3 < termArray.length) {
                if (nArray[n3] < 0) {
                    throw new SMTLIBException("subtree array must not contain negative element");
                }
                n2 = n3;
                while (nArray[n3] < n2) {
                    n2 = nArray[n2 - 1];
                }
                if (nArray[n3] != n2) {
                    throw new SMTLIBException("malformed subtree array.");
                }
                ++n3;
            }
            if (nArray[termArray.length - 1] != 0) {
                throw new SMTLIBException("malformed subtree array.");
            }
            Set[] setArray = new Set[termArray.length];
            n2 = 0;
            while (n2 < termArray.length) {
                if (!(termArray[n2] instanceof ApplicationTerm)) {
                    throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                }
                termArray2 = ((ApplicationTerm)termArray[n2]).getFunction();
                if (termArray2.isIntern()) {
                    if (!termArray2.getName().equals("and")) {
                        throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                    }
                    simplifyDDA = ((ApplicationTerm)termArray[n2]).getParameters();
                } else {
                    simplifyDDA = new SimplifyDDA[]{termArray[n2]};
                }
                setArray[n2] = new HashSet();
                n = 0;
                while (n < ((Term[])simplifyDDA).length) {
                    if (!(simplifyDDA[n] instanceof ApplicationTerm)) {
                        throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                    }
                    ApplicationTerm applicationTerm = (ApplicationTerm)simplifyDDA[n];
                    if (applicationTerm.getParameters().length != 0) {
                        throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                    }
                    if (applicationTerm.getFunction().isIntern()) {
                        throw new SMTLIBException("arguments must be named terms or conjunctions of named terms");
                    }
                    setArray[n2].add(applicationTerm.getFunction().getName().intern());
                    ++n;
                }
                ++n2;
            }
            SMTInterpol sMTInterpol = null;
            if (this.mSolverOptions.isInterpolantCheckModeActive()) {
                termArray2 = Collections.singletonMap(":produce-assertions", Boolean.TRUE);
                sMTInterpol = new SMTInterpol(this, (Map<String, Object>)termArray2, OptionMap.CopyMode.CURRENT_VALUE);
            }
            try {
                simplifyDDA = new Interpolator(this.mLogger, (Script)sMTInterpol, this.mAssertions, this.getTheory(), setArray, nArray, this.mResourceLimit);
                termArray2 = simplifyDDA.getInterpolants(term);
                if (sMTInterpol != null) {
                    this.mLogger.info("FOUND VALID INTERPOLANT");
                }
            }
            finally {
                if (sMTInterpol != null) {
                    sMTInterpol.exit();
                    sMTInterpol = null;
                }
            }
            if (this.mSolverOptions.isSimplifyInterpolants()) {
                simplifyDDA = new SimplifyDDA((Script)new SMTInterpol(this, Collections.singletonMap(":check-type", this.mSolverOptions.getSimplifierCheckType()), OptionMap.CopyMode.CURRENT_VALUE), this.getBooleanOption(":simplify-repeatedly"));
                n = 0;
                while (n < termArray2.length) {
                    termArray2[n] = simplifyDDA.getSimplifiedTerm(termArray2[n]);
                    ++n;
                }
            }
            Term[] termArray3 = termArray2;
            return termArray3;
        }
        catch (SMTLIBException sMTLIBException) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.ERROR_ON_GET_INTERPOLANTS);
            }
            throw sMTLIBException;
        }
        finally {
            this.mTimeout.clearTimeout();
            this.mResourceLimit.clearResourceLimit();
        }
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.getBooleanOption(":produce-unsat-cores")) {
            throw new SMTLIBException("Set option :produce-unsat-cores to true before using get-unsat-cores");
        }
        this.checkAssertionStackModified();
        Clause clause = this.mEngine.getProof();
        if (clause == null) {
            throw new SMTLIBException("Logical context not inconsistent!");
        }
        Annotation annotation = new UnsatCoreCollector((Script)this).getUnsatCore(clause);
        if (this.getBooleanOption(":unsat-core-check-mode")) {
            Object object;
            HashSet<String> hashSet = new HashSet<String>();
            Annotation annotation2 = annotation;
            int n = ((Term[])annotation2).length;
            int n2 = 0;
            while (n2 < n) {
                object = annotation2[n2];
                hashSet.add(((ApplicationTerm)object).getFunction().getName());
                ++n2;
            }
            object = new SMTInterpol(this, null, OptionMap.CopyMode.CURRENT_VALUE);
            n2 = ((SMTInterpol)((Object)object)).mLogger.getLoglevel();
            try {
                Annotation annotation3;
                ((SMTInterpol)((Object)object)).mLogger.setLoglevel(2);
                block4: for (Term term : this.mAssertions) {
                    if (term instanceof AnnotatedTerm) {
                        AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                        Annotation[] annotationArray = annotatedTerm.getAnnotations();
                        int n3 = annotationArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            annotation3 = annotationArray[n4];
                            if (":named".equals(annotation3.getKey()) && hashSet.contains(annotation3.getValue())) continue block4;
                            ++n4;
                        }
                    }
                    ((SMTInterpol)((Object)object)).assertTerm(term);
                }
                annotation3 = annotation;
                int n5 = ((Term[])annotation3).length;
                int n6 = 0;
                while (n6 < n5) {
                    Term term = annotation3[n6];
                    ((SMTInterpol)((Object)object)).assertTerm(term);
                    ++n6;
                }
                Script.LBool lBool = ((SMTInterpol)((Object)object)).checkSat();
                if (lBool != Script.LBool.UNSAT) {
                    this.mLogger.error("Unsat core could not be proven unsat (Result is %s)", lBool);
                }
            }
            finally {
                ((SMTInterpol)((Object)object)).mLogger.setLoglevel(n2);
                object.exit();
            }
        }
        return annotation;
    }

    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        if (!this.getBooleanOption(":produce-unsat-assumptions")) {
            throw new SMTLIBException("Set option :produce-unsat-assumptions to true before using get-unsat-assumptions");
        }
        this.checkAssertionStackModified();
        if (!this.mEngine.inconsistent()) {
            throw new SMTLIBException("Logical context not inconsistent!");
        }
        Literal[] literalArray = this.mEngine.getUnsatAssumptions();
        Term[] termArray = new Term[literalArray.length];
        Theory theory = this.getTheory();
        int n = 0;
        while (n < literalArray.length) {
            termArray[n] = literalArray[n].negate().getSMTFormula(theory);
            ++n;
        }
        if (this.getBooleanOption(":unsat-assumptions-check-mode")) {
            SMTInterpol sMTInterpol = new SMTInterpol(this, null, OptionMap.CopyMode.CURRENT_VALUE);
            int n2 = sMTInterpol.mLogger.getLoglevel();
            try {
                Term term2;
                sMTInterpol.mLogger.setLoglevel(2);
                for (Term term2 : this.mAssertions) {
                    sMTInterpol.assertTerm(term2);
                }
                Term[] termArray2 = termArray;
                int n3 = termArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    term2 = termArray2[n4];
                    sMTInterpol.assertTerm(term2);
                    ++n4;
                }
                term2 = sMTInterpol.checkSat();
                if (term2 != Script.LBool.UNSAT) {
                    this.mLogger.error("Unsat assumptions could not be proven unsat (Result is %s)", term2);
                }
            }
            finally {
                sMTInterpol.mLogger.setLoglevel(n2);
                sMTInterpol.exit();
            }
        }
        return termArray;
    }

    public Map<Term, Term> getValue(Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.buildModel();
        return this.mModel.evaluate(termArray);
    }

    public de.uni_freiburg.informatik.ultimate.logic.Model getModel() throws SMTLIBException, UnsupportedOperationException {
        if (this.mEngine == null) {
            throw new SMTLIBException("No logic set!");
        }
        this.buildModel();
        return this.mModel;
    }

    public void setInfo(String string, Object object) {
        if (string.equals(":status")) {
            this.mStatusInfo = object.equals("sat") ? Script.LBool.SAT : (object.equals("unsat") ? Script.LBool.UNSAT : Script.LBool.UNKNOWN);
        }
        if (string.equals(":smt-lib-version")) {
            this.mSMTLIBVersion = (BigDecimal)object;
        }
    }

    public void setOption(String string, Object object) throws UnsupportedOperationException, SMTLIBException {
        this.mOptions.set(string, object);
    }

    public Term simplify(Term term) throws SMTLIBException {
        CheckType checkType = this.mSolverOptions.getCheckType();
        int n = this.mStackLevel;
        try {
            this.mSolverOptions.setCheckType(this.mSolverOptions.getSimplifierCheckType());
            Term term2 = new SimplifyDDA((Script)this, this.getBooleanOption(":simplify-repeatedly")).getSimplifiedTerm(term);
            return term2;
        }
        finally {
            this.mSolverOptions.setCheckType(checkType);
            assert (this.mStackLevel == n);
        }
    }

    public void flipDecisions() {
        this.mEngine.flipDecisions();
    }

    public void flipNamedLiteral(String string) throws SMTLIBException {
        this.mEngine.flipNamedLiteral(string);
    }

    public Clausifier getClausifier() {
        return this.mClausifier;
    }

    public DPLLEngine getEngine() {
        return this.mEngine;
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    protected void setEngine(DPLLEngine dPLLEngine) {
        this.mEngine = dPLLEngine;
    }

    protected void setClausifier(Clausifier clausifier) {
        this.mClausifier = clausifier;
    }

    private void checkAssertionStackModified() throws SMTLIBException {
        if (this.mAssertionStackModified) {
            throw new SMTLIBException("Assertion stack has been modified since last check-sat!");
        }
    }

    private void modifyAssertionStack() {
        this.mAssertionStackModified = true;
        this.mModel = null;
        this.mEngine.clearAssumptions();
    }

    private void buildModel() throws SMTLIBException {
        this.checkAssertionStackModified();
        if (this.mEngine.inconsistent()) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.GET_MODEL_BUT_UNSAT);
            }
            throw new SMTLIBException("Context is inconsistent");
        }
        if (this.mStatus != Script.LBool.SAT) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.GET_MODEL_BUT_UNKNOWN);
            }
            throw new SMTLIBException("Cannot construct model since solving did not complete");
        }
        if (this.mModel == null) {
            this.mModel = new Model(this.mClausifier, this.getTheory());
        }
    }

    public Clause retrieveProof() throws SMTLIBException {
        Clause clause = this.mEngine.getProof();
        if (clause == null) {
            if (this.mErrorCallback != null) {
                this.mErrorCallback.notifyError(ErrorCallback.ErrorReason.GET_PROOF_BUT_SAT);
            }
            throw new SMTLIBException("Logical context not inconsistent!");
        }
        Clause clause2 = this.mSolverOptions.getProofTransformation().transform(clause);
        return clause2;
    }

    public Term[] getSatisfiedLiterals() throws SMTLIBException {
        this.checkAssertionStackModified();
        return this.mEngine.getSatisfiedLiterals(this.getTheory());
    }

    private boolean dumpInterpolationBug(int[] nArray, Term[] termArray, Term[] termArray2, int n) {
        try {
            FileWriter fileWriter = new FileWriter("iplBug.txt");
            FormulaUnLet formulaUnLet = new FormulaUnLet();
            PrintTerm printTerm = new PrintTerm();
            int n2 = n - 1;
            while (n2 >= nArray[n]) {
                printTerm.append((Appendable)fileWriter, formulaUnLet.unlet(termArray2[n2]));
                n2 = nArray[n2] - 1;
                fileWriter.append("\nand\n");
            }
            printTerm.append((Appendable)fileWriter, ((ApplicationTerm)termArray[n]).getFunction().getDefinition());
            fileWriter.append('\n');
            if (n != termArray2.length) {
                fileWriter.append("==>\n");
                printTerm.append((Appendable)fileWriter, formulaUnLet.unlet(termArray2[n]));
                fileWriter.append('\n');
            }
            fileWriter.flush();
            fileWriter.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public Iterable<Term[]> checkAllsat(final Term[] termArray) {
        final Literal[] literalArray = new Literal[termArray.length];
        int n = 0;
        while (n < termArray.length) {
            if (termArray[n].getSort() != this.getTheory().getBooleanSort()) {
                throw new SMTLIBException("AllSAT over non-Boolean");
            }
            literalArray[n] = this.mClausifier.getCreateLiteral(termArray[n], new SourceAnnotation("", null));
            ++n;
        }
        return new Iterable<Term[]>(){

            @Override
            public Iterator<Term[]> iterator() {
                DPLLEngine dPLLEngine = SMTInterpol.this.mEngine;
                dPLLEngine.getClass();
                return new DPLLEngine.AllSatIterator(dPLLEngine, literalArray, termArray);
            }
        };
    }

    public Term[] findImpliedEquality(Term[] termArray, Term[] termArray2) throws SMTLIBException, UnsupportedOperationException {
        Term term;
        Term term2;
        Object object;
        block24: {
            Rational rational;
            if (termArray.length != termArray2.length) {
                throw new SMTLIBException("Different number of x's and y's");
            }
            if (termArray.length < 2) {
                throw new SMTLIBException("Need at least two elements to find equality");
            }
            int n = 0;
            while (n < termArray.length) {
                if (!termArray[n].getSort().isNumericSort() || !termArray2[n].getSort().isNumericSort()) {
                    throw new SMTLIBException("Only numeric types supported");
                }
                ++n;
            }
            Script.LBool lBool = this.checkSat();
            if (lBool == Script.LBool.UNSAT) {
                throw new SMTLIBException("Context is inconsistent!");
            }
            Term[] termArray3 = new Term[termArray.length + termArray2.length];
            System.arraycopy(termArray, 0, termArray3, 0, termArray.length);
            System.arraycopy(termArray2, 0, termArray3, termArray.length, termArray2.length);
            Map<Term, Term> map = this.getValue(termArray3);
            Rational rational2 = (Rational)((ConstantTerm)map.get(termArray[0])).getValue();
            Rational rational3 = (Rational)((ConstantTerm)map.get(termArray2[0])).getValue();
            Rational rational4 = null;
            Rational rational5 = null;
            int n2 = 1;
            while (n2 < termArray.length) {
                rational4 = (Rational)((ConstantTerm)map.get(termArray[n2])).getValue();
                rational5 = (Rational)((ConstantTerm)map.get(termArray2[n2])).getValue();
                if (!rational4.equals((Object)rational2)) break;
                if (!rational5.equals((Object)rational3)) {
                    return new Term[0];
                }
                ++n2;
            }
            if ((rational = rational2.sub(rational4)).equals((Object)Rational.ZERO)) {
                return new Term[0];
            }
            Rational rational6 = rational3.subdiv(rational5, rational);
            Rational rational7 = Rational.ONE;
            Rational rational8 = rational3.mul(rational4).subdiv(rational2.mul(rational5), rational);
            Sort sort = termArray[0].getSort();
            if (termArray[0].getSort().getName().equals("Int") && termArray2[0].getSort().getName().equals("Int")) {
                if (!rational6.isIntegral()) {
                    object = rational6.denominator();
                    rational6 = rational6.mul((BigInteger)object);
                    rational7 = rational7.mul((BigInteger)object);
                    rational8 = rational8.mul((BigInteger)object);
                }
                if (!rational8.isIntegral()) {
                    object = rational8.denominator();
                    rational6 = rational6.mul((BigInteger)object);
                    rational7 = rational7.mul((BigInteger)object);
                    rational8 = rational8.mul((BigInteger)object);
                }
            } else if (sort.getName().equals("Int")) {
                sort = this.sort("Real", new Sort[0]);
            }
            object = rational6.toTerm(sort);
            term2 = rational7.toTerm(sort);
            term = rational8.toTerm(sort);
            if (this.mSolverOptions.getCheckType() == CheckType.FULL) {
                Term[] termArray4 = new Term[termArray.length];
                int n3 = 0;
                while (n3 < termArray.length) {
                    termArray4[n3] = this.term("not", new Term[]{this.term("=", new Term[]{this.term("*", new Term[]{object, termArray[n3]}), this.term("+", new Term[]{this.term("*", new Term[]{term2, termArray2[n3]}), term})})});
                    ++n3;
                }
                try {
                    this.push(1);
                    this.assertTerm(this.term("or", termArray4));
                    Script.LBool lBool2 = this.checkSat();
                    if (lBool2 != Script.LBool.UNSAT) {
                        Term[] termArray5 = new Term[]{};
                        return termArray5;
                    }
                    break block24;
                }
                finally {
                    this.pop(1);
                }
            }
            int n4 = 0;
            while (n4 < termArray.length) {
                Term term3 = this.term("not", new Term[]{this.term("=", new Term[]{this.term("*", new Term[]{object, termArray[n4]}), this.term("+", new Term[]{this.term("*", new Term[]{term2, termArray2[n4]}), term})})});
                try {
                    this.push(1);
                    this.assertTerm(term3);
                    Script.LBool lBool3 = this.checkSat();
                    if (lBool3 != Script.LBool.UNSAT) {
                        Term[] termArray6 = new Term[]{};
                        return termArray6;
                    }
                }
                finally {
                    this.pop(1);
                }
                ++n4;
            }
        }
        return new Term[]{object, term2, term};
    }

    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        Sort sort2 = sort.getRealSort();
        if (sort2.isArraySort() && sort2.getArguments()[0] == this.getTheory().getBooleanSort()) {
            throw new UnsupportedOperationException("SMTInterpol does not support Arrays with Boolean indices");
        }
        super.declareFun(string, sortArray, sort);
    }

    private final boolean getBooleanOption(String string) {
        return (Boolean)this.mOptions.get(string);
    }

    public boolean isTerminationRequested() {
        return this.mResourceLimit.isTerminationRequested();
    }

    public void setTerminationRequest(TerminationRequest terminationRequest) {
        this.mCancel = terminationRequest;
        this.mTimeout = new TimeoutHandler(terminationRequest);
        this.mResourceLimit = new ResourceLimit(this.mTimeout);
    }

    public TerminationRequest getTerminationRequest() {
        return this.mCancel;
    }

    public static enum CheckType {
        FULL{

            @Override
            boolean check(DPLLEngine dPLLEngine) {
                dPLLEngine.setCompleteness(0);
                return dPLLEngine.solve();
            }
        }
        ,
        PROPAGATION{

            @Override
            boolean check(DPLLEngine dPLLEngine) {
                dPLLEngine.setCompleteness(6);
                return dPLLEngine.propagate();
            }
        }
        ,
        QUICK{

            @Override
            boolean check(DPLLEngine dPLLEngine) {
                dPLLEngine.setCompleteness(6);
                return dPLLEngine.quickCheck();
            }
        };


        abstract boolean check(DPLLEngine var1);
    }

    public static enum ProofMode {
        NONE,
        CLAUSES,
        FULL,
        LOWLEVEL;

    }

    private static class SMTInterpolSetup
    extends Theory.SolverSetup {
        public void setLogic(Theory theory, Logics logics) {
            Sort[] sortArray = theory.createSortVariables(new String[]{"X"});
            Sort sort = theory.getSort("Bool", new Sort[0]);
            SMTInterpolSetup.declareInternalPolymorphicFunction((Theory)theory, (String)"@EQ", (Sort[])sortArray, (Sort[])new Sort[]{sortArray[0], sortArray[0]}, (Sort)sort, (int)64);
            SMTInterpolSetup.defineFunction((Theory)theory, (FunctionSymbolFactory)new FunctionSymbolFactory("@undefined"){

                public int getFlags(String[] stringArray, Sort[] sortArray, Sort sort) {
                    return 17;
                }

                public Sort getResultSort(String[] stringArray, Sort[] sortArray, Sort sort) {
                    if (stringArray != null || sortArray.length != 0) {
                        return null;
                    }
                    return sort;
                }
            });
            if (logics.isArray()) {
                SMTInterpolSetup.declareArraySymbols(theory);
            }
        }

        private static final void declareArraySymbols(Theory theory) {
            Sort[] sortArray = theory.createSortVariables(new String[]{"Index", "Elem"});
            Sort sort = theory.getSort("Array", sortArray);
            SMTInterpolSetup.declareInternalPolymorphicFunction((Theory)theory, (String)"@diff", (Sort[])sortArray, (Sort[])new Sort[]{sort, sort}, (Sort)sortArray[0], (int)64);
        }
    }
}

