/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrLoopSummarization;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopaccelerator.IAccelerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;

public class AcceleratorQvasr
implements IAccelerator {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final IPredicateUnifier mPredUnifier;
    private boolean mFoundAcceleration;
    private boolean mIsOverapprox;

    public AcceleratorQvasr(ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, IPredicateUnifier iPredicateUnifier) {
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mPredUnifier = iPredicateUnifier;
        this.mFoundAcceleration = false;
        this.mIsOverapprox = false;
    }

    @Override
    public UnmodifiableTransFormula accelerateLoop(UnmodifiableTransFormula unmodifiableTransFormula, IcfgLocation icfgLocation) {
        try {
            this.mLogger.debug((Object)"Accelerating Loop using Qvasr Summarization");
            QvasrLoopSummarization qvasrLoopSummarization = new QvasrLoopSummarization(this.mLogger, this.mServices, this.mScript, this.mPredUnifier);
            UnmodifiableTransFormula unmodifiableTransFormula2 = qvasrLoopSummarization.getQvasrAcceleration(unmodifiableTransFormula);
            this.mFoundAcceleration = true;
            this.mIsOverapprox = qvasrLoopSummarization.isOverapprox();
            return unmodifiableTransFormula2;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.mFoundAcceleration = false;
            this.mLogger.info((Object)("Qvasr could not accelerate loop because " + String.valueOf(unsupportedOperationException)));
            return unmodifiableTransFormula;
        }
    }

    @Override
    public boolean accelerationFinishedCorrectly() {
        return this.mFoundAcceleration;
    }

    @Override
    public boolean isOverapprox() {
        return this.mIsOverapprox;
    }
}

