/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValueFactory;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalEvaluationResult;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.Evaluator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorLogger;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.EvaluatorUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.evaluator.IEvaluationResult;
import java.util.Collection;
import java.util.Collections;

public class SingletonValueExpressionEvaluator<VALUE extends INonrelationalValue<VALUE>, STATE extends IAbstractState<STATE>>
extends Evaluator<VALUE, STATE> {
    private final VALUE mValue;
    private final EvaluatorUtils.EvaluatorType mType;

    public SingletonValueExpressionEvaluator(VALUE VALUE, EvaluatorUtils.EvaluatorType evaluatorType, int n, INonrelationalValueFactory<VALUE> iNonrelationalValueFactory, EvaluatorLogger evaluatorLogger) {
        super(n, iNonrelationalValueFactory, evaluatorLogger);
        this.mValue = VALUE;
        this.mType = evaluatorType;
    }

    @Override
    public Collection<IEvaluationResult<VALUE>> evaluate(STATE STATE) {
        assert (STATE != null);
        return Collections.singletonList(new NonrelationalEvaluationResult<VALUE>(this.mValue, BooleanValue.TOP));
    }

    @Override
    public Collection<STATE> inverseEvaluate(IEvaluationResult<VALUE> iEvaluationResult, STATE STATE) {
        assert (iEvaluationResult != null);
        assert (STATE != null);
        return Collections.singletonList(STATE);
    }

    @Override
    public boolean hasFreeOperands() {
        return false;
    }

    @Override
    public boolean containsBool() {
        return false;
    }

    public String toString() {
        return this.mValue.toString();
    }

    @Override
    public EvaluatorUtils.EvaluatorType getType() {
        return this.mType;
    }
}

