/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational;

import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.NonrelationalState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.nonrelational.NonrelationalTermProcessor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class NonrelationalPostOperator<STATE extends NonrelationalState<STATE, V>, ACTION, V extends INonrelationalValue<V>>
implements IAbstractPostOperator<STATE, ACTION> {
    private final ILogger mLogger;
    private final NonrelationalTermProcessor<V, STATE> mTermProcessor;
    private final Supplier<STATE> mTopStateSupplier;

    protected NonrelationalPostOperator(ILogger iLogger, NonrelationalTermProcessor<V, STATE> nonrelationalTermProcessor, Supplier<STATE> supplier) {
        this.mLogger = iLogger;
        this.mTermProcessor = nonrelationalTermProcessor;
        this.mTopStateSupplier = supplier;
    }

    public List<STATE> apply(STATE STATE, ACTION ACTION) {
        UnmodifiableTransFormula unmodifiableTransFormula;
        assert (STATE != null);
        assert (!((NonrelationalState)STATE).isBottom()) : "Trying to compute post for a bottom state.";
        assert (ACTION != null);
        if (ACTION instanceof Summary && !((Summary)ACTION).calledProcedureHasImplementation()) {
            throw new UnsupportedOperationException("Summary for procedure without implementation");
        }
        if (ACTION instanceof CodeBlock) {
            unmodifiableTransFormula = ((CodeBlock)ACTION).getTransformula();
        } else if (ACTION instanceof IcfgEdge) {
            unmodifiableTransFormula = ((IcfgEdge)ACTION).getTransformula();
        } else {
            throw new UnsupportedOperationException("Unknown instance of transition: " + ACTION.getClass().getSimpleName());
        }
        Term term = unmodifiableTransFormula.getFormula();
        Map<String, IProgramVarOrConst> map = this.createIdentifierMap(STATE, unmodifiableTransFormula);
        STATE STATE2 = this.createNewPreState(STATE, unmodifiableTransFormula, map);
        List<STATE> list = this.mTermProcessor.process(term, STATE2);
        return this.createPostStates(list, STATE, unmodifiableTransFormula, map);
    }

    private Map<String, IProgramVarOrConst> createIdentifierMap(STATE STATE, UnmodifiableTransFormula unmodifiableTransFormula) {
        DummyProgramVar dummyProgramVar;
        TermVariable termVariable;
        IProgramVarOrConst iProgramVarOrConst;
        HashMap<String, IProgramVarOrConst> hashMap = new HashMap<String, IProgramVarOrConst>();
        for (Map.Entry termVariable2 : unmodifiableTransFormula.getInVars().entrySet()) {
            iProgramVarOrConst = (IProgramVarOrConst)termVariable2.getKey();
            termVariable = (TermVariable)termVariable2.getValue();
            dummyProgramVar = new DummyProgramVar(termVariable.getName(), iProgramVarOrConst.isGlobal(), iProgramVarOrConst.getTerm());
            assert (!hashMap.containsKey(dummyProgramVar.getGloballyUniqueId()));
            hashMap.put(dummyProgramVar.getGloballyUniqueId(), dummyProgramVar);
        }
        for (Map.Entry entry : unmodifiableTransFormula.getOutVars().entrySet()) {
            iProgramVarOrConst = (IProgramVarOrConst)entry.getKey();
            termVariable = (TermVariable)entry.getValue();
            if (hashMap.containsKey(termVariable.getName())) continue;
            dummyProgramVar = new DummyProgramVar(termVariable.getName(), iProgramVarOrConst.isGlobal(), iProgramVarOrConst.getTerm());
            hashMap.put(dummyProgramVar.getGloballyUniqueId(), dummyProgramVar);
        }
        for (TermVariable termVariable2 : unmodifiableTransFormula.getAuxVars()) {
            assert (!hashMap.containsKey(termVariable2.getName()));
            iProgramVarOrConst = new DummyProgramVar(termVariable2.getName(), false, null);
            hashMap.put(iProgramVarOrConst.getGloballyUniqueId(), iProgramVarOrConst);
        }
        return hashMap;
    }

    private STATE createNewPreState(STATE STATE, UnmodifiableTransFormula unmodifiableTransFormula, Map<String, IProgramVarOrConst> map) {
        IProgramVarOrConst iProgramVarOrConst;
        NonrelationalState nonrelationalState = (NonrelationalState)this.mTopStateSupplier.get();
        for (Map.Entry termVariable : unmodifiableTransFormula.getInVars().entrySet()) {
            iProgramVarOrConst = (IProgramVarOrConst)termVariable.getKey();
            TermVariable termVariable2 = (TermVariable)termVariable.getValue();
            assert (map.containsKey(termVariable2.getName()));
            IProgramVarOrConst iProgramVarOrConst2 = map.get(termVariable2.getName());
            nonrelationalState = nonrelationalState.addVariable(iProgramVarOrConst2);
            NonrelationalState.VariableType variableType = ((NonrelationalState)STATE).getVariableType(iProgramVarOrConst);
            switch (variableType) {
                case VARIABLE: {
                    nonrelationalState = nonrelationalState.setValue(iProgramVarOrConst2, ((NonrelationalState)STATE).getValue(iProgramVarOrConst));
                    break;
                }
                case BOOLEAN: {
                    nonrelationalState = nonrelationalState.setBooleanValue(iProgramVarOrConst2, ((NonrelationalState)STATE).getBooleanValue(iProgramVarOrConst));
                    break;
                }
                case ARRAY: {
                    throw new UnsupportedOperationException("Arrays are not supported at this point.");
                }
            }
        }
        for (TermVariable termVariable : unmodifiableTransFormula.getOutVars().values()) {
            assert (map.containsKey(termVariable.getName()));
            iProgramVarOrConst = map.get(termVariable.getName());
            if (nonrelationalState.containsVariable(iProgramVarOrConst)) continue;
            nonrelationalState = nonrelationalState.addVariable(iProgramVarOrConst);
        }
        for (TermVariable termVariable : unmodifiableTransFormula.getAuxVars()) {
            assert (map.containsKey(termVariable.getName()));
            iProgramVarOrConst = map.get(termVariable.getName());
            nonrelationalState = nonrelationalState.addVariable(iProgramVarOrConst);
        }
        return (STATE)nonrelationalState;
    }

    private List<STATE> createPostStates(List<STATE> list, STATE STATE, UnmodifiableTransFormula unmodifiableTransFormula, Map<String, IProgramVarOrConst> map) {
        assert (list != null);
        assert (list.size() > 0);
        assert (STATE != null);
        assert (unmodifiableTransFormula != null);
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (NonrelationalState nonrelationalState : list) {
            STATE STATE2 = STATE;
            for (Map.Entry entry : unmodifiableTransFormula.getOutVars().entrySet()) {
                IProgramVar iProgramVar = (IProgramVar)entry.getKey();
                TermVariable termVariable = (TermVariable)entry.getValue();
                assert (((NonrelationalState)STATE).containsVariable((IProgramVarOrConst)iProgramVar));
                assert (map.containsKey(termVariable.getName()));
                IProgramVarOrConst iProgramVarOrConst = map.get(termVariable.getName());
                assert (nonrelationalState.containsVariable(iProgramVarOrConst));
                NonrelationalState.VariableType variableType = ((NonrelationalState)STATE).getVariableType((IProgramVarOrConst)iProgramVar);
                assert (variableType.equals((Object)nonrelationalState.getVariableType(iProgramVarOrConst)));
                switch (variableType) {
                    case VARIABLE: {
                        STATE2 = ((NonrelationalState)STATE2).setValue((IProgramVarOrConst)iProgramVar, nonrelationalState.getValue(iProgramVarOrConst));
                        break;
                    }
                    case BOOLEAN: {
                        STATE2 = ((NonrelationalState)STATE2).setBooleanValue((IProgramVarOrConst)iProgramVar, nonrelationalState.getBooleanValue(iProgramVarOrConst));
                        break;
                    }
                    case ARRAY: {
                        throw new UnsupportedOperationException("Arrays are not supported at this point.");
                    }
                }
            }
            arrayList.add(STATE2);
        }
        return arrayList;
    }

    public List<STATE> apply(STATE STATE, STATE STATE2, ACTION ACTION) {
        assert (ACTION instanceof Call || ACTION instanceof Return || ACTION instanceof Summary) : "Cannot calculate hierachical post for non-hierachical transition";
        if (ACTION instanceof Call) {
            Call call = (Call)ACTION;
            return this.handleCallTransition(STATE, STATE2, call);
        }
        if (ACTION instanceof Return) {
            Return return_ = (Return)ACTION;
            return this.handleReturnTransition(STATE, STATE2, return_.getCallStatement());
        }
        if (ACTION instanceof Summary) {
            Summary summary = (Summary)ACTION;
            return this.handleReturnTransition(STATE, STATE2, summary.getCallStatement());
        }
        throw new UnsupportedOperationException("Nonrelational domains do not support context switches other than Call and Return (yet)");
    }

    private List<STATE> handleCallTransition(STATE STATE, STATE STATE2, Call call) {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        CallStatement callStatement = call.getCallStatement();
        Expression[] expressionArray = callStatement.getArguments();
        if (expressionArray.length == 0) {
            arrayList.add(STATE2);
            return arrayList;
        }
        throw new UnsupportedAddressTypeException();
    }

    private List<STATE> handleReturnTransition(STATE STATE, STATE STATE2, CallStatement callStatement) {
        throw new UnsupportedOperationException();
    }

    private static final class DummyProgramVar
    implements IProgramVarOrConst {
        private static final long serialVersionUID = 1L;
        private final String mName;
        private final boolean mIsGlobal;
        private final Term mTerm;

        protected DummyProgramVar(String string, boolean bl, Term term) {
            this.mName = string;
            this.mIsGlobal = bl;
            this.mTerm = term;
        }

        public String getGloballyUniqueId() {
            return this.mName;
        }

        public boolean isGlobal() {
            return this.mIsGlobal;
        }

        public Term getTerm() {
            return this.mTerm;
        }

        public String toString() {
            return this.mName;
        }
    }
}

