/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.EmptySet;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Epsilon;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Literal;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Star;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ErrorOnEnterCall;
import de.uni_freiburg.informatik.ultimate.lib.sifa.IEnterCallRegistrar;
import de.uni_freiburg.informatik.ultimate.lib.sifa.ILoiPredicateStorage;
import de.uni_freiburg.informatik.ultimate.lib.sifa.IWorklistWithInputs;
import de.uni_freiburg.informatik.ultimate.lib.sifa.MapBasedStorage;
import de.uni_freiburg.informatik.ultimate.lib.sifa.PriorityWorklist;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.TopsortCache;
import de.uni_freiburg.informatik.ultimate.lib.sifa.cfgpreprocessing.CallReturnSummary;
import de.uni_freiburg.informatik.ultimate.lib.sifa.cfgpreprocessing.LocationMarkerTransition;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.IFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.IDagOverlay;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagNode;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ICallSummarizer;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ILoopSummarizer;
import java.util.function.Function;

public class DagInterpreter {
    private final ILogger mLogger;
    private final SifaStats mStats;
    private final SymbolicTools mTools;
    private final IDomain mDomain;
    private final IFluid mFluid;
    private final TopsortCache mTopsortCache = new TopsortCache();
    private final ILoopSummarizer mLoopSummarizer;
    private final ICallSummarizer mCallSummarizer;
    private final IProgressAwareTimer mTimer;

    public DagInterpreter(ILogger iLogger, SifaStats sifaStats, IProgressAwareTimer iProgressAwareTimer, SymbolicTools symbolicTools, IDomain iDomain, IFluid iFluid, Function<DagInterpreter, ILoopSummarizer> function, Function<DagInterpreter, ICallSummarizer> function2) {
        this.mLogger = iLogger;
        this.mStats = sifaStats;
        this.mTimer = iProgressAwareTimer;
        this.mTools = symbolicTools;
        this.mDomain = iDomain;
        this.mFluid = iFluid;
        this.mLoopSummarizer = function.apply(this);
        this.mCallSummarizer = function2.apply(this);
    }

    public IPredicate interpretForSingleMarker(RegexDag<IIcfgTransition<IcfgLocation>> regexDag, IDagOverlay<IIcfgTransition<IcfgLocation>> iDagOverlay, IPredicate iPredicate) {
        MapBasedStorage mapBasedStorage = new MapBasedStorage(this.mLogger);
        this.interpret(regexDag, iDagOverlay, iPredicate, mapBasedStorage, ErrorOnEnterCall.instance());
        return mapBasedStorage.getSingletonOrDefault(this.mTools.bottom());
    }

    public void interpret(RegexDag<IIcfgTransition<IcfgLocation>> regexDag, IDagOverlay<IIcfgTransition<IcfgLocation>> iDagOverlay, IPredicate iPredicate, ILoiPredicateStorage iLoiPredicateStorage, IEnterCallRegistrar iEnterCallRegistrar) {
        PriorityWorklist<RegexDagNode<IIcfgTransition<IcfgLocation>>, IPredicate> priorityWorklist = new PriorityWorklist<RegexDagNode<IIcfgTransition<IcfgLocation>>, IPredicate>(this.mTopsortCache.topsort(regexDag), this.mDomain::join);
        iDagOverlay.sources(regexDag).forEach(regexDagNode -> priorityWorklist.add((RegexDagNode<IIcfgTransition<IcfgLocation>>)((Object)regexDagNode), iPredicate));
        while (priorityWorklist.advance()) {
            this.respectTimeout();
            this.logWorklistEntry(priorityWorklist);
            RegexDagNode regexDagNode2 = (RegexDagNode)((Object)priorityWorklist.getWork());
            IPredicate iPredicate2 = this.fluidAbstraction((IPredicate)priorityWorklist.getInput());
            IPredicate iPredicate3 = this.ipretNode(regexDagNode2, iPredicate2, iLoiPredicateStorage, iEnterCallRegistrar);
            this.logWorklistEntryDone(iPredicate3);
            if (this.earlyExitAfterStep(iDagOverlay, regexDagNode2, iPredicate3)) continue;
            iDagOverlay.successorsOf(regexDagNode2).forEach(regexDagNode -> priorityWorklist.add((RegexDagNode<IIcfgTransition<IcfgLocation>>)((Object)regexDagNode), iPredicate3));
        }
    }

    private boolean earlyExitAfterStep(IDagOverlay<IIcfgTransition<IcfgLocation>> iDagOverlay, RegexDagNode<IIcfgTransition<IcfgLocation>> regexDagNode, IPredicate iPredicate) {
        boolean bl = this.mTools.isBottomLiteral(iPredicate);
        if (!bl && iDagOverlay.successorsOf(regexDagNode).size() > 1) {
            this.mStats.increment(SifaStats.Key.DAG_INTERPRETER_EARLY_EXIT_QUERIES_NONTRIVIAL);
            bl = this.mDomain.isEqBottom(iPredicate).isTrueForAbstraction();
        }
        if (bl) {
            this.mStats.increment(SifaStats.Key.DAG_INTERPRETER_EARLY_EXITS);
            this.logEarlyExitAfterStep();
        }
        return bl;
    }

    private void respectTimeout() {
        if (!this.mTimer.continueProcessing()) {
            this.mLogger.warn((Object)"Timeout while interpreting dag");
            throw new ToolchainCanceledException(this.getClass());
        }
    }

    private IPredicate ipretNode(RegexDagNode<IIcfgTransition<IcfgLocation>> regexDagNode, IPredicate iPredicate, ILoiPredicateStorage iLoiPredicateStorage, IEnterCallRegistrar iEnterCallRegistrar) {
        IRegex<IIcfgTransition<IcfgLocation>> iRegex = regexDagNode.getContent();
        if (iRegex instanceof Epsilon) {
            return iPredicate;
        }
        if (iRegex instanceof EmptySet) {
            return this.mTools.bottom();
        }
        if (iRegex instanceof Literal) {
            return this.ipretTrans((IIcfgTransition<IcfgLocation>)((IIcfgTransition)((Literal)iRegex).getLetter()), iPredicate, iLoiPredicateStorage, iEnterCallRegistrar);
        }
        if (iRegex instanceof Star) {
            return this.ipretLoop((Star<IIcfgTransition<IcfgLocation>>)((Star)iRegex), iPredicate, iLoiPredicateStorage);
        }
        throw new UnsupportedOperationException("Unexpected node type in dag: " + String.valueOf(iRegex.getClass()));
    }

    private IPredicate ipretLoop(Star<IIcfgTransition<IcfgLocation>> star, IPredicate iPredicate, ILoiPredicateStorage iLoiPredicateStorage) {
        this.logIpretLoop();
        IPredicate iPredicate2 = this.mLoopSummarizer.summarize(star, iPredicate);
        this.logIpretLoopDone();
        return iPredicate2;
    }

    private IPredicate ipretTrans(IIcfgTransition<IcfgLocation> iIcfgTransition, IPredicate iPredicate, ILoiPredicateStorage iLoiPredicateStorage, IEnterCallRegistrar iEnterCallRegistrar) {
        if (iIcfgTransition instanceof IIcfgCallTransition) {
            return this.ipretEnterCall((IIcfgCallTransition<IcfgLocation>)((IIcfgCallTransition)iIcfgTransition), iPredicate, iEnterCallRegistrar);
        }
        return this.ipretTransAndStoreLoiPred(iIcfgTransition, iPredicate, iLoiPredicateStorage);
    }

    private IPredicate ipretEnterCall(IIcfgCallTransition<IcfgLocation> iIcfgCallTransition, IPredicate iPredicate, IEnterCallRegistrar iEnterCallRegistrar) {
        this.logRegisterEnterCall();
        IPredicate iPredicate2 = this.mTools.postCall(iPredicate, iIcfgCallTransition);
        iEnterCallRegistrar.registerEnterCall(iIcfgCallTransition.getSucceedingProcedure(), iPredicate2);
        DagInterpreter.logRegisterEnterCallDone();
        return iPredicate2;
    }

    private IPredicate ipretTransAndStoreLoiPred(IIcfgTransition<IcfgLocation> iIcfgTransition, IPredicate iPredicate, ILoiPredicateStorage iLoiPredicateStorage) {
        IPredicate iPredicate2;
        if (iIcfgTransition instanceof LocationMarkerTransition) {
            iLoiPredicateStorage.storePredicate(iIcfgTransition.getTarget(), iPredicate);
            iPredicate2 = iPredicate;
        } else if (iIcfgTransition instanceof CallReturnSummary) {
            iPredicate2 = this.ipretCallReturnSummary((CallReturnSummary)iIcfgTransition, iPredicate);
        } else if (iIcfgTransition instanceof IIcfgInternalTransition) {
            iPredicate2 = this.ipretInternal((IIcfgInternalTransition<IcfgLocation>)((IIcfgInternalTransition)iIcfgTransition), iPredicate);
        } else {
            throw new UnsupportedOperationException("Unexpected transition type: " + String.valueOf(iIcfgTransition.getClass()));
        }
        return iPredicate2;
    }

    private IPredicate ipretCallReturnSummary(CallReturnSummary callReturnSummary, IPredicate iPredicate) {
        IIcfgCallTransition<IcfgLocation> iIcfgCallTransition = callReturnSummary.correspondingCall();
        IPredicate iPredicate2 = this.mTools.postCall(iPredicate, iIcfgCallTransition);
        this.logIpretCallReturnQuery(iPredicate2);
        IPredicate iPredicate3 = this.mCallSummarizer.summarize(iIcfgCallTransition.getSucceedingProcedure(), iPredicate2);
        this.logIpretCallReturnApply(iPredicate3);
        return this.mTools.postReturn(iPredicate, iPredicate3, callReturnSummary.correspondingReturn());
    }

    private IPredicate ipretInternal(IIcfgInternalTransition<IcfgLocation> iIcfgInternalTransition, IPredicate iPredicate) {
        this.logIpretInternal();
        IPredicate iPredicate2 = this.mTools.post(iPredicate, (IIcfgTransition<IcfgLocation>)iIcfgInternalTransition);
        this.logIpretInternalDone();
        return iPredicate2;
    }

    private IPredicate fluidAbstraction(IPredicate iPredicate) {
        this.logConsiderAbstraction();
        if (this.mFluid.shallBeAbstracted(iPredicate)) {
            this.logFluidAbstractionYes();
            iPredicate = this.mDomain.alpha(iPredicate);
            this.logFluidAbstractionDone(iPredicate);
        } else {
            this.logFluidAbstractionNo();
        }
        return iPredicate;
    }

    private void logWorklistEntry(IWorklistWithInputs<RegexDagNode<IIcfgTransition<IcfgLocation>>, IPredicate> iWorklistWithInputs) {
        this.mLogger.debug("\u25cf  Processing next worklist item %s with input %s", new Object[]{iWorklistWithInputs.getWork().getContent(), iWorklistWithInputs.getInput()});
    }

    private void logWorklistEntryDone(IPredicate iPredicate) {
        this.mLogger.debug("Output of worklist entry is %s", new Object[]{iPredicate});
    }

    private void logEarlyExitAfterStep() {
        this.mLogger.debug((Object)"Ignoring successors of the last worklist entry as its output was bottom.");
    }

    private void logConsiderAbstraction() {
        this.mLogger.debug((Object)"Asking fluid if we should abstract");
    }

    private void logFluidAbstractionYes() {
        this.mLogger.debug((Object)"Fluid: Yes, abstract");
    }

    private void logFluidAbstractionNo() {
        this.mLogger.debug((Object)"Fluid: No, don't abstract");
    }

    private void logFluidAbstractionDone(IPredicate iPredicate) {
        this.mLogger.debug("Fluid abstraction is %s", new Object[]{iPredicate});
    }

    private void logIpretInternal() {
        this.mLogger.debug((Object)"\u2192  Interpreting internal transition");
    }

    private void logIpretInternalDone() {
        this.mLogger.debug((Object)"\u2192  Internal transition interpreted");
    }

    private void logIpretLoop() {
        this.mLogger.debug((Object)"\u27f2  Using loop summarizer");
    }

    private void logIpretLoopDone() {
        this.mLogger.debug((Object)"\u27f2  Loop summarizer finished");
    }

    private void logRegisterEnterCall() {
        this.mLogger.debug((Object)"Register enter call for later");
    }

    private static void logRegisterEnterCallDone() {
    }

    private void logIpretCallReturnQuery(IPredicate iPredicate) {
        this.mLogger.debug("\u21f5  Requesting call summary for input after call %s", new Object[]{iPredicate});
    }

    private void logIpretCallReturnApply(IPredicate iPredicate) {
        this.mLogger.debug("\u21f5  Apply call summary %s", new Object[]{iPredicate});
    }
}

