/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Star;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDagUtils;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.RegexStatUtils;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import java.util.HashMap;
import java.util.Map;

public class StarDagCache {
    private final SifaStats mStats;
    private final Map<IRegex<IIcfgTransition<IcfgLocation>>, RegexDag<IIcfgTransition<IcfgLocation>>> mCache = new HashMap<IRegex<IIcfgTransition<IcfgLocation>>, RegexDag<IIcfgTransition<IcfgLocation>>>();

    public StarDagCache(SifaStats sifaStats) {
        this.mStats = sifaStats;
    }

    public RegexDag<IIcfgTransition<IcfgLocation>> dagOf(IRegex<IIcfgTransition<IcfgLocation>> iRegex) {
        return this.mCache.computeIfAbsent(iRegex, this::computeDagOf);
    }

    private RegexDag<IIcfgTransition<IcfgLocation>> computeDagOf(IRegex<IIcfgTransition<IcfgLocation>> iRegex) {
        assert (!(iRegex instanceof Star)) : "Tried to compute RegexDag for star expression. Computing such a DAG is possible but probably not what you want. Either you forgot to call .inner() on the star for which you want to compute a DAG or your regex is of the form ((expr)*)* which could be simplified to just (expr)*.";
        return RegexStatUtils.compress(this.mStats, RegexStatUtils.regexToDag(this.mStats, RegexDagUtils.markRegex(iRegex, null)));
    }
}

