/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.graphml;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.io.GraphMLMetadata;
import edu.uci.ics.jung.io.GraphMLWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.collections15.Transformer;

public class UltimateGraphMLWriter<V, E>
extends GraphMLWriter<V, E> {
    private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    private static final String GRAPHML_OPEN = "<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n";

    protected void writeKeySpecification(String string, String string2, GraphMLMetadata<?> graphMLMetadata, BufferedWriter bufferedWriter) throws IOException {
        String string3;
        bufferedWriter.write("<key id=\"" + string + "\" attr.name=\"" + string + "\" for=\"" + string2 + "\"");
        boolean bl = false;
        String string4 = graphMLMetadata.description;
        if (string4 != null) {
            bufferedWriter.write(">\n");
            bl = true;
            bufferedWriter.write("<desc>" + string4 + "</desc>\n");
        }
        if ((string3 = graphMLMetadata.default_value) != null) {
            if (!bl) {
                bufferedWriter.write(">\n");
                bl = true;
            }
            bufferedWriter.write("<default>" + string3.toString() + "</default>\n");
        }
        if (!bl) {
            bufferedWriter.write("/>\n");
        } else {
            bufferedWriter.write("</key>\n");
        }
    }

    public void save(Hypergraph<V, E> hypergraph, Writer writer) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        bufferedWriter.write(XML_VERSION);
        bufferedWriter.write(GRAPHML_OPEN);
        for (Map.Entry entry : this.graph_data.entrySet()) {
            this.writeKeySpecification((String)entry.getKey(), "graph", (GraphMLMetadata)entry.getValue(), bufferedWriter);
        }
        for (Map.Entry entry : this.vertex_data.entrySet()) {
            this.writeKeySpecification((String)entry.getKey(), "node", (GraphMLMetadata)entry.getValue(), bufferedWriter);
        }
        for (Map.Entry entry : this.edge_data.entrySet()) {
            this.writeKeySpecification((String)entry.getKey(), "edge", (GraphMLMetadata)entry.getValue(), bufferedWriter);
        }
        bufferedWriter.write("<graph edgedefault=\"");
        boolean bl = this.directed = !(hypergraph instanceof UndirectedGraph);
        if (this.directed) {
            bufferedWriter.write("directed\">\n");
        } else {
            bufferedWriter.write("undirected\">\n");
        }
        String string = (String)this.graph_desc.transform(hypergraph);
        if (string != null) {
            bufferedWriter.write("<desc>" + string + "</desc>\n");
        }
        for (Map.Entry entry : this.graph_data.entrySet()) {
            Transformer transformer = ((GraphMLMetadata)entry.getValue()).transformer;
            Object object = transformer.transform(hypergraph);
            if (object == null) continue;
            bufferedWriter.write(this.format("data", "key", (String)entry.getKey(), object.toString()) + "\n");
        }
        this.writeVertexData(hypergraph, bufferedWriter);
        this.writeEdgeData(hypergraph, bufferedWriter);
        bufferedWriter.write("</graph>\n");
        bufferedWriter.write("</graphml>\n");
        bufferedWriter.flush();
        bufferedWriter.close();
    }
}

