/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.dangerinvariants;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class DangerInvariantUtils {
    private DangerInvariantUtils() {
    }

    public static IncrementalPlicationChecker.Validity eachStateHasSuccessor(IPredicate iPredicate, HashRelation<IAction, IPredicate> hashRelation, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, BasicPredicateFactory basicPredicateFactory, ILogger iLogger) {
        IncrementalPlicationChecker.Validity validity;
        Object object2;
        PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer = new PredicateTransformer<Term, IPredicate, TransFormula>(managedScript, new TermDomainOperationProvider(iUltimateServiceProvider, managedScript));
        ArrayList<IPredicate> arrayList = new ArrayList<IPredicate>();
        for (Object object2 : hashRelation.getSetOfPairs()) {
            validity = DangerInvariantUtils.constructPreInternal(iLogger, basicPredicateFactory, cfgSmtToolkit, predicateTransformer, ((IAction)object2.getKey()).getTransformula(), (IPredicate)object2.getValue(), iUltimateServiceProvider);
            arrayList.add(basicPredicateFactory.newPredicate((Term)validity));
        }
        object2 = basicPredicateFactory.or(SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, arrayList);
        MonolithicImplicationChecker monolithicImplicationChecker = new MonolithicImplicationChecker(iUltimateServiceProvider, managedScript);
        validity = monolithicImplicationChecker.checkImplication(iPredicate, false, (IPredicate)object2, false);
        return validity;
    }

    public static IncrementalPlicationChecker.Validity predicateIsNotEmpty(IPredicate iPredicate, ManagedScript managedScript) {
        Script.LBool lBool = SmtUtils.checkSatTerm((Script)managedScript.getScript(), (Term)iPredicate.getClosedFormula());
        return IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)lBool);
    }

    private static Term constructPreInternal(ILogger iLogger, BasicPredicateFactory basicPredicateFactory, CfgSmtToolkit cfgSmtToolkit, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, TransFormula transFormula, IPredicate iPredicate, IUltimateServiceProvider iUltimateServiceProvider) {
        Term term = predicateTransformer.weakestPrecondition(basicPredicateFactory.not(iPredicate), transFormula);
        Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)cfgSmtToolkit.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term);
        Term term3 = SmtUtils.not((Script)cfgSmtToolkit.getManagedScript().getScript(), (Term)term2);
        return term3;
    }

    public static IncrementalPlicationChecker.Validity checkDangerInvariant(Map<IcfgLocation, IPredicate> map, IIcfg<?> iIcfg, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, BasicPredicateFactory basicPredicateFactory, ILogger iLogger) {
        Object object;
        Object object22;
        for (Object object22 : iIcfg.getInitialNodes()) {
            object = DangerInvariantUtils.predicateIsNotEmpty(map.get(object22), managedScript);
            if (object == IncrementalPlicationChecker.Validity.VALID) {
                return IncrementalPlicationChecker.Validity.INVALID;
            }
            if (object == IncrementalPlicationChecker.Validity.INVALID) continue;
            return object;
        }
        object22 = new ArrayDeque(iIcfg.getInitialNodes());
        HashSet hashSet = new HashSet();
        while (!object22.isEmpty()) {
            IcfgEdge icfgEdge2;
            object = (IcfgLocation)object22.pop();
            hashSet.add(object);
            if (IcfgUtils.isErrorLocation(iIcfg, (IcfgLocation)object)) continue;
            HashRelation hashRelation = new HashRelation();
            for (IcfgEdge icfgEdge2 : object.getOutgoingEdges()) {
                IcfgLocation icfgLocation = (IcfgLocation)icfgEdge2.getTarget();
                hashRelation.addPair((Object)icfgEdge2, (Object)map.get(icfgLocation));
                if (hashSet.contains(icfgLocation)) continue;
                object22.add(icfgLocation);
            }
            icfgEdge2 = DangerInvariantUtils.eachStateHasSuccessor(map.get(object), (HashRelation<IAction, IPredicate>)hashRelation, managedScript, iUltimateServiceProvider, iIcfg.getCfgSmtToolkit(), basicPredicateFactory, iLogger);
            if (icfgEdge2 == IncrementalPlicationChecker.Validity.VALID) continue;
            return icfgEdge2;
        }
        return IncrementalPlicationChecker.Validity.VALID;
    }
}

