/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.SdHoareTripleCheckHelper;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import java.util.Set;

public class ReturnCheckHelper
extends SdHoareTripleCheckHelper<IReturnAction> {
    ReturnCheckHelper(IPredicateCoverageChecker iPredicateCoverageChecker, IPredicate iPredicate, IPredicate iPredicate2, HoareTripleCheckerStatisticsGenerator hoareTripleCheckerStatisticsGenerator, ModifiableGlobalsTable modifiableGlobalsTable) {
        super(iPredicateCoverageChecker, iPredicate, iPredicate2, hoareTripleCheckerStatisticsGenerator, modifiableGlobalsTable);
    }

    @Override
    public IncrementalPlicationChecker.Validity sdecToFalse(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction) {
        if (this.preHierNotFalse(iPredicate, iPredicate2, iReturnAction.getLocalVarsAssignmentOfCall(), iReturnAction.getPrecedingProcedure())) {
            this.mStatistics.getSDtfsCounter().incRe();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    @Override
    public boolean isInductiveSelfloop(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        if (iPredicate == iPredicate3 && this.sdecReturnSelfloopPre(iPredicate, iReturnAction) == IncrementalPlicationChecker.Validity.VALID) {
            return true;
        }
        return iPredicate2 == iPredicate3 && this.sdecReturnSelfloopHier(iPredicate2, iReturnAction) == IncrementalPlicationChecker.Validity.VALID;
    }

    private IncrementalPlicationChecker.Validity sdecReturnSelfloopPre(IPredicate iPredicate, IReturnAction iReturnAction) {
        Set<IProgramVar> set = iReturnAction.getAssignmentOfReturn().getOutVars().keySet();
        for (IProgramVar iProgramVar : iPredicate.getVars()) {
            if (!iProgramVar.isGlobal()) {
                return null;
            }
            if (iProgramVar.isOldvar()) {
                return null;
            }
            if (!set.contains(iProgramVar)) continue;
            return null;
        }
        this.mStatistics.getSDsluCounter().incRe();
        return IncrementalPlicationChecker.Validity.VALID;
    }

    private IncrementalPlicationChecker.Validity sdecReturnSelfloopHier(IPredicate iPredicate, IReturnAction iReturnAction) {
        Set<IProgramVar> set = iReturnAction.getAssignmentOfReturn().getOutVars().keySet();
        String string = iReturnAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> set2 = this.mModifiableGlobals.getModifiedBoogieVars(string);
        for (IProgramVar iProgramVar : iPredicate.getVars()) {
            if (set2.contains(iProgramVar)) {
                return null;
            }
            if (!set.contains(iProgramVar)) continue;
            return null;
        }
        return IncrementalPlicationChecker.Validity.VALID;
    }

    @Override
    public IncrementalPlicationChecker.Validity sdec(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        if (this.mModifiableGlobals.containsNonModifiableOldVars(iPredicate, iReturnAction.getPrecedingProcedure()) || this.mModifiableGlobals.containsNonModifiableOldVars(iPredicate2, iReturnAction.getSucceedingProcedure()) || this.mModifiableGlobals.containsNonModifiableOldVars(iPredicate3, iReturnAction.getSucceedingProcedure())) {
            return null;
        }
        if (this.hierPostIndependent(iPredicate2, iReturnAction, iPredicate3) && this.preHierNotFalse(iPredicate, iPredicate2, iReturnAction.getLocalVarsAssignmentOfCall(), iReturnAction.getPrecedingProcedure()) && ReturnCheckHelper.prePostIndependent(iPredicate, iReturnAction, iPredicate3)) {
            this.mStatistics.getSDsCounter().incRe();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    @Override
    public IncrementalPlicationChecker.Validity sdLazyEc(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        if (ReturnCheckHelper.isOrIteFormula(iPredicate3)) {
            return this.sdec(iPredicate, iPredicate2, iReturnAction, iPredicate3);
        }
        if (!ReturnCheckHelper.varsDisjointFromOutVars(iPredicate, iReturnAction.getLocalVarsAssignmentOfCall())) {
            return null;
        }
        String string = iReturnAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> set = this.mModifiableGlobals.getModifiedBoogieVars(string);
        boolean bl = !ReturnCheckHelper.varsDisjointFromInVars(iPredicate, iReturnAction.getAssignmentOfReturn());
        Set<IProgramVar> set2 = iReturnAction.getAssignmentOfReturn().getOutVars().keySet();
        for (IProgramVar iProgramVar : iPredicate3.getVars()) {
            if (ReturnCheckHelper.continueSdLazyEcReturnLoop(iProgramVar, set, iPredicate2, iPredicate, set2, bl)) continue;
            this.mStatistics.getSdLazyCounter().incRe();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    private static boolean continueSdLazyEcReturnLoop(IProgramVar iProgramVar, Set<IProgramNonOldVar> set, IPredicate iPredicate, IPredicate iPredicate2, Set<IProgramVar> set2, boolean bl) {
        if (iProgramVar.isGlobal()) {
            if (iProgramVar.isOldvar()) {
                if (iPredicate.getVars().contains(iProgramVar)) {
                    return true;
                }
            } else {
                if (set.contains(iProgramVar)) {
                    if (iPredicate2.getVars().contains(iProgramVar)) {
                        return true;
                    }
                } else {
                    if (iPredicate.getVars().contains(iProgramVar)) {
                        return true;
                    }
                    if (iPredicate2.getVars().contains(iProgramVar)) {
                        return true;
                    }
                }
                if (set2.contains(iProgramVar) && bl) {
                    return true;
                }
            }
        } else if (set2.contains(iProgramVar) ? bl : iPredicate.getVars().contains(iProgramVar)) {
            return true;
        }
        return false;
    }

    private boolean preHierNotFalse(IPredicate iPredicate, IPredicate iPredicate2, UnmodifiableTransFormula unmodifiableTransFormula, String string) {
        Set<IProgramNonOldVar> set = this.mModifiableGlobals.getModifiedBoogieVars(string);
        boolean bl = ReturnCheckHelper.isSelfConnectedViaLocalVarsAssignment(iPredicate, unmodifiableTransFormula);
        if (bl) {
            return false;
        }
        boolean bl2 = ReturnCheckHelper.isConnectedViaLocalVarsAssignment(iPredicate2, unmodifiableTransFormula, iPredicate);
        if (bl2) {
            return false;
        }
        IncrementalPlicationChecker.Validity validity = this.mCoverage.isCovered(iPredicate, iPredicate2);
        boolean bl3 = ReturnCheckHelper.canBeCrossConnectedViaGlobalVars(iPredicate2, iPredicate, set, validity == IncrementalPlicationChecker.Validity.VALID);
        if (bl3) {
            return false;
        }
        if (validity == IncrementalPlicationChecker.Validity.VALID) {
            return true;
        }
        return ReturnCheckHelper.disjointOnNonModifiableGlobals(iPredicate2, iPredicate, set);
    }

    private static boolean canBeCrossConnectedViaGlobalVars(IPredicate iPredicate, IPredicate iPredicate2, Set<IProgramNonOldVar> set, boolean bl) {
        for (IProgramVar iProgramVar : iPredicate2.getVars()) {
            IProgramVar iProgramVar2;
            if (iProgramVar instanceof IProgramOldVar) {
                iProgramVar2 = ((IProgramOldVar)iProgramVar).getNonOldVar();
                if (iPredicate.getVars().contains(iProgramVar2)) {
                    return true;
                }
                if (bl || set.contains(iProgramVar2) || !iPredicate.getVars().contains(iProgramVar)) continue;
                return true;
            }
            if (!(iProgramVar instanceof IProgramNonOldVar) || bl || set.contains(iProgramVar)) continue;
            if (iPredicate.getVars().contains(iProgramVar)) {
                return true;
            }
            iProgramVar2 = ((IProgramNonOldVar)iProgramVar).getOldVar();
            if (!iPredicate.getVars().contains(iProgramVar2)) continue;
            return true;
        }
        return false;
    }

    private static boolean disjointOnNonModifiableGlobals(IPredicate iPredicate, IPredicate iPredicate2, Set<IProgramNonOldVar> set) {
        for (IProgramVar iProgramVar : iPredicate2.getVars()) {
            if (!(iProgramVar instanceof IProgramNonOldVar) || set.contains(iProgramVar) || !iPredicate.getVars().contains(iProgramVar)) continue;
            return false;
        }
        return true;
    }

    private static boolean isConnectedViaLocalVarsAssignment(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula, IPredicate iPredicate2) {
        return !ReturnCheckHelper.varsDisjointFromOutVars(iPredicate2, unmodifiableTransFormula) && !ReturnCheckHelper.varsDisjointFromInVars(iPredicate, unmodifiableTransFormula);
    }

    private static boolean isSelfConnectedViaLocalVarsAssignment(IPredicate iPredicate, UnmodifiableTransFormula unmodifiableTransFormula) {
        return !ReturnCheckHelper.varsDisjointFromOutVars(iPredicate, unmodifiableTransFormula);
    }

    private static boolean prePostIndependent(IPredicate iPredicate, IReturnAction iReturnAction, IPredicate iPredicate2) {
        UnmodifiableTransFormula unmodifiableTransFormula = iReturnAction.getAssignmentOfReturn();
        if (!ReturnCheckHelper.varsDisjointFromInVars(iPredicate, unmodifiableTransFormula) && !ReturnCheckHelper.varsDisjointFromOutVars(iPredicate2, unmodifiableTransFormula)) {
            return false;
        }
        UnmodifiableTransFormula unmodifiableTransFormula2 = iReturnAction.getLocalVarsAssignmentOfCall();
        if (!ReturnCheckHelper.varsDisjointFromInVars(iPredicate2, unmodifiableTransFormula2) && !ReturnCheckHelper.varsDisjointFromOutVars(iPredicate, unmodifiableTransFormula2)) {
            return false;
        }
        for (IProgramVar iProgramVar : iPredicate.getVars()) {
            if (!iProgramVar.isGlobal() || iProgramVar.isOldvar() || !iPredicate2.getVars().contains(iProgramVar)) continue;
            return false;
        }
        return true;
    }

    private boolean hierPostIndependent(IPredicate iPredicate, IReturnAction iReturnAction, IPredicate iPredicate2) {
        Set<IProgramVar> set = iReturnAction.getAssignmentOfReturn().getOutVars().keySet();
        String string = iReturnAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> set2 = this.mModifiableGlobals.getModifiedBoogieVars(string);
        for (IProgramVar iProgramVar : iPredicate2.getVars()) {
            if (set2.contains(iProgramVar) || set.contains(iProgramVar) || !iPredicate.getVars().contains(iProgramVar)) continue;
            return false;
        }
        return true;
    }
}

