/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.Intvasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IntvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.IntVasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasrs.QvasrsAbstraction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class QvasrUtils {
    private QvasrUtils() {
    }

    public static Set<Term> splitDisjunction(Term term) {
        HashSet<Term> hashSet = new HashSet<Term>();
        ApplicationTerm applicationTerm = (ApplicationTerm)term;
        if (!"or".equals(applicationTerm.getFunction().getName())) {
            hashSet.add(term);
        } else {
            hashSet.addAll(Arrays.asList(applicationTerm.getParameters()));
        }
        return hashSet;
    }

    public static Set<Term> checkDisjoint(Set<Term> set, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique) {
        HashDeque hashDeque = new HashDeque();
        HashSet<Term> hashSet = new HashSet<Term>();
        hashDeque.addAll(set);
        while (!hashDeque.isEmpty()) {
            Term term = (Term)hashDeque.pop();
            boolean bl = false;
            for (Term term2 : hashDeque) {
                if (SmtUtils.checkSatTerm((Script)managedScript.getScript(), (Term)SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term, term2})) != Script.LBool.SAT) continue;
                hashDeque.add(SmtUtils.simplify((ManagedScript)managedScript, (Term)SmtUtils.or((Script)managedScript.getScript(), (Term[])new Term[]{term, term2}), (IUltimateServiceProvider)iUltimateServiceProvider, (SmtUtils.SimplificationTechnique)simplificationTechnique));
                bl = true;
                break;
            }
            if (bl) continue;
            hashSet.add(term);
        }
        return hashSet;
    }

    public static Rational[][] getCoherenceIdentityMatrix(Set<Integer> set, int n) {
        Rational[][] rationalArray = new Rational[set.size()][n];
        int n2 = 0;
        while (n2 < set.size()) {
            int n3 = 0;
            while (n3 < n) {
                rationalArray[n2][n3] = Rational.ZERO;
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        for (Integer n4 : set) {
            rationalArray[n2][n4.intValue()] = Rational.ONE;
            ++n2;
        }
        return rationalArray;
    }

    public static Rational[][] getIdentityMatrix(int n) {
        Rational[][] rationalArray = new Rational[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                rationalArray[n2][n3] = n2 == n3 ? Rational.ONE : Rational.ZERO;
                ++n3;
            }
            ++n2;
        }
        return rationalArray;
    }

    public static Term[][] vectorMatrixMultiplicationWithVariables(ManagedScript managedScript, Term[] termArray, Rational[][] rationalArray) {
        int n = termArray.length;
        int n2 = rationalArray.length;
        if (n != n2) {
            throw new UnsupportedOperationException();
        }
        int n3 = rationalArray[0].length;
        Term[][] termArray2 = new Term[1][n3];
        int n4 = 0;
        while (n4 < n3) {
            termArray2[0][n4] = managedScript.getScript().decimal("0");
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            Term term = managedScript.getScript().decimal("0");
            int n5 = 0;
            while (n5 < n2) {
                Term term2 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{termArray[n5], rationalArray[n5][n4].toTerm(SmtSortUtils.getRealSort((ManagedScript)managedScript))});
                termArray2[0][n4] = term = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{term, term2});
                ++n5;
            }
            ++n4;
        }
        return termArray2;
    }

    public static Term[][] matrixVectorMultiplicationWithVariables(ManagedScript managedScript, Integer[][] integerArray, Term[][] termArray) {
        int n = termArray.length;
        int n2 = integerArray[0].length;
        assert (n == n2);
        int n3 = integerArray.length;
        Term[][] termArray2 = new Term[n3][1];
        int n4 = 0;
        while (n4 < n3) {
            termArray2[n4][0] = managedScript.getScript().numeral("0");
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            Term term = managedScript.getScript().numeral("0");
            int n5 = 0;
            while (n5 < n2) {
                Term term2 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{termArray[n5][0], managedScript.getScript().numeral(integerArray[n4][n5].toString())});
                termArray2[n4][0] = term = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{term, term2});
                ++n5;
            }
            ++n4;
        }
        return termArray2;
    }

    public static boolean checkTermEquiv(ManagedScript managedScript, Term term, Term term2) {
        return SmtUtils.areFormulasEquivalent((Term)term, (Term)term2, (Script)managedScript.getScript());
    }

    public static boolean isApplicationTerm(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getParameters().length > 0;
    }

    public static UnmodifiableTransFormula buildFormula(UnmodifiableTransFormula unmodifiableTransFormula, Term term, ManagedScript managedScript) {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), true, null, true, null, false);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(unmodifiableTransFormula.getAuxVars(), managedScript);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula buildFormula(ManagedScript managedScript, Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, map2, true, null, true, null, true);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static Rational[][] rationalMatrixVectorMultiplication(Rational[][] rationalArray, Rational[][] rationalArray2) {
        int n;
        int n2;
        if (rationalArray2.length == 1) {
            rationalArray2 = QvasrUtils.transposeRowToColumnVector(rationalArray2);
        }
        if ((n2 = rationalArray2.length) != (n = rationalArray[0].length)) {
            throw new UnsupportedOperationException();
        }
        int n3 = rationalArray.length;
        Rational[][] rationalArray3 = new Rational[n3][1];
        int n4 = 0;
        while (n4 < n3) {
            Rational rational = Rational.ZERO;
            int n5 = 0;
            while (n5 < n) {
                Rational rational2 = rationalArray2[n5][0].mul(rationalArray[n4][n5]);
                rationalArray3[n4][0] = rational = rational.add(rational2);
                ++n5;
            }
            ++n4;
        }
        return rationalArray3;
    }

    public static Rational[][] rationalMatrixMultiplication(Rational[][] rationalArray, Rational[][] rationalArray2) {
        int n;
        int n2 = rationalArray[0].length;
        int n3 = rationalArray2.length;
        if (n2 != n3) {
            return new Rational[0][0];
        }
        int n4 = rationalArray2[0].length;
        int n5 = rationalArray.length;
        Rational[][] rationalArray3 = new Rational[n5][n4];
        int n6 = 0;
        while (n6 < n5) {
            n = 0;
            while (n < n4) {
                rationalArray3[n6][n] = Rational.ZERO;
                ++n;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < n5) {
            n = 0;
            while (n < n4) {
                int n7 = 0;
                while (n7 < n2) {
                    Rational rational;
                    Rational rational2 = rationalArray[n6][n7].mul(rationalArray2[n7][n]);
                    rationalArray3[n6][n] = rational = rationalArray3[n6][n].add(rational2);
                    ++n7;
                }
                ++n;
            }
            ++n6;
        }
        return rationalArray3;
    }

    public static Rational[][] transposeRowToColumnVector(Rational[][] rationalArray) {
        Rational[][] rationalArray2 = new Rational[rationalArray[0].length][1];
        int n = 0;
        while (n < rationalArray[0].length) {
            rationalArray2[n][0] = rationalArray[0][n];
            ++n;
        }
        return rationalArray2;
    }

    public static Rational[][] transposeRowToColumnVector(Rational[] rationalArray) {
        Rational[][] rationalArray2 = new Rational[rationalArray.length][1];
        int n = 0;
        while (n < rationalArray.length) {
            rationalArray2[n][0] = rationalArray[n];
            ++n;
        }
        return rationalArray2;
    }

    public static Term[][] transposeRowToColumnTermVector(Term[] termArray) {
        Term[][] termArray2 = new Term[termArray.length][1];
        int n = 0;
        while (n < termArray.length) {
            termArray2[n][0] = termArray[n];
            ++n;
        }
        return termArray2;
    }

    public static Rational[] transposeColumnToRowVector(Rational[][] rationalArray) {
        Rational[] rationalArray2 = new Rational[rationalArray.length];
        int n = 0;
        while (n < rationalArray.length) {
            rationalArray2[n] = rationalArray[n][0];
            ++n;
        }
        return rationalArray2;
    }

    public static Set<Set<Term>> joinSet(Set<Set<Term>> set, Set<Term> set2) {
        HashSet<Set<Term>> hashSet = new HashSet<Set<Term>>(set);
        for (Set<Term> set3 : set) {
            HashSet<Term> hashSet2 = new HashSet<Term>(set3);
            hashSet2.addAll(set2);
            hashSet.add(hashSet2);
        }
        return hashSet;
    }

    public static BigInteger getLeastCommonMultiple(QvasrAbstraction qvasrAbstraction) {
        BigInteger bigInteger;
        Rational rational;
        BigInteger bigInteger2 = BigInteger.ZERO;
        BigInteger bigInteger3 = BigInteger.ONE;
        int n = 0;
        while (n < qvasrAbstraction.getSimulationMatrix().length) {
            int n2 = 0;
            while (n2 < qvasrAbstraction.getSimulationMatrix()[0].length) {
                rational = qvasrAbstraction.getSimulationMatrix()[n][n2];
                if (!rational.isIntegral()) {
                    bigInteger2 = Rational.gcd((BigInteger)bigInteger2, (BigInteger)rational.denominator());
                    bigInteger3 = bigInteger3.multiply(rational.denominator());
                }
                ++n2;
            }
            ++n;
        }
        for (Pair<Rational[], Rational[]> pair : qvasrAbstraction.getVasr().getTransformer()) {
            Rational rational2 = rational = (Rational)pair.getSecond();
            int n3 = ((Rational)rational2).length;
            int n4 = 0;
            while (n4 < n3) {
                Rational rational3 = rational2[n4];
                if (!rational3.isIntegral()) {
                    bigInteger2 = Rational.gcd((BigInteger)bigInteger2, (BigInteger)rational3.denominator());
                    bigInteger3 = bigInteger3.multiply(rational3.denominator());
                }
                ++n4;
            }
        }
        if (bigInteger2 == BigInteger.ZERO) {
            bigInteger2 = BigInteger.ONE;
        }
        if ((bigInteger = bigInteger3.divide(bigInteger2)).equals(BigInteger.ONE)) {
            bigInteger = bigInteger2;
        }
        return bigInteger;
    }

    public static IntvasrAbstraction qvasrAbstractionToInt(QvasrAbstraction qvasrAbstraction) {
        BigInteger bigInteger = QvasrUtils.getLeastCommonMultiple(qvasrAbstraction);
        Integer[][] integerArray = new Integer[qvasrAbstraction.getSimulationMatrix().length][qvasrAbstraction.getSimulationMatrix()[0].length];
        int n = 0;
        while (n < integerArray.length) {
            int n2 = 0;
            while (n2 < integerArray[0].length) {
                Rational rational = qvasrAbstraction.getSimulationMatrix()[n][n2].mul(bigInteger);
                assert (rational.isIntegral());
                integerArray[n][n2] = rational.numerator().intValue();
                ++n2;
            }
            ++n;
        }
        Intvasr intvasr = new Intvasr();
        for (Pair<Rational[], Rational[]> pair : qvasrAbstraction.getVasr().getTransformer()) {
            Integer[] integerArray2 = new Integer[((Rational[])pair.getFirst()).length];
            Integer[] integerArray3 = new Integer[((Rational[])pair.getFirst()).length];
            int n3 = 0;
            while (n3 < ((Rational[])pair.getFirst()).length) {
                assert (((Rational[])pair.getFirst())[n3].isIntegral());
                integerArray2[n3] = ((Rational[])pair.getFirst())[n3].numerator().intValue();
                Rational rational = ((Rational[])pair.getSecond())[n3].mul(bigInteger);
                assert (rational.isIntegral());
                integerArray3[n3] = rational.numerator().intValue();
                ++n3;
            }
            intvasr.addTransformer((Pair<Integer[], Integer[]>)new Pair((Object)integerArray2, (Object)integerArray3));
        }
        return new IntvasrAbstraction(integerArray, intvasr);
    }

    public static IntVasrsAbstraction qvasrsAbstactionToIntVasrsAbstraction(ManagedScript managedScript, QvasrsAbstraction qvasrsAbstraction) {
        BigInteger bigInteger = QvasrUtils.getLeastCommonMultiple(qvasrsAbstraction.getAbstraction());
        IntvasrAbstraction intvasrAbstraction = QvasrUtils.qvasrAbstractionToInt(qvasrsAbstraction.getAbstraction());
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>();
        HashMap<Term, TermVariable> hashMap3 = new HashMap<Term, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> object2 : qvasrsAbstraction.getInVars().entrySet()) {
            TermVariable termVariable = managedScript.constructFreshTermVariable(object2.getValue().getName(), SmtSortUtils.getIntSort((ManagedScript)managedScript));
            hashMap.put(object2.getKey(), termVariable);
            hashMap3.put((Term)object2.getValue(), termVariable);
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : qvasrsAbstraction.getOutVars().entrySet()) {
            TermVariable termVariable = managedScript.constructFreshTermVariable(entry.getValue().getName(), SmtSortUtils.getIntSort((ManagedScript)managedScript));
            hashMap2.put(entry.getKey(), termVariable);
            hashMap3.put((Term)entry.getValue(), termVariable);
        }
        IntVasrsAbstraction intVasrsAbstraction = new IntVasrsAbstraction(intvasrAbstraction, qvasrsAbstraction.getStates(), hashMap, hashMap2, qvasrsAbstraction.getPreState(), qvasrsAbstraction.getPostState());
        HashSet hashSet = new HashSet();
        for (Triple<Term, Pair<Rational[], Rational[]>, Term> triple : qvasrsAbstraction.getTransitions()) {
            Term term = Substitution.apply((ManagedScript)managedScript, hashMap3, (Term)((Term)triple.getFirst()));
            Term term2 = Substitution.apply((ManagedScript)managedScript, hashMap3, (Term)((Term)triple.getThird()));
            hashSet.add(term2);
            hashSet.add(term);
            Integer[] integerArray = new Integer[((Rational[])((Pair)triple.getSecond()).getFirst()).length];
            Integer[] integerArray2 = new Integer[((Rational[])((Pair)triple.getSecond()).getFirst()).length];
            int n = 0;
            while (n < ((Rational[])((Pair)triple.getSecond()).getFirst()).length) {
                integerArray[n] = ((Rational[])((Pair)triple.getSecond()).getFirst())[n].numerator().intValue();
                Rational rational = ((Rational[])((Pair)triple.getSecond()).getSecond())[n].mul(bigInteger);
                assert (rational.isIntegral());
                integerArray2[n] = rational.numerator().intValue();
                ++n;
            }
            Triple triple2 = new Triple((Object)term, (Object)new Pair((Object)integerArray, (Object)integerArray2), (Object)term2);
            intVasrsAbstraction.addTransition((Triple<Term, Pair<Integer[], Integer[]>, Term>)triple2);
        }
        intVasrsAbstraction.setStates(hashSet);
        Term term = Substitution.apply((ManagedScript)managedScript, hashMap3, (Term)qvasrsAbstraction.getPreState());
        Term term3 = Substitution.apply((ManagedScript)managedScript, hashMap3, (Term)qvasrsAbstraction.getPostState());
        intVasrsAbstraction.setPreState(term);
        intVasrsAbstraction.setPostState(term3);
        return intVasrsAbstraction;
    }
}

