/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.mapelim.monniaux;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.IdentityTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.mapelim.monniaux.StoreSelectEqualityCollector;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.FormulaToEqDisjunctiveConstraintConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MonniauxMapEliminator
implements IIcfgTransformer<IcfgLocation> {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final IIcfg<IcfgLocation> mIcfg;
    private final IIcfg<IcfgLocation> mResultIcfg;
    private final ILogger mLogger;
    private final IcfgTransformationBacktranslator mBacktranslationTracker;
    private final int mCells;

    public MonniauxMapEliminator(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, IIcfg<IcfgLocation> iIcfg, IcfgTransformationBacktranslator icfgTransformationBacktranslator, int n) {
        this.mServices = iUltimateServiceProvider;
        this.mIcfg = Objects.requireNonNull(iIcfg);
        this.mMgdScript = Objects.requireNonNull(this.mIcfg.getCfgSmtToolkit().getManagedScript());
        this.mLogger = iLogger;
        this.mBacktranslationTracker = icfgTransformationBacktranslator;
        this.mCells = n;
        this.mResultIcfg = this.eliminateMaps();
    }

    @Override
    public IIcfg<IcfgLocation> getResult() {
        return this.mResultIcfg;
    }

    private IIcfg<IcfgLocation> eliminateMaps() {
        BasicIcfg basicIcfg = new BasicIcfg(this.mIcfg.getIdentifier() + "ME", this.mIcfg.getCfgSmtToolkit(), IcfgLocation.class);
        ILocationFactory<IcfgLocation, IcfgLocation> iLocationFactory = (icfgLocation, debugIdentifier, string) -> {
            IcfgLocation icfgLocation2 = new IcfgLocation(debugIdentifier, string);
            ModelUtils.copyAnnotations((IElement)icfgLocation, (IElement)icfgLocation2);
            return icfgLocation2;
        };
        TransformedIcfgBuilder<IcfgLocation, IcfgLocation> transformedIcfgBuilder = new TransformedIcfgBuilder<IcfgLocation, IcfgLocation>(this.mLogger, iLocationFactory, this.mBacktranslationTracker, new IdentityTransformer(this.mIcfg.getCfgSmtToolkit()), this.mIcfg, basicIcfg);
        this.mMgdScript.lock((Object)this);
        this.iterate(transformedIcfgBuilder);
        transformedIcfgBuilder.finish();
        this.mMgdScript.unlock((Object)this);
        return basicIcfg;
    }

    private void iterate(TransformedIcfgBuilder<IcfgLocation, IcfgLocation> transformedIcfgBuilder) {
        Collection collection;
        Collection collection2;
        String string;
        Object object;
        UnmodifiableTransFormula unmodifiableTransFormula;
        IIcfgInternalTransition iIcfgInternalTransition;
        Sort sort;
        IcfgEdgeIterator icfgEdgeIterator;
        IProgramVar iProgramVar2;
        Object object2;
        Script script = this.mMgdScript.getScript();
        IIcfgSymbolTable iIcfgSymbolTable = this.mIcfg.getCfgSmtToolkit().getSymbolTable();
        Set set = iIcfgSymbolTable.getGlobals();
        HashSet hashSet = new HashSet();
        for (Map.Entry object32 : this.mIcfg.getProcedureEntryNodes().entrySet()) {
            String string2 = (String)object32.getKey();
            object2 = iIcfgSymbolTable.getLocals(string2);
            hashSet.addAll(object2);
        }
        HashSet hashSet2 = new HashSet(set.size() + hashSet.size());
        set.stream().filter(iProgramNonOldVar -> iProgramNonOldVar.getSort().isArraySort()).forEach(hashSet2::add);
        hashSet.stream().filter(iLocalProgramVar -> iLocalProgramVar.getSort().isArraySort()).forEach(hashSet2::add);
        object2 = new LinkedHashMap();
        LinkedHashMap<IProgramVar, List<IProgramVar>> linkedHashMap = new LinkedHashMap<IProgramVar, List<IProgramVar>>();
        LinkedHashSet<Collection> linkedHashSet = new LinkedHashSet<Collection>();
        for (IProgramVar iProgramVar2 : hashSet2) {
            assert (iProgramVar2.getSort().isArraySort());
            assert (iProgramVar2.getSort().getArguments().length == 2) : "Array sort with != 2 arguments";
            icfgEdgeIterator = iProgramVar2.getSort().getArguments()[0];
            sort = iProgramVar2.getSort().getArguments()[1];
            iIcfgInternalTransition = new LinkedHashSet();
            unmodifiableTransFormula = new ArrayList();
            int n = 0;
            while (n < this.mCells) {
                object = iProgramVar2.toString() + "_idx_" + Integer.toString(n);
                string = iProgramVar2.toString() + "_val_" + Integer.toString(n);
                collection2 = ProgramVarUtils.constructGlobalProgramVarPair((String)SmtUtils.removeSmtQuoteCharacters((String)object), (Sort)icfgEdgeIterator, (ManagedScript)this.mMgdScript, (Object)this);
                collection = ProgramVarUtils.constructGlobalProgramVarPair((String)SmtUtils.removeSmtQuoteCharacters((String)string), (Sort)sort, (ManagedScript)this.mMgdScript, (Object)this);
                iIcfgInternalTransition.add(collection2);
                unmodifiableTransFormula.add(collection);
                linkedHashSet.add(collection);
                ++n;
            }
            object2.put(iProgramVar2, iIcfgInternalTransition);
            linkedHashMap.put(iProgramVar2, (List<IProgramVar>)unmodifiableTransFormula);
        }
        iProgramVar2 = new LinkedHashMap();
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        icfgEdgeIterator = new IcfgEdgeIterator(this.mIcfg);
        while (icfgEdgeIterator.hasNext()) {
            sort = icfgEdgeIterator.next();
            if (sort instanceof IIcfgInternalTransition) {
                Object object3;
                Term term;
                Object object4;
                Object object52;
                Object object62;
                Object object7;
                Object object82;
                Object object9;
                Object object10;
                IProgramVar iProgramVar32;
                Object object11;
                Object object122;
                Term term2;
                Object object13;
                Object object14;
                Object object15;
                Term term3;
                Object object16;
                Term term42;
                Object object172;
                Object object18;
                Object object19;
                Object object20;
                Object object212;
                Object object22;
                Object object23;
                Cloneable cloneable;
                Cloneable cloneable2;
                Object object24;
                Object object25;
                Object object262;
                Object object27;
                Object object282;
                Object object29;
                Object object30;
                iIcfgInternalTransition = (IIcfgInternalTransition)sort;
                unmodifiableTransFormula = iIcfgInternalTransition.getTransformula();
                Term term5 = unmodifiableTransFormula.getFormula();
                object = new FormulaToEqDisjunctiveConstraintConverter.StoreChainSquisher(this.mMgdScript);
                string = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)object.transform(term5));
                collection2 = object.getReplacementEquations();
                collection = object.getReplacementTermVariables();
                StoreSelectEqualityCollector storeSelectEqualityCollector = new StoreSelectEqualityCollector();
                storeSelectEqualityCollector.transform((Term)string);
                Boolean bl = storeSelectEqualityCollector.hasMultDim();
                if (storeSelectEqualityCollector.isEmpty()) {
                    object30 = iIcfgInternalTransition.getSource();
                    object29 = transformedIcfgBuilder.createNewLocation((IcfgLocation)object30);
                    object282 = iIcfgInternalTransition.getTarget();
                    object27 = transformedIcfgBuilder.createNewLocation((IcfgLocation)object282);
                    transformedIcfgBuilder.createNewTransition((IcfgLocation)object29, (IcfgLocation)object27, (IcfgEdge)iIcfgInternalTransition);
                    continue;
                }
                object30 = new HashMap();
                object29 = new HashSet(unmodifiableTransFormula.getAuxVars());
                for (Object object282 : collection) {
                    object29.add((TermVariable)object282);
                }
                object282 = new LinkedHashMap();
                object27 = new LinkedHashMap();
                LinkedHashSet<Object> linkedHashSet2 = new LinkedHashSet<Object>();
                Object object31 = object29.iterator();
                while (object31.hasNext()) {
                    object262 = (TermVariable)object31.next();
                    assert (object262.getSort().isArraySort());
                    assert (object262.getSort().getArguments().length == 2) : "Array sort with != 2 arguments";
                    if (!object262.getSort().isArraySort()) continue;
                    object25 = object262.getSort().getArguments()[0];
                    object24 = object262.getSort().getArguments()[1];
                    cloneable2 = new LinkedHashSet();
                    cloneable = new ArrayList();
                    int n = 0;
                    while (n < this.mCells) {
                        object23 = object262.toString() + "_idx_" + Integer.toString(n);
                        object22 = object262.toString() + "_val_" + Integer.toString(n);
                        object212 = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)object23), (Sort)object25);
                        object20 = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)object22), (Sort)object24);
                        cloneable2.add(object212);
                        cloneable.add(object20);
                        linkedHashSet2.add(object212);
                        linkedHashSet2.add(object20);
                        ++n;
                    }
                    object282.put(object262, cloneable2);
                    object27.put(object262, cloneable);
                }
                for (Object object262 : linkedHashSet2) {
                    object29.add(object262);
                }
                object262 = new HashMap(unmodifiableTransFormula.getInVars());
                object31 = new HashMap(unmodifiableTransFormula.getOutVars());
                object25 = new LinkedHashMap();
                object24 = new LinkedHashMap();
                cloneable2 = new LinkedHashMap();
                cloneable = new LinkedHashMap();
                LinkedHashSet<IProgramVar> n = new LinkedHashSet<IProgramVar>(object262.keySet());
                n.addAll(object31.keySet());
                object23 = new LinkedHashMap();
                object22 = new LinkedHashMap();
                for (Object object212 : hashSet2) {
                    object19 = (TermVariable)object262.remove(object212);
                    object18 = (TermVariable)object31.remove(object212);
                    LinkedHashSet<Term> linkedHashSet3 = new LinkedHashSet<Term>();
                    for (Object object172 : (Set)object2.get(object212)) {
                        term42 = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(object172.toString() + "_term")), object172.getSort());
                        if (!iProgramVar2.containsKey(object172)) {
                            object16 = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(object172.toString() + "_term_assigned")), SmtSortUtils.getBoolSort((Script)script));
                            term3 = ProgramVarUtils.constructGlobalProgramVarPair((String)SmtUtils.removeSmtQuoteCharacters((String)(object172.toString() + "_bool")), (Sort)SmtSortUtils.getBoolSort((Script)script), (ManagedScript)this.mMgdScript, (Object)this);
                            iProgramVar2.put(object172, new Pair(object16, (Object)term3));
                        }
                        object262.put(object172, term42);
                        object31.put(object172, term42);
                        cloneable.put(term42, object172);
                        linkedHashSet3.add(term42);
                    }
                    if (object19 != null) {
                        object24.put(object19, linkedHashSet3);
                    }
                    if (object18 != null) {
                        object24.put(object18, linkedHashSet3);
                    }
                    for (Object object172 : iProgramVar2.keySet()) {
                        term42 = (IProgramVar)((Pair)iProgramVar2.get(object172)).getSecond();
                        object16 = (Term)((Pair)iProgramVar2.get(object172)).getFirst();
                        object262.put(term42, (TermVariable)object16);
                        object31.put(term42, (TermVariable)object16);
                    }
                    if (object19 != null) {
                        object172 = new ArrayList();
                        object15 = new ArrayList();
                        for (Term term42 : (List)linkedHashMap.get(object212)) {
                            term3 = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(term42.toString() + "_in")), term42.getSort());
                            object262.put(term42, term3);
                            object172.add(term3);
                            object15.add(term3);
                        }
                        object25.put(object19, object172);
                        object22.put(object212, object15);
                        for (Term term42 : collection2) {
                            if (!(term42 instanceof ApplicationTerm) || (object14 = (object13 = ((ApplicationTerm)(term2 = (term3 = ((ApplicationTerm)term42).getParameters())[0] instanceof ApplicationTerm ? term3[0] : term3[1])).getParameters())[0]) != object19) continue;
                            object25.put(term3[1], object172);
                            object24.put(term3[1], (Set)object24.get(object19));
                        }
                    }
                    if (object18 == null) continue;
                    object172 = new ArrayList();
                    object15 = new ArrayList();
                    for (Term term42 : (List)linkedHashMap.get(object212)) {
                        term3 = storeSelectEqualityCollector.hasNoStoEqu() ? (TermVariable)object262.get(term42) : this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(term42.toString() + "_out")), term42.getSort());
                        object31.put(term42, term3);
                        object172.add(term3);
                        object15.add(term3);
                        cloneable2.put(term3, term42);
                    }
                    object25.put(object18, object172);
                    object23.put(object212, object15);
                    for (Term term42 : collection2) {
                        if (!(term42 instanceof ApplicationTerm) || (object14 = (object13 = (term2 = (term3 = ((ApplicationTerm)term42).getParameters())[0] instanceof ApplicationTerm ? (ApplicationTerm)term3[0] : (ApplicationTerm)term3[1]).getParameters())[0]) != object19) continue;
                        object25.put(term3[1], object172);
                        object24.put(term3[1], (Set)object24.get(object18));
                    }
                }
                object212 = new LinkedHashMap();
                object20 = new LinkedHashSet();
                object19 = new LinkedHashMap();
                object18 = new LinkedHashMap();
                for (Term term6 : storeSelectEqualityCollector.getSelectTerms()) {
                    object15 = (ApplicationTerm)term6;
                    term42 = MonniauxMapEliminator.eliminateSelects(this.mMgdScript, (Map<Term, Set<Term>>)object24, (ApplicationTerm)object15, (Map<Term, List<Term>>)object25, (Set<TermVariable>)object29, (Map<Term, Term>)object30, (Map<Term, IProgramVar>)((Object)cloneable), linkedHashMap2, (Map<IProgramVar, TermVariable>)object262, (Map<IProgramVar, Pair<List<Term>, Integer>>)object19, n, this.mCells, linkedHashMap, (Map<Term, Term>)object18, (Map<Term, Set<Term>>)object282, (Map<Term, List<Term>>)object27, (Map<Term, Term>)object212);
                    object30.put(term6, (Term)term42.getFirst());
                    object20.add((Term)term42.getSecond());
                }
                for (Term term7 : storeSelectEqualityCollector.getStoreTerms()) {
                    object15 = (ApplicationTerm)term7;
                    term42 = MonniauxMapEliminator.eliminateStores(this.mMgdScript, (Map<Term, Set<Term>>)object24, (ApplicationTerm)object15, (Map<Term, List<Term>>)object25, (Map<IProgramVar, TermVariable>)object262, (Map<Term, IProgramVar>)((Object)cloneable2), (Map<Term, Term>)object30, collection, (Map<Term, IProgramVar>)((Object)cloneable), linkedHashMap2, (Map<IProgramVar, Pair<List<Term>, Integer>>)object19, this.mCells, linkedHashMap, (Map<Term, Term>)object18, n, (Map<Term, Set<Term>>)object282, (Map<Term, List<Term>>)object27);
                    object30.put(term7, term42);
                }
                for (Term term8 : storeSelectEqualityCollector.getEqualityTerms()) {
                    object15 = (ApplicationTerm)term8;
                    term42 = MonniauxMapEliminator.eliminateEqualities(this.mMgdScript, (Map<Term, Set<Term>>)object24, (ApplicationTerm)object15, (Map<Term, List<Term>>)object25, (Map<Term, Term>)object30);
                    object30.put(term8, term42);
                }
                for (IProgramVar iProgramVar4 : object262.keySet()) {
                    if (!linkedHashSet.contains(iProgramVar4)) continue;
                    object20.add(SmtUtils.binaryEquality((Script)script, (Term)((Term)object262.get(iProgramVar4)), (Term)((Term)object31.get(iProgramVar4))));
                }
                HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
                object172 = new HashMap();
                object15 = SmtUtils.getDisjuncts((Term)string);
                int n2 = 0;
                while (n2 < ((Object)object15).length) {
                    object16 = object15[n2];
                    term3 = new StoreSelectEqualityCollector();
                    term3.transform((Term)object16);
                    term2 = new HashSet();
                    object13 = new HashSet(term3.getStoreTerms());
                    object122 = object13.iterator();
                    while (object122.hasNext()) {
                        object14 = (Term)object122.next();
                        ApplicationTerm applicationTerm = (ApplicationTerm)object14;
                        object11 = applicationTerm.getParameters();
                        iProgramVar32 = object11[0];
                        object10 = object11[0];
                        object9 = object11;
                        int n3 = ((ApplicationTerm)object9).length;
                        int n4 = 0;
                        while (n4 < n3) {
                            object82 = object9[n4];
                            if (object82 instanceof ApplicationTerm) {
                                object7 = ((ApplicationTerm)object82).getParameters();
                                iProgramVar32 = object7[0];
                                object10 = object7[1];
                            }
                            ++n4;
                        }
                        object82 = (Set)object24.get(iProgramVar32);
                        if (object82 == null) {
                            object82 = (Set)object282.get(iProgramVar32);
                        }
                        object62 = object82.iterator();
                        while (object62.hasNext()) {
                            Term term9 = (Term)object62.next();
                            object9 = hashMap.get(n2) != null ? new HashSet((Collection)hashMap.get(n2)) : null;
                            if (object9 != null) {
                                object52 = object9.iterator();
                                while (object52.hasNext()) {
                                    object7 = (Pair)object52.next();
                                    object4 = new HashSet((Collection)object7.getSecond());
                                    object4.add(object10);
                                    term = new HashSet(object9);
                                    term.add(new Pair((Object)term9, object4));
                                    hashMap.put(n2, term);
                                    if (object29.contains(term9)) continue;
                                    term2.add((Term)((Pair)iProgramVar2.get(cloneable.get(term9))).getFirst());
                                }
                                continue;
                            }
                            object7 = new HashSet();
                            object7.add(object10);
                            object52 = new HashSet();
                            object52.add(new Pair((Object)term9, object7));
                            hashMap.put(n2, object52);
                            if (object29.contains(term9)) continue;
                            term2.add((Term)((Pair)iProgramVar2.get(cloneable.get(term9))).getFirst());
                        }
                    }
                    object14 = new HashSet<Term>(term3.getSelectTerms());
                    Iterator iterator = object14.iterator();
                    while (iterator.hasNext()) {
                        object122 = (Term)iterator.next();
                        object11 = (ApplicationTerm)object122;
                        iProgramVar32 = object11.getParameters();
                        object10 = iProgramVar32[0];
                        object82 = iProgramVar32[1];
                        Set set2 = (Set)object24.get(object10);
                        if (set2 == null) {
                            set2 = (Set)object282.get(object10);
                        }
                        for (Object object62 : set2) {
                            object7 = hashMap.get(n2) != null ? new HashSet((Collection)hashMap.get(n2)) : null;
                            if (object7 != null) {
                                for (Object object52 : object7) {
                                    term = (Term)object52.getSecond();
                                    term.add(object82);
                                    object3 = new HashSet(object7);
                                    object3.add(new Pair(object62, term));
                                    hashMap.put(n2, object3);
                                    if (object29.contains(object62)) continue;
                                    term2.add((Term)((Pair)iProgramVar2.get(cloneable.get(object62))).getFirst());
                                }
                                continue;
                            }
                            object52 = new HashSet();
                            object52.add(object82);
                            object4 = new HashSet();
                            object4.add(new Pair(object62, object52));
                            hashMap.put(n2, object4);
                            if (object29.contains(object62)) continue;
                            term2.add((Term)((Pair)iProgramVar2.get(cloneable.get(object62))).getFirst());
                        }
                    }
                    if (hashMap.get(n2) != null) {
                        for (Object object122 : (Set)hashMap.get(n2)) {
                            object11 = (Set)object122.getSecond();
                            iProgramVar32 = (Term)object122.getFirst();
                            object10 = new HashSet();
                            Iterator iterator2 = object11.iterator();
                            while (iterator2.hasNext()) {
                                object82 = (Term)iterator2.next();
                                object10.add(SmtUtils.binaryEquality((Script)script, (Term)iProgramVar32, (Term)object82));
                            }
                            object82 = (IProgramVar)cloneable.get(iProgramVar32);
                            if (object82 == null) continue;
                            term2.add(SmtUtils.implies((Script)script, (Term)((Term)((Pair)iProgramVar2.get(cloneable.get(iProgramVar32))).getFirst()), (Term)SmtUtils.or((Script)script, (Collection)object10)));
                        }
                    }
                    term2.add(object16);
                    object172.put(object16, SmtUtils.and((Script)script, (Collection)term2));
                    ++n2;
                }
                term42 = Substitution.apply((ManagedScript)this.mMgdScript, (Map)object172, (Term)string);
                object20.add(term42);
                object16 = Substitution.apply((ManagedScript)this.mMgdScript, (Map)object30, (Term)SmtUtils.and((Script)script, (Collection)object20));
                term3 = object16;
                while (bl.booleanValue()) {
                    term2 = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)object.transform((Term)object16));
                    object13 = new StoreSelectEqualityCollector();
                    object13.transform(term2);
                    object14 = new HashMap();
                    object122 = new LinkedHashSet();
                    for (Term term10 : ((StoreSelectEqualityCollector)((Object)object13)).getSelectTerms()) {
                        iProgramVar32 = (IProgramVar)term10;
                        object10 = MonniauxMapEliminator.eliminateSelects(this.mMgdScript, (Map<Term, Set<Term>>)object24, (ApplicationTerm)iProgramVar32, (Map<Term, List<Term>>)object25, (Set<TermVariable>)object29, (Map<Term, Term>)object30, (Map<Term, IProgramVar>)((Object)cloneable), linkedHashMap2, (Map<IProgramVar, TermVariable>)object262, (Map<IProgramVar, Pair<List<Term>, Integer>>)object19, n, this.mCells, linkedHashMap, (Map<Term, Term>)object18, (Map<Term, Set<Term>>)object282, (Map<Term, List<Term>>)object27, (Map<Term, Term>)object212);
                        object14.put(term10, (Term)object10.getFirst());
                        object122.add((Term)object10.getSecond());
                    }
                    for (IProgramVar iProgramVar5 : object262.keySet()) {
                        if (!linkedHashSet.contains(iProgramVar5)) continue;
                        object122.add(SmtUtils.binaryEquality((Script)script, (Term)((Term)object262.get(iProgramVar5)), (Term)((Term)object31.get(iProgramVar5))));
                    }
                    HashMap<Integer, Object> hashMap2 = new HashMap<Integer, Object>();
                    object11 = new HashMap();
                    iProgramVar32 = SmtUtils.getDisjuncts((Term)term2);
                    int n5 = 0;
                    while (n5 < ((Term[])iProgramVar32).length) {
                        Object object32;
                        Term term11;
                        object82 = iProgramVar32[n5];
                        StoreSelectEqualityCollector storeSelectEqualityCollector2 = new StoreSelectEqualityCollector();
                        storeSelectEqualityCollector2.transform((Term)object82);
                        object62 = new HashSet();
                        object9 = new HashSet<Term>(storeSelectEqualityCollector2.getSelectTerms());
                        object52 = object9.iterator();
                        while (object52.hasNext()) {
                            object7 = (Term)object52.next();
                            object4 = (ApplicationTerm)object7;
                            term = object4.getParameters();
                            object3 = term[0];
                            term11 = term[1];
                            object32 = (Set)object24.get(object3);
                            if (object32 == null) {
                                object32 = (Set)object282.get(object3);
                            }
                            Iterator iterator = object32.iterator();
                            while (iterator.hasNext()) {
                                Pair pair2;
                                Term term12 = (Term)iterator.next();
                                HashSet hashSet3 = hashMap2.get(n5) != null ? new HashSet((Collection)hashMap2.get(n5)) : null;
                                if (hashSet3 != null) {
                                    for (Pair pair2 : hashSet3) {
                                        Set set3 = (Set)pair2.getSecond();
                                        set3.add(term11);
                                        HashSet<Pair> hashSet4 = new HashSet<Pair>(hashSet3);
                                        hashSet4.add(new Pair((Object)term12, (Object)set3));
                                        hashMap2.put(n5, hashSet4);
                                        if (object29.contains(term12)) continue;
                                        object62.add((Term)((Pair)iProgramVar2.get(cloneable.get(term12))).getFirst());
                                    }
                                    continue;
                                }
                                pair2 = new HashSet();
                                pair2.add(term11);
                                HashSet hashSet5 = new HashSet();
                                hashSet5.add(new Pair((Object)term12, (Object)pair2));
                                hashMap2.put(n5, hashSet5);
                                if (object29.contains(term12)) continue;
                                object62.add((Term)((Pair)iProgramVar2.get(cloneable.get(term12))).getFirst());
                            }
                        }
                        if (hashMap2.get(n5) != null) {
                            object52 = ((Set)hashMap2.get(n5)).iterator();
                            while (object52.hasNext()) {
                                object7 = (Pair)object52.next();
                                object4 = (Set)object7.getSecond();
                                term = (Term)object7.getFirst();
                                object3 = new HashSet();
                                object32 = object4.iterator();
                                while (object32.hasNext()) {
                                    term11 = (Term)object32.next();
                                    object3.add(SmtUtils.binaryEquality((Script)script, (Term)term, (Term)term11));
                                }
                                term11 = (IProgramVar)cloneable.get(term);
                                if (term11 != null) {
                                    object62.add(SmtUtils.implies((Script)script, (Term)((Term)((Pair)iProgramVar2.get(cloneable.get(term))).getFirst()), (Term)SmtUtils.or((Script)script, (Collection)object3)));
                                    continue;
                                }
                                object62.add(SmtUtils.or((Script)script, (Collection)object3));
                            }
                        }
                        object62.add(object82);
                        object11.put(object82, SmtUtils.and((Script)script, (Collection)object62));
                        ++n5;
                    }
                    object10 = Substitution.apply((ManagedScript)this.mMgdScript, (Map)object11, (Term)term2);
                    object122.add(object10);
                    term3 = Substitution.apply((ManagedScript)this.mMgdScript, (Map)object14, (Term)SmtUtils.and((Script)script, (Collection)object122));
                    bl = ((StoreSelectEqualityCollector)((Object)object13)).hasMultDim();
                }
                term2 = this.buildTransitionFormula(unmodifiableTransFormula, term3, (Map<IProgramVar, TermVariable>)object262, (Map<IProgramVar, TermVariable>)object31, (Collection<TermVariable>)object29);
                object13 = iIcfgInternalTransition.getSource();
                object14 = transformedIcfgBuilder.createNewLocation((IcfgLocation)object13);
                object122 = iIcfgInternalTransition.getTarget();
                IcfgLocation icfgLocation = transformedIcfgBuilder.createNewLocation((IcfgLocation)object122);
                object11 = transformedIcfgBuilder.createNewInternalTransition((IcfgLocation)object14, icfgLocation, (UnmodifiableTransFormula)term2, true);
                this.mLogger.info(object14);
                this.mLogger.info((Object)("In  " + unmodifiableTransFormula.toStringDirect()));
                this.mLogger.info((Object)("Out " + term2.toStringDirect()));
                this.mLogger.info((Object)icfgLocation);
                for (IProgramVar iProgramVar32 : hashSet2) {
                    for (Object object82 : (Set)object2.get(iProgramVar32)) {
                        if (!linkedHashMap2.containsKey(object82)) continue;
                        linkedHashMap2.remove(object82);
                        object62 = new HashSet();
                        object62.add((Term)object31.get(object82));
                        linkedHashMap2.put(object82, object62);
                    }
                }
                this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)object11, (IIcfgTransition<IcfgLocation>)iIcfgInternalTransition);
                continue;
            }
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private UnmodifiableTransFormula buildTransitionFormula(UnmodifiableTransFormula unmodifiableTransFormula, Term term, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2, Collection<TermVariable> collection) {
        Set set = unmodifiableTransFormula.getNonTheoryConsts();
        boolean bl = collection.isEmpty();
        Set set2 = unmodifiableTransFormula.getBranchEncoders();
        boolean bl2 = set2.isEmpty();
        boolean bl3 = set.isEmpty();
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map, map2, bl3, set, bl2, (Collection)set2, bl);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        collection.stream().forEach(arg_0 -> ((TransFormulaBuilder)transFormulaBuilder).addAuxVar(arg_0));
        this.mMgdScript.unlock((Object)this);
        UnmodifiableTransFormula unmodifiableTransFormula2 = transFormulaBuilder.finishConstruction(this.mMgdScript);
        this.mMgdScript.lock((Object)this);
        return unmodifiableTransFormula2;
    }

    private static Pair<TermVariable, Term> eliminateSelects(ManagedScript managedScript, Map<Term, Set<Term>> map, ApplicationTerm applicationTerm, Map<Term, List<Term>> map2, Set<TermVariable> set, Map<Term, Term> map3, Map<Term, IProgramVar> map4, Map<IProgramVar, Set<Term>> map5, Map<IProgramVar, TermVariable> map6, Map<IProgramVar, Pair<List<Term>, Integer>> map7, Set<IProgramVar> set2, int n, Map<IProgramVar, List<IProgramVar>> map8, Map<Term, Term> map9, Map<Term, Set<Term>> map10, Map<Term, List<Term>> map11, Map<Term, Term> map12) {
        TermVariable termVariable;
        Sort sort2;
        TermVariable termVariable2;
        Object object;
        IProgramVar iProgramVar32;
        Term[] termArray = applicationTerm.getParameters();
        Term term = map3.containsKey(termArray[0]) ? map3.get(termArray[0]) : termArray[0];
        Term term2 = map3.containsKey(termArray[1]) ? map3.get(termArray[1]) : termArray[1];
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<TermVariable> arrayList2 = new ArrayList<TermVariable>();
        IProgramVar iProgramVar2 = null;
        for (IProgramVar iProgramVar32 : set2) {
            if (!term.toString().contains(iProgramVar32.toString())) continue;
            iProgramVar2 = iProgramVar32;
        }
        if (map2.containsKey(term)) {
            arrayList.addAll((Collection)map2.get(term));
            arrayList2.addAll((Collection)map.get(term));
        }
        if (!(map2.containsKey(term) || map7.containsKey(iProgramVar2) || set.contains(term))) {
            int n2 = 0;
            while (n2 < n) {
                String string = iProgramVar2.toString() + "_val_" + Integer.toString(n2) + Integer.toString(0);
                object = managedScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)string), map8.get(iProgramVar2).iterator().next().getSort());
                arrayList.add(object);
                ++n2;
            }
            map7.put(iProgramVar2, (Pair<List<Term>, Integer>)new Pair(arrayList, (Object)0));
            arrayList2.addAll((Collection)map.get(map6.get(iProgramVar2)));
        }
        if (map7.containsKey(iProgramVar2)) {
            int n3 = (Integer)map7.get(iProgramVar2).getValue() + 1;
            int n4 = 0;
            while (n4 < n) {
                object = iProgramVar2.toString() + "_val_" + Integer.toString(n4) + Integer.toString(n3);
                termVariable2 = managedScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)object), map8.get(iProgramVar2).iterator().next().getSort());
                arrayList.add(termVariable2);
                map9.put((Term)termVariable2, (Term)((List)map7.get(iProgramVar2).getFirst()).get(n3 - 1));
                ++n4;
            }
            map7.remove(iProgramVar2);
            map7.put(iProgramVar2, (Pair<List<Term>, Integer>)new Pair(arrayList, (Object)n3));
            arrayList2.addAll((Collection)map.get(map6.get(iProgramVar2)));
        }
        if (map11.containsKey(term)) {
            arrayList.addAll((Collection)map11.get(term));
            arrayList2.addAll((Collection)map10.get(term));
        }
        iProgramVar32 = managedScript.getScript();
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            LinkedHashSet<TermVariable> linkedHashSet = new LinkedHashSet<TermVariable>();
            object = new ArrayList();
            int n5 = 0;
            while (n5 < n) {
                assert (term.getSort().isArraySort());
                assert (term.getSort().getArguments().length == 2) : "Array sort with != 2 arguments";
                if (term.getSort().isArraySort()) {
                    sort2 = term2.getSort();
                    Sort sort4 = term.getSort();
                    String string = term.toString() + "_iterIdx" + Integer.toString(n5);
                    String string2 = term.toString() + "_iterVal" + Integer.toString(n5);
                    TermVariable termVariable3 = managedScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)string), sort2);
                    termVariable = managedScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)string2), sort4);
                    linkedHashSet.add(termVariable3);
                    object.add(termVariable);
                    arrayList2.add(termVariable3);
                    arrayList.add(termVariable);
                    set.add(termVariable);
                    set.add(termVariable3);
                }
                ++n5;
            }
            map10.put(term, linkedHashSet);
            map11.put(term, (List<Term>)object);
        }
        if (map12.containsKey(term)) {
            Sort sort3 = term.getSort().getArguments()[1];
            object = managedScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(term.toString() + "_aux")), sort3);
            set.add((TermVariable)object);
            sort2 = new HashSet();
            for (Term term3 : arrayList) {
                for (Term term4 : arrayList2) {
                    termVariable = new HashSet();
                    if (map5.containsKey(map4.get(term4))) {
                        termVariable.addAll((Collection)map5.get(map4.get(term4)));
                    }
                    termVariable.add(term2);
                    map5.put(map4.get(term4), (Set<Term>)termVariable);
                    sort2.add(SmtUtils.implies((Script)iProgramVar32, (Term)SmtUtils.and((Script)iProgramVar32, (Term[])new Term[]{SmtUtils.binaryEquality((Script)iProgramVar32, (Term)term2, (Term)term4), map12.get(term)}), (Term)SmtUtils.binaryEquality((Script)iProgramVar32, (Term)term3, (Term)term)));
                    map12.put(term3, SmtUtils.binaryEquality((Script)iProgramVar32, (Term)term2, (Term)term4));
                }
            }
            termVariable2 = SmtUtils.and((Script)iProgramVar32, (Collection)sort2);
            Pair pair = new Pair(object, (Object)termVariable2);
            return pair;
        }
        Sort sort5 = term.getSort().getArguments()[1];
        object = managedScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(term.toString() + "_aux")), sort5);
        set.add((TermVariable)object);
        sort2 = new HashSet();
        for (Term term5 : arrayList) {
            for (Term term6 : arrayList2) {
                termVariable = new HashSet();
                if (map5.containsKey(map4.get(term6))) {
                    termVariable.addAll((Collection)map5.get(map4.get(term6)));
                }
                termVariable.add(term2);
                map5.put(map4.get(term6), (Set<Term>)termVariable);
                sort2.add(SmtUtils.implies((Script)iProgramVar32, (Term)SmtUtils.binaryEquality((Script)iProgramVar32, (Term)term2, (Term)term6), (Term)SmtUtils.binaryEquality((Script)iProgramVar32, (Term)term5, (Term)object)));
                map12.put((Term)object, SmtUtils.binaryEquality((Script)iProgramVar32, (Term)term2, (Term)term6));
            }
        }
        termVariable2 = SmtUtils.and((Script)iProgramVar32, (Collection)sort2);
        Pair pair = new Pair(object, (Object)termVariable2);
        return pair;
    }

    private static Term eliminateStores(ManagedScript managedScript, Map<Term, Set<Term>> map, ApplicationTerm applicationTerm, Map<Term, List<Term>> map2, Map<IProgramVar, TermVariable> map3, Map<Term, IProgramVar> map4, Map<Term, Term> map5, Collection<Term> collection, Map<Term, IProgramVar> map6, Map<IProgramVar, Set<Term>> map7, Map<IProgramVar, Pair<List<Term>, Integer>> map8, int n, Map<IProgramVar, List<IProgramVar>> map9, Map<Term, Term> map10, Set<IProgramVar> set, Map<Term, Set<Term>> map11, Map<Term, List<Term>> map12) {
        Object object5;
        Object object2;
        Term term;
        IProgramVar iProgramVar = applicationTerm.getParameters();
        Term term2 = iProgramVar[0];
        Object object3 = iProgramVar[0];
        Object object4 = iProgramVar[0];
        IProgramVar iProgramVar22 = iProgramVar;
        int n2 = ((Term[])iProgramVar22).length;
        int n3 = 0;
        while (n3 < n2) {
            term = iProgramVar22[n3];
            if (term instanceof ApplicationTerm) {
                object2 = ((ApplicationTerm)term).getParameters();
                term2 = object2[0];
                object3 = object2[1];
                object4 = object2[2];
            }
            ++n3;
        }
        term = new ArrayList();
        ArrayList arrayList = new ArrayList();
        IProgramVar iProgramVar3 = null;
        for (IProgramVar iProgramVar22 : set) {
            if (!term2.toString().contains(iProgramVar22.toString())) continue;
            iProgramVar3 = iProgramVar22;
        }
        if (map2.containsKey(term2)) {
            term.addAll((Collection)map2.get(term2));
            arrayList.addAll(map.get(term2));
        }
        if (!(map2.containsKey(term2) || map8.containsKey(iProgramVar3) || map12.containsKey(term2))) {
            int n4 = 0;
            while (n4 < n) {
                object2 = iProgramVar3.toString() + "_val_" + Integer.toString(n4) + Integer.toString(0);
                object5 = managedScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)object2), map9.get(iProgramVar3).iterator().next().getSort());
                term.add(object5);
                ++n4;
            }
            map8.put(iProgramVar3, (Pair<List<Term>, Integer>)new Pair((Object)term, (Object)0));
            arrayList.addAll(map.get(map3.get(iProgramVar3)));
        }
        if (map8.containsKey(iProgramVar3)) {
            int n5 = (Integer)map8.get(iProgramVar3).getValue() + 1;
            int n6 = 0;
            while (n6 < n) {
                object5 = iProgramVar3.toString() + "_val_" + Integer.toString(n6) + Integer.toString(n5);
                TermVariable termVariable = managedScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)object5), map9.get(iProgramVar3).iterator().next().getSort());
                term.add(termVariable);
                map10.put((Term)termVariable, (Term)((List)map8.get(iProgramVar3).getFirst()).get(n5 - 1));
                ++n6;
            }
            map8.remove(iProgramVar3);
            map8.put(iProgramVar3, (Pair<List<Term>, Integer>)new Pair((Object)term, (Object)n5));
            arrayList.addAll(map.get(map3.get(iProgramVar3)));
        }
        if (map12.containsKey(term2)) {
            term.addAll((Collection)map12.get(term2));
            arrayList.addAll(map11.get(term2));
        }
        Script script = managedScript.getScript();
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        for (Object object5 : term) {
            Object object6 = map3.containsValue(object5) || collection.contains(term2) ? object5 : (map8.containsKey(iProgramVar3) ? map10.get(object5) : (Term)map3.get(map4.get(term2)));
            for (Term term3 : arrayList) {
                HashSet<Term> hashSet = new HashSet<Term>();
                if (map7.containsKey(map6.get(term3))) {
                    hashSet.addAll((Collection)map7.get(map6.get(term3)));
                }
                hashSet.add((Term)object3);
                map7.put(map6.get(term3), hashSet);
                linkedHashSet.add(SmtUtils.implies((Script)script, (Term)SmtUtils.binaryEquality((Script)script, (Term)object3, (Term)term3), (Term)SmtUtils.binaryEquality((Script)script, (Term)object5, (Term)object4)));
                linkedHashSet.add(SmtUtils.implies((Script)script, (Term)SmtUtils.distinct((Script)script, (Term)term3, (Term)object3), (Term)SmtUtils.binaryEquality((Script)script, (Term)object5, (Term)object6)));
            }
        }
        return SmtUtils.and((Script)script, linkedHashSet);
    }

    private static Term eliminateEqualities(ManagedScript managedScript, Map<Term, Set<Term>> map, ApplicationTerm applicationTerm, Map<Term, List<Term>> map2, Map<Term, Term> map3) {
        Term[] termArray = applicationTerm.getParameters();
        if (!(termArray[0] instanceof TermVariable)) {
            return applicationTerm;
        }
        if (!(termArray[1] instanceof TermVariable)) {
            return applicationTerm;
        }
        if (map3.containsKey(termArray[0])) {
            map3.get(termArray[0]);
        } else {
            Term cfr_ignored_0 = termArray[0];
        }
        if (map3.containsKey(termArray[1])) {
            map3.get(termArray[1]);
        } else {
            Term cfr_ignored_1 = termArray[1];
        }
        Script script = managedScript.getScript();
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>();
        List<Term> list = map2.get(termArray[0]);
        for (Term term : list) {
            Set<Term> set = map.get(termArray[0]);
            for (Term term2 : set) {
                for (Term term3 : map2.get(termArray[1])) {
                    for (Term term4 : map.get(termArray[1])) {
                        linkedHashSet.add(SmtUtils.implies((Script)script, (Term)SmtUtils.binaryEquality((Script)script, (Term)term2, (Term)term4), (Term)SmtUtils.binaryEquality((Script)script, (Term)term, (Term)term3)));
                    }
                }
            }
        }
        return SmtUtils.and((Script)script, linkedHashSet);
    }
}

