/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.BooleanDecision;
import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import java.util.Set;

public class RelationDecision
extends BooleanDecision {
    String leftExpr;
    String rightExpr;
    Operator op;

    public RelationDecision(String string, Operator operator, String string2) {
        super(string + String.valueOf((Object)operator) + string2);
        if (string == null || string2 == null) {
            System.err.println();
        }
        this.leftExpr = string;
        this.op = operator;
        this.rightExpr = string2;
    }

    public static CDD create(String string, Operator operator, String string2) {
        if (operator.equals((Object)Operator.GEQ)) {
            return CDD.create(new RelationDecision(string, Operator.LESS, string2), CDD.FALSE_CHILDS);
        }
        if (operator.equals((Object)Operator.GREATER)) {
            return CDD.create(new RelationDecision(string, Operator.LEQ, string2), CDD.FALSE_CHILDS);
        }
        return CDD.create(new RelationDecision(string, operator, string2), CDD.TRUE_CHILDS);
    }

    public static CDD create(String[] stringArray, Operator operator) {
        if (stringArray.length != 2) {
            throw new IllegalArgumentException();
        }
        return RelationDecision.create(stringArray[0], operator, stringArray[1]);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BooleanDecision)) {
            return false;
        }
        return this.getVar().equals(((BooleanDecision)object).getVar());
    }

    @Override
    public String toString(int n) {
        if (n != 0) {
            switch (this.op) {
                case LESS: {
                    return this.leftExpr + String.valueOf((Object)Operator.GEQ) + this.rightExpr;
                }
                case GREATER: {
                    return this.leftExpr + String.valueOf((Object)Operator.LEQ) + this.rightExpr;
                }
                case LEQ: {
                    return this.leftExpr + String.valueOf((Object)Operator.GREATER) + this.rightExpr;
                }
                case GEQ: {
                    return this.leftExpr + String.valueOf((Object)Operator.LESS) + this.rightExpr;
                }
                case EQUALS: {
                    return this.leftExpr + String.valueOf((Object)Operator.NEQ) + this.rightExpr;
                }
                case NEQ: {
                    return this.leftExpr + String.valueOf((Object)Operator.EQUALS) + this.rightExpr;
                }
            }
        }
        return this.getVar();
    }

    @Override
    public String toUppaalString(int n) {
        return "true";
    }

    @Override
    public RelationDecision prime(Set<String> set) {
        String string = this.leftExpr.replaceAll("([a-zA-Z_])(\\w*)", "$1$2'");
        String string2 = this.rightExpr.replaceAll("([a-zA-Z_])(\\w*)", "$1$2'");
        return new RelationDecision(string, this.op, string2);
    }

    @Override
    public RelationDecision unprime(Set<String> set) {
        String string = this.leftExpr;
        String string2 = this.rightExpr;
        if (this.leftExpr.endsWith("'")) {
            string = this.leftExpr.substring(0, this.leftExpr.length() - 1);
        }
        if (this.rightExpr.endsWith("'")) {
            string2 = this.rightExpr.substring(0, this.rightExpr.length() - 1);
        }
        return new RelationDecision(string, this.op, string2);
    }

    public static enum Operator {
        PRIME("'"),
        LESS("<"),
        GREATER(">"),
        LEQ("=<"),
        GEQ(">="),
        EQUALS("="),
        PLUS("+"),
        MINUS("-"),
        MULT("*"),
        DIV("/"),
        NEQ("!=");

        String op;

        private Operator(String string2) {
            this.op = string2;
        }

        public String toString() {
            return this.op;
        }
    }
}

