/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopLocalResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class CegarLoopResult<L> {
    private final Map<IcfgLocation, CegarLoopLocalResult<L>> mLocalResults;
    private final IStatisticsDataProvider mCegarLoopStatisticsGenerator;
    private final IElement mArtifact;
    private final List<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> mFloydHoareAutomata;

    public CegarLoopResult(Map<IcfgLocation, CegarLoopLocalResult<L>> map, IStatisticsDataProvider iStatisticsDataProvider, IElement iElement, List<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> list) {
        this.mLocalResults = Collections.unmodifiableMap(map);
        this.mCegarLoopStatisticsGenerator = iStatisticsDataProvider;
        this.mArtifact = iElement;
        this.mFloydHoareAutomata = list;
    }

    public Stream<AbstractCegarLoop.Result> resultStream() {
        return this.mLocalResults.values().stream().map(CegarLoopLocalResult::getResult);
    }

    public Map<IcfgLocation, CegarLoopLocalResult<L>> getResults() {
        return this.mLocalResults;
    }

    public IStatisticsDataProvider getCegarLoopStatisticsGenerator() {
        return this.mCegarLoopStatisticsGenerator;
    }

    public IElement getArtifact() {
        return this.mArtifact;
    }

    public boolean hasProvenAnything() {
        return this.mLocalResults.values().stream().anyMatch(cegarLoopLocalResult -> cegarLoopLocalResult.getResult() == AbstractCegarLoop.Result.SAFE);
    }

    public List<Pair<AbstractInterpolantAutomaton<L>, IPredicateUnifier>> getFloydHoareAutomata() {
        return this.mFloydHoareAutomata;
    }
}

