/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization.ErrorLocalizationStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorlocalization.ErrorLocalizationStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.Benchmark;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class ErrorLocalizationStatisticsGenerator
implements IStatisticsDataProvider {
    private final Benchmark mBenchmark = new Benchmark();
    private boolean mRunning = false;
    private boolean mSuccessfullyFinished;
    private int mIcfgEdges;
    private int mErrorEnforcingIcfgEdges;
    private int mErrorAdmittingIcfgEdges;
    private int mErrorIrrelevantIcfgEdges;
    private int mNumberOfBranches;
    private double mAngelicScore;
    private final StatisticsData mHoareTripleCheckerStatistics;

    public ErrorLocalizationStatisticsGenerator() {
        this.mBenchmark.register(String.valueOf((Object)ErrorLocalizationStatisticsDefinitions.ErrorLocalizationTime));
        this.mHoareTripleCheckerStatistics = new StatisticsData();
    }

    public long getErrorLocalizationTime() {
        return (long)this.mBenchmark.getElapsedTime(String.valueOf((Object)ErrorLocalizationStatisticsDefinitions.ErrorLocalizationTime), TimeUnit.NANOSECONDS);
    }

    public void continueErrorLocalizationTime() {
        assert (!this.mRunning) : "Timing already running";
        this.mRunning = true;
        this.mBenchmark.unpause(String.valueOf((Object)ErrorLocalizationStatisticsDefinitions.ErrorLocalizationTime));
    }

    public void stopErrorLocalizationTime() {
        assert (this.mRunning) : "Timing not running";
        this.mRunning = false;
        this.mBenchmark.pause(String.valueOf((Object)ErrorLocalizationStatisticsDefinitions.ErrorLocalizationTime));
    }

    public void reportSuccessfullyFinished() {
        if (this.mSuccessfullyFinished) {
            throw new IllegalStateException("already finished before");
        }
        this.mSuccessfullyFinished = true;
    }

    public void reportIcfgEdge() {
        ++this.mIcfgEdges;
    }

    public void reportErrorEnforcingIcfgEdge() {
        ++this.mErrorEnforcingIcfgEdges;
    }

    public void reportErrorAdmittingIcfgEdge() {
        ++this.mErrorAdmittingIcfgEdges;
    }

    public void reportErrorIrrelevantIcfgEdge() {
        ++this.mErrorIrrelevantIcfgEdges;
    }

    public void reportNumberOfBranches(int n) {
        this.mNumberOfBranches = n;
    }

    public void reportAngelicScore(double d) {
        this.mAngelicScore = d;
    }

    public void addHoareTripleCheckerStatistics(HoareTripleCheckerStatisticsGenerator hoareTripleCheckerStatisticsGenerator) {
        this.mHoareTripleCheckerStatistics.aggregateBenchmarkData((IStatisticsDataProvider)hoareTripleCheckerStatisticsGenerator);
    }

    public Collection<String> getKeys() {
        return ErrorLocalizationStatisticsType.getInstance().getKeys();
    }

    public Object getValue(String string) {
        ErrorLocalizationStatisticsDefinitions errorLocalizationStatisticsDefinitions = ErrorLocalizationStatisticsDefinitions.valueOf(string);
        switch (errorLocalizationStatisticsDefinitions) {
            case ErrorAdmittingIcfgEdges: {
                return this.mErrorAdmittingIcfgEdges;
            }
            case ErrorEnforcingIcfgEdges: {
                return this.mErrorEnforcingIcfgEdges;
            }
            case ErrorIrrelevantIcfgEdges: {
                return this.mErrorIrrelevantIcfgEdges;
            }
            case NumberOfBranches: {
                return this.mNumberOfBranches;
            }
            case AngelicScore: {
                return this.mAngelicScore;
            }
            case ErrorLocalizationTime: {
                return this.getErrorLocalizationTime();
            }
            case HoareTripleCheckerStatistics: {
                return this.mHoareTripleCheckerStatistics;
            }
            case IcfgEdges: {
                return this.mIcfgEdges;
            }
            case SuccessfullyFinished: {
                return this.mSuccessfullyFinished ? 1 : 0;
            }
        }
        throw new AssertionError((Object)"unknown key");
    }

    public IStatisticsType getBenchmarkType() {
        return ErrorLocalizationStatisticsType.getInstance();
    }
}

